// Code generated by ent, DO NOT EDIT.

package migrate

import (
	"entgo.io/ent/dialect/sql/schema"
	"entgo.io/ent/schema/field"
)

var (
	// ContentsColumns holds the columns for the "contents" table.
	ContentsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "root", Type: field.TypeBool},
		{Name: "data", Type: field.TypeJSON},
		{Name: "created_at", Type: field.TypeTime},
		{Name: "updated_at", Type: field.TypeTime, Nullable: true},
		{Name: "user_content", Type: field.TypeUUID, Nullable: true},
	}
	// ContentsTable holds the schema information for the "contents" table.
	ContentsTable = &schema.Table{
		Name:       "contents",
		Columns:    ContentsColumns,
		PrimaryKey: []*schema.Column{ContentsColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "contents_users_content",
				Columns:    []*schema.Column{ContentsColumns[5]},
				RefColumns: []*schema.Column{UsersColumns[0]},
				OnDelete:   schema.SetNull,
			},
		},
	}
	// EventsColumns holds the columns for the "events" table.
	EventsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "data", Type: field.TypeJSON},
		{Name: "created_at", Type: field.TypeTime},
	}
	// EventsTable holds the schema information for the "events" table.
	EventsTable = &schema.Table{
		Name:       "events",
		Columns:    EventsColumns,
		PrimaryKey: []*schema.Column{EventsColumns[0]},
	}
	// GroupsColumns holds the columns for the "groups" table.
	GroupsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "data", Type: field.TypeJSON},
	}
	// GroupsTable holds the schema information for the "groups" table.
	GroupsTable = &schema.Table{
		Name:       "groups",
		Columns:    GroupsColumns,
		PrimaryKey: []*schema.Column{GroupsColumns[0]},
	}
	// GroupInvitesColumns holds the columns for the "group_invites" table.
	GroupInvitesColumns = []*schema.Column{
		{Name: "id", Type: field.TypeInt, Increment: true},
		{Name: "secret", Type: field.TypeString},
		{Name: "group_invites", Type: field.TypeUUID, Nullable: true},
	}
	// GroupInvitesTable holds the schema information for the "group_invites" table.
	GroupInvitesTable = &schema.Table{
		Name:       "group_invites",
		Columns:    GroupInvitesColumns,
		PrimaryKey: []*schema.Column{GroupInvitesColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "group_invites_groups_invites",
				Columns:    []*schema.Column{GroupInvitesColumns[2]},
				RefColumns: []*schema.Column{GroupsColumns[0]},
				OnDelete:   schema.SetNull,
			},
		},
	}
	// GroupUsersColumns holds the columns for the "group_users" table.
	GroupUsersColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "role", Type: field.TypeString},
		{Name: "group_group_users", Type: field.TypeUUID, Nullable: true},
		{Name: "user_group_users", Type: field.TypeUUID, Nullable: true},
	}
	// GroupUsersTable holds the schema information for the "group_users" table.
	GroupUsersTable = &schema.Table{
		Name:       "group_users",
		Columns:    GroupUsersColumns,
		PrimaryKey: []*schema.Column{GroupUsersColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "group_users_groups_group_users",
				Columns:    []*schema.Column{GroupUsersColumns[2]},
				RefColumns: []*schema.Column{GroupsColumns[0]},
				OnDelete:   schema.SetNull,
			},
			{
				Symbol:     "group_users_users_group_users",
				Columns:    []*schema.Column{GroupUsersColumns[3]},
				RefColumns: []*schema.Column{UsersColumns[0]},
				OnDelete:   schema.SetNull,
			},
		},
	}
	// SessionsColumns holds the columns for the "sessions" table.
	SessionsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeInt, Increment: true},
		{Name: "token", Type: field.TypeString, Unique: true},
		{Name: "data", Type: field.TypeBytes},
		{Name: "expiry", Type: field.TypeTime},
	}
	// SessionsTable holds the schema information for the "sessions" table.
	SessionsTable = &schema.Table{
		Name:       "sessions",
		Columns:    SessionsColumns,
		PrimaryKey: []*schema.Column{SessionsColumns[0]},
	}
	// TagsColumns holds the columns for the "tags" table.
	TagsColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "name", Type: field.TypeString, Unique: true},
		{Name: "group_tags", Type: field.TypeUUID, Nullable: true},
	}
	// TagsTable holds the schema information for the "tags" table.
	TagsTable = &schema.Table{
		Name:       "tags",
		Columns:    TagsColumns,
		PrimaryKey: []*schema.Column{TagsColumns[0]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "tags_groups_tags",
				Columns:    []*schema.Column{TagsColumns[2]},
				RefColumns: []*schema.Column{GroupsColumns[0]},
				OnDelete:   schema.SetNull,
			},
		},
	}
	// UsersColumns holds the columns for the "users" table.
	UsersColumns = []*schema.Column{
		{Name: "id", Type: field.TypeUUID},
		{Name: "email", Type: field.TypeString},
		{Name: "password_hash", Type: field.TypeString, Nullable: true},
		{Name: "data", Type: field.TypeJSON},
		{Name: "verified", Type: field.TypeBool, Default: false},
		{Name: "verify_secret", Type: field.TypeUUID, Nullable: true},
		{Name: "oauth_user", Type: field.TypeJSON, Default: "{}"},
	}
	// UsersTable holds the schema information for the "users" table.
	UsersTable = &schema.Table{
		Name:       "users",
		Columns:    UsersColumns,
		PrimaryKey: []*schema.Column{UsersColumns[0]},
	}
	// ContentChildrenColumns holds the columns for the "content_children" table.
	ContentChildrenColumns = []*schema.Column{
		{Name: "content_id", Type: field.TypeUUID},
		{Name: "parent_id", Type: field.TypeUUID},
	}
	// ContentChildrenTable holds the schema information for the "content_children" table.
	ContentChildrenTable = &schema.Table{
		Name:       "content_children",
		Columns:    ContentChildrenColumns,
		PrimaryKey: []*schema.Column{ContentChildrenColumns[0], ContentChildrenColumns[1]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "content_children_content_id",
				Columns:    []*schema.Column{ContentChildrenColumns[0]},
				RefColumns: []*schema.Column{ContentsColumns[0]},
				OnDelete:   schema.Cascade,
			},
			{
				Symbol:     "content_children_parent_id",
				Columns:    []*schema.Column{ContentChildrenColumns[1]},
				RefColumns: []*schema.Column{ContentsColumns[0]},
				OnDelete:   schema.Cascade,
			},
		},
	}
	// ContentGroupsColumns holds the columns for the "content_groups" table.
	ContentGroupsColumns = []*schema.Column{
		{Name: "content_id", Type: field.TypeUUID},
		{Name: "group_id", Type: field.TypeUUID},
	}
	// ContentGroupsTable holds the schema information for the "content_groups" table.
	ContentGroupsTable = &schema.Table{
		Name:       "content_groups",
		Columns:    ContentGroupsColumns,
		PrimaryKey: []*schema.Column{ContentGroupsColumns[0], ContentGroupsColumns[1]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "content_groups_content_id",
				Columns:    []*schema.Column{ContentGroupsColumns[0]},
				RefColumns: []*schema.Column{ContentsColumns[0]},
				OnDelete:   schema.Cascade,
			},
			{
				Symbol:     "content_groups_group_id",
				Columns:    []*schema.Column{ContentGroupsColumns[1]},
				RefColumns: []*schema.Column{GroupsColumns[0]},
				OnDelete:   schema.Cascade,
			},
		},
	}
	// TagContentsColumns holds the columns for the "tag_contents" table.
	TagContentsColumns = []*schema.Column{
		{Name: "tag_id", Type: field.TypeUUID},
		{Name: "content_id", Type: field.TypeUUID},
	}
	// TagContentsTable holds the schema information for the "tag_contents" table.
	TagContentsTable = &schema.Table{
		Name:       "tag_contents",
		Columns:    TagContentsColumns,
		PrimaryKey: []*schema.Column{TagContentsColumns[0], TagContentsColumns[1]},
		ForeignKeys: []*schema.ForeignKey{
			{
				Symbol:     "tag_contents_tag_id",
				Columns:    []*schema.Column{TagContentsColumns[0]},
				RefColumns: []*schema.Column{TagsColumns[0]},
				OnDelete:   schema.Cascade,
			},
			{
				Symbol:     "tag_contents_content_id",
				Columns:    []*schema.Column{TagContentsColumns[1]},
				RefColumns: []*schema.Column{ContentsColumns[0]},
				OnDelete:   schema.Cascade,
			},
		},
	}
	// Tables holds all the tables in the schema.
	Tables = []*schema.Table{
		ContentsTable,
		EventsTable,
		GroupsTable,
		GroupInvitesTable,
		GroupUsersTable,
		SessionsTable,
		TagsTable,
		UsersTable,
		ContentChildrenTable,
		ContentGroupsTable,
		TagContentsTable,
	}
)

func init() {
	ContentsTable.ForeignKeys[0].RefTable = UsersTable
	GroupInvitesTable.ForeignKeys[0].RefTable = GroupsTable
	GroupUsersTable.ForeignKeys[0].RefTable = GroupsTable
	GroupUsersTable.ForeignKeys[1].RefTable = UsersTable
	TagsTable.ForeignKeys[0].RefTable = GroupsTable
	ContentChildrenTable.ForeignKeys[0].RefTable = ContentsTable
	ContentChildrenTable.ForeignKeys[1].RefTable = ContentsTable
	ContentGroupsTable.ForeignKeys[0].RefTable = ContentsTable
	ContentGroupsTable.ForeignKeys[1].RefTable = GroupsTable
	TagContentsTable.ForeignKeys[0].RefTable = TagsTable
	TagContentsTable.ForeignKeys[1].RefTable = ContentsTable
}
