// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/groupuser"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/predicate"
)

// GroupUserDelete is the builder for deleting a GroupUser entity.
type GroupUserDelete struct {
	config
	hooks    []Hook
	mutation *GroupUserMutation
}

// Where appends a list predicates to the GroupUserDelete builder.
func (gud *GroupUserDelete) Where(ps ...predicate.GroupUser) *GroupUserDelete {
	gud.mutation.Where(ps...)
	return gud
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (gud *GroupUserDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, gud.sqlExec, gud.mutation, gud.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (gud *GroupUserDelete) ExecX(ctx context.Context) int {
	n, err := gud.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (gud *GroupUserDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(groupuser.Table, sqlgraph.NewFieldSpec(groupuser.FieldID, field.TypeUUID))
	if ps := gud.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, gud.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	gud.mutation.done = true
	return affected, err
}

// GroupUserDeleteOne is the builder for deleting a single GroupUser entity.
type GroupUserDeleteOne struct {
	gud *GroupUserDelete
}

// Where appends a list predicates to the GroupUserDelete builder.
func (gudo *GroupUserDeleteOne) Where(ps ...predicate.GroupUser) *GroupUserDeleteOne {
	gudo.gud.mutation.Where(ps...)
	return gudo
}

// Exec executes the deletion query.
func (gudo *GroupUserDeleteOne) Exec(ctx context.Context) error {
	n, err := gudo.gud.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{groupuser.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (gudo *GroupUserDeleteOne) ExecX(ctx context.Context) {
	if err := gudo.Exec(ctx); err != nil {
		panic(err)
	}
}
