// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/google/uuid"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/group"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/groupuser"
	entuser "github.com/lunabrain-ai/lunabrain/pkg/ent/user"
)

// GroupUserCreate is the builder for creating a GroupUser entity.
type GroupUserCreate struct {
	config
	mutation *GroupUserMutation
	hooks    []Hook
}

// SetRole sets the "role" field.
func (guc *GroupUserCreate) SetRole(s string) *GroupUserCreate {
	guc.mutation.SetRole(s)
	return guc
}

// SetID sets the "id" field.
func (guc *GroupUserCreate) SetID(u uuid.UUID) *GroupUserCreate {
	guc.mutation.SetID(u)
	return guc
}

// SetNillableID sets the "id" field if the given value is not nil.
func (guc *GroupUserCreate) SetNillableID(u *uuid.UUID) *GroupUserCreate {
	if u != nil {
		guc.SetID(*u)
	}
	return guc
}

// SetUserID sets the "user" edge to the User entity by ID.
func (guc *GroupUserCreate) SetUserID(id uuid.UUID) *GroupUserCreate {
	guc.mutation.SetUserID(id)
	return guc
}

// SetNillableUserID sets the "user" edge to the User entity by ID if the given value is not nil.
func (guc *GroupUserCreate) SetNillableUserID(id *uuid.UUID) *GroupUserCreate {
	if id != nil {
		guc = guc.SetUserID(*id)
	}
	return guc
}

// SetUser sets the "user" edge to the User entity.
func (guc *GroupUserCreate) SetUser(u *User) *GroupUserCreate {
	return guc.SetUserID(u.ID)
}

// SetGroupID sets the "group" edge to the Group entity by ID.
func (guc *GroupUserCreate) SetGroupID(id uuid.UUID) *GroupUserCreate {
	guc.mutation.SetGroupID(id)
	return guc
}

// SetNillableGroupID sets the "group" edge to the Group entity by ID if the given value is not nil.
func (guc *GroupUserCreate) SetNillableGroupID(id *uuid.UUID) *GroupUserCreate {
	if id != nil {
		guc = guc.SetGroupID(*id)
	}
	return guc
}

// SetGroup sets the "group" edge to the Group entity.
func (guc *GroupUserCreate) SetGroup(g *Group) *GroupUserCreate {
	return guc.SetGroupID(g.ID)
}

// Mutation returns the GroupUserMutation object of the builder.
func (guc *GroupUserCreate) Mutation() *GroupUserMutation {
	return guc.mutation
}

// Save creates the GroupUser in the database.
func (guc *GroupUserCreate) Save(ctx context.Context) (*GroupUser, error) {
	guc.defaults()
	return withHooks(ctx, guc.sqlSave, guc.mutation, guc.hooks)
}

// SaveX calls Save and panics if Save returns an error.
func (guc *GroupUserCreate) SaveX(ctx context.Context) *GroupUser {
	v, err := guc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (guc *GroupUserCreate) Exec(ctx context.Context) error {
	_, err := guc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (guc *GroupUserCreate) ExecX(ctx context.Context) {
	if err := guc.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (guc *GroupUserCreate) defaults() {
	if _, ok := guc.mutation.ID(); !ok {
		v := groupuser.DefaultID()
		guc.mutation.SetID(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (guc *GroupUserCreate) check() error {
	if _, ok := guc.mutation.Role(); !ok {
		return &ValidationError{Name: "role", err: errors.New(`ent: missing required field "GroupUser.role"`)}
	}
	return nil
}

func (guc *GroupUserCreate) sqlSave(ctx context.Context) (*GroupUser, error) {
	if err := guc.check(); err != nil {
		return nil, err
	}
	_node, _spec := guc.createSpec()
	if err := sqlgraph.CreateNode(ctx, guc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	if _spec.ID.Value != nil {
		if id, ok := _spec.ID.Value.(*uuid.UUID); ok {
			_node.ID = *id
		} else if err := _node.ID.Scan(_spec.ID.Value); err != nil {
			return nil, err
		}
	}
	guc.mutation.id = &_node.ID
	guc.mutation.done = true
	return _node, nil
}

func (guc *GroupUserCreate) createSpec() (*GroupUser, *sqlgraph.CreateSpec) {
	var (
		_node = &GroupUser{config: guc.config}
		_spec = sqlgraph.NewCreateSpec(groupuser.Table, sqlgraph.NewFieldSpec(groupuser.FieldID, field.TypeUUID))
	)
	if id, ok := guc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = &id
	}
	if value, ok := guc.mutation.Role(); ok {
		_spec.SetField(groupuser.FieldRole, field.TypeString, value)
		_node.Role = value
	}
	if nodes := guc.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   groupuser.UserTable,
			Columns: []string{groupuser.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(entuser.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.user_group_users = &nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	if nodes := guc.mutation.GroupIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   groupuser.GroupTable,
			Columns: []string{groupuser.GroupColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(group.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_node.group_group_users = &nodes[0]
		_spec.Edges = append(_spec.Edges, edge)
	}
	return _node, _spec
}

// GroupUserCreateBulk is the builder for creating many GroupUser entities in bulk.
type GroupUserCreateBulk struct {
	config
	err      error
	builders []*GroupUserCreate
}

// Save creates the GroupUser entities in the database.
func (gucb *GroupUserCreateBulk) Save(ctx context.Context) ([]*GroupUser, error) {
	if gucb.err != nil {
		return nil, gucb.err
	}
	specs := make([]*sqlgraph.CreateSpec, len(gucb.builders))
	nodes := make([]*GroupUser, len(gucb.builders))
	mutators := make([]Mutator, len(gucb.builders))
	for i := range gucb.builders {
		func(i int, root context.Context) {
			builder := gucb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*GroupUserMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				var err error
				nodes[i], specs[i] = builder.createSpec()
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, gucb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, gucb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, gucb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (gucb *GroupUserCreateBulk) SaveX(ctx context.Context) []*GroupUser {
	v, err := gucb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (gucb *GroupUserCreateBulk) Exec(ctx context.Context) error {
	_, err := gucb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (gucb *GroupUserCreateBulk) ExecX(ctx context.Context) {
	if err := gucb.Exec(ctx); err != nil {
		panic(err)
	}
}
