// Code generated by ent, DO NOT EDIT.

package ent

import (
	"fmt"
	"strings"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/google/uuid"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/group"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/groupuser"
	entuser "github.com/lunabrain-ai/lunabrain/pkg/ent/user"
)

// GroupUser is the model entity for the GroupUser schema.
type GroupUser struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// Role holds the value of the "role" field.
	Role string `json:"role,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the GroupUserQuery when eager-loading is set.
	Edges             GroupUserEdges `json:"edges"`
	group_group_users *uuid.UUID
	user_group_users  *uuid.UUID
	selectValues      sql.SelectValues
}

// GroupUserEdges holds the relations/edges for other nodes in the graph.
type GroupUserEdges struct {
	// User holds the value of the user edge.
	User *User `json:"user,omitempty"`
	// Group holds the value of the group edge.
	Group *Group `json:"group,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [2]bool
}

// UserOrErr returns the User value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e GroupUserEdges) UserOrErr() (*User, error) {
	if e.loadedTypes[0] {
		if e.User == nil {
			// Edge was loaded but was not found.
			return nil, &NotFoundError{label: entuser.Label}
		}
		return e.User, nil
	}
	return nil, &NotLoadedError{edge: "user"}
}

// GroupOrErr returns the Group value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e GroupUserEdges) GroupOrErr() (*Group, error) {
	if e.loadedTypes[1] {
		if e.Group == nil {
			// Edge was loaded but was not found.
			return nil, &NotFoundError{label: group.Label}
		}
		return e.Group, nil
	}
	return nil, &NotLoadedError{edge: "group"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*GroupUser) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case groupuser.FieldRole:
			values[i] = new(sql.NullString)
		case groupuser.FieldID:
			values[i] = new(uuid.UUID)
		case groupuser.ForeignKeys[0]: // group_group_users
			values[i] = &sql.NullScanner{S: new(uuid.UUID)}
		case groupuser.ForeignKeys[1]: // user_group_users
			values[i] = &sql.NullScanner{S: new(uuid.UUID)}
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the GroupUser fields.
func (gu *GroupUser) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case groupuser.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				gu.ID = *value
			}
		case groupuser.FieldRole:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field role", values[i])
			} else if value.Valid {
				gu.Role = value.String
			}
		case groupuser.ForeignKeys[0]:
			if value, ok := values[i].(*sql.NullScanner); !ok {
				return fmt.Errorf("unexpected type %T for field group_group_users", values[i])
			} else if value.Valid {
				gu.group_group_users = new(uuid.UUID)
				*gu.group_group_users = *value.S.(*uuid.UUID)
			}
		case groupuser.ForeignKeys[1]:
			if value, ok := values[i].(*sql.NullScanner); !ok {
				return fmt.Errorf("unexpected type %T for field user_group_users", values[i])
			} else if value.Valid {
				gu.user_group_users = new(uuid.UUID)
				*gu.user_group_users = *value.S.(*uuid.UUID)
			}
		default:
			gu.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the GroupUser.
// This includes values selected through modifiers, order, etc.
func (gu *GroupUser) Value(name string) (ent.Value, error) {
	return gu.selectValues.Get(name)
}

// QueryUser queries the "user" edge of the GroupUser entity.
func (gu *GroupUser) QueryUser() *UserQuery {
	return NewGroupUserClient(gu.config).QueryUser(gu)
}

// QueryGroup queries the "group" edge of the GroupUser entity.
func (gu *GroupUser) QueryGroup() *GroupQuery {
	return NewGroupUserClient(gu.config).QueryGroup(gu)
}

// Update returns a builder for updating this GroupUser.
// Note that you need to call GroupUser.Unwrap() before calling this method if this GroupUser
// was returned from a transaction, and the transaction was committed or rolled back.
func (gu *GroupUser) Update() *GroupUserUpdateOne {
	return NewGroupUserClient(gu.config).UpdateOne(gu)
}

// Unwrap unwraps the GroupUser entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (gu *GroupUser) Unwrap() *GroupUser {
	_tx, ok := gu.config.driver.(*txDriver)
	if !ok {
		panic("ent: GroupUser is not a transactional entity")
	}
	gu.config.driver = _tx.drv
	return gu
}

// String implements the fmt.Stringer.
func (gu *GroupUser) String() string {
	var builder strings.Builder
	builder.WriteString("GroupUser(")
	builder.WriteString(fmt.Sprintf("id=%v, ", gu.ID))
	builder.WriteString("role=")
	builder.WriteString(gu.Role)
	builder.WriteByte(')')
	return builder.String()
}

// GroupUsers is a parsable slice of GroupUser.
type GroupUsers []*GroupUser
