// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/google/uuid"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/group"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/groupinvite"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/predicate"
)

// GroupInviteUpdate is the builder for updating GroupInvite entities.
type GroupInviteUpdate struct {
	config
	hooks    []Hook
	mutation *GroupInviteMutation
}

// Where appends a list predicates to the GroupInviteUpdate builder.
func (giu *GroupInviteUpdate) Where(ps ...predicate.GroupInvite) *GroupInviteUpdate {
	giu.mutation.Where(ps...)
	return giu
}

// SetSecret sets the "secret" field.
func (giu *GroupInviteUpdate) SetSecret(s string) *GroupInviteUpdate {
	giu.mutation.SetSecret(s)
	return giu
}

// SetGroupID sets the "group" edge to the Group entity by ID.
func (giu *GroupInviteUpdate) SetGroupID(id uuid.UUID) *GroupInviteUpdate {
	giu.mutation.SetGroupID(id)
	return giu
}

// SetNillableGroupID sets the "group" edge to the Group entity by ID if the given value is not nil.
func (giu *GroupInviteUpdate) SetNillableGroupID(id *uuid.UUID) *GroupInviteUpdate {
	if id != nil {
		giu = giu.SetGroupID(*id)
	}
	return giu
}

// SetGroup sets the "group" edge to the Group entity.
func (giu *GroupInviteUpdate) SetGroup(g *Group) *GroupInviteUpdate {
	return giu.SetGroupID(g.ID)
}

// Mutation returns the GroupInviteMutation object of the builder.
func (giu *GroupInviteUpdate) Mutation() *GroupInviteMutation {
	return giu.mutation
}

// ClearGroup clears the "group" edge to the Group entity.
func (giu *GroupInviteUpdate) ClearGroup() *GroupInviteUpdate {
	giu.mutation.ClearGroup()
	return giu
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (giu *GroupInviteUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, giu.sqlSave, giu.mutation, giu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (giu *GroupInviteUpdate) SaveX(ctx context.Context) int {
	affected, err := giu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (giu *GroupInviteUpdate) Exec(ctx context.Context) error {
	_, err := giu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (giu *GroupInviteUpdate) ExecX(ctx context.Context) {
	if err := giu.Exec(ctx); err != nil {
		panic(err)
	}
}

func (giu *GroupInviteUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(groupinvite.Table, groupinvite.Columns, sqlgraph.NewFieldSpec(groupinvite.FieldID, field.TypeInt))
	if ps := giu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := giu.mutation.Secret(); ok {
		_spec.SetField(groupinvite.FieldSecret, field.TypeString, value)
	}
	if giu.mutation.GroupCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   groupinvite.GroupTable,
			Columns: []string{groupinvite.GroupColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(group.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := giu.mutation.GroupIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   groupinvite.GroupTable,
			Columns: []string{groupinvite.GroupColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(group.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, giu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{groupinvite.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	giu.mutation.done = true
	return n, nil
}

// GroupInviteUpdateOne is the builder for updating a single GroupInvite entity.
type GroupInviteUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *GroupInviteMutation
}

// SetSecret sets the "secret" field.
func (giuo *GroupInviteUpdateOne) SetSecret(s string) *GroupInviteUpdateOne {
	giuo.mutation.SetSecret(s)
	return giuo
}

// SetGroupID sets the "group" edge to the Group entity by ID.
func (giuo *GroupInviteUpdateOne) SetGroupID(id uuid.UUID) *GroupInviteUpdateOne {
	giuo.mutation.SetGroupID(id)
	return giuo
}

// SetNillableGroupID sets the "group" edge to the Group entity by ID if the given value is not nil.
func (giuo *GroupInviteUpdateOne) SetNillableGroupID(id *uuid.UUID) *GroupInviteUpdateOne {
	if id != nil {
		giuo = giuo.SetGroupID(*id)
	}
	return giuo
}

// SetGroup sets the "group" edge to the Group entity.
func (giuo *GroupInviteUpdateOne) SetGroup(g *Group) *GroupInviteUpdateOne {
	return giuo.SetGroupID(g.ID)
}

// Mutation returns the GroupInviteMutation object of the builder.
func (giuo *GroupInviteUpdateOne) Mutation() *GroupInviteMutation {
	return giuo.mutation
}

// ClearGroup clears the "group" edge to the Group entity.
func (giuo *GroupInviteUpdateOne) ClearGroup() *GroupInviteUpdateOne {
	giuo.mutation.ClearGroup()
	return giuo
}

// Where appends a list predicates to the GroupInviteUpdate builder.
func (giuo *GroupInviteUpdateOne) Where(ps ...predicate.GroupInvite) *GroupInviteUpdateOne {
	giuo.mutation.Where(ps...)
	return giuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (giuo *GroupInviteUpdateOne) Select(field string, fields ...string) *GroupInviteUpdateOne {
	giuo.fields = append([]string{field}, fields...)
	return giuo
}

// Save executes the query and returns the updated GroupInvite entity.
func (giuo *GroupInviteUpdateOne) Save(ctx context.Context) (*GroupInvite, error) {
	return withHooks(ctx, giuo.sqlSave, giuo.mutation, giuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (giuo *GroupInviteUpdateOne) SaveX(ctx context.Context) *GroupInvite {
	node, err := giuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (giuo *GroupInviteUpdateOne) Exec(ctx context.Context) error {
	_, err := giuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (giuo *GroupInviteUpdateOne) ExecX(ctx context.Context) {
	if err := giuo.Exec(ctx); err != nil {
		panic(err)
	}
}

func (giuo *GroupInviteUpdateOne) sqlSave(ctx context.Context) (_node *GroupInvite, err error) {
	_spec := sqlgraph.NewUpdateSpec(groupinvite.Table, groupinvite.Columns, sqlgraph.NewFieldSpec(groupinvite.FieldID, field.TypeInt))
	id, ok := giuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "GroupInvite.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := giuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, groupinvite.FieldID)
		for _, f := range fields {
			if !groupinvite.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != groupinvite.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := giuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := giuo.mutation.Secret(); ok {
		_spec.SetField(groupinvite.FieldSecret, field.TypeString, value)
	}
	if giuo.mutation.GroupCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   groupinvite.GroupTable,
			Columns: []string{groupinvite.GroupColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(group.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := giuo.mutation.GroupIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   groupinvite.GroupTable,
			Columns: []string{groupinvite.GroupColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(group.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_node = &GroupInvite{config: giuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, giuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{groupinvite.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	giuo.mutation.done = true
	return _node, nil
}
