// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/groupinvite"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/predicate"
)

// GroupInviteDelete is the builder for deleting a GroupInvite entity.
type GroupInviteDelete struct {
	config
	hooks    []Hook
	mutation *GroupInviteMutation
}

// Where appends a list predicates to the GroupInviteDelete builder.
func (gid *GroupInviteDelete) Where(ps ...predicate.GroupInvite) *GroupInviteDelete {
	gid.mutation.Where(ps...)
	return gid
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (gid *GroupInviteDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, gid.sqlExec, gid.mutation, gid.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (gid *GroupInviteDelete) ExecX(ctx context.Context) int {
	n, err := gid.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (gid *GroupInviteDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(groupinvite.Table, sqlgraph.NewFieldSpec(groupinvite.FieldID, field.TypeInt))
	if ps := gid.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, gid.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	gid.mutation.done = true
	return affected, err
}

// GroupInviteDeleteOne is the builder for deleting a single GroupInvite entity.
type GroupInviteDeleteOne struct {
	gid *GroupInviteDelete
}

// Where appends a list predicates to the GroupInviteDelete builder.
func (gido *GroupInviteDeleteOne) Where(ps ...predicate.GroupInvite) *GroupInviteDeleteOne {
	gido.gid.mutation.Where(ps...)
	return gido
}

// Exec executes the deletion query.
func (gido *GroupInviteDeleteOne) Exec(ctx context.Context) error {
	n, err := gido.gid.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{groupinvite.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (gido *GroupInviteDeleteOne) ExecX(ctx context.Context) {
	if err := gido.Exec(ctx); err != nil {
		panic(err)
	}
}
