// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/google/uuid"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/content"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/group"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/groupinvite"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/groupuser"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/predicate"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/tag"
	"github.com/lunabrain-ai/lunabrain/pkg/gen/user"
)

// GroupUpdate is the builder for updating Group entities.
type GroupUpdate struct {
	config
	hooks    []Hook
	mutation *GroupMutation
}

// Where appends a list predicates to the GroupUpdate builder.
func (gu *GroupUpdate) Where(ps ...predicate.Group) *GroupUpdate {
	gu.mutation.Where(ps...)
	return gu
}

// SetData sets the "data" field.
func (gu *GroupUpdate) SetData(u *user.Group) *GroupUpdate {
	gu.mutation.SetData(u)
	return gu
}

// AddGroupUserIDs adds the "group_users" edge to the GroupUser entity by IDs.
func (gu *GroupUpdate) AddGroupUserIDs(ids ...uuid.UUID) *GroupUpdate {
	gu.mutation.AddGroupUserIDs(ids...)
	return gu
}

// AddGroupUsers adds the "group_users" edges to the GroupUser entity.
func (gu *GroupUpdate) AddGroupUsers(g ...*GroupUser) *GroupUpdate {
	ids := make([]uuid.UUID, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return gu.AddGroupUserIDs(ids...)
}

// AddInviteIDs adds the "invites" edge to the GroupInvite entity by IDs.
func (gu *GroupUpdate) AddInviteIDs(ids ...int) *GroupUpdate {
	gu.mutation.AddInviteIDs(ids...)
	return gu
}

// AddInvites adds the "invites" edges to the GroupInvite entity.
func (gu *GroupUpdate) AddInvites(g ...*GroupInvite) *GroupUpdate {
	ids := make([]int, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return gu.AddInviteIDs(ids...)
}

// AddContentIDs adds the "content" edge to the Content entity by IDs.
func (gu *GroupUpdate) AddContentIDs(ids ...uuid.UUID) *GroupUpdate {
	gu.mutation.AddContentIDs(ids...)
	return gu
}

// AddContent adds the "content" edges to the Content entity.
func (gu *GroupUpdate) AddContent(c ...*Content) *GroupUpdate {
	ids := make([]uuid.UUID, len(c))
	for i := range c {
		ids[i] = c[i].ID
	}
	return gu.AddContentIDs(ids...)
}

// AddTagIDs adds the "tags" edge to the Tag entity by IDs.
func (gu *GroupUpdate) AddTagIDs(ids ...uuid.UUID) *GroupUpdate {
	gu.mutation.AddTagIDs(ids...)
	return gu
}

// AddTags adds the "tags" edges to the Tag entity.
func (gu *GroupUpdate) AddTags(t ...*Tag) *GroupUpdate {
	ids := make([]uuid.UUID, len(t))
	for i := range t {
		ids[i] = t[i].ID
	}
	return gu.AddTagIDs(ids...)
}

// Mutation returns the GroupMutation object of the builder.
func (gu *GroupUpdate) Mutation() *GroupMutation {
	return gu.mutation
}

// ClearGroupUsers clears all "group_users" edges to the GroupUser entity.
func (gu *GroupUpdate) ClearGroupUsers() *GroupUpdate {
	gu.mutation.ClearGroupUsers()
	return gu
}

// RemoveGroupUserIDs removes the "group_users" edge to GroupUser entities by IDs.
func (gu *GroupUpdate) RemoveGroupUserIDs(ids ...uuid.UUID) *GroupUpdate {
	gu.mutation.RemoveGroupUserIDs(ids...)
	return gu
}

// RemoveGroupUsers removes "group_users" edges to GroupUser entities.
func (gu *GroupUpdate) RemoveGroupUsers(g ...*GroupUser) *GroupUpdate {
	ids := make([]uuid.UUID, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return gu.RemoveGroupUserIDs(ids...)
}

// ClearInvites clears all "invites" edges to the GroupInvite entity.
func (gu *GroupUpdate) ClearInvites() *GroupUpdate {
	gu.mutation.ClearInvites()
	return gu
}

// RemoveInviteIDs removes the "invites" edge to GroupInvite entities by IDs.
func (gu *GroupUpdate) RemoveInviteIDs(ids ...int) *GroupUpdate {
	gu.mutation.RemoveInviteIDs(ids...)
	return gu
}

// RemoveInvites removes "invites" edges to GroupInvite entities.
func (gu *GroupUpdate) RemoveInvites(g ...*GroupInvite) *GroupUpdate {
	ids := make([]int, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return gu.RemoveInviteIDs(ids...)
}

// ClearContent clears all "content" edges to the Content entity.
func (gu *GroupUpdate) ClearContent() *GroupUpdate {
	gu.mutation.ClearContent()
	return gu
}

// RemoveContentIDs removes the "content" edge to Content entities by IDs.
func (gu *GroupUpdate) RemoveContentIDs(ids ...uuid.UUID) *GroupUpdate {
	gu.mutation.RemoveContentIDs(ids...)
	return gu
}

// RemoveContent removes "content" edges to Content entities.
func (gu *GroupUpdate) RemoveContent(c ...*Content) *GroupUpdate {
	ids := make([]uuid.UUID, len(c))
	for i := range c {
		ids[i] = c[i].ID
	}
	return gu.RemoveContentIDs(ids...)
}

// ClearTags clears all "tags" edges to the Tag entity.
func (gu *GroupUpdate) ClearTags() *GroupUpdate {
	gu.mutation.ClearTags()
	return gu
}

// RemoveTagIDs removes the "tags" edge to Tag entities by IDs.
func (gu *GroupUpdate) RemoveTagIDs(ids ...uuid.UUID) *GroupUpdate {
	gu.mutation.RemoveTagIDs(ids...)
	return gu
}

// RemoveTags removes "tags" edges to Tag entities.
func (gu *GroupUpdate) RemoveTags(t ...*Tag) *GroupUpdate {
	ids := make([]uuid.UUID, len(t))
	for i := range t {
		ids[i] = t[i].ID
	}
	return gu.RemoveTagIDs(ids...)
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (gu *GroupUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, gu.sqlSave, gu.mutation, gu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (gu *GroupUpdate) SaveX(ctx context.Context) int {
	affected, err := gu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (gu *GroupUpdate) Exec(ctx context.Context) error {
	_, err := gu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (gu *GroupUpdate) ExecX(ctx context.Context) {
	if err := gu.Exec(ctx); err != nil {
		panic(err)
	}
}

func (gu *GroupUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(group.Table, group.Columns, sqlgraph.NewFieldSpec(group.FieldID, field.TypeUUID))
	if ps := gu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := gu.mutation.Data(); ok {
		_spec.SetField(group.FieldData, field.TypeJSON, value)
	}
	if gu.mutation.GroupUsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.GroupUsersTable,
			Columns: []string{group.GroupUsersColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupuser.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := gu.mutation.RemovedGroupUsersIDs(); len(nodes) > 0 && !gu.mutation.GroupUsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.GroupUsersTable,
			Columns: []string{group.GroupUsersColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupuser.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := gu.mutation.GroupUsersIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.GroupUsersTable,
			Columns: []string{group.GroupUsersColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupuser.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if gu.mutation.InvitesCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.InvitesTable,
			Columns: []string{group.InvitesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupinvite.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := gu.mutation.RemovedInvitesIDs(); len(nodes) > 0 && !gu.mutation.InvitesCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.InvitesTable,
			Columns: []string{group.InvitesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupinvite.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := gu.mutation.InvitesIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.InvitesTable,
			Columns: []string{group.InvitesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupinvite.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if gu.mutation.ContentCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   group.ContentTable,
			Columns: group.ContentPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(content.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := gu.mutation.RemovedContentIDs(); len(nodes) > 0 && !gu.mutation.ContentCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   group.ContentTable,
			Columns: group.ContentPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(content.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := gu.mutation.ContentIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   group.ContentTable,
			Columns: group.ContentPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(content.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if gu.mutation.TagsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.TagsTable,
			Columns: []string{group.TagsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(tag.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := gu.mutation.RemovedTagsIDs(); len(nodes) > 0 && !gu.mutation.TagsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.TagsTable,
			Columns: []string{group.TagsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(tag.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := gu.mutation.TagsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.TagsTable,
			Columns: []string{group.TagsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(tag.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, gu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{group.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	gu.mutation.done = true
	return n, nil
}

// GroupUpdateOne is the builder for updating a single Group entity.
type GroupUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *GroupMutation
}

// SetData sets the "data" field.
func (guo *GroupUpdateOne) SetData(u *user.Group) *GroupUpdateOne {
	guo.mutation.SetData(u)
	return guo
}

// AddGroupUserIDs adds the "group_users" edge to the GroupUser entity by IDs.
func (guo *GroupUpdateOne) AddGroupUserIDs(ids ...uuid.UUID) *GroupUpdateOne {
	guo.mutation.AddGroupUserIDs(ids...)
	return guo
}

// AddGroupUsers adds the "group_users" edges to the GroupUser entity.
func (guo *GroupUpdateOne) AddGroupUsers(g ...*GroupUser) *GroupUpdateOne {
	ids := make([]uuid.UUID, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return guo.AddGroupUserIDs(ids...)
}

// AddInviteIDs adds the "invites" edge to the GroupInvite entity by IDs.
func (guo *GroupUpdateOne) AddInviteIDs(ids ...int) *GroupUpdateOne {
	guo.mutation.AddInviteIDs(ids...)
	return guo
}

// AddInvites adds the "invites" edges to the GroupInvite entity.
func (guo *GroupUpdateOne) AddInvites(g ...*GroupInvite) *GroupUpdateOne {
	ids := make([]int, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return guo.AddInviteIDs(ids...)
}

// AddContentIDs adds the "content" edge to the Content entity by IDs.
func (guo *GroupUpdateOne) AddContentIDs(ids ...uuid.UUID) *GroupUpdateOne {
	guo.mutation.AddContentIDs(ids...)
	return guo
}

// AddContent adds the "content" edges to the Content entity.
func (guo *GroupUpdateOne) AddContent(c ...*Content) *GroupUpdateOne {
	ids := make([]uuid.UUID, len(c))
	for i := range c {
		ids[i] = c[i].ID
	}
	return guo.AddContentIDs(ids...)
}

// AddTagIDs adds the "tags" edge to the Tag entity by IDs.
func (guo *GroupUpdateOne) AddTagIDs(ids ...uuid.UUID) *GroupUpdateOne {
	guo.mutation.AddTagIDs(ids...)
	return guo
}

// AddTags adds the "tags" edges to the Tag entity.
func (guo *GroupUpdateOne) AddTags(t ...*Tag) *GroupUpdateOne {
	ids := make([]uuid.UUID, len(t))
	for i := range t {
		ids[i] = t[i].ID
	}
	return guo.AddTagIDs(ids...)
}

// Mutation returns the GroupMutation object of the builder.
func (guo *GroupUpdateOne) Mutation() *GroupMutation {
	return guo.mutation
}

// ClearGroupUsers clears all "group_users" edges to the GroupUser entity.
func (guo *GroupUpdateOne) ClearGroupUsers() *GroupUpdateOne {
	guo.mutation.ClearGroupUsers()
	return guo
}

// RemoveGroupUserIDs removes the "group_users" edge to GroupUser entities by IDs.
func (guo *GroupUpdateOne) RemoveGroupUserIDs(ids ...uuid.UUID) *GroupUpdateOne {
	guo.mutation.RemoveGroupUserIDs(ids...)
	return guo
}

// RemoveGroupUsers removes "group_users" edges to GroupUser entities.
func (guo *GroupUpdateOne) RemoveGroupUsers(g ...*GroupUser) *GroupUpdateOne {
	ids := make([]uuid.UUID, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return guo.RemoveGroupUserIDs(ids...)
}

// ClearInvites clears all "invites" edges to the GroupInvite entity.
func (guo *GroupUpdateOne) ClearInvites() *GroupUpdateOne {
	guo.mutation.ClearInvites()
	return guo
}

// RemoveInviteIDs removes the "invites" edge to GroupInvite entities by IDs.
func (guo *GroupUpdateOne) RemoveInviteIDs(ids ...int) *GroupUpdateOne {
	guo.mutation.RemoveInviteIDs(ids...)
	return guo
}

// RemoveInvites removes "invites" edges to GroupInvite entities.
func (guo *GroupUpdateOne) RemoveInvites(g ...*GroupInvite) *GroupUpdateOne {
	ids := make([]int, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return guo.RemoveInviteIDs(ids...)
}

// ClearContent clears all "content" edges to the Content entity.
func (guo *GroupUpdateOne) ClearContent() *GroupUpdateOne {
	guo.mutation.ClearContent()
	return guo
}

// RemoveContentIDs removes the "content" edge to Content entities by IDs.
func (guo *GroupUpdateOne) RemoveContentIDs(ids ...uuid.UUID) *GroupUpdateOne {
	guo.mutation.RemoveContentIDs(ids...)
	return guo
}

// RemoveContent removes "content" edges to Content entities.
func (guo *GroupUpdateOne) RemoveContent(c ...*Content) *GroupUpdateOne {
	ids := make([]uuid.UUID, len(c))
	for i := range c {
		ids[i] = c[i].ID
	}
	return guo.RemoveContentIDs(ids...)
}

// ClearTags clears all "tags" edges to the Tag entity.
func (guo *GroupUpdateOne) ClearTags() *GroupUpdateOne {
	guo.mutation.ClearTags()
	return guo
}

// RemoveTagIDs removes the "tags" edge to Tag entities by IDs.
func (guo *GroupUpdateOne) RemoveTagIDs(ids ...uuid.UUID) *GroupUpdateOne {
	guo.mutation.RemoveTagIDs(ids...)
	return guo
}

// RemoveTags removes "tags" edges to Tag entities.
func (guo *GroupUpdateOne) RemoveTags(t ...*Tag) *GroupUpdateOne {
	ids := make([]uuid.UUID, len(t))
	for i := range t {
		ids[i] = t[i].ID
	}
	return guo.RemoveTagIDs(ids...)
}

// Where appends a list predicates to the GroupUpdate builder.
func (guo *GroupUpdateOne) Where(ps ...predicate.Group) *GroupUpdateOne {
	guo.mutation.Where(ps...)
	return guo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (guo *GroupUpdateOne) Select(field string, fields ...string) *GroupUpdateOne {
	guo.fields = append([]string{field}, fields...)
	return guo
}

// Save executes the query and returns the updated Group entity.
func (guo *GroupUpdateOne) Save(ctx context.Context) (*Group, error) {
	return withHooks(ctx, guo.sqlSave, guo.mutation, guo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (guo *GroupUpdateOne) SaveX(ctx context.Context) *Group {
	node, err := guo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (guo *GroupUpdateOne) Exec(ctx context.Context) error {
	_, err := guo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (guo *GroupUpdateOne) ExecX(ctx context.Context) {
	if err := guo.Exec(ctx); err != nil {
		panic(err)
	}
}

func (guo *GroupUpdateOne) sqlSave(ctx context.Context) (_node *Group, err error) {
	_spec := sqlgraph.NewUpdateSpec(group.Table, group.Columns, sqlgraph.NewFieldSpec(group.FieldID, field.TypeUUID))
	id, ok := guo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "Group.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := guo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, group.FieldID)
		for _, f := range fields {
			if !group.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != group.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := guo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := guo.mutation.Data(); ok {
		_spec.SetField(group.FieldData, field.TypeJSON, value)
	}
	if guo.mutation.GroupUsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.GroupUsersTable,
			Columns: []string{group.GroupUsersColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupuser.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := guo.mutation.RemovedGroupUsersIDs(); len(nodes) > 0 && !guo.mutation.GroupUsersCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.GroupUsersTable,
			Columns: []string{group.GroupUsersColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupuser.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := guo.mutation.GroupUsersIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.GroupUsersTable,
			Columns: []string{group.GroupUsersColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupuser.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if guo.mutation.InvitesCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.InvitesTable,
			Columns: []string{group.InvitesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupinvite.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := guo.mutation.RemovedInvitesIDs(); len(nodes) > 0 && !guo.mutation.InvitesCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.InvitesTable,
			Columns: []string{group.InvitesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupinvite.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := guo.mutation.InvitesIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.InvitesTable,
			Columns: []string{group.InvitesColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(groupinvite.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if guo.mutation.ContentCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   group.ContentTable,
			Columns: group.ContentPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(content.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := guo.mutation.RemovedContentIDs(); len(nodes) > 0 && !guo.mutation.ContentCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   group.ContentTable,
			Columns: group.ContentPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(content.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := guo.mutation.ContentIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   group.ContentTable,
			Columns: group.ContentPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(content.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if guo.mutation.TagsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.TagsTable,
			Columns: []string{group.TagsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(tag.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := guo.mutation.RemovedTagsIDs(); len(nodes) > 0 && !guo.mutation.TagsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.TagsTable,
			Columns: []string{group.TagsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(tag.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := guo.mutation.TagsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   group.TagsTable,
			Columns: []string{group.TagsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(tag.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_node = &Group{config: guo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, guo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{group.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	guo.mutation.done = true
	return _node, nil
}
