// Code generated by ent, DO NOT EDIT.

package ent

import (
	"encoding/json"
	"fmt"
	"strings"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/google/uuid"
	"github.com/lunabrain-ai/lunabrain/pkg/ent/group"
	"github.com/lunabrain-ai/lunabrain/pkg/gen/user"
)

// Group is the model entity for the Group schema.
type Group struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// Data holds the value of the "data" field.
	Data *user.Group `json:"data,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the GroupQuery when eager-loading is set.
	Edges        GroupEdges `json:"edges"`
	selectValues sql.SelectValues
}

// GroupEdges holds the relations/edges for other nodes in the graph.
type GroupEdges struct {
	// GroupUsers holds the value of the group_users edge.
	GroupUsers []*GroupUser `json:"group_users,omitempty"`
	// Invites holds the value of the invites edge.
	Invites []*GroupInvite `json:"invites,omitempty"`
	// Content holds the value of the content edge.
	Content []*Content `json:"content,omitempty"`
	// Tags holds the value of the tags edge.
	Tags []*Tag `json:"tags,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [4]bool
}

// GroupUsersOrErr returns the GroupUsers value or an error if the edge
// was not loaded in eager-loading.
func (e GroupEdges) GroupUsersOrErr() ([]*GroupUser, error) {
	if e.loadedTypes[0] {
		return e.GroupUsers, nil
	}
	return nil, &NotLoadedError{edge: "group_users"}
}

// InvitesOrErr returns the Invites value or an error if the edge
// was not loaded in eager-loading.
func (e GroupEdges) InvitesOrErr() ([]*GroupInvite, error) {
	if e.loadedTypes[1] {
		return e.Invites, nil
	}
	return nil, &NotLoadedError{edge: "invites"}
}

// ContentOrErr returns the Content value or an error if the edge
// was not loaded in eager-loading.
func (e GroupEdges) ContentOrErr() ([]*Content, error) {
	if e.loadedTypes[2] {
		return e.Content, nil
	}
	return nil, &NotLoadedError{edge: "content"}
}

// TagsOrErr returns the Tags value or an error if the edge
// was not loaded in eager-loading.
func (e GroupEdges) TagsOrErr() ([]*Tag, error) {
	if e.loadedTypes[3] {
		return e.Tags, nil
	}
	return nil, &NotLoadedError{edge: "tags"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Group) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case group.FieldData:
			values[i] = new([]byte)
		case group.FieldID:
			values[i] = new(uuid.UUID)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Group fields.
func (gr *Group) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case group.FieldID:
			if value, ok := values[i].(*uuid.UUID); !ok {
				return fmt.Errorf("unexpected type %T for field id", values[i])
			} else if value != nil {
				gr.ID = *value
			}
		case group.FieldData:
			if value, ok := values[i].(*[]byte); !ok {
				return fmt.Errorf("unexpected type %T for field data", values[i])
			} else if value != nil && len(*value) > 0 {
				if err := json.Unmarshal(*value, &gr.Data); err != nil {
					return fmt.Errorf("unmarshal field data: %w", err)
				}
			}
		default:
			gr.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the Group.
// This includes values selected through modifiers, order, etc.
func (gr *Group) Value(name string) (ent.Value, error) {
	return gr.selectValues.Get(name)
}

// QueryGroupUsers queries the "group_users" edge of the Group entity.
func (gr *Group) QueryGroupUsers() *GroupUserQuery {
	return NewGroupClient(gr.config).QueryGroupUsers(gr)
}

// QueryInvites queries the "invites" edge of the Group entity.
func (gr *Group) QueryInvites() *GroupInviteQuery {
	return NewGroupClient(gr.config).QueryInvites(gr)
}

// QueryContent queries the "content" edge of the Group entity.
func (gr *Group) QueryContent() *ContentQuery {
	return NewGroupClient(gr.config).QueryContent(gr)
}

// QueryTags queries the "tags" edge of the Group entity.
func (gr *Group) QueryTags() *TagQuery {
	return NewGroupClient(gr.config).QueryTags(gr)
}

// Update returns a builder for updating this Group.
// Note that you need to call Group.Unwrap() before calling this method if this Group
// was returned from a transaction, and the transaction was committed or rolled back.
func (gr *Group) Update() *GroupUpdateOne {
	return NewGroupClient(gr.config).UpdateOne(gr)
}

// Unwrap unwraps the Group entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (gr *Group) Unwrap() *Group {
	_tx, ok := gr.config.driver.(*txDriver)
	if !ok {
		panic("ent: Group is not a transactional entity")
	}
	gr.config.driver = _tx.drv
	return gr
}

// String implements the fmt.Stringer.
func (gr *Group) String() string {
	var builder strings.Builder
	builder.WriteString("Group(")
	builder.WriteString(fmt.Sprintf("id=%v, ", gr.ID))
	builder.WriteString("data=")
	builder.WriteString(fmt.Sprintf("%v", gr.Data))
	builder.WriteByte(')')
	return builder.String()
}

// Groups is a parsable slice of Group.
type Groups []*Group
