// Code generated by Wire. DO NOT EDIT.

//go:generate go run github.com/google/wire/cmd/wire
//go:build !wireinject
// +build !wireinject

package cli

import (
	"github.com/lunabrain-ai/lunabrain/pkg/bucket"
	"github.com/lunabrain-ai/lunabrain/pkg/chat"
	"github.com/lunabrain-ai/lunabrain/pkg/config"
	"github.com/lunabrain-ai/lunabrain/pkg/content"
	"github.com/lunabrain-ai/lunabrain/pkg/content/normalize"
	"github.com/lunabrain-ai/lunabrain/pkg/content/store"
	"github.com/lunabrain-ai/lunabrain/pkg/db"
	"github.com/lunabrain-ai/lunabrain/pkg/event"
	"github.com/lunabrain-ai/lunabrain/pkg/group"
	"github.com/lunabrain-ai/lunabrain/pkg/http"
	"github.com/lunabrain-ai/lunabrain/pkg/log"
	"github.com/lunabrain-ai/lunabrain/pkg/providers/openai"
	"github.com/lunabrain-ai/lunabrain/pkg/providers/whisper"
	"github.com/lunabrain-ai/lunabrain/pkg/server"
	"github.com/lunabrain-ai/lunabrain/pkg/user"
	"github.com/urfave/cli/v2"
)

// Injectors from wire.go:

func Wire() (*cli.App, error) {
	provider, err := config.NewConfigProvider()
	if err != nil {
		return nil, err
	}
	logConfig, err := log.NewConfig(provider)
	if err != nil {
		return nil, err
	}
	logLog := log.NewLog(logConfig)
	contentConfig, err := content.NewConfig(provider)
	if err != nil {
		return nil, err
	}
	dbConfig, err := db.NewConfig(provider)
	if err != nil {
		return nil, err
	}
	client, err := db.NewEnt(dbConfig)
	if err != nil {
		return nil, err
	}
	entStore := store.NewEntStore(client)
	sessionManager, err := http.NewSession(client)
	if err != nil {
		return nil, err
	}
	openaiConfig, err := openai.NewConfig(provider)
	if err != nil {
		return nil, err
	}
	agent, err := openai.NewAgent(openaiConfig)
	if err != nil {
		return nil, err
	}
	bucketConfig, err := bucket.NewConfig(provider)
	if err != nil {
		return nil, err
	}
	builder, err := bucket.NewBuilder(bucketConfig)
	if err != nil {
		return nil, err
	}
	bucketBucket, err := bucket.New(bucketConfig)
	if err != nil {
		return nil, err
	}
	whisperConfig, err := whisper.NewConfig(provider)
	if err != nil {
		return nil, err
	}
	whisperClient := whisper.NewClient(whisperConfig, openaiConfig, bucketBucket)
	normalizeNormalize := normalize.New(builder, bucketBucket, whisperClient, entStore)
	service := content.NewService(entStore, sessionManager, agent, normalizeNormalize, bucketBucket, builder, whisperClient)
	groupEntStore := group.NewEntStore(client)
	userEntStore := user.NewEntStore(client)
	userConfig, err := user.NewConfig(provider)
	if err != nil {
		return nil, err
	}
	userService := user.NewService(groupEntStore, sessionManager, userEntStore, userConfig)
	chatService := chat.New(sessionManager, userEntStore)
	eventEntStore := event.NewEntStore(client)
	eventConfig, err := event.NewConfig(provider)
	if err != nil {
		return nil, err
	}
	eventService := event.NewService(sessionManager, eventEntStore, eventConfig)
	apihttpServer := server.New(contentConfig, service, bucketBucket, sessionManager, userService, chatService, eventService)
	app := NewApp(logLog, apihttpServer)
	return app, nil
}
