---
title: AI Art Buddy
emoji: 🤖
colorFrom: pink
colorTo: blue
sdk: docker
pinned: false
license: apache-2.0
---

# Agentic RAG Chabot

Agentic RAG (Retrieval-Augmented Generation) Chatbot is an AI system designed to offer a new level of interactivity and assistance by combining real-time information retrieval with advanced language generation. This approach allows the chatbot to not only provide pre-determined responses but also to dynamically generate new content or autonomously pull up-to-date information as needed to enhance the accuracy and relevance of generated responses, making it an effective tool in varied applications such as the AI Art Buddy for Ben Uri Gallery and Museum.

<a name="toc"/></a>
## Table of Contents
<!--ts-->
1. [App Overview](#overview)
2. [How It Works](#howitworks)
3. [Getting Started](#gettingstarted)
4. [Contributing](#contributing)
5. [License](#license)
6. [About the Author](#author)
<!--te-->  

<a name="overview"/></a>
## 1. App Overview
[Back to ToC](#toc)

This section introduces the application of Agentic RAG Chatbot as the AI Art Buddy, specifically tailored for Ben Uri Gallery and Museum. Users can interact with the assistant to explore a rich database focused on Jewish, Refugee, and Immigrant contributions to British visual culture. The assistant is designed to enhance user engagement and provide educational insights through interactive discussions about art and artists.

<a name="howitworks"/></a>
## 2. How It Works
[Back to ToC](#toc)

The AI Art Buddy utilizes a combination of retrieval-augmented generation technology and a curated knowledge base about the artists and artworks featured at Ben Uri Gallery and Museum. When a question is asked, the system decides whether to pull information directly from the knowledge base or to generate a contextual response that synthesizes information into a coherent and informative answer. This process includes:
1. **User Query Handling**: Receive and parse user queries.
2. **Information Retrieval**: Fetch relevant data or past inquiries from the knowledge base.
3. **Response Generation**: Use LLMs to craft responses that are informative, factually accurate, and engaging.

In addition to the inference pipeline mentioned above, there are two additional pipelines: data indexing, which indexes job vacancies in a vector store, and data collection, which gathers the web pages of the museum website. The complete architecture of the platform is illustrated in the figure below.

<p align="center">
  <img src="./docs/images/AI-Art-Buddy-Architecture.svg" alt="" width="500">
</p>

<a name="gettingstarted"/></a>
## 3. Getting Started
[Back to ToC](#toc)

To begin exploring the AI Art Buddy, visit the [application](https://huggingface.co/spaces/luisrodriguesphd/ai-art-buddy) hosted on **Hugging Face Spaces**. Start by typing a question about the Ben Uri collection or artists, and the chatbot will guide you through the rich history and cultural insights available on the museum's website.

<a name="contributing"/></a>
## 4. Contributing
[Back to ToC](#toc)

Contributions to the Agentic RAG Chatbot, especially those that enhance its application as an AI Art Buddy, are highly welcome. If you're interested in improving the platform, adding more features, or enriching the knowledge base, please refer to our contribution guidelines.

<a name="license"/></a>
## 5. License
[Back to ToC](#toc)

Agentic-RAG Chatbot is made available under the Apache-2.0 license. This allows for both personal and commercial use, ensuring the project remains open and accessible. For detailed licensing information, please view the license file in the repository.

<a name="author"/></a>
## 6. About the Author
[Back to ToC](#toc)

The Agentic RAG Chatbot was developed by Luis Rodrigues, a seasoned Data Scientist and Machine Learning Engineer.
Luis holds 9+ years of experience in leveraging Artificial Intelligence and Machine Learning technologies to develop innovative products and services that deliver great customer experiences and significant business impact and is currently specializing in generative AI.
The AI Art Buddy represents his commitment to advancing how AI can support and enhance user interactions in educational and cultural contexts. 
For more information on Luis Rodrigues' work and other projects, visit his [LinkedIn profile](https://www.linkedin.com/in/luisrodriguesphd/).
