// This file was auto-generated by ML.NET Model Builder. 
using Microsoft.ML.Data;
using Microsoft.ML.Transforms;
using System;
using System.Linq;

namespace ASLModelBuilderML.Model
{
    [CustomMappingFactoryAttribute(nameof(LabelMapping))]
    public class LabelMapping : CustomMappingFactory<LabelMappingInput, LabelMappingOutput>
    {
        public static string[] Label { get; set; } = new string[] { "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "space", };
        // This is the custom mapping. We now separate it into a method, so that we can use it both in training and in loading.
        public static void Mapping(LabelMappingInput input, LabelMappingOutput output)
        {
            var values = input.output1.GetValues().ToArray();
            var maxVal = values.Max();
            var exp = values.Select(v => Math.Exp(v - maxVal));
            var sumExp = exp.Sum();

            exp.Select(v => (float)(v / sumExp)).ToArray();
            output.score = exp.Select(v => (float)(v / sumExp)).ToArray();

            var maxValue = output.score.Max();
            var maxValueIndex = Array.IndexOf(output.score, maxValue);
            output.label = Label[maxValueIndex];
        }
        // This factory method will be called when loading the model to get the mapping operation.
        public override Action<LabelMappingInput, LabelMappingOutput> GetMapping()
        {
            return Mapping;
        }
    }
    public class LabelMappingInput
    {
        [ColumnName("output1")]
        public VBuffer<float> output1;
    }
    public class LabelMappingOutput
    {

        [ColumnName("PredictedLabel")]
        public string label { get; set; }

        [ColumnName("Score")]
        public float[] score { get; set; }
    }
}
