// This file was auto-generated by ML.NET Model Builder. 

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.ML;
using ASLModelBuilderML.Model;
using System.IO;
using System.Reflection;

namespace ASLModelBuilderML.Model
{
    public class ConsumeModel
    {
        private static Lazy<PredictionEngine<ModelInput, ModelOutput>> PredictionEngine = new Lazy<PredictionEngine<ModelInput, ModelOutput>>(CreatePredictionEngine);

        // For more info on consuming ML.NET models, visit https://aka.ms/mlnet-consume
        // Method for consuming model in your app
        public static ModelOutput Predict(ModelInput input)
        {
            ModelOutput result = PredictionEngine.Value.Predict(input);
            return result;
        }

        public static PredictionEngine<ModelInput, ModelOutput> CreatePredictionEngine()
        {
            // Create new MLContext
            MLContext mlContext = new MLContext();

            // Register NormalizeMapping to calculate probabilities for each Label.
            mlContext.ComponentCatalog.RegisterAssembly(typeof(NormalizeMapping).Assembly);

            // Register LabelMapping to map predicted Labels to their corresponding probabilities (likelihood of specified Labels)
            mlContext.ComponentCatalog.RegisterAssembly(typeof(LabelMapping).Assembly);

            // Load model & create prediction engine
            string modelPath = Path.Combine(Path.GetDirectoryName(Assembly.GetEntryAssembly().Location), "MLModel.zip");
            ITransformer mlModel = mlContext.Model.Load(modelPath, out var modelInputSchema);
            var predEngine = mlContext.Model.CreatePredictionEngine<ModelInput, ModelOutput>(mlModel);

            return predEngine;
        }
    }
}
