/*
 * Copyright lt 2023
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
rootProject.buildFileName = "build.gradle.kts"
rootProject.name = "ComposeViews"

include(":ComposeViews")
include(":common_app")
include(":android_app")
include("desktop_app")
include("js_app")
include("wasm_app")


includeBuild("convention-plugins")

pluginManagement {
    listOf(repositories, dependencyResolutionManagement.repositories).forEach {
        it.apply {
            maven("https://mirrors.tencent.com/nexus/repository/maven-public/")
            maven("https://maven.pkg.jetbrains.space/public/p/compose/dev")
            maven("https://jitpack.io")
            google()
            gradlePluginPortal()
            mavenCentral()
        }
    }

    plugins {
        val kotlinVersion = extra["kotlin.version"] as String
        val composeVersion = extra["compose.version"] as String
        val kspVersion = extra["ksp.version"] as String
        val agpVersion = "8.3.2"

        kotlin("jvm").version(kotlinVersion)
        kotlin("multiplatform").version(kotlinVersion)
        kotlin("android").version(kotlinVersion)
        kotlin("plugin.compose").version(kotlinVersion)

        id("com.android.application").version(agpVersion)
        id("com.android.library").version(agpVersion)

        id("org.jetbrains.compose").version(composeVersion)

        id("com.google.devtools.ksp").version(kspVersion)

        id("com.vk.vkompose") version "0.6.2-k2"
    }
}
