[![Build Status](https://travis-ci.org/ltn22/SCHC.svg?branch=master)](https://travis-ci.org/ltn22/SCHC)[![Coverage Status](https://coveralls.io/repos/github/ltn22/SCHC/badge.svg?branch=master)](https://coveralls.io/github/ltn22/SCHC?branch=master)

Static Context Header Compression (SCHC, pronounced chic) is a *generic* compression mechanism for LPWAN networks. It is standardized at the IETF.

This implementation applies SCHC to CoAP/UDP/IPv6 headers, but can be extended to other type of fields.

# Introduction

This document describes the application of generic compression/decompression processes defined in {{I-D.toutain-lpwan-ipv6-static-context-hc}} and {{I-D.toutain-lpwan-coap-static-context-hc}}.

For the moment, the implementation has only been tested uplink and downlink, communicating from the Device (Dev) to the LPWAN Compressor/Decompressor (SC) in the infrastructure with a simple CoAP server running on top of the SCHC C/D. Device implementation is 
writen in Python. It currently use the pycom API for LoRa and can be easily adapted for Sigfox.

A CoAP/UDP/IPv6 packet is generated by the Device, the Device parses this packet to obtain each value of the header fields, then the Device searches for a compression rule that matches this packet format. If there is a rule in the context that matches the header format and values of the packet, the header fields are compressed using the Compression/Decompression Action (CDA) specified by that rule and the compressed packet is sent over the air to the infrastructure C/D.

Upon receipt, the compresssed packet is parsed by the infrastructure C/D to delineate the rule identifier (first byte), each subsequent header field (as specified by the rule) and the payload. Finally, the LC decompresses the headers, as described in the rule. The CoAP message is then processed and if an answer is needed, the response is compressed and sent back to the device which decompressed it.

For this purpose, the Device is implemented on a LoPy module, which is able to transmit via LoRa and can be easily programmed in MicroPython. The infrastructure C/S is implemented with a Node.js by an HTTP Server which receives the raw compressed packet LPWAN payload frames in a POST message. The answer is included in the Acknowledgement of this POST message.

# compression / decompression in Python

Different classes are needed to implement compression and decompression. 

## Rule Manager

RuleMngt.py defines RuleManager class which maintains the SCHC context.

A ruleManager instance is created with a call the RuleManager()

~~~~
 RM = RuleManager()
~~~~

Then rules can be added using the addRule method:

~~~~
 RM.addRule(rule_coap0)
 RM.addRule(rule_coap1)
~~~~

The rule is defined oin JSON using the following format:

~~~~
 rule_coap0 = {"ruleid"  : 0,
               "content" : [["IPv6.version",      1,  "bi", 6,                  "equal",  "not-sent"],
                            ["IPv6.trafficClass", 1,  "bi", 0x00,               "equal",  "not-sent"]] }
 
~~~~

A rule is composed of a list (dictionnary) of two elements:

 * ruleid defines the rule number,
 * content contains an array of field description composed of:
 
   * a Field ID (which must correspond to a value returned by the field Parser.
   * a field position: an integer, by default 1
   * a field direction "bi", "up" and "dw"
   * a Target Value: Integer or String
   * a Matching Operator ("ignore", "equal", "MSB(v)", "match-mapping".
   * a Compression Decompression Action ("not-sent", "value-sent", "LSB(v)", mapping-sent", "compute-length", "compute-checksum")
   
The method FindRuleFromId(ruleid) returns the rule corresponding the ruleid.

The method FindRuleFromPkt (header, direction) returns the rule corresponding the header
field list contained in the first argument. This value comes generally from a packet
header parsing done with the class Parser. The second argument is either "up", "dw" or "bi",
indication the direction from the device point of view.

For both methods, if no rule is found, a None is returned.



