import React from "react"

interface IconBoardProps {
  width: number
  height: number
  enabled: boolean
}

const IconBoard = ({ width, height, enabled }: IconBoardProps) => {
  return (
    <svg
      width={width}
      height={height}
      viewBox="0 0 108 108"
      opacity={enabled ? 1 : 0.2}
    >
      <polygon
        fill="fill:#0d5b9e;"
        points="10 87 10 70 6 67 6 34 10 31 10 26 96 26 96 87 10 87"
      />
      <path
        fill="#33363a"
        d="M97,88H9V70.5l-4-3v-34l4-3V25H97V88ZM11,86H95V27H11v4.5l-4,3v32l4,3V86Z"
      />
      <polygon
        fill="#009be8"
        points="10 83 10 66 6 63 6 30 10 27 10 22 96 22 96 83 10 83"
      />
      <path
        fill="#33363a"
        d="M97,84H9V66.5l-4-3v-34l4-3V21H97V84ZM11,82H95V23H11v4.5l-4,3v32l4,3V82Z"
      />
      <rect
        fill="#5e6a70"
        height="44"
        transform="translate(74.5 4.5) rotate(90)"
        width="9"
        x="30.5"
        y="17.5"
      />
      <path fill="#33363a" d="M58,45H12V34H58V45ZM14,43H56V36H14v7Z" />
      <rect
        fill="#7d8d95"
        height="43"
        transform="translate(71 2) rotate(90)"
        width="9"
        x="30"
        y="15"
      />
      <path fill="#33363a" d="M58,41H12V30H58V41ZM14,39H56V32H14v7Z" />
      <rect
        fill="#5e6a70"
        height="56"
        transform="translate(116.5 32.5) rotate(90)"
        width="9"
        x="37.5"
        y="46.5"
      />
      <path fill="#33363a" d="M71,80H13V69H71V80ZM15,78H69V71H15v7Z" />
      <rect
        fill="#7d8d95"
        height="55"
        transform="translate(110.5 27.5) rotate(90)"
        width="4"
        x="39.5"
        y="41.5"
      />
      <path fill="#33363a" d="M71,73H13V65H71v8ZM15,71H69V67H15v4Z" />
      <path fill="#33363a" d="M22,49H16V39h6V49Zm-4-2h2V41H18v6Z" />
      <path fill="#33363a" d="M22,32H16V26h6v6Zm-4-2h2V28H18v2Z" />
      <path fill="#33363a" d="M30,49H24V39h6V49Zm-4-2h2V41H26v6Z" />
      <path fill="#33363a" d="M38,49H32V39h6V49Zm-4-2h2V41H34v6Z" />
      <path fill="#33363a" d="M46,49H40V39h6V49Zm-4-2h2V41H42v6Z" />
      <path fill="#33363a" d="M54,49H48V39h6V49Zm-4-2h2V41H50v6Z" />
      <rect fill="#d8e5ea" height="3" width="2" x="18" y="41" />
      <rect fill="#d8e5ea" height="2" width="2" x="18" y="28" />
      <path fill="#33363a" d="M30,32H24V26h6v6Zm-4-2h2V28H26v2Z" />
      <rect fill="#d8e5ea" height="2" width="2" x="26" y="28" />
      <path fill="#33363a" d="M38,32H32V26h6v6Zm-4-2h2V28H34v2Z" />
      <rect fill="#d8e5ea" height="2" width="2" x="34" y="28" />
      <path fill="#33363a" d="M46,32H40V26h6v6Zm-4-2h2V28H42v2Z" />
      <rect fill="#d8e5ea" height="2" width="2" x="42" y="28" />
      <path fill="#33363a" d="M54,32H48V26h6v6Zm-4-2h2V28H50v2Z" />
      <rect fill="#d8e5ea" height="2" width="2" x="50" y="28" />
      <rect fill="#81959d" height="3" width="2" x="18" y="44" />
      <rect fill="#d8e5ea" height="3" width="2" x="26" y="41" />
      <rect fill="#81959d" height="3" width="2" x="26" y="44" />
      <rect fill="#d8e5ea" height="3" width="2" x="34" y="41" />
      <rect fill="#81959d" height="3" width="2" x="34" y="44" />
      <rect fill="#d8e5ea" height="3" width="2" x="42" y="41" />
      <rect fill="#81959d" height="3" width="2" x="42" y="44" />
      <rect fill="#d8e5ea" height="3" width="2" x="50" y="41" />
      <rect fill="#81959d" height="3" width="2" x="50" y="44" />
      <rect fill="#5e6a70" height="2" width="2" x="17" y="68" />
      <rect fill="#5e6a70" height="2" width="2" x="21" y="68" />
      <rect fill="#5e6a70" height="2" width="2" x="25" y="68" />
      <rect fill="#5e6a70" height="2" width="2" x="29" y="68" />
      <rect fill="#5e6a70" height="2" width="2" x="33" y="68" />
      <rect fill="#5e6a70" height="2" width="2" x="37" y="68" />
      <rect fill="#5e6a70" height="2" width="2" x="41" y="68" />
      <rect fill="#5e6a70" height="2" width="2" x="45" y="68" />
      <rect fill="#5e6a70" height="2" width="2" x="49" y="68" />
      <rect fill="#5e6a70" height="2" width="2" x="53" y="68" />
      <rect fill="#5e6a70" height="2" width="2" x="57" y="68" />
      <rect fill="#5e6a70" height="2" width="2" x="61" y="68" />
      <rect fill="#5e6a70" height="2" width="2" x="65" y="68" />
      <rect
        fill="#5e6a70"
        height="17"
        transform="translate(133 -54) rotate(90)"
        width="9"
        x="89"
        y="31"
      />
      <path fill="#33363a" d="M103,45H84V34h19V45ZM86,43h15V36H86v7Z" />
      <rect
        fill="#7d8d95"
        height="17"
        transform="translate(127 -60) rotate(90)"
        width="9"
        x="89"
        y="25"
      />
      <path fill="#33363a" d="M103,39H84V28h19V39ZM86,37h15V30H86v7Z" />
      <rect
        fill="#81959d"
        height="25"
        transform="translate(148 -31) rotate(90)"
        width="9"
        x="85"
        y="46"
      />
      <path fill="#33363a" d="M103,64H76V53h27V64ZM78,62h23V55H78v7Z" />
      <rect
        fill="#d8e5ea"
        height="25"
        transform="translate(142 -37) rotate(90)"
        width="9"
        x="85"
        y="40"
      />
      <polyline fill="#f0fbfc" points="91.22 48 87.29 57 85 57 89 48" />
      <polyline fill="#f0fbfc" points="94 48 90 57 89 57 93 48" />
      <path fill="#33363a" d="M103,58H76V47h27V58ZM78,56h23V49H78v7Z" />
      <path fill="#f0fbfc" d="M73,33v8c0,1.66,1.79,3,4,3s4-1.34,4-3V33H73Z" />
      <polygon fill="#d8e5ea" points="78 44 81 42.19 81 33 78 33 78 44" />
      <path
        fill="#33363a"
        d="M77,45c-2.76,0-5-1.79-5-4V33a1,1,0,0,1,1-1h8a1,1,0,0,1,1,1v8C82,43.21,79.76,45,77,45ZM74,34v7c0,1.08,1.37,2,3,2s3-.92,3-2V34H74Z"
      />
      <ellipse fill="#d8e5ea" cx="77" cy="33" rx="4" ry="3" />
      <path
        fill="#33363a"
        d="M77,37c-2.76,0-5-1.79-5-4s2.24-4,5-4,5,1.79,5,4S79.76,37,77,37Zm0-6c-1.63,0-3,.92-3,2s1.37,2,3,2,3-.92,3-2S78.63,31,77,31Z"
      />
      <path fill="#f0fbfc" d="M61,35v6c0,1.66,1.79,3,4,3s4-1.34,4-3V35H61Z" />
      <polygon fill="#d8e5ea" points="66 44 69 42.19 69 35 66 35 66 44" />
      <path
        fill="#33363a"
        d="M65,45c-2.76,0-5-1.79-5-4V35a1,1,0,0,1,1-1h8a1,1,0,0,1,1,1v6C70,43.21,67.76,45,65,45Zm-3-9v5c0,1.08,1.37,2,3,2s3-.92,3-2V36H62Z"
      />
      <ellipse fill="#d8e5ea" cx="65" cy="35" rx="4" ry="3" />
      <path
        fill="#33363a"
        d="M65,39c-2.76,0-5-1.79-5-4s2.24-4,5-4,5,1.79,5,4S67.76,39,65,39Zm0-6c-1.63,0-3,.92-3,2s1.37,2,3,2,3-.92,3-2S66.63,33,65,33Z"
      />
      <rect fill="#d8e5ea" height="11" width="14" x="78" y="68" />
      <path fill="#33363a" d="M93,80H77V67H93V80ZM79,78H91V69H79v9Z" />
      <path fill="#d60807" d="M81,69v4c0,1.66,1.79,3,4,3s4-1.34,4-3V69H81Z" />
      <polygon fill="#b50a0b" points="85 76 89 74.19 89 69 85 69 85 76" />
      <path
        fill="#33363a"
        d="M85,77c-2.76,0-5-1.79-5-4V69a1,1,0,0,1,1-1h8a1,1,0,0,1,1,1v4C90,75.21,87.76,77,85,77Zm-3-7v3c0,1.08,1.37,2,3,2s3-.92,3-2V70H82Z"
      />
      <ellipse fill="#d60807" cx="85" cy="69" rx="4" ry="3" />
      <path
        fill="#33363a"
        d="M85,73c-2.76,0-5-1.79-5-4s2.24-4,5-4,5,1.79,5,4S87.76,73,85,73Zm0-6c-1.63,0-3,.92-3,2s1.37,2,3,2,3-.92,3-2S86.63,67,85,67Z"
      />
      <rect fill="#899ba2" height="2" width="15" x="86" y="30" />
      <rect fill="#899ba2" height="2" width="42" x="14" y="32" />
    </svg>
  )
}

export default IconBoard
