# Start Machine Learning in 2025 - Become an expert for free!

## A complete guide to start and improve in machine learning (ML), artificial intelligence (AI) in 2025 without ANY background in the field and stay up-to-date with the latest news and state-of-the-art techniques!

This guide is intended for anyone having zero or a small background in programming, maths, and machine learning. There is no specific order to follow, but a classic path would be from top to bottom. If you don't like reading books, skip it, if you don't want to follow an online course, you can skip it as well. There is not a single way to become a machine learning expert and with motivation, you can absolutely achieve it.

All resources listed here are free, except some online courses and books, which are certainly recommended for a better understanding, but it is definitely possible to become an expert without them, with a little more time spent on online readings, videos and practice. When it comes to paying courses, the links in this guide are affiliated links. Please, use them if you feel like following a course as it will support me. Thank you, and have fun learning! Remember, this is completely up to you and not necessary. I felt like it was useful to me and maybe useful to others as well.

Don't be afraid to repeat videos or learn from multiple sources. Repetition is the key of success to learning!

Maintainer: [louisfb01](https://github.com/louisfb01), also active on [YouTube](https://www.youtube.com/@whatsai) and as a [Podcaster](https://open.spotify.com/show/4rKRJXaXlClkDyInjHkxq3) if you want to see/hear more about AI! You can also learn more twice a week in [my personal newsletter](https://louisbouchard.substack.com/)! [Subscribe](https://louisbouchard.substack.com/) and get AI news and updates explained clearly!

[![Twitter](https://img.shields.io/twitter/url/https/twitter.com/cloudposse.svg?style=social&label=Follow%20%40whats_ai)](https://twitter.com/Whats_AI)

Feel free to message me any great resources to add to this repository at bouchard.lf@gmail.com

***Tag me on Twitter [@Whats_AI](https://twitter.com/Whats_AI) or LinkedIn [@Louis Bouchard](https://www.linkedin.com/in/whats-ai/)  if you share the list!***

### Want to know what is this guide about? Watch this video:

[<img src="https://imgur.com/JFRt2Jb.png" width="512"/>](https://youtu.be/RirEw-uaS_8)

----

👀 **If you'd like to support my work**, you can check to [Sponsor](https://github.com/sponsors/louisfb01) this repository.

[<img src="https://imgur.com/hLr2aQF.png" width="512"/>](https://academy.towardsai.net/courses/beginner-to-advanced-llm-dev?ref=1f9b29)

----

## Table of Contents
- [Start with short YouTube video introductions](#youtubevideos)
- [Follow free online courses on YouTube](#youtubecourses)
- [Read articles](#readarticles)
- [Read books](#readbooks)
- [No math background for ML? Check this out!](#math)
- [No coding background, no problem](#coding)
- [Follow online courses](#onlinecourses)
- [Practice, practice, and practice!](#practice)
- [Want to build language models/apps? Check this out! (now with LLMs!)](#nlp)
- [More resources (Communities, cheat sheets, news, and more!)](#moreresources)
- [How to find a machine learning job](#findajob)
- [AI Ethics](#aiethics)

## Start with short YouTube video introductions<a name="youtubevideos"></a>
### Start with short YouTube videos introductions
This is the best way to start from nothing in my opinion. Here, I list a few of the best videos I found that will give you a great first introduction of the terms you need to know to get started in the field.

* Introduction to the most used terms
    * [Learn the basics in a minute - Louis Bouchard](https://www.youtube.com/playlist?list=PLO4GrDnQanVe6F6MRJg_KO7JEoH-ukFzY) - YouTube Playlist
    
* Understand the neural networks
    * [Neural Networks Demystified - Welch Labs](https://www.youtube.com/playlist?list=PLiaHhY2iBX9hdHaRr6b7XevZtgZRa1PoU) - YouTube Playlist
    * [Learn Neural Networks - 3Blue1Brown](https://www.youtube.com/playlist?list=PLZHQObOWTQDNU6R1_67000Dx_ZCJB-3pi) - YouTube Playlist
    * [Math for Machine Learning - Weights & Biases](https://www.youtube.com/playlist?list=PLD80i8An1OEGZ2tYimemzwC3xqkU0jKUg) - YouTube Playlist
    * [The spelled-out intro to neural networks and backpropagation: building micrograd](https://youtu.be/VMj-3S1tku0) - YouTube Video by Andrej Karpathy

* Understanding Transformers and LLMs (i.e. models behind ChatGPT)!
   * Luis Serrano, "[Natural Language Processing and Large Language Models](https://www.youtube.com/playlist?list=PLs8w1Cdi-zvYskDS2icIItfZgxclApVLv)" - amazing video introductions to the attention mechanism, tokens, embeddings and more to better understand everything behind large language models like GPT!
   * Louis Bouchard's LLM free course videos "[Train & Fine-Tune LLMs for Production Course by Activeloop, Towards AI & Intel Disruptor](https://youtube.com/playlist?list=PLO4GrDnQanVcPlQUBuMd_pwRkILfc463G&si=QbXeHeDs5RSKH3nY)". "A playlist for our LLM course: Gen AI 360: Foundational Model Certification!"

Another easy **way to get started and keep learning is by listening to podcasts** in your spare time. Driving to work, on the bus, or having trouble falling asleep? Listen to some AI podcasts to get used to the terms and patterns, and learn about the field through inspiring stories! I invite you to follow a few of the best I personally prefer, like [Lex Fridman](https://open.spotify.com/show/2MAi0BvDc6GTFvKFPXnkCL), [Machine Learning Street Talk](https://open.spotify.com/show/02e6PZeIOdpmBGT9THuzwR), [Latent Space Podcast](https://www.latent.space/podcast), and obviously, my podcast: [Louis Bouchard Podcast](https://open.spotify.com/show/4rKRJXaXlClkDyInjHkxq3), where you will learn about incredibly talented people in the field with inspiring stories sharing the knowledge they worked so hard to gather.

## Follow free online courses on YouTube<a name="youtubecourses"></a>
### Follow free online courses on YouTube
Here is a list of awesome courses available on YouTube that you should definitely follow and are 100% free.

* [Introduction to machine learning](https://www.youtube.com/playlist?list=PLoROMvodv4rMiGQp3WXShtMGgzqpfVfbU) - YouTube Playlist (Stanford)

* [Introduction to deep learning](https://www.youtube.com/playlist?list=PLtBw6njQRU-rwp5__7C0oIVt26ZgjG9NI) - YouTube Playlist (MIT)
    
* [Deep learning specialization](https://www.youtube.com/channel/UCcIXc5mJsHVYTZR1maL5l9w/playlists) - YouTube Playlist (Deeplearning.ai)

* [Deep Learning (with PyTorch)](https://atcold.github.io/NYU-DLSP21/) - NYU, Yann LeCun

* [MIT Deep Learning](https://deeplearning.mit.edu/) - Lex Fridman's up-to-date deep learning course


## Read articles<a name="readarticles"></a>
### Read many articles
Here is a list of awesome articles available online that you should definitely read and are 100% free.
[Medium](https://whats-ai.medium.com/membership) is pretty much the best place to find great explanations, either on [Towards AI](https://pub.towardsai.net/) or [Towards Data Science](https://towardsdatascience.com/) publications. I also share my own articles there and I love using the platform. You can subscribe to Medium using my affiliated link [here](https://whats-ai.medium.com/membership) if this sounds interesting to you and if you'd like to support me at the same time!

* [Start AI in 2022 — Become an expert from nothing, for free!](https://www.louisbouchard.ai/learnai/) - Louis Bouchard
* [5 Beginner Friendly Steps to Learn Machine Learning and Data Science with Python](https://towardsdatascience.com/5-beginner-friendly-steps-to-learn-machine-learning-and-data-science-with-python-bf69e211ade5) - Daniel Bourke
* [What is Machine Learning?](https://medium.com/towards-artificial-intelligence/what-is-machine-learning-ml-b58162f97ec7) - Roberto Iriondo
* [Machine Learning for Beginners: An Introduction to Neural Networks](https://towardsdatascience.com/machine-learning-for-beginners-an-introduction-to-neural-networks-d49f22d238f9) - Victor Zhou
* [A Beginners Guide to Neural Networks](https://towardsdatascience.com/a-beginners-guide-to-neural-networks-d5cf7e369a13#:~:text=Neural%20networks%20are%20powered%20by,then%20recognize%2C%20interpret%20and%20classify.) - Thomas Davis
* [Understanding Neural Networks](https://towardsdatascience.com/understanding-neural-networks-22b29755abd9) - Prince Canuma
* [Reading lists for new MILA students](https://docs.google.com/document/d/1IXF3h0RU5zz4ukmTrVKVotPQypChscNGf5k6E25HGvA/edit#) - Anonymous
* [The 80/20 AI Reading List](https://medium.com/machine-learning-for-humans/ai-reading-list-c4753afd97a) - Vishal Maini


## Read Books<a name="readbooks"></a>
### Read some books
Here are some great books to read for the people preferring the reading path.

* [Building LLMs for Production: Enhancing LLM Abilities and Reliability with Prompting, Fine-Tuning, and RAG](https://amzn.to/4bqYU9b) - by Towards AI. "Discover the key tech stacks for adapting Large Language Models to real-world applications, including Prompt Engineering, Fine-tuning, and Retrieval Augment Generation." (Or get the e-book [here](https://academy.towardsai.net/courses/buildingllmsforproduction?ref=1f9b29). You can DM me for a nice discount!)
* [Deep learning book](https://www.deeplearningbook.org/) - Free Online
* [Dive into Deep Learning](http://d2l.ai/) - Free Online
* [Probabilistic Machine Learning: An Introduction](https://probml.github.io/pml-book/book1.html) - Free Online
* [Artificial Intelligence: A Modern Approach](https://amzn.to/3mSqhk2) - Optional (Paying)
* [Pattern Recognition and Machine Learning](https://amzn.to/3mPUGPF) - Optional (Paying)
* [Deep Learning with Python](https://amzn.to/32iR3sm) - Optional (Paying)
* [Understanding Machine Learning: From Theory to Algorithms](https://www.cs.huji.ac.il/~shais/UnderstandingMachineLearning/index.html) - Shai Shalev-Shwartz and Shai Ben-David - Free Online

Great books for building your math background:

* [Mathematics for Machine Learning](https://mml-book.com/) - Free Online
* [The Elements of Statistical Learning](https://amzn.to/3mMn5Gy) - Optional (Paying)
* [Statistical Inference](https://amzn.to/3wRqIzD) - Optional (Paying)

A complete Calculus background:

* [Calculus: Concepts and Contexts](https://amzn.to/2OT4NXC) - Optional (Paying)
* [Single Variable Calculus: Concepts and Contexts](https://amzn.to/3wXtzHf) - Optional (Paying)
* [Multivariable Calculus: Concepts and Contexts](https://amzn.to/32jIRYC) - Optional (Paying)

These books are completely optional, but they will provide you a better understanding of the theory and even teach you some stuff about coding your neural networks!

## No math background for ML? Check this out!<a name="math"></a>
### No math background for ML? Check this out!
Don't stress, just like most of the things in life, you can learn maths! Here are some great beginner and advanced resources to get into machine learning maths. I would suggest starting with these three very important concepts in machine learning (here are 3 awesome free courses available on Khan Academy):

* [Linear Algebra](https://www.khanacademy.org/math/linear-algebra) - Khan Academy
* [Statistics and probability](https://www.khanacademy.org/math/statistics-probability) - Khan Academy
* [Multivariable Calculus](https://www.khanacademy.org/math/multivariable-calculus) - Khan Academy

Here are some great free books and videos that might help you learn in a more "structured approach":

* [mathematicalmonk](https://www.youtube.com/channel/UCcAtD_VYwcYwVbTdvArsm7w) - YouTube
* [Mathematics for Machine Learning](https://gwthomas.github.io/docs/math4ml.pdf) - Garrett Thomas
* [An Introduction to Statistical Learning: with Applications in R (Springer Texts in Statistics)](http://fs2.american.edu/alberto/www/analytics/ISLRLectures.html) - Gareth James, Daniela Witten, Trevor Hastie and Robert Tibshirani

If you still lack mathematical confidence, check out the [Read books](#ReadBooks) section above, where I shared many great books to build a strong mathematical background.
You now have a very good math background for machine learning and you are ready to dive in deeper!


## No coding background, no problem<a name="coding"></a>
### No coding background, no problem
Here is a list of some great courses to learn the programming side of machine learning.

* [Practical Machine Learning Tutorial with Python](https://www.youtube.com/playlist?list=PLQVvvaa0QuDfKTOs3Keq_kaG2P55YRn5v) - Free YouTube python introduction
* [Learn Python](https://www.learnpython.org/) - Free interactive tutorial to learn python
* [Learn Python Basics for Data Analysis](https://openclassrooms.com/en/courses/2304731-learn-python-basics-for-data-analysis/6009031-get-started-with-python-and-anaconda) - Free course on OpenClassrooms
* [Getting started with Python and R for Data Science](https://youtu.be/6LWnvC2_DZI?list=PL8eNk_zTBST8kAYLTxYRnsOfznYMRhgZG) - Free
* [Machine Learning with Python | Coursera - IBM](https://coursera.pxf.io/P0vOZe) - Optional (Paying)
* [Introduction to Python for Data Science](https://datasciencedojo.com/python-for-data-science/ref/whatsai/) - In this Python for Data Science course, students will be learning core Python concepts and use the language as it relates to data science in a 16-week learning program (paying, optional).
* [100 numpy exercises](https://github.com/rougier/numpy-100/blob/master/100_Numpy_exercises.ipynb) - A collection of exercises that have been collected in the numpy mailing list, on stack overflow and in the numpy documentation.
* [Shell tutorial](https://swcarpentry.github.io/shell-novice/) - Learn to use the Unix shell! A must for developers and AI practitioners.


> Check out [the Louis Bouchard podcast](https://open.spotify.com/show/4rKRJXaXlClkDyInjHkxq3) for more AI content in the form of interviews with experts in the field! An invited AI expert and I will cover specific topics, sub-fields, and roles related to AI to teach and share knowledge from the people who worked hard to gather it.


## Follow online courses<a name="onlinecourses"></a>
### (Optional) Get a better understanding and more guided practice by following some online courses
If you prefer to be more guided and have clear steps to follow, these courses are the best ones to do.

* [DEEP LEARNING - Yann LeCun](https://atcold.github.io/pytorch-Deep-Learning/?fbclid=IwAR0HQC0NZannqXaaHEj3sJCgLjRxkyDXC-gAoCTN4077wFA33R_udrJfHw4) - This course concerns the latest techniques in deep learning and representation learning. - Free
* [Intro to Machine Learning - Kaggle](https://www.kaggle.com/learn/intro-to-machine-learning) - Learn the core ideas in machine learning, and build your first models. - Free
* [Get started in AI / AI For everyone - Andrew Ng](https://coursera.pxf.io/gbeOKA) - Paying, optional
* [Machine learning - Andrew Ng - Stanford](https://coursera.pxf.io/oeg43O) - Paying, optional
* [AI Programming with Python - Complete nanodegree](https://imp.i115008.net/GjGzek) - Paying, optional
* [Deep learning specialization - Andrew Ng](https://coursera.pxf.io/WDvyaA) - Paying, optional
* [TensorFlow (Professional certificates)](https://coursera.pxf.io/6bQy9q) - Paying, optional
* [AI Engineering - IBM (Professional certificates)](https://coursera.pxf.io/RyNGjN) - Paying, optional
* [Complete data science bootcamp 2022](https://click.linksynergy.com/deeplink?id=8jtkHPNI0iU&mid=39197&murl=https%3A%2F%2Fwww.udemy.com%2Fcourse%2Fthe-data-science-course-complete-data-science-bootcamp%2F) - Paying, optional
* [Machine learning - No coding](https://click.linksynergy.com/link?id=8jtkHPNI0iU&offerid=507388.1292838&type=2&murl=https%3A%2F%2Fwww.udemy.com%2Fcourse%2Fhands-on-machine-learning-without-writing-code%2F) - Paying, optional
* [Data Science Training + Industry Experience](https://datasciencedojo.com/data-science-training-and-internship/ref/whatsai/) - A complete instructor-led 16-week training program with experience (paying, optional).
* [Instructor-led Online Data Science Bootcamp](https://datasciencedojo.com/data-science-bootcamp/ref/whatsai/) - A complete instructor-led 16-week learning program (paying, optional).
* [fast.ai's Deep Learning Courses](https://www.fast.ai/) - Free
* [CS50 - Introduction to Artificial Intelligence with Python (and Machine Learning), Harvard OCW](https://cs50.harvard.edu/ai/2020/) - Free (and usable for teachers as well!)
* [DEEP LEARNING COURSE - François Fleuret](https://fleuret.org/dlc/) - This course is a thorough introduction to deep-learning, with examples in the PyTorch framework. There are some [prerequisites](https://fleuret.org/dlc/#information).

For specific applications:
* [AI For trading nanodegree from Udacity](https://imp.i115008.net/Rymvkg) - Paid
* [Learn Deep Reinforcement learning - Udacity nanodegree](https://imp.i115008.net/7moj2y) - Paid
* [Become an NLP pro with Coursera's Natural Language Processing Specialization by deeplearning.ai](https://coursera.pxf.io/P0vO9e) - Paid
 _"Break into the NLP space. Master cutting-edge NLP techniques through four hands-on courses!"_


Get your models online and show them to the world:
* [Gradio Course - Create User Interfaces for Machine Learning Models - freeCodeCamp](https://youtu.be/RiCQzBluTxU) - Free
* [How to Deploy a Machine Learning Model to Google Cloud - Daniel Bourke](https://youtu.be/fw6NMQrYc6w) - Free
* [Machine Learning DevOps Engineer - Udacity Nanodegree](https://imp.i115008.net/mgZWAX) - Paid
* [AWS Machine Learning Engineer - Udacity Nanodegree](https://imp.i115008.net/9WO5Ry) - Paid


## Practice, practice, and practice!<a name="practice"></a>
### Practice is key

The most important thing in programming is practice. And this applies to machine learning too. It can be hard to find a personal project to practice.

Fortunately, [Kaggle](https://www.kaggle.com/) exists. This website is full of free courses, tutorials and competitions. You can join competitions for free and just download their data, read about their problem and start coding and testing right away! You can even earn money from winning competitions and it is a great thing to have on your resume. This may be the best way to get experience while learning a lot and even earn money! Another great opportunity for projects is to follow courses that are oriented towards a specific application like the [AI For trading course from Udacity](https://imp.i115008.net/Rymvkg).

You can also create teams for kaggle competition and learn with people! I suggest you join a community to find a team and learn with others, it is always better than alone. Check out the next section for that.


## Want to build language models/apps? Check this out (Now with LLMs!)!<a name="nlp"></a>
I had a lot of requests from people wanting to focus on natural language processing (NLP) (models dealing with language) or even learn machine learning strictly for NLP tasks. This is a section dedicated to that need. Happy NLP learning!
* [A complete roadmap to master NLP in 2022](https://www.analyticsvidhya.com/blog/2022/01/roadmap-to-master-nlp-in-2022/)
* [Become an NLP pro with Coursera's Natural Language Processing Specialization by deeplearning.ai](https://coursera.pxf.io/P0vO9e) - Paid
 _"Break into the NLP space. Master cutting-edge NLP techniques through four hands-on courses!"_
* [An NLP Nano Degree!](https://imp.i115008.net/jW4K60) — Paid
_"Learn cutting-edge natural language processing techniques to process speech and analyze text. Build probabilistic and deep learning models, such as hidden Markov models and recurrent neural networks, to teach the computer to do tasks such as speech recognition, machine translation, and more!"_
* NLTK Book is the free resource to learn about fundamental theories behind NLP: https://www.nltk.org/book/
* Looking to build a quick text classification model or word vectorizer, [fasttext](https://fasttext.cc/docs/en/supervised-tutorial.html) is a good library to quickly train up a model.
* [Huggingface](https://huggingface.co/course/chapter1/1) is THE place to get modern day NLP models, and they also include a whole [course](https://huggingface.co/course/chapter1/1) about it.
* [SpaCy](https://course.spacy.io/en/) is great for NLP in production, as it does NLU, NER, and one can train classification, etc with it. It's also able to add customized steps or models into the pipeline.
* [Prompting!](https://learnprompting.org/) Prompting is a new skill that you should master if you want to build NLP-related apps. This is a great course I am contributing to, intending to teach prompting and give tips for specific models.

### Train, fine-tune, and use Large Language Models!
* [LangChain & Vector Databases in Production](https://learn.activeloop.ai/courses/langchain/) - An amazing free resource we built at Towards AI in partnership with Activeloop and the Intel Disruptor Initiative to learn about LangChain & Vector Databases in Production. "Whether you are an experienced developer who's a newcomer to the AI realm or an experienced machine learning enthusiast, this course is designed for you. Our goal is to make AI accessible and practical, transforming how you approach your daily tasks and the overall impact of your work."
* [Training & Fine-Tuning LLMs for Production](https://learn.activeloop.ai/courses/llms/) - An amazing free resource we built at Towards AI in partnership with Activeloop and the Intel Disruptor Initiative to learn about Training & Fine-Tuning LLMs for Production. "If you want to learn how to train and fine-tune LLMs from scratch, and have intermediate Python knowledge as well as access to moderate compute resources (for some cases, just a Google Colab will suffice!), you should be all set to take and complete the course. This course is designed with a wide audience in mind, including beginners in AI, current machine learning engineers, students, and professionals considering a career transition to AI. We aim to provide you with the necessary tools to apply and tailor Large Language Models across a wide range of industries to make AI more accessible and practical."
* [From Beginners to Advanced LLM Developer](https://academy.towardsai.net/courses/beginner-to-advanced-llm-dev?ref=1f9b29) - by Towards AI. "Build Your First Scalable Product with LLMs, Prompting, RAG, Fine-Tuning, and Agents! Master the skills top companies need and build your own advanced LLM MVP with real-world applications."
* [Building LLMs for Production: Enhancing LLM Abilities and Reliability with Prompting, Fine-Tuning, and RAG](https://amzn.to/4bqYU9b) - by Towards AI. "Discover the key tech stacks for adapting Large Language Models to real-world applications, including Prompt Engineering, Fine-tuning, and Retrieval Augment Generation." (Or get the e-book [here](https://academy.towardsai.net/courses/buildingllmsforproduction?ref=1f9b29). You can DM me for a nice discount!)

[![Twitter](https://img.shields.io/twitter/url/https/twitter.com/cloudposse.svg?style=social&label=Follow%20%40whats_ai)](https://twitter.com/Whats_AI)

## More Resources<a name="moreresources"></a>
### Join communities!

* [A Discord server with many AI enthusiasts](https://discord.gg/learnaitogether) - Learn together, ask questions, find kaggle teammates, share your projects, and more.
* [A Discord server where you can stay up-to-date with the latest AI news](https://ws.towardsai.net/discord) - Stay up-to-date with the latest AI news, ask questions, share your projects, and much more.

* Follow reddit communities - Ask questions, share your projects, follow news, and more.
    * [artificial](https://www.reddit.com/r/artificial/) - Artificial Intelligence
    * [MachineLearning](https://www.reddit.com/r/MachineLearning/) - Machine Learning (Biggest subreddit of the field)
    * [DeepLearningPapers](https://www.reddit.com/r/DeepLearningPapers/) - Deep Learning Papers
    * [ComputerVision](https://www.reddit.com/r/computervision/) - Extracting useful information from images and videos
    * [learnmachinelearning](https://www.reddit.com/r/learnmachinelearning/) - Learn Machine Learning
    * [ArtificialInteligence](https://www.reddit.com/r/ArtificialInteligence/) - AI
    * [LatsestInML](https://www.reddit.com/r/LatestInML/) - Game-changing developments in machine learning you shouldn't miss


### Save Cheat Sheets!

* The best Cheat Sheets for Artificial Intelligence, Machine Learning, and Python.
    * [Cheat Sheets for AI, Neural Networks, Machine Learning, Deep Learning & Big Data](https://becominghuman.ai/cheat-sheets-for-ai-neural-networks-machine-learning-deep-learning-big-data-678c51b4b463) - Stefan Kojouharov
    * [Machine Learning cheatsheets for Stanford's CS 229](https://github.com/afshinea/stanford-cs-229-machine-learning) - Afshine Amidi & Shervine Amidi
    * [Cheat Sheet of Machine Learning and Python (and Math) Cheat Sheets](https://medium.com/machine-learning-in-practice/cheat-sheet-of-machine-learning-and-python-and-math-cheat-sheets-a4afe4e791b6) - Robbie Allen
    * [AI Expert Roadmap](https://i.am.ai/roadmap/#fundamentals) - Use it as a skillset checklist!

[<img src="https://imgur.com/hLr2aQF.png" width="512"/>](https://academy.towardsai.net/courses/beginner-to-advanced-llm-dev?ref=1f9b29)

### Follow the news in the field!

* Subscribe to YouTube channels that share new papers - Stay up to date with the news in the field!
    * [Louis Bouchard](https://www.youtube.com/channel/UCUzGQrN-lyyc0BWTYoJM_Sg) - Weekly videos covering new papers
    * [Two Minutes Papers](https://www.youtube.com/user/keeroyz) - Bi-weekly videos covering new papers
    * [Bycloud](https://www.youtube.com/channel/UCgfe2ooZD3VJPB6aJAnuQng) - Weekly videos covering new papers
    
* LinkedIn Groups
    * [Artificial Intelligence, Machine Learning and Deep Learning News](https://www.linkedin.com/groups/8942343/) - News of the field shared by everyone in the group
    * [Artificial Intelligence | Deep Learning  | Machine Learning](https://www.linkedin.com/groups/45655/)
    * [Applied Artificial Intelligence](https://www.linkedin.com/groups/127447/)
    
* Facebook Groups
    * [Artificial Intelligence & Deep Learning](https://www.facebook.com/groups/DeepNetGroup) - The definitive and most active FB Group on A.I., Neural Networks and Deep Learning. All things new and interesting on the frontier of A.I. and Deep Learning. Neural networks will redefine what it means to be a smart machine in the years to come.
    * [Deep learning](https://www.facebook.com/groups/DeepLearnng/) - Nowadays society tends to be soft and automated evolving into the 4th industrial revolution, which consequently drives the constituents into the swirl of societal upheaval. To survive or take a lead one is supposed to be equipped with associated tools. Machine is becoming smarter and more intelligent. Machine learning is inescapable skill and it requires people to be familiar with. This group is for these people who are interest in the development of their talents to fit in.

* Newsletters
   * [AlphaSignal](https://alphasignal.ai/) — The Most Read Technical Newsletter in AI
   * [AI News](https://buttondown.email/ainews/archive/) - by Swyx & friends - a lot of LLM aid going on indexing ~356 Twitters, ~21 Discords, etc. (I personally mostly read the main recap)
   * [Inside AI](https://inside.com/ai) - A daily roundup of stories and commentary on Artificial Intelligence, Robotics, and Neurotechnology.
   * [AI Weekly](http://aiweekly.co/) - A weekly collection of AI News and resources on Artificial Intelligence and Machine Learning.
   * [AI Ethics Weekly](https://lighthouse3.com/newsletter/) - The latest updates in AI Ethics delivered to your inbox every week.
   * [Louis Bouchard Weekly](https://louisbouchard.substack.com/) - One and only one paper clearly explained weekly with an article, video demo, demo, code, etc.
   * [Toward's AI newsletter](https://towardsai.net/ai/newsletter) - Summarizing the most interesting news and learning resources weekly as well as community updates from the Learn AI Together Discord community. Perfect for ML professionals and enthusiasts.
    
* Follow Medium accounts and publications
    * [Towards Data Science](https://towardsdatascience.com/) - "Sharing concepts, ideas, and codes"
    * [Towards AI](https://medium.com/towards-artificial-intelligence) - "The Best of Tech, Science, and Engineering."
    * [OneZero](https://onezero.medium.com/) - "The undercurrents of the future. A Medium publication about tech and science."
    * [Louis Bouchard](https://whats-ai.medium.com/) - "Hi, I am Louis (loo·ee, French pronunciation), from Montreal, Canada. I try to share and explain artificial intelligence terms and news the best way I can for everyone. My goal is to demystify the AI “black box” for everyone and sensitize people about the risks of using it."
   
* Check this complete GitHub guide to keep up with AI News
   * [BAILOOL/DoYouEvenLearn](https://github.com/louisfb01/DoYouEvenLearn) - Essential Guide to keep up with AI/ML/DL/CV
    
## Find a machine learning job<a name="findajob"></a>

* Read [this section from the article](https://www.louisbouchard.ai/learnai/#how-to-find-a-job) full of interview tips and **how to prepare for them**.
* Learn how the interview process goes and getting better at preparing for them by watching how others did it, like the [interview series](https://youtube.com/playlist?list=PLO4GrDnQanVfrRIuIT_1rlLLTgQJdfXmS) I ran with experts from NVIDIA, Zoox (Self-driving company), D-ID (Generative AI Startup), etc.

## AI Ethics<a name="aiethics"></a>
* [What are Ethics and Why do they Matter? Machine Learning Edition](https://www.youtube.com/watch?v=F0cxzESR7ec&list=PLtmWHNX-gukIU6V33Bc8eP8OD41I4GywR&ab_channel=RachelThomas) - by Rachel Thomas, founder of fast.ai
* [AI4People—An Ethical Framework for a Good AI Society: Opportunities, Risks, Principles, and Recommendations](https://link.springer.com/content/pdf/10.1007/s11023-018-9482-5.pdf) - Floridi et al., 2018, AI4People AI for a good society
* [Ethics guidelines for trustworthy AI](https://wayback.archive-it.org/12090/20210728013426/https://digital-strategy.ec.europa.eu/en/library/ethics-guidelines-trustworthy-ai) - European Commission high-level expert group 7 points for a trustworthy AI.
* [An Introduction to Ethics in Robotics and AI](https://link.springer.com/book/10.1007/978-3-030-51110-4) - a free e-book by Christoph Bartneck, Christoph Lütge, Alan Wagner, and Sean Welsh.


---


***Tag me on Twitter [@Whats_AI](https://twitter.com/Whats_AI) or LinkedIn [@Louis Bouchard](https://www.linkedin.com/in/whats-ai/)  if you share the list!***

👀 **If you'd like to support my work**, you can check to [Sponsor](https://github.com/sponsors/louisfb01) this repository.

This guide is still regularly updated.
