// Copyright IBM Corp. and LoopBack contributors 2020. All Rights Reserved.
// Node module: @loopback/filter
// This file is licensed under the MIT License.
// License text available at https://opensource.org/licenses/MIT

/**
 * A set of utility typings and filter builders to aid in constructing LoopBack
 * filters using the
 * {@link https://en.wikipedia.org/wiki/Builder_pattern | builder pattern}.
 *
 * @remarks
 * This lightweight module provides strongly-typed typings and filter builders
 * to intuitively construct LoopBack filters to be used against querying a
 * LoopBack filter-compatible server over the network or within the server
 * itself.
 *
 * @packageDocumentation
 */

export * from './query';
