# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

# [6.2.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@6.1.2...@loopback/cli@6.2.0) (2024-12-12)


### Bug Fixes

* update geopoint data in tests ([c2441cb](https://github.com/loopbackio/loopback-next/commit/c2441cbd77f8db55db6757f20576a5bde11b5c78))


### Features

* **cli:** add EditorConfig files to project template ([b6d82f9](https://github.com/loopbackio/loopback-next/commit/b6d82f950cb441061de895d4cdf3a0b92c859bec))





## [6.1.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@6.1.1...@loopback/cli@6.1.2) (2024-11-18)


### Bug Fixes

* add condition to check type of property before parsing from json object ([37d6780](https://github.com/loopbackio/loopback-next/commit/37d6780c5047283f4f5b5a5ce52887c99e649d13))
* fix accessing dependencies from yeoman's packageJson ([ca166f4](https://github.com/loopbackio/loopback-next/commit/ca166f4f93ad5e7b16e36cc1fa3f4dbc79a1616a))
* fix hasOne relation with the same table ([4427f25](https://github.com/loopbackio/loopback-next/commit/4427f25fa31f8b30c7978ab1e41a07b8fd402ced))





## [6.1.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@6.1.0...@loopback/cli@6.1.1) (2024-10-15)

**Note:** Version bump only for package @loopback/cli





# [6.1.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@6.0.5...@loopback/cli@6.1.0) (2024-09-12)


### Bug Fixes

* change dataSource to datasource for consistency ([0c69224](https://github.com/loopbackio/loopback-next/commit/0c692247b0594813bc0d0ef4f50cc69e5efe20b2))
* remove duplicate targetModelClassName import in has-one relation template ([57bae5b](https://github.com/loopbackio/loopback-next/commit/57bae5b315bf081cc601c7fbe90faf88fd60c992))
* update variable names to standard ([ec7c6a0](https://github.com/loopbackio/loopback-next/commit/ec7c6a02ad901a94648f59ee415f90f239a378bc))


### Features

* add a condition on process.env.HOST ([7c7f55f](https://github.com/loopbackio/loopback-next/commit/7c7f55fac3809fe7e44f00c9028cd96bbc412bec))





## [6.0.5](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@6.0.4...@loopback/cli@6.0.5) (2024-08-14)

**Note:** Version bump only for package @loopback/cli





## [6.0.4](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@6.0.3...@loopback/cli@6.0.4) (2024-07-09)


### Bug Fixes

* **cli:** add check on process.env.HOST ([d33ebf4](https://github.com/loopbackio/loopback-next/commit/d33ebf453a727c00f8445d60161feb0d942b32c7))





## [6.0.3](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@6.0.2...@loopback/cli@6.0.3) (2024-06-10)

**Note:** Version bump only for package @loopback/cli





## [6.0.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@6.0.1...@loopback/cli@6.0.2) (2024-05-17)

**Note:** Version bump only for package @loopback/cli





## [6.0.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@6.0.0...@loopback/cli@6.0.1) (2024-04-09)


### Bug Fixes

* enable lb4 relation generate relation with same table ([7dd40b0](https://github.com/loopbackio/loopback-next/commit/7dd40b09cf5e890a31b2075135c31d572140e938))





# [6.0.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@5.2.4...@loopback/cli@6.0.0) (2024-03-04)


### Bug Fixes

* update connector versions to latest ([b402065](https://github.com/loopbackio/loopback-next/commit/b4020656d36d9ef18e018cc56825de420bbf20ba))
* update loopback-connector-mysql to 7.0.5 (latest) ([e031d91](https://github.com/loopbackio/loopback-next/commit/e031d91859594591b211dc38eac12fe019103346))


### chore

* drop Node.js 16 support ([b9efcb4](https://github.com/loopbackio/loopback-next/commit/b9efcb477d50507ba3c778ba23ea7acba7692593))


### BREAKING CHANGES

* Drop Node.js 16 support in all LB4 modules and extensions

Signed-off-by: dhmlau <dhmlau@ca.ibm.com>





## [5.2.4](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@5.2.3...@loopback/cli@5.2.4) (2024-01-11)

**Note:** Version bump only for package @loopback/cli





## [5.2.3](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@5.2.2...@loopback/cli@5.2.3) (2023-12-12)


### Bug Fixes

* add process.exit for generators ([e5e1621](https://github.com/loopbackio/loopback-next/commit/e5e162179b28847428ddb873480723d38579e917))
* fix import update-notifier ([565fc1f](https://github.com/loopbackio/loopback-next/commit/565fc1fd43876fbee1de1ca39244ddf42f0c6a80))
* handle enum ([f664a76](https://github.com/loopbackio/loopback-next/commit/f664a76d554f1c33cfcbcbcd542e9d1dd1374923))
* revert change-case to 4.x ([271dfe3](https://github.com/loopbackio/loopback-next/commit/271dfe354eda41e777efb5006c650e2eb5092a59))





## [5.2.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@5.2.1...@loopback/cli@5.2.2) (2023-09-12)

**Note:** Version bump only for package @loopback/cli





## [5.2.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@5.2.0...@loopback/cli@5.2.1) (2023-08-15)


### Bug Fixes

* **cli:** display model choices alphabetically for "lb4 discover" CLI command ([d4d4347](https://github.com/loopbackio/loopback-next/commit/d4d4347905ced431b496194be9220754f7929c58))
* **cli:** fix linter errors ([7e91bde](https://github.com/loopbackio/loopback-next/commit/7e91bde3e1181b5a5ff6d56c26c83fddf3a305e3))





# [5.2.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@5.1.0...@loopback/cli@5.2.0) (2023-07-17)


### Bug Fixes

* fix the script to update cli templates ([b657b0e](https://github.com/loopbackio/loopback-next/commit/b657b0e3a28c0fdbe6234fc1fafc6ff5a384aa5e))
* pin ts-query to 5.x as 6.x breaks cli tests on macos ([7a0424b](https://github.com/loopbackio/loopback-next/commit/7a0424bf842e34f031495428b7df35e62a79dd36))
* use named exports ([34dfe4f](https://github.com/loopbackio/loopback-next/commit/34dfe4f107bf190c2b9fddeeef1702d72a34b9f2))


### Features

* add binary lb for cli ([f7ad002](https://github.com/loopbackio/loopback-next/commit/f7ad0020fbadbf7125340cd2fd66336a1eae1b86))





# [5.1.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@5.0.0...@loopback/cli@5.1.0) (2023-06-28)


### Bug Fixes

* check for existing relationImports ([2d5b659](https://github.com/loopbackio/loopback-next/commit/2d5b6597490a98151727a04268c07497da006652))
* fix the usage of the option --connector ([5ed00ea](https://github.com/loopbackio/loopback-next/commit/5ed00ea491424b648d24fa83a9b627d7682f9f4e)), closes [#9607](https://github.com/loopbackio/loopback-next/issues/9607)
* migrate Lerna to NPM Workspaces ([d5c4994](https://github.com/loopbackio/loopback-next/commit/d5c4994d28f1741427b427d99ca4df03936547e6))
* run lerna repair command ([fe72763](https://github.com/loopbackio/loopback-next/commit/fe727639605b839dbfb5afd953a47238aa5c01cc))


### Features

* update dependency @types/node to ^16 ([2af42b7](https://github.com/loopbackio/loopback-next/commit/2af42b721c6dfc2df49bfcac1cbea478aba417ab))





# [5.0.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.2.1...@loopback/cli@5.0.0) (2023-05-15)


### Bug Fixes

* add missing keys from config passed to lb4 relation ([d1ddfc2](https://github.com/loopbackio/loopback-next/commit/d1ddfc2018208099ddb972512c4e66c4ad9d1e6d))
* **cli:** fix for lb4 repository generator to recognize repositoryBaseClass in --config ([dac6631](https://github.com/loopbackio/loopback-next/commit/dac6631fd7742efa28a8b4eeb20452c2a8fd5fb3))
* **cli:** openapi generator implementation for controllers ([611a533](https://github.com/loopbackio/loopback-next/commit/611a533a4f773fc4dc6d42b78ae05e78f03c2e22))
* **cli:** recognize registerInclusionResolver provided in -c or --config ([f12963a](https://github.com/loopbackio/loopback-next/commit/f12963adee2db35f1178b797535516a58a6bab87))
* **cli:** update --help for relation ([132e986](https://github.com/loopbackio/loopback-next/commit/132e986edaf6345a0d9935371c35628488726c5a))
* remove repeated code from controller in case of same table hasManyThrough relation ([30a8bfc](https://github.com/loopbackio/loopback-next/commit/30a8bfc36bcfd3738a703eb63278f2a63b3f3c53))


### Features

* add support for node v20 ([e23cefa](https://github.com/loopbackio/loopback-next/commit/e23cefaf5cce3fb990cb09f4c94239d1979615b1))
* remove support for node v14 ([5425762](https://github.com/loopbackio/loopback-next/commit/5425762f1353869994acf081bcda4816e6a9c3b0))
* remove support for node v19 ([e26a2ac](https://github.com/loopbackio/loopback-next/commit/e26a2ac2e43245d09dfc9721ccfa41d830daccb8))


### BREAKING CHANGES

* End of life of Node v14

Signed-off-by: Francisco Buceta <frbuceta@gmail.com>





## [4.2.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.2.0...@loopback/cli@4.2.1) (2023-04-13)


### Bug Fixes

* allow belongsTo relation with same table ([584e4ac](https://github.com/loopbackio/loopback-next/commit/584e4acb174280fe947ac39ce099b7f72c08ca11))
* **cli:** extend from DefaultKeyValueRepository in case of kv datasource ([7afd25a](https://github.com/loopbackio/loopback-next/commit/7afd25a97fa0bd28f9319d31690ac20467c8a3b2))
* **cli:** pass flags to mysql-connector while lb4 discover ([357d0c3](https://github.com/loopbackio/loopback-next/commit/357d0c3c1b0dae27b1b2fafa4a04c9e170d4cff2))
* refresh package lock files ([9979eb1](https://github.com/loopbackio/loopback-next/commit/9979eb183b6c6cd5775da7478cdede8a92ce0d5e)), closes [#9351](https://github.com/loopbackio/loopback-next/issues/9351)
* replace backslash with forward slash ([38665f9](https://github.com/loopbackio/loopback-next/commit/38665f9f54fe94d5cbbb8b744f6b82854f444849))
* use glob named import ([7daf6fb](https://github.com/loopbackio/loopback-next/commit/7daf6fb6b82e2ce01e3693869c695fe77146238d))





# [4.2.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.1.8...@loopback/cli@4.2.0) (2023-03-09)


### Bug Fixes

* **cli:** add lerna bootstrap as dep ([c37658c](https://github.com/loopbackio/loopback-next/commit/c37658c45968171a8f02b4d9e706b4c60607a20e))
* **cli:** fixed cli not detecting custom base repositories ([1e70be0](https://github.com/loopbackio/loopback-next/commit/1e70be0a7e4997b71f0bb529bfff5579b89033f1)), closes [#8637](https://github.com/loopbackio/loopback-next/issues/8637)
* **cli:** response type from array to object in belongsTo ([d9a0f69](https://github.com/loopbackio/loopback-next/commit/d9a0f695be3cf22481b33de102dfb3656209fa22))


### Features

* **cli:** add support for Binary to handle blob ([f8dde03](https://github.com/loopbackio/loopback-next/commit/f8dde034a5d4eaf7c32c0150ca40dcdd3e5d90a9))
* **cli:** specify models with --models in lb4 discover ([4f5f9cc](https://github.com/loopbackio/loopback-next/commit/4f5f9cc17ac0acfab17abfceaaaf3b9171d8066f))





## [4.1.8](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.1.7...@loopback/cli@4.1.8) (2023-02-07)


### Reverts

* "chore: update dependency rimraf to v4" ([c516d5e](https://github.com/loopbackio/loopback-next/commit/c516d5e33e2d2ce950c6811305e7da3fe40ca9c6))





## [4.1.7](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.1.6...@loopback/cli@4.1.7) (2023-01-09)

**Note:** Version bump only for package @loopback/cli





# Change Log

All notable changes to this project will be documented in this file. See
[Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## [4.1.6](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.1.5...@loopback/cli@4.1.6) (2022-12-14)

### Bug Fixes

- **cli:** made changes so update comamnd updates the peerDependencies as well
  ([bb755d1](https://github.com/loopbackio/loopback-next/commit/bb755d1240abaedcf7a8d322a9889242982654aa)),
  closes [#9144](https://github.com/loopbackio/loopback-next/issues/9144)

# Change Log

All notable changes to this project will be documented in this file. See
[Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## [4.1.5](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.1.4...@loopback/cli@4.1.5) (2022-11-24)

### Bug Fixes

- **cli:** fix lb4 discover --config missing provided options
  ([b8704a6](https://github.com/loopbackio/loopback-next/commit/b8704a6dcc036c6db42eb58024456bcbb721ef9b)),
  closes [#8963](https://github.com/loopbackio/loopback-next/issues/8963)
  [#8966](https://github.com/loopbackio/loopback-next/issues/8966)

# Change Log

All notable changes to this project will be documented in this file. See
[Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## [4.1.4](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.1.3...@loopback/cli@4.1.4) (2022-10-13)

### Bug Fixes

- **cli:** change artifact name
  ([121eed3](https://github.com/loopbackio/loopback-next/commit/121eed35e20d39960ccba5d01dd9c90cdfa3fe2a))
- **openapi-spec-builder:** fix resolution of openapi urls returning http
  unauthorized error
  ([809b503](https://github.com/loopbackio/loopback-next/commit/809b50362a36ecf45eff262f81079b542186b12e))
- the TypeGuards has been replaced by Node
  ([4c047f4](https://github.com/loopbackio/loopback-next/commit/4c047f4915f0e5d6df05384eff30da5d9c8818b2))

## [4.1.3](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.1.2...@loopback/cli@4.1.3) (2022-08-25)

**Note:** Version bump only for package @loopback/cli

## [4.1.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.1.1...@loopback/cli@4.1.2) (2022-08-11)

### Bug Fixes

- **cli:** does not generate an application or extension with node > v16
  ([72cc49b](https://github.com/loopbackio/loopback-next/commit/72cc49bf7d1bf6ce8018d9fce5f173af4af7f0ac))

## [4.1.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.1.0...@loopback/cli@4.1.1) (2022-07-14)

### Bug Fixes

- **docs:** documentation update for typo availble
  ([f9782fd](https://github.com/loopbackio/loopback-next/commit/f9782fdd0ccd208bdfa01f9f4c62e0b58d1060b3))
- **docs:** documentation update from seuqence to sequence
  ([62898a2](https://github.com/loopbackio/loopback-next/commit/62898a292e48f61d39e193224358c8cb46b743e8))
- **docs:** documentation updates for datasoure to datasource
  ([c05a7e6](https://github.com/loopbackio/loopback-next/commit/c05a7e6f8b50c2db51a157f94c2b77fbcc8b7406))

# [4.1.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0...@loopback/cli@4.1.0) (2022-06-13)

### Bug Fixes

- **cli:** look for all id properties including composite keys
  ([1a51f32](https://github.com/loopbackio/loopback-next/commit/1a51f322cc618a553dda346c1fe4e3905e794746))

### Features

- **cli:** add option to create relations in cli discover command
  ([37a5f73](https://github.com/loopbackio/loopback-next/commit/37a5f73ada12b64035ef32b01411c28d72058887))
- **cli:** add option to mark id field as not required in discover command
  ([497b21d](https://github.com/loopbackio/loopback-next/commit/497b21d84d970a8dcc714d059108cabdf99d46e0))
- **rest-crud:** add option to create readonly rest-crud apis
  ([6ae1423](https://github.com/loopbackio/loopback-next/commit/6ae142302ca61363a357559ba42243bdaf4f7256))

## [4.0.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@3.2.0...@loopback/cli@4.0.0) (2022-05-05)

### ⚠ BREAKING CHANGES

- remove node v12 support

### Features

- add support for node v18
  ([ccb4c61](https://github.com/loopbackio/loopback-next/commit/ccb4c61307d94ab7bb07a19c547dfc4fa7d388a8))
- remove node v12 support
  ([5f66e5b](https://github.com/loopbackio/loopback-next/commit/5f66e5bd288ba806b3aa6550fc29c5009de8b60d))
- **repository:** support `ReferencesMany` relation
  ([371a6dc](https://github.com/loopbackio/loopback-next/commit/371a6dcdf32d1a9a674f22528160b775f6639364))

### Bug Fixes

- **cli:** added missing checks for options provided in command or config
  ([8c75809](https://github.com/loopbackio/loopback-next/commit/8c758093e4e5578bf0c534a681c079ea06565f6d))

# [3.2.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@3.1.1...@loopback/cli@3.2.0) (2022-03-29)

### Features

- **cli:** model generator can now pick properties from config file
  ([06b804b](https://github.com/loopbackio/loopback-next/commit/06b804bd61bd05036bc23177dc21e1b5d90ed0e2))

## [3.1.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@3.1.0...@loopback/cli@3.1.1) (2022-02-28)

**Note:** Version bump only for package @loopback/cli

# [3.1.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@3.0.1...@loopback/cli@3.1.0) (2022-02-14)

### Features

- update @types/node to v12
  ([65a09a4](https://github.com/loopbackio/loopback-next/commit/65a09a406e4865f774f97b58af9e616733b8b255))

## [3.0.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@3.0.0...@loopback/cli@3.0.1) (2022-01-11)

**Note:** Version bump only for package @loopback/cli

# [3.0.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.22.1...@loopback/cli@3.0.0) (2021-11-18)

### Features

- drop support for Node.js v10
  ([9bcbbb3](https://github.com/loopbackio/loopback-next/commit/9bcbbb358ec3eabc3033d4e7e1c22b524a7069b3))
- support Node.js v17
  ([8d86c03](https://github.com/loopbackio/loopback-next/commit/8d86c03cb7047e2b1f18d05870628ef5783e71b2))
- upgrade to TypeScript 4.5.2
  ([72ece91](https://github.com/loopbackio/loopback-next/commit/72ece91289ecfdfd8747bb9888ad75db73e8ff4b))

### BREAKING CHANGES

- drop support for Node.js v10

Co-authored-by: Francisco Buceta <frbuceta@gmail.com> Signed-off-by: Rifa
Achrinza <25147899+achrinza@users.noreply.github.com>

## [2.22.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.22.0...@loopback/cli@2.22.1) (2021-10-18)

### Bug Fixes

- **cli:** use relative path in homepage
  ([312c58e](https://github.com/loopbackio/loopback-next/commit/312c58e1b5c67dddb85deb9711263ab8f893716e)),
  closes [#6826](https://github.com/loopbackio/loopback-next/issues/6826)

# [2.22.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.21.2...@loopback/cli@2.22.0) (2021-09-16)

### Features

- **cli:** add socketio example
  ([cb88d21](https://github.com/loopbackio/loopback-next/commit/cb88d213d63f6442a78c0d5eb5d8cdb3a7d0e72a))
- **cli:** update docs and apply suggested changes
  ([df01aa2](https://github.com/loopbackio/loopback-next/commit/df01aa2a4733cf6c2d4bafc6fba0c1a29e5b7967))
- **cli:** updates loopback-connector-grpc
  ([3fd4d1d](https://github.com/loopbackio/loopback-next/commit/3fd4d1d495f846e09aaca129744e9ea69e030301))

## [2.21.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.21.1...@loopback/cli@2.21.2) (2021-07-15)

**Note:** Version bump only for package @loopback/cli

## [2.21.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.21.0...@loopback/cli@2.21.1) (2021-06-10)

### Bug Fixes

- **cli:** do not create migration script if repositories not selected
  ([3cfd556](https://github.com/loopbackio/loopback-next/commit/3cfd5569830bfcddf68a95cb95f9267c238746a5))

# [2.21.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.20.2...@loopback/cli@2.21.0) (2021-05-03)

### Bug Fixes

- **cli:** invalid package.plain.json.ejs template
  ([df085a4](https://github.com/loopbackio/loopback-next/commit/df085a44d43bfd117b683699a2fe39b410244a5e))
- add url-slug v3 changes
  ([7b32782](https://github.com/loopbackio/loopback-next/commit/7b32782253e8c56f0d21ebd8b40b8d1fb61752d0))

### Features

- support node v16
  ([ac99415](https://github.com/loopbackio/loopback-next/commit/ac994154543bde22b4482ba98813351656db1b55))
- **cli:** april drop
  ([ad1df67](https://github.com/loopbackio/loopback-next/commit/ad1df6746431ccc062d5654c3f5133ecb5d31231))

## [2.20.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.20.1...@loopback/cli@2.20.2) (2021-04-06)

**Note:** Version bump only for package @loopback/cli

## [2.20.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.20.0...@loopback/cli@2.20.1) (2021-04-06)

### Bug Fixes

- cli openapi generator op name inference
  ([a9b561c](https://github.com/loopbackio/loopback-next/commit/a9b561c3a322aa6a6a4b725dc4da6e3881c21a4c)),
  closes [#3417](https://github.com/loopbackio/loopback-next/issues/3417)

# [2.20.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.19.0...@loopback/cli@2.20.0) (2021-03-18)

### Bug Fixes

- update spdx-license-list
  ([34073ce](https://github.com/loopbackio/loopback-next/commit/34073cec118aea4002e474cae0573d3cd94c9d1b))
- use a named export with @lerna/\*
  ([d0f6a7d](https://github.com/loopbackio/loopback-next/commit/d0f6a7dac49a32d27ba3971ccb893da5396b36ee))
- **cli:** add rebuild script to package.json of extensions
  ([c7623a2](https://github.com/loopbackio/loopback-next/commit/c7623a245821bb770ad6e01a0bd8a4954684e026))

### Features

- update package-lock.json to v2 consistently
  ([dfc3fbd](https://github.com/loopbackio/loopback-next/commit/dfc3fbdae0c9ca9f34c64154a471bef22d5ac6b7))
- upgrade to TypeScript 4.2.x
  ([05930bc](https://github.com/loopbackio/loopback-next/commit/05930bc0cece3909dd66f75ad91eeaa2d365a480))

### Reverts

- Revert "chore: update dependency spdx-license-list to ^6.4.0"
  ([86aa11a](https://github.com/loopbackio/loopback-next/commit/86aa11aed5afb358891e6a6c9d6b01e2a493585b))

# [2.19.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.18.0...@loopback/cli@2.19.0) (2021-02-09)

### Features

- **cli:** add graphql example
  ([6e53690](https://github.com/loopbackio/loopback-next/commit/6e536904cd495a6d9d2d34bf9d184a2fa56c7bb2))

# [2.18.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.17.2...@loopback/cli@2.18.0) (2021-01-21)

### Bug Fixes

- **cli:** copyright year git integration
  ([ce8fa66](https://github.com/loopbackio/loopback-next/commit/ce8fa663e756d49cc1544752461f4b62b28a72ce))

### Features

- fix eslint violations
  ([062de9c](https://github.com/loopbackio/loopback-next/commit/062de9c5f908332f58f54ddf13798a22ca21f1e7))

## [2.17.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.17.1...@loopback/cli@2.17.2) (2020-12-07)

### Bug Fixes

- show README with yarn when selected and make it dynamic
  ([e2a88c8](https://github.com/loopbackio/loopback-next/commit/e2a88c8878e3dfff84b98789180b5aaae870a2eb))

## [2.17.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.17.0...@loopback/cli@2.17.1) (2020-11-18)

**Note:** Version bump only for package @loopback/cli

# [2.17.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.16.1...@loopback/cli@2.17.0) (2020-11-05)

### Bug Fixes

- **cli:** add missing language to code blocks
  ([672d331](https://github.com/loopbackio/loopback-next/commit/672d33111b840a9436c40d6fb7c2d583366ec2b8))
- **cli:** fix build error when manually deleting a model, repository or
  controller
  ([00c9ee7](https://github.com/loopbackio/loopback-next/commit/00c9ee71e3b94af36c0a4643a5e91420490ff146)),
  closes [#3259](https://github.com/loopbackio/loopback-next/issues/3259)
- **cli:** print a warning for Node.js versions that are not supported
  ([a03bc34](https://github.com/loopbackio/loopback-next/commit/a03bc34d0499bf6f7c96a5fc1cace45a32a92475))

### Features

- **cli:** add vscode launch tasks in app
  ([4b86952](https://github.com/loopbackio/loopback-next/commit/4b869527f46dc2917760330b87de09fa22a3d75d))
- **cli:** improve lb4 copyright to accept custom license-header.template
  ([cf071cb](https://github.com/loopbackio/loopback-next/commit/cf071cb8546b1922b60443f3e86b1aeb8e336f8a))
- **core:** add `init` to application life cycle events
  ([747bc7f](https://github.com/loopbackio/loopback-next/commit/747bc7fda83f44b288aefa505c6eddbe387122d4))

## [2.16.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.16.0...@loopback/cli@2.16.1) (2020-10-08)

**Note:** Version bump only for package @loopback/cli

# [2.16.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.15.1...@loopback/cli@2.16.0) (2020-10-07)

### Bug Fixes

- **cli:** update package dependencies in cli template
  ([ac511ee](https://github.com/loopbackio/loopback-next/commit/ac511ee264b72b314105da14ac0ec4c35d0cac9c))

### Features

- **cli:** add exit option to mocharc template in generator
  ([64dbbde](https://github.com/loopbackio/loopback-next/commit/64dbbde2678d3a9de25ccad4f0b3b7adf77aa3db))
- **cli:** build before migrate and openapi-spec
  ([b1d0bd6](https://github.com/loopbackio/loopback-next/commit/b1d0bd69319f71712d2dd257e3dea734218b3cbb))
- **cli:** improve `lb4 update` to any package that uses `@loopback/*`
  ([9892b35](https://github.com/loopbackio/loopback-next/commit/9892b35ff771e40b9b2c3a5c5d7e17104a863211))
- **cli:** leave numbers in dirname alone
  ([3c970ae](https://github.com/loopbackio/loopback-next/commit/3c970aec818f2371be3dec56e620b2cb29223c49))
- **example-webpack:** add an example to generate bundles with webpack
  ([53bbb3a](https://github.com/loopbackio/loopback-next/commit/53bbb3a1ad36e45672bf8f64257e343f18258bd5))
- **repository:** implement hasManyThrough resolver
  ([8e7767d](https://github.com/loopbackio/loopback-next/commit/8e7767df0a4679c8c70ad524e56aea9783def521))

## [2.15.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.15.0...@loopback/cli@2.15.1) (2020-09-18)

**Note:** Version bump only for package @loopback/cli

# [2.15.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.14.0...@loopback/cli@2.15.0) (2020-09-17)

### Features

- **cli:** improve README.md for application projects
  ([38582f4](https://github.com/loopbackio/loopback-next/commit/38582f43f0c325656344443189948fcf031efa37))

# [2.14.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.13.1...@loopback/cli@2.14.0) (2020-09-15)

### Features

- update examples and docs to use `@loopback/*` instead of
  `@loopback/extension-*`
  ([a96b7cb](https://github.com/loopbackio/loopback-next/commit/a96b7cbb2e146f941b1fec0e7dd0b0829dcd0245))
- **cli:** move "@loopback/core" to peerDependencies for new extensions
  ([3ee9a39](https://github.com/loopbackio/loopback-next/commit/3ee9a39acd6d76d200808dc1604c1d88b2bf42f9))
- **cli:** update translation message
  ([6cea7cf](https://github.com/loopbackio/loopback-next/commit/6cea7cf85c7ac7bf38904ca4fd547d723e809432))

## [2.13.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.13.0...@loopback/cli@2.13.1) (2020-08-27)

**Note:** Version bump only for package @loopback/cli

# [2.13.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.12.0...@loopback/cli@2.13.0) (2020-08-19)

### Bug Fixes

- ibm i db2 connector
  ([e6a6cfd](https://github.com/loopbackio/loopback-next/commit/e6a6cfdb5ffc1ed6f77cc8fe1179408e835090d0))
- remove .npmrc when Yarn has been selected
  ([ebb6b3a](https://github.com/loopbackio/loopback-next/commit/ebb6b3aa87bdca6a65034386104947f1936fd09b))
- use Yarn in scripts when Yarn is selected
  ([142ae8b](https://github.com/loopbackio/loopback-next/commit/142ae8b9d124e9f8c71ac4e9b6ae4b1c13c42d13))
- **docs:** rename legacy juggler to juggler
  ([d1febb1](https://github.com/loopbackio/loopback-next/commit/d1febb17341ef647e203cb24cba3b716c0163f4c))

### Features

- add the git user as the author of a project
  ([873ea96](https://github.com/loopbackio/loopback-next/commit/873ea9651766234053b4d6142495c8e94b4c194e))
- set the project template version to 0.0.1
  ([05bbf62](https://github.com/loopbackio/loopback-next/commit/05bbf62f70237691ed9ae21101de7f056fd6d260))
- **cli:** update translation messages
  ([c854e4f](https://github.com/loopbackio/loopback-next/commit/c854e4f697a37f85778b1f867f5e568ecd1832a5))

# [2.12.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.11.0...@loopback/cli@2.12.0) (2020-08-05)

### Features

- **cli:** add hasManyThrough to relation option
  ([1c3fb1e](https://github.com/loopbackio/loopback-next/commit/1c3fb1eaf9dfeb887545a075f2c468a5900d345f))
- **cli:** update eslintignore template to skip linting `.eslintrc.js`
  ([a8b3b00](https://github.com/loopbackio/loopback-next/commit/a8b3b00845e8922ca4fd2572ffeedfaa4a979b50))
- **cli:** update template for `src/sequence.ts`
  ([dc5023c](https://github.com/loopbackio/loopback-next/commit/dc5023cc26ae4e81a542bdc4d861104bffc8ed1b))

# [2.11.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.10.0...@loopback/cli@2.11.0) (2020-07-20)

### Bug Fixes

- fix
  ([852e7d8](https://github.com/loopbackio/loopback-next/commit/852e7d8c9fab34a71a5232001a01db779cf7bfe9))
- globalize artifacts creation result
  ([dfdad08](https://github.com/loopbackio/loopback-next/commit/dfdad088eb8d82cdff63ec801c4a0ac3e3af8573))
- globalize help options
  ([44ac989](https://github.com/loopbackio/loopback-next/commit/44ac9894ff0679f4a48d867e5c515923c6754ef2))
- globalize strings for repository generator
  ([2cbe048](https://github.com/loopbackio/loopback-next/commit/2cbe04844bc8065e0c1f127a96967a9a70940fe3))
- globlize strings for model generator
  ([67729f9](https://github.com/loopbackio/loopback-next/commit/67729f918572a0144cc67fab6cfaa2ad389e9d33))

### Features

- **cli:** honor `required` flag for parameters
  ([5debaa9](https://github.com/loopbackio/loopback-next/commit/5debaa9d0f856b6a5df88cdd54e2a8253c9a0b5b))
- **cli:** remove openapi-v3 from project template dependencies
  ([e992c15](https://github.com/loopbackio/loopback-next/commit/e992c1551fe4a398b7add572c335c6c5309cae5b))
- **cli:** update translation messages
  ([c28acef](https://github.com/loopbackio/loopback-next/commit/c28acefd2bcb0af4c4eff59f04ed4058a6eef603))

# [2.10.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.9.1...@loopback/cli@2.10.0) (2020-06-30)

### Bug Fixes

- **cli:** set processDestinationPath option for backward-compatibility
  ([b1de0d5](https://github.com/loopbackio/loopback-next/commit/b1de0d5922a894155a805418d1826537706232ef))

### Features

- **cli:** improve snapshot matcher to be compatible with parallel testing
  ([862072b](https://github.com/loopbackio/loopback-next/commit/862072b82ad88ec4b248e0b243dda58b53640f94))

## [2.9.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.9.0...@loopback/cli@2.9.1) (2020-06-23)

### Bug Fixes

- set node version to >=10.16 to support events.once
  ([e39da1c](https://github.com/loopbackio/loopback-next/commit/e39da1ca47728eafaf83c10ce35b09b03b6a4edc))

# [2.9.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.8.0...@loopback/cli@2.9.0) (2020-06-11)

### Features

- **cli:** allow custom copyright/license lines
  ([f4ef6b6](https://github.com/loopbackio/loopback-next/commit/f4ef6b64305812922a1a61ba837111e5c8509fdc))

# [2.8.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.7.1...@loopback/cli@2.8.0) (2020-05-28)

### Bug Fixes

- **cli:** group union/intersection types for array
  ([5172b5f](https://github.com/loopbackio/loopback-next/commit/5172b5ffac629c6b875e9416f587db0eaa986634))
- **docs:** add todo-jwt to example list
  ([7024e8e](https://github.com/loopbackio/loopback-next/commit/7024e8e969684e6a5f0ecbcf08b98e6c940024c4))
- use correct relation name in belongsTo template
  ([826120c](https://github.com/loopbackio/loopback-next/commit/826120c10a881c80232e4963a6e0148790ba6518))

### Features

- **cli:** print out a url for `lb4 update` to open changelogs
  ([ccd7531](https://github.com/loopbackio/loopback-next/commit/ccd7531abeb5e45a97fc7f1b9bb4817727c08cbe))
- **cli:** update application template to generate openapi-spec.ts
  ([3b58292](https://github.com/loopbackio/loopback-next/commit/3b582929714915fb21487228f5f56c2562626ef3))

## [2.7.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.7.0...@loopback/cli@2.7.1) (2020-05-20)

**Note:** Version bump only for package @loopback/cli

# [2.7.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.6.0...@loopback/cli@2.7.0) (2020-05-19)

### Bug Fixes

- **cli:** add yeoman-environment as a dependency
  ([065ff27](https://github.com/loopbackio/loopback-next/commit/065ff273d60264e1d3fe87ab249bfaa139149010))

### Features

- upgrade to TypeScript 3.9.x
  ([3300e45](https://github.com/loopbackio/loopback-next/commit/3300e4569ab8410bb1285f7a54d326e9d976476d))
- **cli:** remove `node_modules` before run `npm install` for `lb4 update`
  ([54ff104](https://github.com/loopbackio/loopback-next/commit/54ff10429b91355adb6363847de3c0cc2bf28da1))
- **cli:** update dependencies to be compatible with ESLint 7.x
  ([d05d357](https://github.com/loopbackio/loopback-next/commit/d05d3575312f987155542ce0222e2da86d3dfbe9))

# [2.6.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.5.0...@loopback/cli@2.6.0) (2020-05-07)

### Bug Fixes

- **cli:** add passport-login to example cli
  ([221bd6b](https://github.com/loopbackio/loopback-next/commit/221bd6b958763e3bf0a8f6fa5dc7c1be090d82d1))
- **cli:** ignoring default when require is true
  ([44fd3bc](https://github.com/loopbackio/loopback-next/commit/44fd3bcd03c6c4c0f8e6467466a23ad14f35120b))
- **cli:** make yarn related tests conditional on the yarn availablity
  ([3c579f6](https://github.com/loopbackio/loopback-next/commit/3c579f66da2ed47d0e44d733dcba63ed5403ff1d))

### Features

- **cli:** add `baseModel` option for `lb4 openapi` command
  ([53f819d](https://github.com/loopbackio/loopback-next/commit/53f819dfc372ea48b90a04fd2e59f1a62233e9dc))
- **cli:** add bash-completion using tabtab package
  ([a0dd2c9](https://github.com/loopbackio/loopback-next/commit/a0dd2c9a20bcd36b8fac85a07aa0a3bbff56694f))
- **cli:** add middleware support in sequence.ts template
  ([b2df4e6](https://github.com/loopbackio/loopback-next/commit/b2df4e641aa973eddf0b4df25cc23c88bf22981e))
- **cli:** add yarn support for generated projects
  ([320aab9](https://github.com/loopbackio/loopback-next/commit/320aab9eddadf38a001f8aea690d108dfa5b5dfa))

# [2.5.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.4.4...@loopback/cli@2.5.0) (2020-04-29)

### Bug Fixes

- **authentication-jwt:** fix package.json and rename the package
  ([0973d18](https://github.com/loopbackio/loopback-next/commit/0973d18ee4e94391367ee3510a9f0bc2eebaf4b7))
- **cli:** clean up datasource/service code generation
  ([818121f](https://github.com/loopbackio/loopback-next/commit/818121f69e78cf4d0e5d747b90ef6cfe32b68f4e))
- **cli:** extract body from response object returned by openapi connector
  ([2895ad9](https://github.com/loopbackio/loopback-next/commit/2895ad9d0c3a16af24f5335b055693900fdf1b16))
- **cli:** fix eslint violation as `fs.exists` returns `void`
  ([c70839b](https://github.com/loopbackio/loopback-next/commit/c70839b1a0f90a570eff4ac63dac3c64b01dae60))
- **cli:** fix schema conversion with array types
  ([12718bf](https://github.com/loopbackio/loopback-next/commit/12718bfd075de165586a92194b4650093c48c211))
- **cli:** mitigate json schema to be draft 7 compatible
  ([0f6816a](https://github.com/loopbackio/loopback-next/commit/0f6816af26267c6573e374b7ad7a90d43e2055f0))
- **cli:** skip datasource selection with `--url` or non-matched `--datasource`
  ([352bf34](https://github.com/loopbackio/loopback-next/commit/352bf34359b75efbbb77f9890db178391e908121))

### Features

- **cli:** update opencli templates to match the openapi connector
  ([a9965a3](https://github.com/loopbackio/loopback-next/commit/a9965a39ba82b9297f2a0d98b47846eea4a69516))
- remove hand-written datasource `stop()` method
  ([df4ee09](https://github.com/loopbackio/loopback-next/commit/df4ee09482fa67522629c381a0de595ce12d9a1b))
- **cli:** add translation for 10 languages
  ([c93735f](https://github.com/loopbackio/loopback-next/commit/c93735fdc60fa959fc93ecc1c6251d654f673e8c))
- **cli:** add translation for 4 left languages
  ([a2a9270](https://github.com/loopbackio/loopback-next/commit/a2a9270401dc9818aafa2e040bc9180aad146afc))
- **cli:** convert OpenAPI schema to JSON schema for model/property
  ([d0785dd](https://github.com/loopbackio/loopback-next/commit/d0785ddd38c836d7495199f9a563f24931b0ec11))
- **cli:** improve `lb4 openapi --client` to handle method name mapping
  ([c2f7ebd](https://github.com/loopbackio/loopback-next/commit/c2f7ebd9bd4a734e66299fd7858bdfd737d35140))
- **cli:** use forward-slash characters in spec URL on Windows
  ([89fc25f](https://github.com/loopbackio/loopback-next/commit/89fc25fbc9ef3523a9306abcb39ce2054f7d2da7))
- **cli:** uses `HttpErrors` for openapi service proxies
  ([0aa5e23](https://github.com/loopbackio/loopback-next/commit/0aa5e237691e75b2959827b922f0432bc522391a))
- move datasource config from JSON to TS files
  ([6105456](https://github.com/loopbackio/loopback-next/commit/6105456deb6d7acadc3e46867558311dce2d005c))

## [2.4.4](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.4.3...@loopback/cli@2.4.4) (2020-04-23)

### Bug Fixes

- **cli:** fix the `lb4 app --apiconnect` code generation
  ([ca5135a](https://github.com/loopbackio/loopback-next/commit/ca5135a539301633298a39b9738e308f2fce6c1b))
- **cli:** remove project references from examples
  ([6359ed6](https://github.com/loopbackio/loopback-next/commit/6359ed6f33b3ed4c5ce0c87aa077c02225cc7651)),
  closes
  [loopbackio/loopback-next#5155](https://github.com/loopbackio/loopback-next/issues/5155)

## [2.4.3](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.4.2...@loopback/cli@2.4.3) (2020-04-22)

### Bug Fixes

- **cli:** examples now use tsconfig.json instead of tsconfig.build.json
  ([f01b4e9](https://github.com/loopbackio/loopback-next/commit/f01b4e915a00266bca02ac519e12026e774e0c98))

## [2.4.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.4.1...@loopback/cli@2.4.2) (2020-04-22)

**Note:** Version bump only for package @loopback/cli

## [2.4.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.4.0...@loopback/cli@2.4.1) (2020-04-22)

**Note:** Version bump only for package @loopback/cli

# [2.4.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.3.1...@loopback/cli@2.4.0) (2020-04-22)

### Bug Fixes

- add global strings from controller generator
  ([c87bd07](https://github.com/loopbackio/loopback-next/commit/c87bd07c833e02831a1d7c92d3d8e730f540159c))
- fixes help menu undefined options
  ([25baa8f](https://github.com/loopbackio/loopback-next/commit/25baa8f0870a48e5c1b2bd6dede64aee6bc18d11))
- globalize app generator strings
  ([45e0172](https://github.com/loopbackio/loopback-next/commit/45e0172863b3787e039ffbf588b925c60ac984e5))
- globalize messages from artiface generator
  ([5d54b55](https://github.com/loopbackio/loopback-next/commit/5d54b551fec4ded1737e3e29384ab4b694d65b65))
- **cli:** check if the object is `null` for OpenAPI spec cloning
  ([ee13e9c](https://github.com/loopbackio/loopback-next/commit/ee13e9c37fdcb7464477bcd969d0d82741a8d0cb))
- globalize lb4 example strings
  ([98fe611](https://github.com/loopbackio/loopback-next/commit/98fe6118a3fcfde906bccdabac176785bfa50d44))
- overwrite generator options from yeoman
  ([ecfedee](https://github.com/loopbackio/loopback-next/commit/ecfedeec7ab0ad7bbf739bb3d8d93f8946f72207))
- **cli:** exclude `**/node_modules/**/*` from copyright header searching
  ([9d989bd](https://github.com/loopbackio/loopback-next/commit/9d989bd7f7baadf2d8c8e0548d4702184e350054))
- **cli:** fix property schema mapping for openapi specs
  ([b851aed](https://github.com/loopbackio/loopback-next/commit/b851aed4886be50d03aefc022bd7d9c9089523ef))

### Features

- **cli:** add --client option for `lb4 openapi` to generate service proxies
  ([63a18c8](https://github.com/loopbackio/loopback-next/commit/63a18c8cae03c18954653cee36d1043833c03e54))
- **cli:** add `--apiconnect` option to enable ApiConnectComponent
  ([c2931d6](https://github.com/loopbackio/loopback-next/commit/c2931d6cb8d5f4077c3e680885eee0eee929bd6d))
- **cli:** allow generator fs to be used for updating index.ts
  ([3c7ca41](https://github.com/loopbackio/loopback-next/commit/3c7ca41115948afc70a67a9f0d471949af8308f9))
- **cli:** populate OpenAPI spec objects into generated code
  ([ae620d4](https://github.com/loopbackio/loopback-next/commit/ae620d4ad5e2be4bf8dcaac9b4842166b9b76215))

## [2.3.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.3.0...@loopback/cli@2.3.1) (2020-04-11)

### Bug Fixes

- **cli:** make the StatusConflicter compatible with the base Conflicter
  ([b6a1af9](https://github.com/loopbackio/loopback-next/commit/b6a1af98ccb0705ee3a802df68bb590ec74473f5))
- **cli:** remove unused imports from the crud controller template
  ([848272d](https://github.com/loopbackio/loopback-next/commit/848272d980e94bc9f0878e678de12a336c0d8b8a))

# [2.3.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.2.1...@loopback/cli@2.3.0) (2020-04-08)

### Bug Fixes

- **cli:** allow `-h` for help
  ([f74092e](https://github.com/loopbackio/loopback-next/commit/f74092eb20acd9e9ab1875c56ccbcb2e55f4c1da))
- **cli:** make sure generated package.json is well formatted
  ([38be23f](https://github.com/loopbackio/loopback-next/commit/38be23f46f02ea380f1290f12704078925d264cd))
- **cli:** remove `All rights reserved.` from the header for LICENSE
  ([ce78b2a](https://github.com/loopbackio/loopback-next/commit/ce78b2a81314aacb46b525121ecdfdbd97d0d94e))

### Features

- **cli:** add `lb4 copyright` to generate/update file headers
  ([abc6111](https://github.com/loopbackio/loopback-next/commit/abc6111148a831f47308f4284215ac9564f3c12b))
- **cli:** add `updateLicense` to `lb4 copyright` command
  ([535df04](https://github.com/loopbackio/loopback-next/commit/535df04df75d39f2a5e36740ae1e0de27359af78))
- **cli:** allow --exclude <glob-pattern> to not update headers for excluded
  files
  ([a81ce7e](https://github.com/loopbackio/loopback-next/commit/a81ce7e1193f7408d30d984d0c3ddcec74f7c316))
- **cli:** implement dark mode in the app template
  ([6939546](https://github.com/loopbackio/loopback-next/commit/6939546d2b0cba59d8a70ce500dbf1b6e42d682b))
- **cli:** print options for `lb4 copyright --help` and update docs
  ([f23ecb7](https://github.com/loopbackio/loopback-next/commit/f23ecb741bcd589767d94acf2a394efddfe37ff6))
- **cli:** wrap license text with a max line length of 80 chars
  ([a9046ed](https://github.com/loopbackio/loopback-next/commit/a9046ed639076bf8e06a0952c0ae2a298f92c330))

## [2.2.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.2.0...@loopback/cli@2.2.1) (2020-03-24)

**Note:** Version bump only for package @loopback/cli

# [2.2.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.1.1...@loopback/cli@2.2.0) (2020-03-24)

### Bug Fixes

- **cli:** add validation-app to example cli
  ([36a70b3](https://github.com/loopbackio/loopback-next/commit/36a70b39062e3e8d467a3a820a51a58ffaefb613))
- update package locks
  ([cd2f6fa](https://github.com/loopbackio/loopback-next/commit/cd2f6fa7a732afe4a16f4ccf8316ff3142959fe8))

### Features

- **cli:** add `lb4 rest-crud` command to generate model endpoints from
  model/datasource
  ([38fd41e](https://github.com/loopbackio/loopback-next/commit/38fd41e26cd5abf52e69d0b275a730b195be813a))

## [2.1.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.1.0...@loopback/cli@2.1.1) (2020-03-17)

**Note:** Version bump only for package @loopback/cli

# [2.1.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.0.1...@loopback/cli@2.1.0) (2020-03-17)

### Bug Fixes

- **cli:** add ibmi, relocate db2z for affinity to other db2s
  ([76bb470](https://github.com/loopbackio/loopback-next/commit/76bb470e8feba478796741d09b35fdb7549b79ab))
- **cli:** add missing examples to CLI
  ([221d8d0](https://github.com/loopbackio/loopback-next/commit/221d8d00973e28475aee7771c521fd06b2723ef4))

### Features

- **cli:** add translations for 14 languages
  ([31bc951](https://github.com/loopbackio/loopback-next/commit/31bc951c405e3bf21bc10875bc1c8cc6a1bab794))
- **example-file-upload-download:** add file download support
  ([12afd6b](https://github.com/loopbackio/loopback-next/commit/12afd6b47ee1d371c68d03bd86c03d49b5f43b8d))
- **example-rest-crud:** add example showing CrudRestApiBuilder
  ([ea37afb](https://github.com/loopbackio/loopback-next/commit/ea37afb8d9e4ca9aef032b84e349e918d945e8ee))

## [2.0.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@2.0.0...@loopback/cli@2.0.1) (2020-03-05)

### Bug Fixes

- **cli:** include intl in package.json
  ([097724b](https://github.com/loopbackio/loopback-next/commit/097724bc0d38ce6a499d2a26092a570451b5e026))

# [2.0.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.30.1...@loopback/cli@2.0.0) (2020-03-05)

### Bug Fixes

- remove ref for v4.loopback.io
  ([78f20c0](https://github.com/loopbackio/loopback-next/commit/78f20c0ed4db5f3ce0d7b676449ba3b22526319e))
- **cli:** correct root directory in test
  ([f951052](https://github.com/loopbackio/loopback-next/commit/f951052a12b82923b18f781c3b0292de0a2c8634)),
  closes [#4425](https://github.com/loopbackio/loopback-next/issues/4425)
- **cli:** extract messages for generators
  ([2f572bd](https://github.com/loopbackio/loopback-next/commit/2f572bd75883420e38bfaa780bc38445aec92e65))
- **cli:** extract messages for generators
  ([b264d60](https://github.com/loopbackio/loopback-next/commit/b264d60752e8487c0649b1f47419dbc06a111384))
- **cli:** ignore stdin when config is provided via CLI args
  ([3d64cfe](https://github.com/loopbackio/loopback-next/commit/3d64cfebe19ae26b66ae7639a8ddffbf3dd54061))
- **cli:** move `loopback` to devDependencies
  ([7701cab](https://github.com/loopbackio/loopback-next/commit/7701cab4a18f37be62269d075045a0d0b8eb7d57))
- **cli:** update tsconfig template excludes
  ([1fcc463](https://github.com/loopbackio/loopback-next/commit/1fcc4633af333b56d0ba978e58fbc29778861215)),
  closes
  [/github.com/loopbackio/loopback-next/pull/4707#issuecomment-590255940](https://github.com//github.com/loopbackio/loopback-next/pull/4707/issues/issuecomment-590255940)
- cleanup tilde-path-app post test
  ([4562a50](https://github.com/loopbackio/loopback-next/commit/4562a5055c40ea91d33c4e1f29c08edcefa7fdef)),
  closes [#4652](https://github.com/loopbackio/loopback-next/issues/4652)

### chore

- remove support for Node.js v8.x
  ([4281d9d](https://github.com/loopbackio/loopback-next/commit/4281d9df50f0715d32879e1442a90b643ec8f542))

### Features

- use [@param](https://github.com/param).filter and
  [@param](https://github.com/param).where decorators
  ([896ef74](https://github.com/loopbackio/loopback-next/commit/896ef7485376b3aedcca01a40f828bf1ed9470ae))
- **cli:** add `tslib` as a template dependency
  ([267b074](https://github.com/loopbackio/loopback-next/commit/267b074a93dc7483333486e2b381b3d7168ebc79)),
  closes [#4676](https://github.com/loopbackio/loopback-next/issues/4676)
- **cli:** add build:globalize option
  ([3c42077](https://github.com/loopbackio/loopback-next/commit/3c4207730cd87e9399b18969c71515d44991e547))
- **cli:** allow different naming convention for discover
  ([298e66e](https://github.com/loopbackio/loopback-next/commit/298e66e7430406d2615f7826c770ee126ae56d18))
- **cli:** automatically include base models when importing LB3 models
  ([9d5f8a7](https://github.com/loopbackio/loopback-next/commit/9d5f8a771f475c1597bc5e1d22efc06e4940cbb7))
- **cli:** import LB3 models with a custom base class
  ([aa3dc12](https://github.com/loopbackio/loopback-next/commit/aa3dc12e32bd9c297742c9b54224644ea81f7526))
- **cli:** improve logging from processing of config & options
  ([41a39c1](https://github.com/loopbackio/loopback-next/commit/41a39c17a595bb92ea928d93318cc353e3e19218))
- **cli:** skip inherited props & settings when importing a LB3 model
  ([97c8b05](https://github.com/loopbackio/loopback-next/commit/97c8b0535f32dc5271d84fa8b66009126ddae8e1))
- .vscode add typescript lint rules
  ([e8eb371](https://github.com/loopbackio/loopback-next/commit/e8eb371af12ced96d0c87c88eae2be40b76c7911)),
  closes [#4584](https://github.com/loopbackio/loopback-next/issues/4584)
- add `tslib` as dependency
  ([a6e0b4c](https://github.com/loopbackio/loopback-next/commit/a6e0b4ce7b862764167cefedee14c1115b25e0a4)),
  closes [#4676](https://github.com/loopbackio/loopback-next/issues/4676)
- lb3 migration tests for models customized with db metadata
  ([c58cc11](https://github.com/loopbackio/loopback-next/commit/c58cc117b6e7a75e1920ce873a9cb4b98ff1058b))

### BREAKING CHANGES

- Node.js v8.x is now end of life. Please upgrade to version 10 and above. See
  https://nodejs.org/en/about/releases.

## [1.30.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.30.0...@loopback/cli@1.30.1) (2020-02-06)

**Note:** Version bump only for package @loopback/cli

# [1.30.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.29.0...@loopback/cli@1.30.0) (2020-02-05)

### Features

- leverage isactive for transaction
  ([fc94437](https://github.com/loopbackio/loopback-next/commit/fc9443787039d4a1db3008a0141f5693f95bfbd4))
- **cli:** add hasOne relation type to `lb4 relation`
  ([3046f3e](https://github.com/loopbackio/loopback-next/commit/3046f3e9ca29225c2ca64567af0be337a6fa5b00))

# [1.29.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.28.1...@loopback/cli@1.29.0) (2020-01-27)

### Bug Fixes

- **cli:** disgard any changes if lb4 `relation` fails
  ([08dc87c](https://github.com/loopbackio/loopback-next/commit/08dc87ca3f654f3669c5ffb130e1e4cbf0dcebef))
- **cli:** fix has many relation controller attribute
  ([5aa83df](https://github.com/loopbackio/loopback-next/commit/5aa83df2fe3c38165174328d26726690f6cbafb5))
- **cli:** index file should be updated. Add relation interface to model
  template
  ([7fd9b88](https://github.com/loopbackio/loopback-next/commit/7fd9b88626a7d1b4a227077a4334fdbd00edea0d))
- **cli:** reject datasources with no name property for service generator
  ([cc871e5](https://github.com/loopbackio/loopback-next/commit/cc871e509b5c3a0de2ac0dc1108332285aa808a4))

### Features

- **cli:** add static BINDING_KEY prop to non-global interceptors
  ([5fbd95f](https://github.com/loopbackio/loopback-next/commit/5fbd95f47f67207d7e0430d8c08e2a9738e685ae))

## [1.28.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.28.0...@loopback/cli@1.28.1) (2020-01-07)

**Note:** Version bump only for package @loopback/cli

# [1.28.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.27.0...@loopback/cli@1.28.0) (2020-01-07)

### Features

- add title property to ping response schema definition
  ([b8b7490](https://github.com/loopbackio/loopback-next/commit/b8b7490ce29d0973208ba38c3365de9091b7a795))

# [1.27.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.26.0...@loopback/cli@1.27.0) (2019-12-09)

### Features

- **cli:** add default option for gracePeriodForClose to configure http/https
  close
  ([5a243e2](https://github.com/loopbackio/loopback-next/commit/5a243e280868c4b83d7b5685f326a44baf5cbd9a))
- **cli:** update templates to enable esModuleInterop and default imports from
  non-ES modules
  ([83e628b](https://github.com/loopbackio/loopback-next/commit/83e628bdf5834102aa9042e52a3d7e608d2d1754))

# [1.26.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.25.1...@loopback/cli@1.26.0) (2019-11-25)

### Bug Fixes

- **cli:** disconnect the datasource after the model was discovered
  ([ad30c61](https://github.com/loopbackio/loopback-next/commit/ad30c61e8f35795bef6c2aef893884e520561832))
- **cli:** emit correct property definitions for built-in types
  ([6a972db](https://github.com/loopbackio/loopback-next/commit/6a972db819aab9f831a26da4f2f81abe3c26efe7))
- **cli:** emit correct property definitions for built-in types
  ([9d34f23](https://github.com/loopbackio/loopback-next/commit/9d34f23bd8eadaed9a38ca95339384bddce041b2))
- **cli:** handle missing target artifact dir
  ([ba34838](https://github.com/loopbackio/loopback-next/commit/ba348384b045d6976e257f09cdc610766568abfa))
- **cli:** updated OAS 'Date' JS Type Mapping to 'string'
  ([839caa9](https://github.com/loopbackio/loopback-next/commit/839caa92038d5ba8548106cd4136ee40d9abf679))

### Features

- **cli:** add `connectors.json`
  ([802529e](https://github.com/loopbackio/loopback-next/commit/802529ed0ba1e3a9f9ef417b4b8b4a7459589682))
- use stringifyObject instead of JSON.stringify for connector metadata
  ([da60ee7](https://github.com/loopbackio/loopback-next/commit/da60ee79d48a7ec11f510ccdbecc878e28651237))
- **cli:** add lb4 update command to check/update project dependencies
  ([54d1896](https://github.com/loopbackio/loopback-next/commit/54d1896f63705b6938fe74ba2c21ad0b4d9bea23))
- **cli:** add the ability to check latest cli version
  ([869d1e4](https://github.com/loopbackio/loopback-next/commit/869d1e4b19ba5483521a632a9c8af4b39ca7254f))
- **cli:** update controller template to enable filter for findById endpoint
  ([b0ce84b](https://github.com/loopbackio/loopback-next/commit/b0ce84b79158cadf2f53bbe627da4d8196f0543f))

## [1.25.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.25.0...@loopback/cli@1.25.1) (2019-11-13)

**Note:** Version bump only for package @loopback/cli

# [1.25.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.24.0...@loopback/cli@1.25.0) (2019-11-12)

### Bug Fixes

- **cli:** improve message for model discovery code generation
  ([15c11d4](https://github.com/loopbackio/loopback-next/commit/15c11d4b6644182b4bd5fc6be34fe805104fc3ca))
- update error message when failing to read datasource, to include filename
  ([6663733](https://github.com/loopbackio/loopback-next/commit/6663733586ec3a98816f63a887c28b3debf51e4c)),
  closes [#3965](https://github.com/loopbackio/loopback-next/issues/3965)

### Features

- **cli:** generate datasource json with '.config.json` extension
  ([51d8f7b](https://github.com/loopbackio/loopback-next/commit/51d8f7b20ec59f888fd6d0634efb47d111f00ef7))
- **cli:** improve UX of multi-item selection
  ([077f38c](https://github.com/loopbackio/loopback-next/commit/077f38ceccb2e1568aed69dbe00e298b30106c30))
- **cli:** recognize PK properties defined as `{id: 1}`
  ([1094509](https://github.com/loopbackio/loopback-next/commit/10945093e17b260686e532804f71965d7b156606))

# [1.24.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.23.2...@loopback/cli@1.24.0) (2019-10-24)

### Bug Fixes

- **cli:** append "Service" in service generator
  ([c8fb805](https://github.com/loopbackio/loopback-next/commit/c8fb8058c375fe22b0c64988c7ff91c1024084ed))

### Features

- **cli:** add inclusion resolver to lb4 relation
  ([199e1bc](https://github.com/loopbackio/loopback-next/commit/199e1bc84a6c57fe650db9588bdb121d27eca7a3))

## [1.23.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.23.1...@loopback/cli@1.23.2) (2019-10-07)

### Bug Fixes

- **cli:** fix typo in cli relation tests
  ([466f79b](https://github.com/loopbackio/loopback-next/commit/466f79b))

## [1.23.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.23.0...@loopback/cli@1.23.1) (2019-09-28)

### Bug Fixes

- **cli:** make sure properties are correctly generated
  ([369d58b](https://github.com/loopbackio/loopback-next/commit/369d58b))

# [1.23.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.22.1...@loopback/cli@1.23.0) (2019-09-27)

### Bug Fixes

- **cli:** remove extra SPACE at EOL in help output
  ([aeaf793](https://github.com/loopbackio/loopback-next/commit/aeaf793))

### Features

- **cli:** add new command `import-lb3-model` (EXPERIMENTAL)
  ([2e465e6](https://github.com/loopbackio/loopback-next/commit/2e465e6))
- **cli:** print help on updating snapshots when some snapshots were not matched
  ([c6959b8](https://github.com/loopbackio/loopback-next/commit/c6959b8))
- **cli:** write snapshot files in parallel
  ([a16ae34](https://github.com/loopbackio/loopback-next/commit/a16ae34))

## [1.22.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.22.0...@loopback/cli@1.22.1) (2019-09-17)

**Note:** Version bump only for package @loopback/cli

# [1.22.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.21.6...@loopback/cli@1.22.0) (2019-09-17)

### Bug Fixes

- **cli:** exclude \*.tsbuildinfo from Docker image
  ([581a0f3](https://github.com/loopbackio/loopback-next/commit/581a0f3))
- model with id required
  ([270e13e](https://github.com/loopbackio/loopback-next/commit/270e13e))
- **cli:** fix schema title for POST operation in relation controllers
  ([34a2077](https://github.com/loopbackio/loopback-next/commit/34a2077))

### Features

- **cli:** add lifecycle support for datasources
  ([8573173](https://github.com/loopbackio/loopback-next/commit/8573173))
- use descriptive title to describe schema of POST (create) request bodies
  ([8f49a45](https://github.com/loopbackio/loopback-next/commit/8f49a45))
- **eslint-config:** enable "no-misused-promises" rule
  ([88d5494](https://github.com/loopbackio/loopback-next/commit/88d5494))

## [1.21.6](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.21.5...@loopback/cli@1.21.6) (2019-09-06)

**Note:** Version bump only for package @loopback/cli

## [1.21.5](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.21.4...@loopback/cli@1.21.5) (2019-09-03)

### Bug Fixes

- **cli:** belongsto property generation
  ([82a95d4](https://github.com/loopbackio/loopback-next/commit/82a95d4))

## [1.21.4](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.21.3...@loopback/cli@1.21.4) (2019-08-19)

**Note:** Version bump only for package @loopback/cli

## [1.21.3](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.21.2...@loopback/cli@1.21.3) (2019-08-15)

**Note:** Version bump only for package @loopback/cli

## [1.21.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.21.1...@loopback/cli@1.21.2) (2019-08-15)

**Note:** Version bump only for package @loopback/cli

## [1.21.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.21.0...@loopback/cli@1.21.1) (2019-08-15)

### Bug Fixes

- set foreignkey to be optional in the requestbody of hasmany relation
  ([d46ea18](https://github.com/loopbackio/loopback-next/commit/d46ea18))

# [1.21.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.20.0...@loopback/cli@1.21.0) (2019-07-31)

### Bug Fixes

- add class name separation to multiple class names output
  ([fc79bf5](https://github.com/loopbackio/loopback-next/commit/fc79bf5)),
  closes [#3350](https://github.com/loopbackio/loopback-next/issues/3350)

### Features

- **cli:** improve `lb4 service` to generate local service classes/providers
  ([f743008](https://github.com/loopbackio/loopback-next/commit/f743008))

# [1.20.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.19.0...@loopback/cli@1.20.0) (2019-07-26)

### Bug Fixes

- **cli:** remove -p option from eslint
  ([d2ffd80](https://github.com/loopbackio/loopback-next/commit/d2ffd80))
- add support for excluding custom pk from POST requests
  ([9694d99](https://github.com/loopbackio/loopback-next/commit/9694d99))

### Features

- update examples and docs to use getModelSchemaRef
  ([99758b1](https://github.com/loopbackio/loopback-next/commit/99758b1))
- **cli:** update templates to make use of getModelSchemaRef
  ([4147619](https://github.com/loopbackio/loopback-next/commit/4147619))
- remove openapi-v3-types package
  ([2a93395](https://github.com/loopbackio/loopback-next/commit/2a93395))

# [1.19.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.18.0...@loopback/cli@1.19.0) (2019-07-17)

### Bug Fixes

- **cli:** app generator handles tildified project path. relevant test added
  ([7f7feaa](https://github.com/loopbackio/loopback-next/commit/7f7feaa))
- **cli:** rearrange interceptor cli prompts
  ([0b2ed34](https://github.com/loopbackio/loopback-next/commit/0b2ed34))
- fix conflict
  ([6302101](https://github.com/loopbackio/loopback-next/commit/6302101))

### Features

- **cli:** modify controller templates to exclude id from POST requests
  ([4c1ce67](https://github.com/loopbackio/loopback-next/commit/4c1ce67))
- **cli:** store original cli version in .yo.rc.json
  ([3b7db55](https://github.com/loopbackio/loopback-next/commit/3b7db55))

# [1.18.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.17.2...@loopback/cli@1.18.0) (2019-06-28)

### Bug Fixes

- address violations of "no-floating-promises" rule
  ([0947531](https://github.com/loopbackio/loopback-next/commit/0947531))

### Features

- **cli:** enable source map for npm start script
  ([1882240](https://github.com/loopbackio/loopback-next/commit/1882240))
- **cli:** modify Controller templates to allow partial updates via PATCH
  ([c7c6695](https://github.com/loopbackio/loopback-next/commit/c7c6695))

## [1.17.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.17.1...@loopback/cli@1.17.2) (2019-06-21)

### Bug Fixes

- **cli:** make sure tsbuildinfo is removed by the clean script
  ([3fdc0b1](https://github.com/loopbackio/loopback-next/commit/3fdc0b1))
- **cli:** remove no-any warning from model template
  ([264aa28](https://github.com/loopbackio/loopback-next/commit/264aa28))

## [1.17.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.17.0...@loopback/cli@1.17.1) (2019-06-20)

**Note:** Version bump only for package @loopback/cli

# [1.17.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.16.1...@loopback/cli@1.17.0) (2019-06-17)

### Bug Fixes

- **cli:** change class/file naming convention. Add prompt msg
  ([0b2a45b](https://github.com/loopbackio/loopback-next/commit/0b2a45b))
- discover uses owner instead of schema
  ([ed588b6](https://github.com/loopbackio/loopback-next/commit/ed588b6))
- remove forgotten references to tslint
  ([faa0a92](https://github.com/loopbackio/loopback-next/commit/faa0a92))
- **cli:** discover prompt exits after generating
  ([8ba0dd5](https://github.com/loopbackio/loopback-next/commit/8ba0dd5))

### Features

- **build:** enable incremental compilation
  ([2120712](https://github.com/loopbackio/loopback-next/commit/2120712))

## [1.16.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.16.0...@loopback/cli@1.16.1) (2019-06-06)

**Note:** Version bump only for package @loopback/cli

# [1.16.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.15.1...@loopback/cli@1.16.0) (2019-06-06)

### Features

- **cli:** add lb4 interceptor command to generate interceptors
  ([58017b6](https://github.com/loopbackio/loopback-next/commit/58017b6))

## [1.15.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.15.0...@loopback/cli@1.15.1) (2019-06-03)

### Bug Fixes

- **cli:** add eslint related dev dependencies to generated package.json
  ([fc18caf](https://github.com/loopbackio/loopback-next/commit/fc18caf))

# [1.15.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.14.1...@loopback/cli@1.15.0) (2019-06-03)

### Bug Fixes

- **cli:** add type param to Filter and Where
  ([a9570bc](https://github.com/loopbackio/loopback-next/commit/a9570bc))

### Features

- add navigational properties to find\* methods
  ([1f0aa0b](https://github.com/loopbackio/loopback-next/commit/1f0aa0b))
- replace tslint with eslint
  ([44185a7](https://github.com/loopbackio/loopback-next/commit/44185a7))

## [1.14.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.14.0...@loopback/cli@1.14.1) (2019-05-31)

### Bug Fixes

- modelSettings is stringified properly
  [#2915](https://github.com/loopbackio/loopback-next/issues/2915)
  ([84072ec](https://github.com/loopbackio/loopback-next/commit/84072ec))

# [1.14.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.13.1...@loopback/cli@1.14.0) (2019-05-30)

### Features

- **cli:** add `lb4 relation` command
  ([75939a4](https://github.com/loopbackio/loopback-next/commit/75939a4))

## [1.13.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.13.0...@loopback/cli@1.13.1) (2019-05-23)

### Bug Fixes

- **cli:** clean up template for life cycle observers
  ([6733610](https://github.com/loopbackio/loopback-next/commit/6733610))

# [1.13.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.12.1...@loopback/cli@1.13.0) (2019-05-14)

### Features

- add lb3 application
  ([bf60011](https://github.com/loopbackio/loopback-next/commit/bf60011))

## [1.12.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.12.0...@loopback/cli@1.12.1) (2019-05-10)

**Note:** Version bump only for package @loopback/cli

# [1.12.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.11.3...@loopback/cli@1.12.0) (2019-05-09)

### Features

- **cli:** improve scaffolding of complex model settings
  ([5035c63](https://github.com/loopbackio/loopback-next/commit/5035c63))

## [1.11.3](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.11.2...@loopback/cli@1.11.3) (2019-05-06)

**Note:** Version bump only for package @loopback/cli

## [1.11.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.11.1...@loopback/cli@1.11.2) (2019-04-26)

### Bug Fixes

- **cli:** escape char sequences for javascript comments
  ([83ff105](https://github.com/loopbackio/loopback-next/commit/83ff105))
- **cli:** escape identifiers with conflicting name as decorators
  ([6d71439](https://github.com/loopbackio/loopback-next/commit/6d71439))

## [1.11.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.11.0...@loopback/cli@1.11.1) (2019-04-20)

### Bug Fixes

- **cli:** keep or escape property names for models
  ([cb308ad](https://github.com/loopbackio/loopback-next/commit/cb308ad))

# [1.11.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.10.0...@loopback/cli@1.11.0) (2019-04-11)

### Bug Fixes

- **cli:** generate operation only for the 1st tag to avoid duplicate routes
  ([4843a1f](https://github.com/loopbackio/loopback-next/commit/4843a1f))
- **cli:** improve openapi code generation for naming and typing
  ([af20548](https://github.com/loopbackio/loopback-next/commit/af20548))

### Features

- **cli:** add lb4 discover for model discovery
  ([35f719c](https://github.com/loopbackio/loopback-next/commit/35f719c))
- **cli:** normalize variable names for OpenAPI paths
  ([a3d0dfc](https://github.com/loopbackio/loopback-next/commit/a3d0dfc))

# [1.10.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.9.0...@loopback/cli@1.10.0) (2019-04-09)

### Bug Fixes

- **cli:** make sure the item type is imported for an array in openapi spec
  ([91b2381](https://github.com/loopbackio/loopback-next/commit/91b2381))

### Features

- **cli:** add `lb4 observer` command to generate life cycle scripts
  ([d54651d](https://github.com/loopbackio/loopback-next/commit/d54651d))

# [1.9.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.8.4...@loopback/cli@1.9.0) (2019-04-05)

### Features

- add greeter-extension example
  ([9b09298](https://github.com/loopbackio/loopback-next/commit/9b09298))

## [1.8.4](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.8.3...@loopback/cli@1.8.4) (2019-03-22)

**Note:** Version bump only for package @loopback/cli

## [1.8.3](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.8.2...@loopback/cli@1.8.3) (2019-03-22)

### Bug Fixes

- **build:** remove "dom" from the list of global libraries
  ([781cd1d](https://github.com/loopbackio/loopback-next/commit/781cd1d))

## [1.8.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.8.1...@loopback/cli@1.8.2) (2019-03-12)

### Bug Fixes

- **cli:** setup controller generator after adding properties
  ([b0ee417](https://github.com/loopbackio/loopback-next/commit/b0ee417))
- **cli:** simplify HTTP server setup in acceptance tests
  ([aa0e2f7](https://github.com/loopbackio/loopback-next/commit/aa0e2f7))
- **cli:** use pascalCase for toClassName to handle '-'
  ([861256c](https://github.com/loopbackio/loopback-next/commit/861256c))

### Performance Improvements

- update dockerfile to better version
  ([5494243](https://github.com/loopbackio/loopback-next/commit/5494243))

## [1.8.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.8.0...@loopback/cli@1.8.1) (2019-03-01)

**Note:** Version bump only for package @loopback/cli

# [1.8.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.7.0...@loopback/cli@1.8.0) (2019-03-01)

### Bug Fixes

- **cli:** fix prompt for base repository class
  ([b429729](https://github.com/loopbackio/loopback-next/commit/b429729)),
  closes [#2429](https://github.com/loopbackio/loopback-next/issues/2429)

### Features

- add express example
  ([dd2400e](https://github.com/loopbackio/loopback-next/commit/dd2400e))

# [1.7.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.6.0...@loopback/cli@1.7.0) (2019-02-25)

### Bug Fixes

- **cli:** do not install deps for built-in connectors
  ([2e035a5](https://github.com/loopbackio/loopback-next/commit/2e035a5))
- update version of nyc
  ([f8db27c](https://github.com/loopbackio/loopback-next/commit/f8db27c))
- **cli:** force test host to be HOST env var or ipv4 interface
  ([1664d4f](https://github.com/loopbackio/loopback-next/commit/1664d4f))
- **cli:** generate property.array for array of simple types
  ([ec80d9a](https://github.com/loopbackio/loopback-next/commit/ec80d9a))

### Features

- **cli:** add `--docker` option to generate docker files
  ([4cd2442](https://github.com/loopbackio/loopback-next/commit/4cd2442))

# [1.6.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.5.2...@loopback/cli@1.6.0) (2019-02-08)

### Bug Fixes

- remove unused juggler import
  ([0121c10](https://github.com/loopbackio/loopback-next/commit/0121c10))
- update to the most recent lodash version
  ([65ee865](https://github.com/loopbackio/loopback-next/commit/65ee865))

### Features

- **cli:** scaffold test files to `src/__tests__`
  ([d3a3bea](https://github.com/loopbackio/loopback-next/commit/d3a3bea))
- **cli:** use a custom repository base class
  ([edbbe88](https://github.com/loopbackio/loopback-next/commit/edbbe88))

## [1.5.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.5.1...@loopback/cli@1.5.2) (2019-01-28)

### Bug Fixes

- **cli:** add fs-extra dependency as it's used by lb example
  ([3c74ffa](https://github.com/loopbackio/loopback-next/commit/3c74ffa))
- **cli:** allow base class exist for model config option
  ([9605ed1](https://github.com/loopbackio/loopback-next/commit/9605ed1))

## [1.5.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.5.0...@loopback/cli@1.5.1) (2019-01-15)

### Bug Fixes

- **cli:** change enable setting check
  ([f4a9dc0](https://github.com/loopbackio/loopback-next/commit/f4a9dc0))

# [1.5.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.4.0...@loopback/cli@1.5.0) (2019-01-14)

### Bug Fixes

- **cli:** add descriptions to features
  ([8a94f8f](https://github.com/loopbackio/loopback-next/commit/8a94f8f))
- **cli:** remove license header from test code template
  ([1fd35f4](https://github.com/loopbackio/loopback-next/commit/1fd35f4))

### Features

- always include tslint and typescript in project dev-dependencies
  ([e0df285](https://github.com/loopbackio/loopback-next/commit/e0df285))
- use dependency instead of keyword to check loopback projects
  ([bb6ee51](https://github.com/loopbackio/loopback-next/commit/bb6ee51))
- **cli:** add property modelSettings
  ([e0f75ac](https://github.com/loopbackio/loopback-next/commit/e0f75ac))
- **cli:** add strict prompt to model generator
  ([a68d78b](https://github.com/loopbackio/loopback-next/commit/a68d78b))

# [1.4.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.3.0...@loopback/cli@1.4.0) (2018-12-20)

### Bug Fixes

- **cli:** set `required: true` in property decoration for openapi
  ([3c37286](https://github.com/loopbackio/loopback-next/commit/3c37286))

### Features

- **cli:** new projects load tslint config from
  `[@loopback](https://github.com/loopback)/tslint-config`
  ([5b9c329](https://github.com/loopbackio/loopback-next/commit/5b9c329))

# [1.3.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.2.2...@loopback/cli@1.3.0) (2018-12-13)

### Bug Fixes

- add model/entity descriptions
  ([8156f9d](https://github.com/loopbackio/loopback-next/commit/8156f9d))
- **cli:** add missing PUT method in rest controller template
  ([8394c74](https://github.com/loopbackio/loopback-next/commit/8394c74))
- change service generator ds to uppercase
  ([83840a3](https://github.com/loopbackio/loopback-next/commit/83840a3))

### Features

- scaffold DB migration script for new app projects
  ([f783f07](https://github.com/loopbackio/loopback-next/commit/f783f07))
- **cli:** allow annonymous schemas in openapi to be mapped to models
  ([eedec1e](https://github.com/loopbackio/loopback-next/commit/eedec1e))

## [1.2.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.2.1...@loopback/cli@1.2.2) (2018-11-26)

**Note:** Version bump only for package @loopback/cli

## [1.2.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.2.0...@loopback/cli@1.2.1) (2018-11-17)

**Note:** Version bump only for package @loopback/cli

# [1.2.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.1.1...@loopback/cli@1.2.0) (2018-11-17)

### Bug Fixes

- **cli:** allow `*` for version range
  ([0a42541](https://github.com/loopbackio/loopback-next/commit/0a42541))

### Features

- an extension adding a self-hosted REST API Explorer
  ([4c165c7](https://github.com/loopbackio/loopback-next/commit/4c165c7))

## [1.1.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.1.0...@loopback/cli@1.1.1) (2018-11-14)

**Note:** Version bump only for package @loopback/cli

<a name="1.1.0"></a>

# [1.1.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.0.1...@loopback/cli@1.1.0) (2018-11-08)

### Bug Fixes

- change unmatched html tags, remove redundant 'px' from 0
  ([46d08f6](https://github.com/loopbackio/loopback-next/commit/46d08f6))
- **cli:** allow other connectors to be used for repositories
  ([9a0d9a8](https://github.com/loopbackio/loopback-next/commit/9a0d9a8))
- update usage of `x-ts-type` for schemas
  ([57c694e](https://github.com/loopbackio/loopback-next/commit/57c694e))
- **cli:** set glob options to support windows paths with special chars
  ([9a84ef0](https://github.com/loopbackio/loopback-next/commit/9a84ef0))

### Features

- **cli:** use app.static for default home page
  ([1dcf169](https://github.com/loopbackio/loopback-next/commit/1dcf169))

<a name="1.0.1"></a>

## [1.0.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@1.0.0...@loopback/cli@1.0.1) (2018-10-17)

### Bug Fixes

- **cli:** add more exit checks to fail fast
  ([90c4406](https://github.com/loopbackio/loopback-next/commit/90c4406))

<a name="0.31.0"></a>

# [0.31.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.30.0...@loopback/cli@0.31.0) (2018-10-08)

### Features

- use resolveJsonModule to load datasource config
  ([73e19ff](https://github.com/loopbackio/loopback-next/commit/73e19ff))

<a name="0.30.0"></a>

# [0.30.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.29.0...@loopback/cli@0.30.0) (2018-10-06)

### Bug Fixes

- **cli:** generate matching arg names for repository constructors
  ([190fbf3](https://github.com/loopbackio/loopback-next/commit/190fbf3))
- **cli:** remove dist-util from project templates
  ([f6c3048](https://github.com/loopbackio/loopback-next/commit/f6c3048))

### Features

- deprecate dist-util package
  ([91a343c](https://github.com/loopbackio/loopback-next/commit/91a343c))

<a name="0.29.0"></a>

# [0.29.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.28.0...@loopback/cli@0.29.0) (2018-10-05)

### Features

- **cli:** add lb4 model option to select base model class
  ([4c0ce80](https://github.com/loopbackio/loopback-next/commit/4c0ce80)),
  closes [#1698](https://github.com/loopbackio/loopback-next/issues/1698)

<a name="0.28.0"></a>

# [0.28.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.27.0...@loopback/cli@0.28.0) (2018-10-03)

### Bug Fixes

- **cli:** fixed ds names that were hyphened
  ([568307c](https://github.com/loopbackio/loopback-next/commit/568307c)),
  closes [#1791](https://github.com/loopbackio/loopback-next/issues/1791)
- clean up dataSource usage
  ([69506a4](https://github.com/loopbackio/loopback-next/commit/69506a4))

### Features

- **cli:** check project deps against cli template
  ([8d056c4](https://github.com/loopbackio/loopback-next/commit/8d056c4))

<a name="0.27.0"></a>

# [0.27.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.26.0...@loopback/cli@0.27.0) (2018-09-28)

### Bug Fixes

- **cli:** fixes final datasource class name on repository and service
  ([d0994af](https://github.com/loopbackio/loopback-next/commit/d0994af)),
  closes [#1771](https://github.com/loopbackio/loopback-next/issues/1771)

### Features

- **cli:** add code template for default home page controller
  ([f4be330](https://github.com/loopbackio/loopback-next/commit/f4be330))
- **repository:** return an object for count and updateAll
  ([c146366](https://github.com/loopbackio/loopback-next/commit/c146366))

<a name="0.26.0"></a>

# [0.26.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.25.0...@loopback/cli@0.26.0) (2018-09-27)

### Bug Fixes

- **cli:** datasource class being referenced in generators
  ([6d345f7](https://github.com/loopbackio/loopback-next/commit/6d345f7))

### Features

- **cli:** add basic scaffolding for lb4 service
  ([bed83b3](https://github.com/loopbackio/loopback-next/commit/bed83b3))
- **cli:** add integration tests for lb4 service
  ([3731f5b](https://github.com/loopbackio/loopback-next/commit/3731f5b))
- **cli:** change location fixtures service/repository
  ([d4f5b5c](https://github.com/loopbackio/loopback-next/commit/d4f5b5c))
- **cli:** lb4 service install service-proxy if missing
  ([b086d2d](https://github.com/loopbackio/loopback-next/commit/b086d2d))
- **cli:** lb4 service/repository shared scaffold
  ([9bafc6d](https://github.com/loopbackio/loopback-next/commit/9bafc6d))

<a name="0.25.0"></a>

# [0.25.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.24.0...@loopback/cli@0.25.0) (2018-09-25)

### Features

- add "filter" parameter to "find" endpoints
  ([7e1acfc](https://github.com/loopbackio/loopback-next/commit/7e1acfc))
- **cli:** add responses for PingController.ping()
  ([ec52b89](https://github.com/loopbackio/loopback-next/commit/ec52b89))

<a name="0.24.0"></a>

# [0.24.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.23.0...@loopback/cli@0.24.0) (2018-09-21)

### Bug Fixes

- **cli:** removed unused dependencies from project template
  ([3907df4](https://github.com/loopbackio/loopback-next/commit/3907df4))

### Features

- **cli:** add update notifier to remind cli upgrade
  ([61255cc](https://github.com/loopbackio/loopback-next/commit/61255cc))
- **testlab:** add createRestAppClient(), simplify usage in tests
  ([d75be77](https://github.com/loopbackio/loopback-next/commit/d75be77))
- **testlab:** set port to 0 in givenHttpServerConfig
  ([90a0bfb](https://github.com/loopbackio/loopback-next/commit/90a0bfb))

<a name="0.23.0"></a>

# [0.23.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.22.11...@loopback/cli@0.23.0) (2018-09-19)

### Features

- **cli:** add lb4 repository feature
  ([0397c04](https://github.com/loopbackio/loopback-next/commit/0397c04)),
  closes [#1588](https://github.com/loopbackio/loopback-next/issues/1588)
- **cli:** add test for multiple repositories
  ([6e6faad](https://github.com/loopbackio/loopback-next/commit/6e6faad))
- **cli:** add util shared functions and constants
  ([26915e5](https://github.com/loopbackio/loopback-next/commit/26915e5))
- **cli:** ast-helper integration
  ([99a0bad](https://github.com/loopbackio/loopback-next/commit/99a0bad))
- **cli:** change msg when no datasource or repository exists
  ([739676b](https://github.com/loopbackio/loopback-next/commit/739676b))
- **repository:** rework \*ById methods to throw if id not found
  ([264f231](https://github.com/loopbackio/loopback-next/commit/264f231))

<a name="0.22.11"></a>

## [0.22.11](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.22.10...@loopback/cli@0.22.11) (2018-09-17)

### Bug Fixes

- **cli:** generate correct index.js without loopback build
  ([1c8cb3e](https://github.com/loopbackio/loopback-next/commit/1c8cb3e))
- **cli:** use rimraf to replace rm -rf
  ([479f363](https://github.com/loopbackio/loopback-next/commit/479f363))

<a name="0.22.10"></a>

## [0.22.10](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.22.9...@loopback/cli@0.22.10) (2018-09-14)

**Note:** Version bump only for package @loopback/cli

<a name="0.22.9"></a>

## [0.22.9](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.22.8...@loopback/cli@0.22.9) (2018-09-14)

**Note:** Version bump only for package @loopback/cli

<a name="0.22.8"></a>

## [0.22.8](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.22.7...@loopback/cli@0.22.8) (2018-09-14)

### Bug Fixes

- **cli:** enforce an empty object on connectors without settings property
  ([111442b](https://github.com/loopbackio/loopback-next/commit/111442b)),
  closes [#1697](https://github.com/loopbackio/loopback-next/issues/1697)
- **cli:** git-ignore all "dist\*" dirs in scaffolded projects
  ([1cab517](https://github.com/loopbackio/loopback-next/commit/1cab517))
- **cli:** update template with responses object
  ([a2bbbc9](https://github.com/loopbackio/loopback-next/commit/a2bbbc9))

<a name="0.22.7"></a>

## [0.22.7](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.22.6...@loopback/cli@0.22.7) (2018-09-12)

### Bug Fixes

- make `lb model` prompts clearer
  ([2ec4d2f](https://github.com/loopbackio/loopback-next/commit/2ec4d2f))

<a name="0.22.6"></a>

## [0.22.6](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.22.5...@loopback/cli@0.22.6) (2018-09-10)

**Note:** Version bump only for package @loopback/cli

<a name="0.22.5"></a>

## [0.22.5](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.22.3...@loopback/cli@0.22.5) (2018-09-10)

**Note:** Version bump only for package @loopback/cli

<a name="0.22.4"></a>

## [0.22.4](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.22.3...@loopback/cli@0.22.4) (2018-09-10)

**Note:** Version bump only for package @loopback/cli

<a name="0.22.3"></a>

## [0.22.3](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.22.2...@loopback/cli@0.22.3) (2018-09-10)

**Note:** Version bump only for package @loopback/cli

<a name="0.22.2"></a>

## [0.22.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.22.1...@loopback/cli@0.22.2) (2018-09-10)

**Note:** Version bump only for package @loopback/cli

<a name="0.22.1"></a>

## [0.22.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.22.0...@loopback/cli@0.22.1) (2018-09-10)

**Note:** Version bump only for package @loopback/cli

<a name="0.22.0"></a>

# [0.22.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.21.4...@loopback/cli@0.22.0) (2018-09-08)

### Bug Fixes

- remove extra imports for mixin dependencies
  ([35b916b](https://github.com/loopbackio/loopback-next/commit/35b916b))
- **cli:** rename repository/service feature flags
  ([c089299](https://github.com/loopbackio/loopback-next/commit/c089299))

### Features

- **service-proxy:** add service mixin
  ([fb01931](https://github.com/loopbackio/loopback-next/commit/fb01931))

<a name="0.21.4"></a>

## [0.21.4](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.21.3...@loopback/cli@0.21.4) (2018-08-25)

**Note:** Version bump only for package @loopback/cli

<a name="0.21.3"></a>

## [0.21.3](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.21.2...@loopback/cli@0.21.3) (2018-08-24)

### Bug Fixes

- **cli:** tweaks to templates
  ([6f1d7bb](https://github.com/loopbackio/loopback-next/commit/6f1d7bb))

<a name="0.21.2"></a>

## [0.21.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.21.1...@loopback/cli@0.21.2) (2018-08-20)

### Bug Fixes

- **cli:** add esnext.asynciterable to lib for typescript
  ([83a8036](https://github.com/loopbackio/loopback-next/commit/83a8036))
- **cli:** increase timeout for app generation tests
  ([c51383d](https://github.com/loopbackio/loopback-next/commit/c51383d))

<a name="0.21.1"></a>

## [0.21.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.21.0...@loopback/cli@0.21.1) (2018-08-15)

### Bug Fixes

- **repository:** change the way array property definition is built for the
  juggler
  ([2471c88](https://github.com/loopbackio/loopback-next/commit/2471c88))

<a name="0.21.0"></a>

# [0.21.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.20.2...@loopback/cli@0.21.0) (2018-08-08)

### Bug Fixes

- import package in template
  ([14bb6a5](https://github.com/loopbackio/loopback-next/commit/14bb6a5))
- **cli:** change model template to properly render array types
  ([2d43a61](https://github.com/loopbackio/loopback-next/commit/2d43a61))
- **cli:** install dependencies for clones examples
  ([5774f1f](https://github.com/loopbackio/loopback-next/commit/5774f1f))
- **cli:** remove deleteAll endpoint from REST Controller template
  ([34eba34](https://github.com/loopbackio/loopback-next/commit/34eba34))
- **cli:** use this.exit instead of throwing an error
  ([8d25a79](https://github.com/loopbackio/loopback-next/commit/8d25a79))

### Features

- **cli:** add repositorymixin and imports by a new switch
  ([be81131](https://github.com/loopbackio/loopback-next/commit/be81131)),
  closes [#1594](https://github.com/loopbackio/loopback-next/issues/1594)
- **cli:** use `app.restServer.url` for console logs
  ([f31160c](https://github.com/loopbackio/loopback-next/commit/f31160c))
- **example-soap-calculator:** add soap web services integration example
  ([9a8d57c](https://github.com/loopbackio/loopback-next/commit/9a8d57c)),
  closes [#1550](https://github.com/loopbackio/loopback-next/issues/1550)

<a name="0.20.2"></a>

## [0.20.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.20.1...@loopback/cli@0.20.2) (2018-07-21)

**Note:** Version bump only for package @loopback/cli

<a name="0.20.1"></a>

## [0.20.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.20.0...@loopback/cli@0.20.1) (2018-07-20)

**Note:** Version bump only for package @loopback/cli

<a name="0.20.0"></a>

# [0.20.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.19.0...@loopback/cli@0.20.0) (2018-07-20)

### Bug Fixes

- **cli:** fix cli rest controller generator template
  ([cc9591d](https://github.com/loopbackio/loopback-next/commit/cc9591d))

### Features

- **example-todo-list:** add TodoList package/tutorial
  ([306d437](https://github.com/loopbackio/loopback-next/commit/306d437))

<a name="0.19.0"></a>

# [0.19.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.18.1...@loopback/cli@0.19.0) (2018-07-13)

### Bug Fixes

- **cli:** add empty logs to better format model prompts
  ([60b3d57](https://github.com/loopbackio/loopback-next/commit/60b3d57))
- **cli:** adds the <idtype> on param.path for those methods in the rest
  controller template parsing
  ([c526b99](https://github.com/loopbackio/loopback-next/commit/c526b99))
- **cli:** reorder where and body in CLI template for updateAll and make where
  optional
  ([c875707](https://github.com/loopbackio/loopback-next/commit/c875707))
- **cli:** support updating multiple index.ts files
  ([1e92f4f](https://github.com/loopbackio/loopback-next/commit/1e92f4f))

### Features

- **cli:** `lb4 model` command to scaffold model files
  ([3593820](https://github.com/loopbackio/loopback-next/commit/3593820))

<a name="0.18.1"></a>

## [0.18.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.18.0...@loopback/cli@0.18.1) (2018-07-11)

**Note:** Version bump only for package @loopback/cli

<a name="0.18.0"></a>

# [0.18.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.17.0...@loopback/cli@0.18.0) (2018-07-10)

### Bug Fixes

- **cli:** install deps if necessary for datasource
  ([4c605b0](https://github.com/loopbackio/loopback-next/commit/4c605b0))

### Features

- **cli:** add --format to run lint:fix for generated code
  ([77f15c7](https://github.com/loopbackio/loopback-next/commit/77f15c7))

<a name="0.17.0"></a>

# [0.17.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.16.3...@loopback/cli@0.17.0) (2018-07-09)

### Bug Fixes

- **cli:** tweak getArtifactList to return pascalCased strings
  ([b3bb208](https://github.com/loopbackio/loopback-next/commit/b3bb208))

### Features

- **cli:** add comments for generated methods from openapi
  ([daa7f78](https://github.com/loopbackio/loopback-next/commit/daa7f78))
- **cli:** add config and yes options
  ([5778a2a](https://github.com/loopbackio/loopback-next/commit/5778a2a))
- **cli:** improve openapi handling of body and impl
  ([640b941](https://github.com/loopbackio/loopback-next/commit/640b941))

<a name="0.16.3"></a>

## [0.16.3](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.16.2...@loopback/cli@0.16.3) (2018-06-28)

**Note:** Version bump only for package @loopback/cli

<a name="0.16.2"></a>

## [0.16.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.16.1...@loopback/cli@0.16.2) (2018-06-27)

**Note:** Version bump only for package @loopback/cli

<a name="0.16.1"></a>

## [0.16.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.16.0...@loopback/cli@0.16.1) (2018-06-26)

### Bug Fixes

- **cli:** allow path level parameters for openapi
  ([55b041a](https://github.com/loopbackio/loopback-next/commit/55b041a))

<a name="0.16.0"></a>

# [0.16.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.14.0...@loopback/cli@0.16.0) (2018-06-25)

### Features

- **cli:** add cli for code generation from openapi
  ([1a1b12c](https://github.com/loopbackio/loopback-next/commit/1a1b12c))

<a name="0.15.0"></a>

# [0.15.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.14.0...@loopback/cli@0.15.0) (2018-06-25)

### Features

- **cli:** add cli for code generation from openapi
  ([1a1b12c](https://github.com/loopbackio/loopback-next/commit/1a1b12c))

<a name="0.14.0"></a>

# [0.14.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.13.6...@loopback/cli@0.14.0) (2018-06-20)

### Bug Fixes

- **cli:** make download-connector-list more robust
  ([a4c2ce0](https://github.com/loopbackio/loopback-next/commit/a4c2ce0))
- **cli:** update successful creation message
  ([d602ded](https://github.com/loopbackio/loopback-next/commit/d602ded)),
  closes [#886](https://github.com/loopbackio/loopback-next/issues/886)

### Features

- **cli:** add lb4 datasource command
  ([b3844eb](https://github.com/loopbackio/loopback-next/commit/b3844eb))

<a name="0.13.6"></a>

## [0.13.6](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.13.5...@loopback/cli@0.13.6) (2018-06-11)

**Note:** Version bump only for package @loopback/cli

<a name="0.13.5"></a>

## [0.13.5](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.13.4...@loopback/cli@0.13.5) (2018-06-09)

**Note:** Version bump only for package @loopback/cli

<a name="0.13.4"></a>

## [0.13.4](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.13.3...@loopback/cli@0.13.4) (2018-06-09)

**Note:** Version bump only for package @loopback/cli

<a name="0.13.3"></a>

## [0.13.3](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.13.1...@loopback/cli@0.13.3) (2018-06-09)

**Note:** Version bump only for package @loopback/cli

<a name="0.13.2"></a>

## [0.13.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.13.1...@loopback/cli@0.13.2) (2018-06-09)

**Note:** Version bump only for package @loopback/cli

<a name="0.13.1"></a>

## [0.13.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.13.0...@loopback/cli@0.13.1) (2018-06-08)

**Note:** Version bump only for package @loopback/cli

<a name="0.13.0"></a>

# [0.13.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.12.1...@loopback/cli@0.13.0) (2018-06-08)

### Bug Fixes

- **cli:** fix controller.integration.js tests and refactor
  ([f3edbd9](https://github.com/loopbackio/loopback-next/commit/f3edbd9))
- **cli:** fix templates & move some utils to base generator
  ([1a5cbf8](https://github.com/loopbackio/loopback-next/commit/1a5cbf8))
- **cli:** make sure --applicationName is honored
  ([526e6ca](https://github.com/loopbackio/loopback-next/commit/526e6ca))

### Features

- **cli:** add vscode config files
  ([3738b9c](https://github.com/loopbackio/loopback-next/commit/3738b9c))
- **cli:** auto-generate / update index.ts for exports
  ([2998363](https://github.com/loopbackio/loopback-next/commit/2998363)),
  closes [#1127](https://github.com/loopbackio/loopback-next/issues/1127)

<a name="0.12.1"></a>

## [0.12.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.12.0...@loopback/cli@0.12.1) (2018-05-28)

**Note:** Version bump only for package @loopback/cli

<a name="0.12.0"></a>

# [0.12.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.11.6...@loopback/cli@0.12.0) (2018-05-23)

### Features

- **cli:** add CLI prompt for controller's http path name
  ([0f9c438](https://github.com/loopbackio/loopback-next/commit/0f9c438))

<a name="0.11.6"></a>

## [0.11.6](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.11.5...@loopback/cli@0.11.6) (2018-05-20)

### Bug Fixes

- replace gulp-rename with our own implementation
  ([f8349d4](https://github.com/loopbackio/loopback-next/commit/f8349d4))

<a name="0.11.5"></a>

## [0.11.5](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.11.4...@loopback/cli@0.11.5) (2018-05-14)

**Note:** Version bump only for package @loopback/cli

<a name="0.11.4"></a>

## [0.11.4](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.11.3...@loopback/cli@0.11.4) (2018-05-14)

**Note:** Version bump only for package @loopback/cli

<a name="0.11.3"></a>

## [0.11.3](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.11.2...@loopback/cli@0.11.3) (2018-05-08)

**Note:** Version bump only for package @loopback/cli

<a name="0.11.2"></a>

## [0.11.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.11.1...@loopback/cli@0.11.2) (2018-05-03)

**Note:** Version bump only for package @loopback/cli

<a name="0.11.1"></a>

## [0.11.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.11.0...@loopback/cli@0.11.1) (2018-05-03)

**Note:** Version bump only for package @loopback/cli

<a name="0.11.0"></a>

# [0.11.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.9.2...@loopback/cli@0.11.0) (2018-05-03)

### Features

- **cli:** download examples via npm
  ([43383f5](https://github.com/loopbackio/loopback-next/commit/43383f5))
- add helper package "dist-util"
  ([532f153](https://github.com/loopbackio/loopback-next/commit/532f153))

<a name="0.10.0"></a>

# [0.10.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.9.2...@loopback/cli@0.10.0) (2018-05-03)

### Features

- **cli:** download examples via npm
  ([43383f5](https://github.com/loopbackio/loopback-next/commit/43383f5))
- add helper package "dist-util"
  ([532f153](https://github.com/loopbackio/loopback-next/commit/532f153))

<a name="0.9.2"></a>

## [0.9.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.9.1...@loopback/cli@0.9.2) (2018-04-26)

**Note:** Version bump only for package @loopback/cli

<a name="0.9.1"></a>

## [0.9.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.9.0...@loopback/cli@0.9.1) (2018-04-26)

**Note:** Version bump only for package @loopback/cli

<a name="0.9.0"></a>

# [0.9.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.8.0...@loopback/cli@0.9.0) (2018-04-25)

### Features

- **cli:** improve cli help/version/commands options
  ([715cc91](https://github.com/loopbackio/loopback-next/commit/715cc91))

<a name="0.8.0"></a>

# [0.8.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.7.4...@loopback/cli@0.8.0) (2018-04-16)

**Note:** Version bump only for package @loopback/cli

<a name="0.7.4"></a>

## [0.7.4](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.7.3...@loopback/cli@0.7.4) (2018-04-16)

**Note:** Version bump only for package @loopback/cli

<a name="0.7.3"></a>

## [0.7.3](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.7.1...@loopback/cli@0.7.3) (2018-04-12)

**Note:** Version bump only for package @loopback/cli

<a name="0.7.2"></a>

## [0.7.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.7.1...@loopback/cli@0.7.2) (2018-04-12)

**Note:** Version bump only for package @loopback/cli

<a name="0.7.1"></a>

## [0.7.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.7.0...@loopback/cli@0.7.1) (2018-04-11)

**Note:** Version bump only for package @loopback/cli

<a name="0.7.0"></a>

# [0.7.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.6.2...@loopback/cli@0.7.0) (2018-04-11)

### Bug Fixes

- change file names to fit advocated naming convention
  ([0331df8](https://github.com/loopbackio/loopback-next/commit/0331df8))

### Features

- **context:** typed binding keys
  ([685195c](https://github.com/loopbackio/loopback-next/commit/685195c))
- **repository:** have [@repository](https://github.com/repository) take in
  constructor as arg
  ([3db07eb](https://github.com/loopbackio/loopback-next/commit/3db07eb))

<a name="0.6.3"></a>

## [0.6.3](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.6.2...@loopback/cli@0.6.3) (2018-04-06)

**Note:** Version bump only for package @loopback/cli

<a name="0.6.2"></a>

## [0.6.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.6.1...@loopback/cli@0.6.2) (2018-04-04)

**Note:** Version bump only for package @loopback/cli

<a name="0.6.1"></a>

## [0.6.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.6.0...@loopback/cli@0.6.1) (2018-04-02)

**Note:** Version bump only for package @loopback/cli

<a name="0.6.0"></a>

# [0.6.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.5.2...@loopback/cli@0.6.0) (2018-03-29)

### Bug Fixes

- **cli:** exit gracefully if the project name fails validation
  ([dfdf090](https://github.com/loopbackio/loopback-next/commit/dfdf090))
- **cli:** remove automatic license generation
  ([537ff86](https://github.com/loopbackio/loopback-next/commit/537ff86))

### Code Refactoring

- renamed example-getting-started to example-todo
  ([7a09f1b](https://github.com/loopbackio/loopback-next/commit/7a09f1b))

### BREAKING CHANGES

- example-getting-started is now example-todo

<a name="0.5.2"></a>

## [0.5.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.5.1...@loopback/cli@0.5.2) (2018-03-23)

**Note:** Version bump only for package @loopback/cli

<a name="0.5.1"></a>

## [0.5.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.5.0...@loopback/cli@0.5.1) (2018-03-21)

**Note:** Version bump only for package @loopback/cli

<a name="0.5.0"></a>

# [0.5.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.4.3...@loopback/cli@0.5.0) (2018-03-21)

### Bug Fixes

- **cli:** update tsconfig.json to include index.ts
  ([dc5107c](https://github.com/loopbackio/loopback-next/commit/dc5107c))

### Features

- **rest:** expose app.requestHandler function
  ([20a41ac](https://github.com/loopbackio/loopback-next/commit/20a41ac))

### BREAKING CHANGES

- **rest:** `RestServer#handleHttp` was renamed to `RestServer#requestHandler`.

<a name="0.4.3"></a>

## [0.4.3](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.4.2...@loopback/cli@0.4.3) (2018-03-14)

**Note:** Version bump only for package @loopback/cli

<a name="0.4.2"></a>

## [0.4.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.4.1...@loopback/cli@0.4.2) (2018-03-13)

**Note:** Version bump only for package @loopback/cli

<a name="0.4.1"></a>

## [0.4.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.4.0...@loopback/cli@0.4.1) (2018-03-08)

**Note:** Version bump only for package @loopback/cli

<a name="0.4.0"></a>

# [0.4.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.3.1...@loopback/cli@0.4.0) (2018-03-08)

### Bug Fixes

- clean up the app run test
  ([c0d3731](https://github.com/loopbackio/loopback-next/commit/c0d3731))
- **cli:** add `--allow-console-logs` to app npm test script
  ([5823a18](https://github.com/loopbackio/loopback-next/commit/5823a18))
- template
  ([cf9cf04](https://github.com/loopbackio/loopback-next/commit/cf9cf04))

### Features

- add private option for project generartion
  ([5c42be4](https://github.com/loopbackio/loopback-next/commit/5c42be4))
- **build:** use options to control cli/shell run
  ([c4e8bce](https://github.com/loopbackio/loopback-next/commit/c4e8bce))

<a name="0.3.1"></a>

## [0.3.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.3.0...@loopback/cli@0.3.1) (2018-03-07)

### Bug Fixes

- fix typo
  ([6ecc13c](https://github.com/loopbackio/loopback-next/commit/6ecc13c))

<a name="0.3.0"></a>

# [0.3.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.2.0...@loopback/cli@0.3.0) (2018-03-06)

### Bug Fixes

- use lerna to collect versions for loopback modules
  ([2956bf9](https://github.com/loopbackio/loopback-next/commit/2956bf9))

### Features

- **cli:** replace hard-coded loopback module version in templates
  ([0a742d7](https://github.com/loopbackio/loopback-next/commit/0a742d7))
- upgrade from swagger 2 to openapi 3
  ([71e5af1](https://github.com/loopbackio/loopback-next/commit/71e5af1))

<a name="0.2.0"></a>

# [0.2.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.1.3...@loopback/cli@0.2.0) (2018-03-01)

**Note:** Version bump only for package @loopback/cli

<a name="0.1.3"></a>

## [0.1.3](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.1.2...@loopback/cli@0.1.3) (2018-03-01)

### Bug Fixes

- **cli:** move sequence customization to app constructor
  ([4ee3429](https://github.com/loopbackio/loopback-next/commit/4ee3429))

<a name="0.1.2"></a>

## [0.1.2](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.1.1...@loopback/cli@0.1.2) (2018-02-23)

**Note:** Version bump only for package @loopback/cli

<a name="0.1.1"></a>

## [0.1.1](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@0.1.0...@loopback/cli@0.1.1) (2018-02-21)

### Bug Fixes

- **cli:** fix app templates with boot and sequence
  ([81272e8](https://github.com/loopbackio/loopback-next/commit/81272e8))

<a name="0.1.0"></a>

# [0.1.0](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.23...@loopback/cli@0.1.0) (2018-02-21)

### Features

- [@loopback](https://github.com/loopback)/boot
  ([#858](https://github.com/loopbackio/loopback-next/issues/858))
  ([c2ca8be](https://github.com/loopbackio/loopback-next/commit/c2ca8be))

<a name="4.0.0-alpha.23"></a>

# [4.0.0-alpha.23](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.22...@loopback/cli@4.0.0-alpha.23) (2018-02-15)

### Bug Fixes

- **cli:** remove copyright header from generated app
  ([#991](https://github.com/loopbackio/loopback-next/issues/991))
  ([c987b28](https://github.com/loopbackio/loopback-next/commit/c987b28)),
  closes [#944](https://github.com/loopbackio/loopback-next/issues/944)

### Features

- **cli:** switch .template to .ejs
  ([#996](https://github.com/loopbackio/loopback-next/issues/996))
  ([a27e856](https://github.com/loopbackio/loopback-next/commit/a27e856))

<a name="4.0.0-alpha.22"></a>

# [4.0.0-alpha.22](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.21...@loopback/cli@4.0.0-alpha.22) (2018-02-07)

### Bug Fixes

- **build:** fix tslint config and slipped violations
  ([22f8e05](https://github.com/loopbackio/loopback-next/commit/22f8e05))

### build

- drop dist6 related targets
  ([#945](https://github.com/loopbackio/loopback-next/issues/945))
  ([a2368ce](https://github.com/loopbackio/loopback-next/commit/a2368ce))

### BREAKING CHANGES

- Support for Node.js version lower than 8.0 has been dropped. Please upgrade to
  the latest Node.js 8.x LTS version.

Co-Authored-by: Taranveer Virk <taranveer@virk.cc>

<a name="4.0.0-alpha.21"></a>

# [4.0.0-alpha.21](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.20...@loopback/cli@4.0.0-alpha.21) (2018-02-04)

**Note:** Version bump only for package @loopback/cli

<a name="4.0.0-alpha.20"></a>

# [4.0.0-alpha.20](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.19...@loopback/cli@4.0.0-alpha.20) (2018-01-30)

**Note:** Version bump only for package @loopback/cli

<a name="4.0.0-alpha.19"></a>

# [4.0.0-alpha.19](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.18...@loopback/cli@4.0.0-alpha.19) (2018-01-29)

**Note:** Version bump only for package @loopback/cli

<a name="4.0.0-alpha.18"></a>

# [4.0.0-alpha.18](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.17...@loopback/cli@4.0.0-alpha.18) (2018-01-26)

### Bug Fixes

- apply source-maps to test errors
  ([76a7f56](https://github.com/loopbackio/loopback-next/commit/76a7f56)),
  closes [#602](https://github.com/loopbackio/loopback-next/issues/602)
- make mocha self-contained with the source map support
  ([7c6d869](https://github.com/loopbackio/loopback-next/commit/7c6d869))

### Features

- **testlab:** create a test sandbox utility
  ([#877](https://github.com/loopbackio/loopback-next/issues/877))
  ([9526ba3](https://github.com/loopbackio/loopback-next/commit/9526ba3))

<a name="4.0.0-alpha.17"></a>

# [4.0.0-alpha.17](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.16...@loopback/cli@4.0.0-alpha.17) (2018-01-19)

### Bug Fixes

- **cli:** rework template to use inline param decoration
  ([e3ef86b](https://github.com/loopbackio/loopback-next/commit/e3ef86b))

### Features

- **cli:** generate REST controller with CRUD methods
  ([57fe858](https://github.com/loopbackio/loopback-next/commit/57fe858))
- **cli:** lb4 example [<example-name>]
  ([4286c0d](https://github.com/loopbackio/loopback-next/commit/4286c0d))
- **example-getting-started:** migrate into monorepo
  ([9478d8b](https://github.com/loopbackio/loopback-next/commit/9478d8b))

<a name="4.0.0-alpha.16"></a>

# [4.0.0-alpha.16](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.15...@loopback/cli@4.0.0-alpha.16) (2018-01-11)

**Note:** Version bump only for package @loopback/cli

<a name="4.0.0-alpha.15"></a>

# [4.0.0-alpha.15](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.14...@loopback/cli@4.0.0-alpha.15) (2018-01-03)

### Bug Fixes

- add new openapi package
  ([#829](https://github.com/loopbackio/loopback-next/issues/829))
  ([dac9320](https://github.com/loopbackio/loopback-next/commit/dac9320))

<a name="4.0.0-alpha.14"></a>

# [4.0.0-alpha.14](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.13...@loopback/cli@4.0.0-alpha.14) (2018-01-03)

### Features

- **cli:** add scoped debug function
  ([8535c5e](https://github.com/loopbackio/loopback-next/commit/8535c5e))

<a name="4.0.0-alpha.13"></a>

# [4.0.0-alpha.13](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.12...@loopback/cli@4.0.0-alpha.13) (2017-12-21)

**Note:** Version bump only for package @loopback/cli

<a name="4.0.0-alpha.12"></a>

# [4.0.0-alpha.12](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.11...@loopback/cli@4.0.0-alpha.12) (2017-12-11)

### Features

- **cli:** Cleanup REST application tooling
  ([#774](https://github.com/loopbackio/loopback-next/issues/774))
  ([dc50ed8](https://github.com/loopbackio/loopback-next/commit/dc50ed8))

<a name="4.0.0-alpha.11"></a>

# [4.0.0-alpha.11](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.10...@loopback/cli@4.0.0-alpha.11) (2017-12-01)

### Bug Fixes

- **cli:** use prerelease versioning for templates
  ([81aaa6f](https://github.com/loopbackio/loopback-next/commit/81aaa6f))

<a name="4.0.0-alpha.10"></a>

# [4.0.0-alpha.10](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.9...@loopback/cli@4.0.0-alpha.10) (2017-12-01)

### Features

- Add exit() to abort generation
  ([c95aa23](https://github.com/loopbackio/loopback-next/commit/c95aa23))

<a name="4.0.0-alpha.9"></a>

# [4.0.0-alpha.9](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.8...@loopback/cli@4.0.0-alpha.9) (2017-12-01)

### Features

- **cli:** remove default option for controller
  ([#768](https://github.com/loopbackio/loopback-next/issues/768))
  ([cc41fd6](https://github.com/loopbackio/loopback-next/commit/cc41fd6))

<a name="4.0.0-alpha.8"></a>

# [4.0.0-alpha.8](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.7...@loopback/cli@4.0.0-alpha.8) (2017-11-30)

### Features

- **cli:** Tooling for empty controller
  ([#762](https://github.com/loopbackio/loopback-next/issues/762))
  ([14e7897](https://github.com/loopbackio/loopback-next/commit/14e7897))

<a name="4.0.0-alpha.7"></a>

# [4.0.0-alpha.7](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.6...@loopback/cli@4.0.0-alpha.7) (2017-11-29)

**Note:** Version bump only for package @loopback/cli

<a name="4.0.0-alpha.6"></a>

# [4.0.0-alpha.6](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.5...@loopback/cli@4.0.0-alpha.6) (2017-11-09)

### Bug Fixes

- Fix CLI to include .gitignore in the templates
  ([842a191](https://github.com/loopbackio/loopback-next/commit/842a191))

<a name="4.0.0-alpha.5"></a>

# [4.0.0-alpha.5](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.4...@loopback/cli@4.0.0-alpha.5) (2017-11-06)

### Bug Fixes

- Add start script for apps
  ([5ba3734](https://github.com/loopbackio/loopback-next/commit/5ba3734))

<a name="4.0.0-alpha.4"></a>

# [4.0.0-alpha.4](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.3...@loopback/cli@4.0.0-alpha.4) (2017-11-06)

### Bug Fixes

- Fix cli templates
  ([2ebf69f](https://github.com/loopbackio/loopback-next/commit/2ebf69f))

<a name="4.0.0-alpha.3"></a>

# [4.0.0-alpha.3](https://github.com/loopbackio/loopback-next/compare/@loopback/cli@4.0.0-alpha.2...@loopback/cli@4.0.0-alpha.3) (2017-11-06)

### Bug Fixes

- Fix help text for cli
  ([8f41c2e](https://github.com/loopbackio/loopback-next/commit/8f41c2e))

<a name="4.0.0-alpha.2"></a>

# 4.0.0-alpha.2 (2017-11-06)

### Features

- Add experimental CLI for LoopBack 4
  ([707f692](https://github.com/loopbackio/loopback-next/commit/707f692))
