import {belongsTo, Entity, model, property} from '@loopback/repository';
import {TodoList, TodoListWithRelations} from './todo-list.model';

@model()
export class Todo extends Entity {
  @property({
    type: 'number',
    id: true,
    generated: true,
  })
  id?: number;

  @property({
    type: 'string',
    required: true,
  })
  title: string;

  @property({
    name: 'is_complete',
    type: 'boolean',
  })
  isComplete?: boolean;

  @belongsTo(
    () => TodoList,
    {
      keyTo: 'id',
      keyFrom: 'todoListId',
      name: 'todoList',
    },
    {
      name: 'todo_list_id',
    },
  )
  todoListId: number;

  constructor(data?: Partial<Todo>) {
    super(data);
  }
}

export interface TodoRelations {
  todoList?: TodoListWithRelations;
}

export type TodoWithRelations = Todo & TodoRelations;
