// Copyright IBM Corp. and LoopBack contributors 2022. All Rights Reserved.
// Node module: @loopback/example-references-many
// This file is licensed under the MIT License.
// License text available at https://opensource.org/licenses/MIT

import {Entity, model, property, referencesMany} from '@loopback/repository';
import {Account, AccountWithRelations} from './account.model';

@model()
export class Customer extends Entity {
  @property({
    type: 'number',
    id: true,
    generated: true,
  })
  id: number;

  @property({
    type: 'string',
  })
  firstName: string;

  @property({
    type: 'string',
  })
  lastName: string;

  @referencesMany(() => Account)
  accountIds?: number[];

  constructor(data?: Partial<Customer>) {
    super(data);
  }
}

export interface CustomerRelations {
  accounts?: AccountWithRelations;
}

export type CustomerWithRelations = Customer & CustomerRelations;
