---
lang: en
title: 'Build large scale Node.js projects with LoopBack 4'
keywords: LoopBack 4.0, LoopBack 4, Node.js, TypeScript, OpenAPI
sidebar: lb4_sidebar
permalink: /doc/en/lb4/core-tutorial.html
---

It's super easy to start developing in Node.js, but challenges will get in the
way as your project grows with more and more modules, components, developers,
teams, and releases. If you are building on an open framework or large-scale
application, you probably have increasing number of **hmm** moments in deciding
between **Be less opinionated** and **Don't repeat yourself**.

To set a solid foundation to build LoopBack 4, we have developed an extensible
and composable core in TypeScript with set of design patterns into the framework
to help you create open APIs or applications that are positioned to scale in
various perspectives.

This is a series of tutorials to illustrate how to leverage core modules from
LoopBack 4 to build an application aiming to be extensible, composable, and
scalable. After finishing the tutorials, you will have a good understanding of
common pain points in building large scale Node.js projects and learn how to
apply certain patterns to make the foundation of their projects much more
extensible and composable so that developers can easily leverage, customize, and
extend the core to create meaningful user experiences with great flexibility and
productivity.

- Part 1: [Introduction of the application scenario](./1-introduction.md)
- Part 2: [Architectural challenges](./2-architecture.md)
- Part 3: [Manage artifacts](./3-context-in-action.md)
- Part 4: [Dependency injection](./4-dependency-injection.md)
- Part 5: [Extension point and extension](./5-extension-point-extension.md)
- Part 6: [Interception](./6-interception.md)
- Part 7: [Observation of life cycle events](./7-observation.md)
- Part 8: [Configuration](./8-configuration.md)
- Part 9: [Boot by convention](./9-boot-by-convention.md)
- Part 10: [Advanced recipes](./10-advanced-recipes.md)
- Part 11: [Architectural summary](./11-summary.md)

---

Next: [Introduction of the application scenario](./1-introduction.md)
