---
lang: en
title: 'Update project dependencies'
keywords: LoopBack 4.0, LoopBack 4, Node.js, TypeScript, OpenAPI
sidebar: lb4_sidebar
permalink: /doc/en/lb4/Update-generator.html
---

### Synopsis

The `lb4 update` command runs inside a LoopBack 4 project and checks
dependencies against the current version of `@loopback/cli`. By default, it
checks for exact match. Use `--semver` option to check compatibility using
semver semantics.

```sh
lb4 update [options]
```

The key benefit of `lb4 update` over `npm update` is that `lb4 update` honors
the collection of compatible LoopBack packages (and their dependencies) that are
released with the current lb4 command from `@loopback/cli`.

If the command is run without a LoopBack 4 project, it prints the version of the
current CLI and versions of LoopBack packages that are released with the
`@loopback/cli`. This is the same as `lb4 -v`.

### Options

`--semver` : _(Optional)_ Use semver semantics to check version compatibility
for project dependencies of LoopBack modules. Without this option, `lb4 update`
performs exact version match between the project dependency and the one from
running CLI template, for example, `"@loopback/core": "^1.2.1"` is considered
different from `"@loopback/core":"^1.2.2"`. The `--semver` flag relaxes the
check to allow `"@loopback/core": "^1.2.1"` to be compatible with
`"@loopback/core": "^1.2.2"` (a new patch version), but not
`"@loopback/core": "^2.0.0"` (a new major version).

### Output

Assuming you have a project `my-app` scaffolded with version `1.0.1` of
`@loopback/cli` and you install a newer version (`1.24.0`) of `@loopback/cli`,
running `lb4 update` against `my-app` will produce the following output:

```
The project was originally generated by @loopback/cli@1.0.1.
The following dependencies are incompatible with @loopback/cli@1.24.0:
- @types/node: ^10.14.6 (cli ^10.17.3)
- @loopback/boot: ^1.2.7 (cli ^1.5.10)
- @loopback/build: ^1.5.4 (cli ^2.0.15)
- @loopback/core: ^1.7.0 (cli ^1.10.6)
- @loopback/repository: ^1.5.5 (cli ^1.15.3)
- @loopback/rest: ^1.11.2 (cli ^1.22.0)
- @loopback/testlab: ^1.2.9 (cli ^1.9.3)
- @loopback/service-proxy: ^1.1.10 (cli ^1.3.10)
? How do you want to proceed? Upgrade project dependencies
- Dependency @loopback/boot: ^1.2.7 => ^1.5.10
- Dependency @loopback/core: ^1.7.0 => ^1.10.6
- Dependency @loopback/repository: ^1.5.5 => ^1.15.3
- Dependency @loopback/rest: ^1.11.2 => ^1.22.0
- Dependency @loopback/service-proxy: ^1.1.10 => ^1.3.10
- DevDependency @loopback/build: ^1.5.4 => ^2.0.15
- DevDependency @loopback/testlab: ^1.2.9 => ^1.9.3
- DevDependency @types/node: ^10.14.6 => ^10.17.3
Upgrading dependencies may break the current project.
 conflict package.json
? Overwrite package.json? overwrite
    force package.json
```
