---
lang: en
title: Tutorials
keywords: LoopBack 4.0, LoopBack 4, Node.js, TypeScript, OpenAPI, Tutorial
sidebar: lb4_sidebar
permalink: /doc/en/lb4/Tutorials.html
---

LoopBack 4 comes with the following tutorials:

- **[todo](todo-tutorial.md)**: Tutorial on building a simple application with
  LoopBack 4 key concepts using bottom-up approach.

- **[todo-list](todo-list-tutorial.md)**: Tutorial on introducing related models
  and building their API from the Todo tutorial

- **[soap-calculator](soap-calculator-tutorial.md)**: Tutorial on integrating
  SOAP web services.

- **[log-extension](https://github.com/loopbackio/loopback-next/tree/master/examples/log-extension)**:
  Tutorial on building a log extension.

- **[express-composition](express-with-lb4-rest-tutorial.md)**: Tutorial on
  mounting LoopBack 4 REST API on an Express application.

- **[lb3-application](https://github.com/loopbackio/loopback-next/tree/master/examples/lb3-application)**:
  Tutorial on mounting an existing LoopBack 3 application in a new LoopBack 4
  project.

- **[core series](tutorials/core/index.md)**: A series of tutorials on building
  large scale Node.js projects with LoopBack 4 core modules

You can download any of the tutorial projects using our CLI tool `lb4`:

```sh
lb4 example <tutorial-name>
```

Please follow the instructions in
[Install LoopBack4 CLI](Getting-started.md#install-loopback-4-cli) if you don't
have `lb4` installed yet.
