---
lang: en
title: 'Community examples'
keywords:
  LoopBack 4.0, LoopBack 4, Node.js, TypeScript, OpenAPI, Examples, Community
sidebar: lb4_sidebar
permalink: /doc/en/lb4/Community-examples.html
---

In addition to the examples that LoopBack provides and maintains, this page
lists the examples created by the community.

{% include warning.html content="The examples listed here are not supported by the LoopBack team; they are maintained by the LoopBack community and are listed here for convenience."%}

{% include note.html content="If you want to share your examples in this page, feel free to submit a PR to update [this page](https://github.com/loopbackio/loopback-next/blob/master/docs/site/Community-examples.md)."%}

## General

<table>
  <thead>
    <tr>
      <th width="160">Example</th>
      <th width="280">Description</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><a href="https://github.com/raymondfeng/loopback4-example-multiservers">loopback4-example-multiservers</a></td>
      <td>Sets up multiple RestServers</td>
    </tr>
    <tr>
      <td><a href="https://github.com/raymondfeng/loopback4-example-websocket">loopback4-example-websocket</a></td>
      <td>Exposes Websocket <a href="https://socket.io">socket.io</a> endpoints in conjunction with LoopBack controllers</td>
    </tr>
    <tr>
      <td><a href="https://github.com/raymondfeng/loopback4-example-serverless">loopback4-example-serverless</a></td>
      <td>Leverages TypeScript, LoopBack 4 Dependency Injection, and Webpack to create serverless functions/actions</td>
    </tr>
    <tr>
      <td><a href="https://github.com/dhmlau/loopback4-external-apis">loopback4-external-apis</a></td>
      <td>Calls REST and SOAP services from a LoopBack application</td>
    </tr>
  </tbody>
</table>

## Authentication

<table width="100%">
  <thead>
    <tr>
      <th width="160">Example</th>
      <th width="280">Description</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><a href="https://github.com/raymondfeng/loopback4-example-auth0">loopback4-example-auth0</a></td>
      <td>Uses <a href="https://auth0.com/">Auth0</a> for JWT based authentication.</td>
    </tr>
    <tr>
      <td><a href="https://github.com/HrithikMittal/Loopback4-auth">Loopback4-auth</a></td>
      <td>Adds JWT authentication to LoopBack 4 application</td>
    </tr>
  </tbody>
</table>

## Authorization

<table width="100%">
  <thead>
    <tr>
      <th width="160">Example</th>
      <th width="280">Description</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><a href="https://github.com/HrithikMittal/loopback4-authorization">loopback4-Authorization</a></td>
      <td>Implementation of your own authorization strategy in Loopback-4 by adding permission properties in User model</td>
    </tr>
  </tbody>
</table>

## Frontend related

<table>
  <thead>
    <tr>
      <th width="160">Example</th>
      <th width="280">Description</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><a href="https://github.com/dhmlau/loopback4-example-todo-angular">loopback4-example-todo-angular</a></td>
      <td>Takes the OpenAPI spec from a LoopBack 4 application and use <a href="https://www.npmjs.com/package/ng-openapi-gen">`ng-openapi-gen`</a> to generate the models and web client in an existing Angular application.</td>
    </tr>
  </tbody>
</table>
