---
lang: en
title: 'Best practices with LoopBack 4'
keywords: LoopBack 4.0, LoopBack 4, Node.js, TypeScript, OpenAPI
sidebar: lb4_sidebar
permalink: /doc/en/lb4/Best-practices.html
redirect_from:
  - /doc/en/lb4/Best-practices-with-Loopback-4.html
---

LoopBack 4 is more than just a framework: It’s an ecosystem that encourages
developers to follow best practices through predefined standards.

In this section, we provide guidelines on building LoopBack application and
extensions the test-driven way, to make such projects robust and easy to
maintain.

- [**Defining the API using code-first approach**](./Defining-the-API-using-code-first-approach.md):
  This section guides you through setting up a skeleton of your application so
  that its full OpenAPI specification can be automatically generated.

- [**Defining your testing strategy**](./Defining-your-testing-strategy.md):
  This section discusses the advantages and the process of building a strong
  testing suite.

- [**Testing your application**](./Testing-your-application.md): A collection of
  practical tips and code snippets useful to developers writing LoopBack
  applications.

- [**Testing your extension**](./Testing-Your-Extensions.md): A collection of
  practical tips and code snippets useful to developers building LoopBack
  extensions.
