---
lang: en
title: 'Application generator'
keywords: LoopBack 4.0, LoopBack 4, Node.js, TypeScript, OpenAPI, CLI
sidebar: lb4_sidebar
permalink: /doc/en/lb4/Application-generator.html
---

### Synopsis

Creates a new LoopBack4 application using REST API.

```sh
lb4 [app] [options] [<name>]
```

### Options

`--applicationName` : Application class name.

`--description` : Description of the application.

`--outdir` : Project root directory for the application.

`--eslint` : Add ESLint to LoopBack4 application project.

`--prettier` : Add Prettier to LoopBack4 application project.

`--mocha` : Add Mocha to LoopBack4 application project.

`--loopbackBuild` : Add @loopback/build module's script set to LoopBack4
application project.

`--editorconfig` : Add EditorConfig config files to the LoopBack4 application
project.

`--vscode`: Add VSCode config files to LoopBack4 application project

`--docker`: Generate Dockerfile and add npm scripts to build/run the project in
a docker container. See also
[Dockerfile considerations](#dockerfile-considerations) below.

{% include_relative includes/CLI-std-options.md %}

### Arguments

`<name>` - Optional name of the application given as an argument to the
command.  If provided, the tool will use that as the default when prompting for
the name.

### Interactive Prompts

The tool will prompt you for:

- Name of the application as will be shown in `package.json`. If the name had
  been supplied from the command-line, the prompt is skipped and the application
  is built with the name from the command-line argument. Must follow npm naming
  conventions.

- Description of the application as will be shown in `package.json`.

- Name of the directory in which to create your application. Defaults to the
  name of the application previously entered.

- Name of the Application class in `application.ts`. Defaults to
  <code><i>name</i>Application</code>.

- Optional modules to add to the application. These modules are helpful tools to
  help format, test, and build a LoopBack4 application. Defaults to `true` for
  all of the modules. The prompted modules are:

  - [`eslint`](https://www.npmjs.com/package/eslint)
  - [`prettier`](https://www.npmjs.com/package/prettier)
  - [`mocha`](https://www.npmjs.com/package/mocha)
  - [`@loopback/build`](https://www.npmjs.com/package/@loopback/build)
  - [`editorconfig`](https://editorconfig.org/)
  - [`vscode`](https://code.visualstudio.com/)

### Output

The core scaffold of a LoopBack4 application generated by the CLI consists of
the following files and directories:

```text
.
├── src/
|   ├── __tests__/
|   ├── controllers/
|   |   └── ping.controller.ts
|   ├── datasources/
|   ├── models/
|   ├── repositories/
|   ├── application.ts
|   ├── index.ts
|   ├── migrate.ts
|   └── sequence.ts
└── package.json
```

`ping.controller.ts` is a file used to provide the application with a responsive
endpoint. It contains logic to respond with a greeting message when the
application receives a `GET` request from endpoint `/ping`.

`cd` to the application's newly created directory and run `npm start` to see the
application running at `localhost:3000`. Go to `localhost:3000/ping` to be
greeted with a message.

Once the application has been created, additional generators such as
[controller generator](Controller-generator.md) can be run from the
application's root directory to further scaffold the application.

### Dockerfile Considerations

The Dockerfile that is generated by the `--docker` option is based on a `slim`
version of a `node` Docker image.

Here are the first two lines of the
[Dockerfile](https://github.com/loopbackio/loopback-next/blob/master/packages/cli/generators/app/templates/Dockerfile):

```
# Check out https://hub.docker.com/_/node to select a new base image
FROM docker.io/library/node:18-slim
```

As the comment suggests, the Docker image name is only a default, and you are
encouraged to select an appropriate base image for your application.

If your application has a dependency on a node module that requires and invokes
build tools during `docker build` (for example :
[loopback-connector-db2](https://github.com/loopbackio/loopback-connector-db2)
), an error may occur due to missing libraries.

Using the Docker image `node:10`, however, will allow the `docker build` step to
complete successfully.

If you intend to use a `node:alpine` Docker image, please see
[node-gyp-alpine](https://github.com/nodejs/docker-node/blob/master/docs/BestPractices.md#node-gyp-alpine)
for an example of how you would install dependencies for packages that require
node-gyp support.

Example compilation error when build tools/libraries are not in place:

```
...
Downloading and extraction of DB2 ODBC CLI Driver completed successfully ...

{ Error: Command failed: node-gyp configure build  --IS_DOWNLOADED=true --IBM_DB_HOME="$IBM_DB_HOME"
gyp ERR! configure error
gyp ERR! stack Error: Can't find Python executable "python", you can set the PYTHON env variable.
gyp ERR! stack     at PythonFinder.failNoPython (/usr/local/lib/node_modules/npm/node_modules/node-gyp/lib/configure.js:484:19)
gyp ERR! stack     at PythonFinder.<anonymous> (/usr/local/lib/node_modules/npm/node_modules/node-gyp/lib/configure.js:406:16)
gyp ERR! stack     at F (/usr/local/lib/node_modules/npm/node_modules/which/which.js:68:16)
gyp ERR! stack     at E (/usr/local/lib/node_modules/npm/node_modules/which/which.js:80:29)
gyp ERR! stack     at /usr/local/lib/node_modules/npm/node_modules/which/which.js:89:16
gyp ERR! stack     at /usr/local/lib/node_modules/npm/node_modules/isexe/index.js:42:5
gyp ERR! stack     at /usr/local/lib/node_modules/npm/node_modules/isexe/mode.js:8:5
gyp ERR! stack     at FSReqWrap.oncomplete (fs.js:152:21)
gyp ERR! System Linux 4.9.184-linuxkit
gyp ERR! command "/usr/local/bin/node" "/usr/local/lib/node_modules/npm/node_modules/node-gyp/bin/node-gyp.js" "configure" "build" "--IS_DOWNLOADED=true" "--IBM_DB_HOME=/home/node/app/node_modules/ibm_db/installer/clidriver"
gyp ERR! cwd /home/node/app/node_modules/ibm_db
gyp ERR! node -v v8.16.1
gyp ERR! node-gyp -v v3.8.0
gyp ERR! not ok

    at ChildProcess.exithandler (child_process.js:281:12)
```
