# Maintaining LoopBack

Congratulations! Since you're reading this page, you are probably already a
maintainer of this repo or close to be one. Thank you for your contributions so
far!

## Why do I want to be a maintainer?

- Greater influence on LoopBack's future direction
- Commit (write) rights to `loopback-next` repo
- Ability to review and land pull requests, edit/categorize/close issues

## What are responsibilities of a maintainer?

We ask you to follow the existing processes, see
http://loopback.io/doc/en/contrib/Governance.html. This means mostly:

- Be nice to others
- Try to reach consensus with other maintainers before making a decision
- Always use pull requests to make code changes
- Honour our current conventions, see
  http://loopback.io/doc/en/contrib/triaging-pull-requests.html and
  http://loopback.io/doc/en/contrib/style-guide.html (but feel free to propose
  changes to these conventions!)
- To avoid possible confusion, we don't have any specific requirements about the
  amount of time you should spend on the project - just keep working on things
  that you find important to you, in a pace that suits you. We may ask you to
  take a look at issues and pull requests related to code you contributed
  yourself.

Please look for community members that are actively involved with the project
and consider nominating them to become maintainers too. See
[Nominating new maintainers](https://github.com/loopbackio/loopback-governance/blob/master/docs/maintainer-nomination.md)
for more information.

## More questions?

**Q: Now that I have rights to merge pull requests, how many approvals from
other maintainers before I can merge?**

A: If the changes are straightforward and you're confident about the changes,
please go ahead to merge it. Otherwise you can always mention
[@loopbackio/loopback-maintainers](https://github.com/orgs/loopbackio/teams/loopback-maintainers)
in the GitHub issues/pull requests.

**Q: If I have questions/suggestions on the contribution process, what should I
do?**

A: We are always open for suggestions on how to make the process for
contributors or maintainers smooth. If you have any feedback, please open a
GitHub ticket for discussion.
