# Contributing to LoopBack

Contributions to LoopBack include code, documentation, answering user questions,
and advocating for all types of LoopBack users. See our official documentation
on loopback.io for more information common to all of our GitHub repositories:

- <http://loopback.io/doc/en/contrib/index.html>

## [Principles](http://loopback.io/doc/en/contrib/Governance.html#principles)

LoopBack is an open, inclusive, and tolerant community of people working
together to build a world-class Node framework and tools. We value diversity of
individuals and opinions, and seek to operate on consensus whenever possible. We
strive to maintain a welcoming, inclusive, and harassment-free environment,
regardless of the form of communication. When consensus is not achievable, we
defer to the owners of each individual module; the powers of the individual
owner are kept in check by the ability of the community to fork and replace
dependencies on the individual module and maintainer.

The LoopBack project adopts the
[Contributor Covenant version 2](CODE_OF_CONDUCT.md).

## [Reporting issues](http://loopback.io/doc/en/contrib/Reporting-issues.html)

Issues in
[loopbackio/loopback-next](https://github.com/loopbackio/loopback-next/issues)
are the primary means by which bug reports and general discussions are made.

- [How to report an issue](http://loopback.io/doc/en/contrib/Reporting-issues.html#how-to-report-an-issue)
- [Disclosing security vulnerabilities](http://loopback.io/doc/en/contrib/Reporting-issues.html#security-issues)

## [Contributing code](http://loopback.io/doc/en/contrib/code-contrib.html)

Pull Requests are the way concrete changes are made to the code, documentation
and tools contained in LoopBack repositories.

- [Monorepo overview](./site/MONOREPO.md)
- [Setting up development environment](./site/DEVELOPING.md#setting-up-development-environment)
  - [Developing with VisualStudio Code (recommended)](./site/VSCODE.md)
  - [Developing with WebStorm](./site/WEBSTORM.md)
- [How to contribute the code](http://loopback.io/doc/en/contrib/code-contrib.html#how-to-contribute-to-the-code)
- [Building the project](./site/DEVELOPING.md#building-the-project)
- [Running tests](./site/DEVELOPING.md#running-tests)
- [Coding rules](./site/DEVELOPING.md#coding-rules)
- [API documentation](./site/DEVELOPING.md#api-documentation)
- [Git commit messages](./site/DEVELOPING.md#commit-message-guidelines)
- [Making breaking changes](./site/DEVELOPING.md#making-breaking-changes)
- [Reviewing pull requests](http://loopback.io/doc/en/contrib/triaging-pull-requests.html)
- [Developer Certificate of Origin (DCO)](https://loopback.io/doc/en/contrib/code-contrib.html#developer-certificate-of-origin-dco)

## [Documentation](http://loopback.io/doc/en/contrib/doc-contrib.html)

LoopBack documentation is sourced in both the
[loopbackio/loopback.io](https://github.com/loopbackio/loopback.io) and
[loopbackio/loopback-next](https://github.com/loopbackio/loopback-next/tree/master/docs/site)
GitHub repositories. The `loopback-next` repository holds the documentation for
LoopBack 4.

- [How LoopBack documentation works](http://loopback.io/doc/en/contrib/doc-contrib.html#how-loopback-documentation-works)
- [Using Jekyll](http://loopback.io/doc/en/contrib/jekyll_getting_started.html)
- [Authoring pages](http://loopback.io/doc/en/contrib/pages.html)
- [Translations](http://loopback.io/doc/en/contrib/translation.html)
