# Security Policy

## Supported Versions

LoopBack implements the
[Module LTS policy](https://github.com/CloudNativeJS/ModuleLTS).

| Version    | Supported          |
| ---------- | ------------------ |
| LoopBack 4 | :white_check_mark: |
| LoopBack 3 | :x:                |
| LoopBack 2 | :x:                |

<details>
<summary>Supported connectors</summary>

- [Memory connector](https://loopback.io/doc/en/lb4/Memory-connector.html)

**Database connectors**

- [Cassandra connector](https://loopback.io/doc/en/lb4/Cassandra-connector.html)
- [CouchDB connector](https://loopback.io/doc/en/lb4/Couchdb2-connector.html)
- [Cloudant connector](https://loopback.io/doc/en/lb4/Cloudant-connector.html)
- [DashDB connector](https://loopback.io/doc/en/lb4/DashDB.html)
- [IBM Db2 connector](https://loopback.io/doc/en/lb4/DB2-connector.html)
- [IBM Db2 for iSeries connector(deprecated)](https://loopback.io/doc/en/lb4/DB2-iSeries-connector.html)
- [IBM Db2 for i connector](https://loopback.io/doc/en/lb4/DB2-for-i-connector.html)
- [IBM Db2 for z/OS connector](https://loopback.io/doc/en/lb4/DB2-for-z-OS-connector.html)
- [Informix connector](https://loopback.io/doc/en/lb4/Informix.html)
- [MongoDB connector](https://loopback.io/doc/en/lb4/MongoDB-connector.html)
- [MySQL connector](https://loopback.io/doc/en/lb4/MySQL-connector.html)
- [Oracle connector](https://loopback.io/doc/en/lb4/Oracle-connector.html)
- [PostgreSQL connector](https://loopback.io/doc/en/lb4/PostgreSQL-connector.html)
- [Redis connector](https://loopback.io/doc/en/lb4/Redis-connector.html)
- [Redis key-value connector](https://loopback.io/doc/en/lb4/kv-redis-connector.html)
- [SQL Server connector](https://loopback.io/doc/en/lb4/SQL-Server-connector.html)
- [SQLite3 connector](https://loopback.io/doc/en/lb4/SQLite3.html)
- [z/OS Connect Enterprise Edition connector](https://loopback.io/doc/en/lb4/zOSconnectEE.html)

**Other connectors**

- [Email connector](https://loopback.io/doc/en/lb4/Email-connector.html)
- [JSON RPC connector](https://loopback.io/doc/en/lb4/JSON-RPC-connector.html)
- [MQ Light connector](https://loopback.io/doc/en/lb4/MQLight-connector.html)
- [Push connector](https://loopback.io/doc/en/lb4/Push-connector.html)
- [Remote connector](https://loopback.io/doc/en/lb4/Remote-connector.html)
- [REST connector](https://loopback.io/doc/en/lb4/REST-connector.html)
- [SOAP connector](https://loopback.io/doc/en/lb4/SOAP-connector.html)
- [Storage connector](https://loopback.io/doc/en/lb4/Storage-connector.html)
- [Swagger connector](https://loopback.io/doc/en/lb4/Swagger-connector.html)

</details>

Within LoopBack 4, fixes are not backported across semver major versions of a
package.

## Security advisories

Security advisories can be found on the
[LoopBack website](https://loopback.io/doc/en/sec/index.html).

## Reporting a vulnerability

If you think you have discovered a new security issue with any LoopBack package,
**please do not report it on GitHub**. Instead, send an email to
[security@loopback.io](mailto:security@loopback.io) with the following details:

- Full description of the vulnerability.
- Steps to reproduce the issue.
- Possible solutions.

If you are sending us any logs as part of the report, then make sure to redact
any sensitive data from them.
