const SVG_TAGS = [
	"a",
	"animate",
	"animateMotion",
	"animateTransform",
	"circle",
	"clipPath",
	"defs",
	"desc",
	"ellipse",
	"feBlend",
	"feColorMatrix",
	"feComponentTransfer",
	"feComposite",
	"feConvolveMatrix",
	"feDiffuseLighting",
	"feDisplacementMap",
	"feDistantLight",
	"feDropShadow",
	"feFlood",
	"feFuncA",
	"feFuncB",
	"feFuncG",
	"feFuncR",
	"feGaussianBlur",
	"feImage",
	"feMerge",
	"feMergeNode",
	"feMorphology",
	"feOffset",
	"fePointLight",
	"feSpecularLighting",
	"feSpotLight",
	"feTile",
	"feTurbulence",
	"filter",
	"foreignObject",
	"g",
	"hatch",
	"hatchpath",
	"image",
	"line",
	"linearGradient",
	"marker",
	"mask",
	"metadata",
	"mpath",
	"path",
	"pattern",
	"polygon",
	"polyline",
	"radialGradient",
	"rect",
	"script",
	"set",
	"stop",
	"style",
	"svg",
	"switch",
	"symbol",
	"text",
	"textPath",
	"title",
	"tspan",
	"use",
	"view",
	"g",
];
const _HTML_TAGS: string[] = [
	"html",
	"div",
	"span",
	"a",
	"ul",
	"li",
	"ol",
	"dl",
	"dt",
	"dd",
	"select",
	"option",
	"!DOCTYPEhtml",
	"title",
	"header",
	"meta",
	"body",
	"h1",
	"h2",
	"h3",
	"h4",
	"h5",
	"h6",
	"p",
	"img",
	"br",
	"table",
	"tr",
	"th",
	"td",
	"form",
	"input",
	"b",
	"strong",
	"i",
	"em",
	"mark",
	"small",
	"del",
	"ins",
	"sub",
	"blockquote",
	"cite",
	"bdo",
	"q",
	"style",
	"link",
	"map",
	"area",
	"address",
	"article",
	"aside",
	"blockquote",
	"canvas",
	"dd",
	"div",
	"dl",
	"dt",
	"fieldset",
	"figure",
	"footer",
	"form",
	"header",
	"hr",
	"li",
	"main",
	"nav",
	"noscript",
	"ol",
	"p",
	"pre",
	"section",
	"table",
	"tfoot",
	"ul",
	"video",
	"a",
	"abbr",
	"acronym",
	"b",
	"bdo",
	"big",
	"br",
	"button",
	"cite",
	"code",
	"dfn",
	"em",
	"i",
	"img",
	"input",
	"kbd",
	"label",
	"map",
	"object",
	"output",
	"q",
	"samp",
	"script",
	"select",
	"small",
	"span",
	"strong",
	"sub",
	"sup",
	"textarea",
	"time",
	"tt",
	"var",
	"ifram",
	"script",
	"noscript",
	"base",
	"nav",
	"section",
	"article",
	"aside",
	"footer",
	"details",
	"summary",
	"samp",
	"code",
	"pre",
	"var",
	"kbd",
	"figcaption",
	"figure",
	"main",
	"time",
	"label",
	"button",
	"fieldset",
	"legend",
	"datalist",
	"output",
	"optgroup",
	"canvas",
	"svg",
	"path",
	"g",
	"rect",
	"circle",
	"clipPath",
	"defs",
	"mask",
	"polygon",
	"text",
	"textPath",
	"video",
	"source",
	"track",
	"audio",
	"object",
	"iframe",
	"use",
	"view",
	"line",
	"ellipse",
	"circle",
	"polyline",
	"caption",
];

const NEW_HTML_TAGS = [
	"a",
	"abbr",
	"acronym",
	"address",
	"applet",
	"area",
	"article",
	"aside",
	"audio",
	"b",
	"base",
	"basefont",
	"bdi",
	"bdo",
	"big",
	"blockquote",
	"body",
	"br",
	"button",
	"canvas",
	"caption",
	"center",
	"cite",
	"code",
	"col",
	"colgroup",
	"data",
	"datalist",
	"dd",
	"del",
	"details",
	"dfn",
	"dialog",
	"dir",
	"div",
	"dl",
	"dt",
	"em",
	"embed",
	"fieldset",
	"figcaption",
	"figure",
	"font",
	"footer",
	"form",
	"frame",
	"frameset",
	"h1 - h6",
	"head",
	"header",
	"hr",
	"html",
	"i",
	"iframe",
	"img",
	"input",
	"ins",
	"kbd",
	"label",
	"legend",
	"li",
	"link",
	"main",
	"map",
	"mark",
	"meta",
	"meter",
	"nav",
	"noframes",
	"noscript",
	"object",
	"ol",
	"optgroup",
	"option",
	"output",
	"p",
	"param",
	"picture",
	"pre",
	"progress",
	"q",
	"rp",
	"rt",
	"ruby",
	"s",
	"samp",
	"script",
	"section",
	"select",
	"small",
	"source",
	"span",
	"strike",
	"strong",
	"style",
	"sub",
	"summary",
	"sup",
	"svg",
	"table",
	"tbody",
	"td",
	"template",
	"textarea",
	"tfoot",
	"th",
	"thead",
	"time",
	"title",
	"tr",
	"track",
	"tt",
	"u",
	"ul",
	"var",
	"video",
	"wbr",
];

export const HTML_TAGS = [
	...new Set([..._HTML_TAGS, ...NEW_HTML_TAGS, ...SVG_TAGS]),
];
