# Julia Projects for Beginners 🧑‍💻

Easy Ideas to Get Started Coding in Julia. Learn more by reading [this article on medium](https://logankilpatrick.medium.com/5-julia-projects-for-beginners-easy-ideas-to-get-started-coding-in-julia-938b823a0a08). If you are new to Julia and un-sure of it's benefits, you might want to check out [Why you should learn Julia, as a beginner / first-time programmer](https://blog.devgenius.io/why-you-should-learn-julia-as-a-beginner-first-time-programmer-96e0ad33faba) or [Why You Should Invest in Julia Now, as a Data Scientist](https://betterprogramming.pub/why-you-should-invest-in-julia-now-as-a-data-scientist-30dc346d62e4).

## Projects
- [Mad Libs ✍️](https://github.com/logankilpatrick/10-Julia-Projects-for-Beginners/blob/main/madlibs.jl) *input-command-line*, *string-parsing*
- [Guess the Number Game 💯](https://github.com/logankilpatrick/10-Julia-Projects-for-Beginners/blob/main/number_guess_human.jl) *while*, *random-numbers*, *if-else*, *input-command-line*
- [Computer Number Guesser 🤖](https://github.com/logankilpatrick/10-Julia-Projects-for-Beginners/blob/main/number_guess_computer.jl) *input-command-line*, *random-shuffle*, *for*, *if-else*
- [Rock 🗿, Paper 📃, Scissors ✂️](https://github.com/logankilpatrick/10-Julia-Projects-for-Beginners/blob/main/rock_paper_scissors.jl) *lists*, *input-command-line-base-prompt*, *sleep*, *if-else*
- [Password Generator 🎫](https://github.com/logankilpatrick/10-Julia-Projects-for-Beginners/blob/main/generate_passwords.jl) *random-numbers*, *for*, *input-command-line*, *using-external-packages*, *sleep*, *lists*
- [Leap Year 📅](https://github.com/logankilpatrick/10-Julia-Projects-for-Beginners/blob/main/leap_year.jl) *input-command-line*, *if-else*, *basic-arithmetic-operations*
- [Dice Rolling Simulator 🎲](https://github.com/logankilpatrick/10-Julia-Projects-for-Beginners/blob/main/rolling_dice.jl) *while*, *input-command-line*, *random-numbers*, *if-else*
- [Countdown Timer ⏱️](https://github.com/logankilpatrick/10-Julia-Projects-for-Beginners/blob/main/countdown_timer.jl) *input-command-line*, *while*, *if-else*, *sleep*
- [Calculator 🧮](https://github.com/logankilpatrick/10-Julia-Projects-for-Beginners/blob/main/calculator.jl) *input-command-line*, *while*, *if-else*, *basic-arithmetic-operations*
- [Prime Number Checker 🔢](https://github.com/logankilpatrick/10-Julia-Projects-for-Beginners/blob/main/prime_checker.jl) *if-else*, *for*, *basic-arithmetic-operations*, *input-command-line*, *while*
- [Chatbot 💻](https://github.com/logankilpatrick/10-Julia-Projects-for-Beginners/blob/main/chatbot.jl) *input-command-line*, *struct*, *random-selection*, *while*, *if-else*, *string-parsing*, *string-interpolation*, *dictionary*
  
  
## Contribute

Have a small Julia project you want to contribute? Open a PR with the code and add it to the list here. Let's help people learn Julia! A few things to keep in mind:

- Add comments to make the code clear for new users
- Make sure the code has consistent spacing
- Use lowercase file names and "_"'s between the words (snake casing)
- Add new examples to the list of problems in the README
- Try to add a new concept that the other programs don't cover

Thank you for contributing 🤗
