/**
 * Copyright (c) 2016 - 2022 Alex Grant (@localnerve), LocalNerve LLC
 * Copyrights licensed under the BSD License. See the accompanying LICENSE file for terms.
 *
 * Specific tests for reuse
 */

/**
 * Extract comparable function text with code instrumentation considerations.
 */
function comparableFunctionText (functionText) {
  return functionText
    // remove any coverage statements
    .replace(/[^;]+(?:cov_[^;]+);/g, '')
    // remove whitespace
    .replace(/\s+/g, '');
}

export function testTransform (expect, actual, expected) {
  Object.keys(expected).forEach((key) => {
    expect(actual[key].page).to.eql(expected[key].page);
    expect(actual[key].path).to.eql(expected[key].path);
    expect(actual[key].method).to.eql(expected[key].method);
    expect(actual[key].label).to.eql(expected[key].label);

    const expectedActionContents =
      comparableFunctionText(/\{([^}]+)\}/.exec(''+expected[key].action)[1]);

    expect(expectedActionContents).to.exist;
    expect(expectedActionContents).to.not.be.empty;

    expect(actual[key].action).to.be.a('function');
    expect(actual[key].action.length).to.eql(expected[key].action.length);

    expect(comparableFunctionText(''+actual[key].action))
      .to.contain(expectedActionContents);
  });
}
