/**
 * Copyright (c) 2016 - 2022 Alex Grant (@localnerve), LocalNerve LLC
 * Copyrights licensed under the BSD License. See the accompanying LICENSE file for terms.
 *
 * Mock idb for sw/sync/push
 */
/* global Promise */
'use strict';

const mockData = {
  error: false,
  value: undefined
};

const mockError = new Error('mock error');

module.exports = {
  synchronize: function synchronizePushSubscription () {
    const error = mockData.error;
    const value = typeof mockData.value === 'undefined' ?
      false : mockData.value;

    return new Promise(function (resolve, reject) {
      if (error) {
        return reject(mockError);
      }

      return resolve(value);
    });
  },
  setEmulateError: function (error) {
    mockData.error = error;
  },
  getMockError: function () {
    return mockError;
  },
  setValue: function (value) {
    mockData.value = value;
  }
};
