/**
 * Copyright (c) 2016 - 2022 Alex Grant (@localnerve), LocalNerve LLC
 * Copyrights licensed under the BSD License. See the accompanying LICENSE file for terms.
 *
 */
import routesResponse from 'test/fixtures/routes-response';
import modelsResponse from 'test/fixtures/models-response';
import aboutResponse from 'test/fixtures/about-response';
import contactResponse from 'test/fixtures/contact-response';
import homeResponse from 'test/fixtures/home-response';
import settingsResponse from 'test/fixtures/settings-response';
// import four04Response from 'test/fixtures/404-response';
// import five00Response from 'test/fixtures/500-response';

export function createContent (input) {
  const content = typeof input === 'string' ? '<h2>'+input+'</h2>'
    : input;

  return {
    models: modelsResponse,
    content: content
  };
}

export function fetch (params, callback) {
  if (params.emulateError) {
    return callback(new Error('mock'));
  }

  if (params.noData) {
    return callback();
  }

  let result;

  switch (params.resource) {
    case 'routes':
      result = callback(null, {
        models: undefined,
        content: JSON.parse(JSON.stringify(routesResponse))
      });
      break;

    case 'about':
      result = callback(null, JSON.parse(JSON.stringify(aboutResponse)));
      break;

    case 'contact':
      result = callback(null, JSON.parse(JSON.stringify(contactResponse)));
      break;

    case 'home':
      result = callback(null, JSON.parse(JSON.stringify(homeResponse)));
      break;

    case 'settings':
      result = callback(null, JSON.parse(JSON.stringify(settingsResponse)));
      break;

    default:
      throw new Error(
        'service-data test mock recieved unexpected resource request'
      );
  }

  return result;
}

function callbackOnly (callback) {
  callback();
}

export { callbackOnly as initialize }
export { callbackOnly as update }

export default {
  initialize: callbackOnly,
  update: callbackOnly,
  fetch,
  createContent
};
