/**
 * Copyright (c) 2016 - 2022 Alex Grant (@localnerve), LocalNerve LLC
 * Copyrights licensed under the BSD License. See the accompanying LICENSE file for terms.
 */
/* global Promise */
'use strict';

function mockAction (context, payload, done) {
  var error;

  if (payload.emulateError) {
    error = new Error('mock');
  }

  if (done) {
    return done(error);
  }

  return error ? Promise.reject() : Promise.resolve();
}

var actions = Object.create(null);
actions.page = mockAction;
actions.settings = mockAction;

module.exports = {
  getActions: function () {
    return actions;
  },
  putAction: function (name, action) {
    actions[name] = action;
  },
  mockAction: mockAction
};
