/***
 * Copyright (c) 2016 - 2022 Alex Grant (@localnerve), LocalNerve LLC
 * Copyrights licensed under the BSD License. See the accompanying LICENSE file for terms.
 */
import FluxibleRouteTransformer from './FluxibleRouteTransformer';
import codes from './codes';

/**
 * Factory to create a FluxibleRouteTransformer object.
 *
 * @param {Object} options - Options to control the object creation.
 * @param {Object} options.actions - The actions available for use in route transformations, and thus in the backend.
 */
export function createFluxibleRouteTransformer (options) {
  options = options || {};
  return new FluxibleRouteTransformer(options.actions);
}

export const conformErrorStatus = codes.conformErrorStatus;

export default {
  createFluxibleRouteTransformer,
  conformErrorStatus
};
