import { SelectProps } from 'antd';
import { flatten } from 'lodash-es';

import voiceList from '@/core/data/voiceList';

const azureVoiceList = {
  'ar-SA': ['ar-SA-HamedNeural', 'ar-SA-ZariyahNeural'],
  'de-DE': [
    'de-DE-AmalaNeural',
    'de-DE-BerndNeural',
    'de-DE-ChristophNeural',
    'de-DE-ConradNeural',
    'de-DE-ElkeNeural',
    'de-DE-GiselaNeural',
    'de-DE-KasperNeural',
    'de-DE-KatjaNeural',
    'de-DE-KillianNeural',
    'de-DE-KlarissaNeural',
    'de-DE-KlausNeural',
    'de-DE-LouisaNeural',
    'de-DE-MajaNeural',
    'de-DE-RalfNeural',
    'de-DE-TanjaNeural',
  ],
  'en-US': [
    'en-US-AIGenerate1Neural',
    'en-US-AIGenerate2Neural',
    'en-US-AmberNeural',
    'en-US-AnaNeural',
    'en-US-AndrewNeural',
    'en-US-AriaNeural',
    'en-US-AshleyNeural',
    'en-US-BlueNeural',
    'en-US-BrandonNeural',
    'en-US-BrianNeural',
    'en-US-ChristopherNeural',
    'en-US-CoraNeural',
    'en-US-DavisNeural',
    'en-US-ElizabethNeural',
    'en-US-EmmaNeural',
    'en-US-EricNeural',
    'en-US-GuyNeural',
    'en-US-JacobNeural',
    'en-US-JaneNeural',
    'en-US-JasonNeural',
    'en-US-JennyNeural',
    'en-US-JennyMultilingualNeural',
    'en-US-JennyMultilingualV2Neural',
    'en-US-MichelleNeural',
    'en-US-MonicaNeural',
    'en-US-NancyNeural',
    'en-US-RogerNeural',
    'en-US-RyanMultilingualNeural',
    'en-US-SaraNeural',
    'en-US-SteffanNeural',
    'en-US-TonyNeural',
  ],
  'es-ES': [
    'es-ES-AbrilNeural',
    'es-ES-AlvaroNeural',
    'es-ES-ArnauNeural',
    'es-ES-DarioNeural',
    'es-ES-EliasNeural',
    'es-ES-ElviraNeural',
    'es-ES-EstrellaNeural',
    'es-ES-IreneNeural',
    'es-ES-LaiaNeural',
    'es-ES-LiaNeural',
    'es-ES-NilNeural',
    'es-ES-SaulNeural',
    'es-ES-TeoNeural',
    'es-ES-TrianaNeural',
    'es-ES-VeraNeural',
  ],
  'fr-FR': [
    'fr-FR-AlainNeural',
    'fr-FR-BrigitteNeural',
    'fr-FR-CelesteNeural',
    'fr-FR-ClaudeNeural',
    'fr-FR-CoralieNeural',
    'fr-FR-DeniseNeural',
    'fr-FR-EloiseNeural',
    'fr-FR-HenriNeural',
    'fr-FR-JacquelineNeural',
    'fr-FR-JeromeNeural',
    'fr-FR-JosephineNeural',
    'fr-FR-MauriceNeural',
    'fr-FR-YvesNeural',
    'fr-FR-YvetteNeural',
  ],
  'ja-JP': [
    'ja-JP-NanamiNeural',
    'ja-JP-KeitaNeural',
    'ja-JP-DaichiNeural',
    'ja-JP-ShioriNeural',
    'ja-JP-NaokiNeural',
    'ja-JP-MayuNeural',
    'ja-JP-AoiNeural',
  ],
  'ko-KR': [
    'ko-KR-GookMinNeural',
    'ko-KR-BongJinNeural',
    'ko-KR-SeoHyeonNeural',
    'ko-KR-SunHiNeural',
    'ko-KR-SoonBokNeural',
    'ko-KR-YuJinNeural',
    'ko-KR-InJoonNeural',
    'ko-KR-JiMinNeural',
  ],
  'pt-BR': [
    'pt-BR-AntonioNeural',
    'pt-BR-BrendaNeural',
    'pt-BR-DonatoNeural',
    'pt-BR-ElzaNeural',
    'pt-BR-FabioNeural',
    'pt-BR-FranciscaNeural',
    'pt-BR-GiovannaNeural',
    'pt-BR-HumbertoNeural',
    'pt-BR-JulioNeural',
    'pt-BR-LeilaNeural',
    'pt-BR-LeticiaNeural',
    'pt-BR-ManuelaNeural',
    'pt-BR-NicolauNeural',
    'pt-BR-ValerioNeural',
    'pt-BR-YaraNeural',
  ],
  'ru-RU': ['ru-RU-DariyaNeural', 'ru-RU-DmitryNeural', 'ru-RU-SvetlanaNeural'],
  'zh-CN': [
    'zh-CN-YunjianNeural',
    'wuu-CN-YunzheNeural',
    'zh-CN-YunxiaNeural',
    'zh-CN-guangxi-YunqiNeural',
    'zh-CN-sichuan-YunxiNeural',
    'zh-CN-YunxiNeural',
    'zh-CN-YunyangNeural',
    'zh-CN-YunjieNeural',
    'yue-CN-YunSongNeural',
    'zh-CN-YunfengNeural',
    'zh-CN-YunzeNeural',
    'zh-CN-henan-YundengNeural',
    'zh-CN-YunhaoNeural',
    'zh-CN-shandong-YunxiangNeural',
    'zh-CN-liaoning-YunbiaoNeural',
    'zh-CN-YunyeNeural',
    'zh-CN-XiaoyiNeural',
    'zh-CN-liaoning-XiaobeiNeural',
    'zh-CN-XiaoshuangNeural',
    'zh-CN-shaanxi-XiaoniNeural',
    'wuu-CN-XiaotongNeural',
    'zh-CN-XiaoyouNeural',
    'yue-CN-XiaoMinNeural',
    'zh-CN-XiaoxiaoNeural',
    'zh-CN-XiaorouNeural',
    'zh-CN-XiaomengNeural',
    'zh-CN-XiaohanNeural',
    'zh-CN-XiaozhenNeural',
    'zh-CN-XiaoruiNeural',
    'zh-CN-XiaoqiuNeural',
    'zh-CN-XiaoxuanNeural',
    'zh-CN-XiaochenNeural',
    'zh-CN-XiaoyanNeural',
    'zh-CN-XiaomoNeural',
  ],
  'zh-TW': ['zh-TW-HsiaoChenNeural', 'zh-TW-HsiaoYuNeural', 'zh-TW-YunJheNeural'],
} as const;

export default azureVoiceList;

export const getAzureVoiceOptions = (locale?: string): SelectProps['options'] => {
  const data =
    locale && (azureVoiceList as any)?.[locale]
      ? (azureVoiceList as any)?.[locale] || []
      : flatten(Object.values(azureVoiceList));

  return data.map((voice: any) => ({ label: (voiceList as any)?.[voice] || voice, value: voice }));
};
