/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/*
 * ipcsem.h - common definitions for the IPC semaphore tests
 */

#ifndef __IPCSEM_H
#define __IPCSEM_H

#include <errno.h>
#include <sys/ipc.h>
#include <sys/sem.h>

#include "test.h"
#include "lapi/sem.h"

void cleanup(void);
void setup(void);

#define SEM_RD	0400
#define SEM_ALT	0200
#define SEM_RA	SEM_RD | SEM_ALT

#define PSEMS	10		/* a reasonable value for the number of */
				/* "primitive semaphores" per ID 	*/

#ifdef LIBIPC
key_t semkey;			/* an IPC key generated by ftok() */
#else
extern key_t semkey;	 	 /* an IPC key generated by ftok() */
#endif

void rm_sema(int sem_id);

int getipckey();
int getuserid(char *);

#endif /* ipcsem.h */
