"""restructure_task_files_to_json

Revision ID: be09bcfc4d20
Revises: 81d0ebd54177
Create Date: 2024-12-18 09:39:44.611645

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'be09bcfc4d20'
down_revision: Union[str, None] = '81d0ebd54177'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    
    # 添加新列，带默认值
    with op.batch_alter_table('tasks') as batch_op:
        batch_op.add_column(sa.Column('style_params', sa.JSON(), nullable=False,
            server_default=sa.text("'{\"content_length\": \"medium\", \"tone\": \"casual\", \"emotion\": \"neutral\"}'")
        ))
        batch_op.add_column(sa.Column('files', sa.JSON(), nullable=False,
            server_default=sa.text("'{}'")
        ))
        batch_op.add_column(sa.Column('created_at', sa.BigInteger(), nullable=False,
            server_default=sa.text('0')
        ))
        batch_op.add_column(sa.Column('updated_at', sa.BigInteger(), nullable=False,
            server_default=sa.text('0')
        ))
        batch_op.add_column(sa.Column('error', sa.String(), nullable=True))
        
        # 删除旧列
        batch_op.drop_column('createdAt')
        batch_op.drop_column('subtitleUrlCn')
        batch_op.drop_column('audioUrlEn')
        batch_op.drop_column('subtitleUrlEn')
        batch_op.drop_column('audioUrlCn')
        batch_op.drop_column('updatedAt')


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('tasks') as batch_op:
        batch_op.add_column(sa.Column('updatedAt', sa.BIGINT(), nullable=False))
        batch_op.add_column(sa.Column('audioUrlCn', sa.VARCHAR(), nullable=True))
        batch_op.add_column(sa.Column('subtitleUrlEn', sa.VARCHAR(), nullable=True))
        batch_op.add_column(sa.Column('audioUrlEn', sa.VARCHAR(), nullable=True))
        batch_op.add_column(sa.Column('subtitleUrlCn', sa.VARCHAR(), nullable=True))
        batch_op.add_column(sa.Column('createdAt', sa.BIGINT(), nullable=False))
        batch_op.drop_column('error')
        batch_op.drop_column('updated_at')
        batch_op.drop_column('created_at')
        batch_op.drop_column('files')
        batch_op.drop_column('style_params')
