# 项目结构说明文档

## 目录结构概览

这是一个基于FastAPI的后端服务项目，采用模块化设计，清晰的分层架构。以下是详细的目录结构说明：

```
server/
├── 📁 alembic/ # 数据库迁移配置
├── 📁 api/ # API路由层
│ └── 📁 v1/ # API版本控制
│ ├── auth.py # 认证相关接口
│ ├── tasks.py # 任务管理接口
│ └── users.py # 用户管理接口
├── 📁 auth/ # 认证模块
│ ├── dependencies.py # 认证依赖
│ └── utils.py # 认证工具
├── 📁 core/ # 核心配置
│ ├── config.py # 应用配置
│ ├── exceptions.py # 异常处理
│ └── logging.py # 日志配置
├── 📁 crud/ # 数据操作层
├── 📁 db/ # 数据库配置
├── 📁 models/ # 数据模型
├── 📁 schemas/ # 数据验证
├── 📁 services/ # 业务服务
├── 📁 tests/ # 测试用例
├── 📁 utils/ # 工具函数
└── main.py # 应用入口
```

## 核心模块说明

### API层 (api/)
- 采用版本化管理 (v1)
- 清晰的接口分组 (auth/tasks/users)
- 统一的错误处理
- 标准化的响应格式

### 认证模块 (auth/)
- JWT token认证
- 权限依赖注入
- 密码加密处理
- 用户状态验证

### 核心配置 (core/)
- 环境配置管理
- 日志系统配置
- 全局异常处理
- 系统常量定义

### 数据层
- 模型定义 (models/)
- 数据验证 (schemas/)
- CRUD操作 (crud/)
- 数据库配置 (db/)

### 业务服务层 (services/)
- 任务处理服务
- 文件处理服务
- TTS服务集成
- URL内容获取

### 测试系统 (tests/)
- 单元测试
- 集成测试
- 测试夹具
- 测试数据库配置

## 设计原则

1. **模块化设计**
   - 高内聚低耦合
   - 清晰的职责划分
   - 可插拔的组件结构

2. **安全性**
   - JWT认证
   - 密码加密存储
   - 权限精细控制
   - 用户状态管理

3. **可维护性**
   - 统一的代码风格
   - 完整的测试覆盖
   - 清晰的文档说明
   - 规范的错误处理

4. **可扩展性**
   - 版本化API设计
   - 模块化服务结构
   - 配置驱动开发
   - 插件化功能扩展
