# LingoPod管理后台UI设计规范

## 1. 整体布局结构

### 1.1 基础布局
```
管理后台
├── 顶部导航栏
│   ├── 系统Logo/标题
│   ├── 管理员信息
│   └── 退出登录
├── 侧边栏导航
│   ├── 仪表盘
│   ├── 用户管理(管理员可见)
│   ├── 任务管理
│   ├── 个人信息
│   └── 系统设置(管理员可见)
└── 主内容区
```

## 2. 功能页面设计

### 2.1 登录页面
- 设计风格：简洁现代
- 核心功能：
  - 用户名密码登录表单
  - "记住我"选项
  - 登录失败次数限制提示
  - 清晰的错误提示样式
  - 注册入口

### 2.2 仪表盘页面
- 欢迎区域
  - 个性化欢迎信息
  - 用户基本信息卡片
    - 用户名/昵称
    - 邮箱地址
    - 上次登录时间
- 快捷操作区
- 数据统计展示

### 2.3 用户管理页面
- 用户列表视图
  - 搜索筛选区
    - 用户名搜索
    - 状态筛选
    - 时间范围选择
  - 列表操作区
    - 批量操作工具栏
    - 分页控制器
  - 用户信息展示
    - 基础信息列
    - 状态标识
    - 操作按钮组
- 用户详情页
  - 基本信息卡片
  - TTS配置面板
  - 任务统计图表

### 2.4 任务管理页面
- 任务列表
  - 高级筛选面板
    - 状态筛选
    - 公开性筛选
    - URL/标题搜索
    - 时间范围选择
  - 任务信息展示
    - 任务状态标识
    - 进度条显示
    - URL和标题信息
    - 文件下载链接
    - 创建时间
  - 操作按钮组
    - 编辑按钮
    - 重试按钮
    - 删除按钮
    - 复制功能
- 任务创建/编辑表单
  - URL输入框
  - 标题输入框
  - 公开性开关
  - 提交按钮组

### 2.5 系统设置页面
- 参数配置面板
  - 配置项列表
    - 配置名称
    - 当前值
    - 类型标识
    - 描述信息
  - 实时编辑状态
  - 重置按钮
- 系统监控面板（待实现）
  - 资源使用统计
  - 日志查看器

## 3. 设计规范

### 3.1 色彩系统
- 主色调：Material-UI默认主题色
- 状态色：
  - 成功：绿色
  - 警告：橙色
  - 错误：红色
  - 信息：蓝色

### 3.2 响应式设计
- 断点设置：遵循Material-UI断点规范
- 移动端优化：
  - 侧边栏可收起
  - 表格横向滚动
  - 适配小屏幕的布局调整

### 3.3 交互规范
- 操作反馈：所有操作都需要即时反馈
- 加载状态：使用骨架屏或进度条
- 表单验证：即时验证与提示
- 错误处理：友好的错误提示
- 确认机制：危险操作需二次确认

### 3.4 无障碍设计
- 键盘导航支持
- 适当的颜色对比度
- ARIA标签支持
- 屏幕阅读器优化

