# LingoPod 客户端UI设计规范

## 1. 整体布局结构

### 1.1 基础布局
客户端
├── 侧边栏导航
│ ├── Logo/品牌标识
│ ├── 播放列表
│ │ ├── 最近播放
│ │ ├── 我的收藏
│ │ └── 历史记录
│ ├── 个人中心
│ └── 任务管理
├── 主内容区
│ ├── 播放器主界面
│ │ ├── 封面展示
│ │ ├── 字幕显示
│ │ └── 进度控制
│ └── 功能页面
└── 底部播放控制栏
├── 播放控制组
│ ├── 上一个/播放/暂停/下一个
│ └── 播放模式切换
├── 进度条
├── 音量控制
└── 播放列表切换


### 1.2 响应式设计
- 断点设置
  - 移动端: < 768px
  - 平板: 768px - 1024px
  - 桌面端: > 1024px
- 布局适配
  - 移动端单列布局
  - 平板/桌面双列布局
  - 弹性伸缩容器

## 2. 功能页面设计

### 2.1 登录/注册页面
- 界面布局
  - 品牌展示区
  - 表单区域
  - 辅助信息区
- 核心功能
  - 账号密码登录
  - 社交账号登录
  - 注册功能
  - 找回密码
- 交互优化
  - 表单验证反馈
  - 登录状态保持
  - 安全性提示

### 2.2 个人中心页面
- 基础信息管理
  - 头像上传
  - 昵称修改
  - 密码修改
  - 邮箱绑定
- TTS偏好设置
  - 音色选择
  - 语速调节
  - 音量设置
  - 配置模板管理
- 使用数据统计
  - 任务统计图表
  - 存储空间统计
  - 使用时长统计

### 2.3 任务管理页面
- 任务列表
  - 列表/网格视图切换
  - 状态标签显示
  - 进度展示
  - 快速操作按钮
- 任务操作
  - 新建任务
  - 批量导入
  - 任务模板
  - 批量操作
- 任务详情
  - 基本信息展示
  - 处理进度追踪
  - 结果预览
  - 分享功能

### 2.4 播放器页面
- 播放控制
  - 基础控制按钮
    - 播放/暂停
    - 上一个/下一个
    - 音量调节
  - 高级控制
    - 倍速播放
    - 音轨切换
    - 循环模式
- 字幕显示
  - 中英文切换
  - 字幕样式设置
  - 同步调整
  - 字体大小控制
- 进度控制
  - 进度条拖拽
  - 预览缩略图
  - 章节标记
  - 历史记录点
- 播放列表
  - 队列管理
  - 收藏功能
  - 历史记录
  - 播放模式切换

## 3. 交互设计规范

### 3.1 操作反馈
- 加载状态
  - 骨架屏加载
  - 进度条显示
  - 加载动画
- 操作提示
  - Toast消息
  - 对话框确认
  - 错误提示
- 空状态处理
  - 引导性提示
  - 示例展示
  - 快捷操作

### 3.2 主题系统
- 主题切换
  - 明亮主题
  - 暗黑主题
  - 跟随系统
- 主题定制
  - 主色调选择
  - 强调色配置
  - 字体设置

### 3.3 无障碍支持
- 键盘操作
  - 快捷键支持
  - 焦点管理
  - Tab键导航
- 屏幕阅读
  - ARIA标签
  - 语义化结构
  - 替代文本

### 3.4 性能优化
- 资源加载
  - 懒加载
  - 预加载
  - 缓存策略
- 渲染优化
  - 虚拟列表
  - 分页加载
  - 防抖节流

## 4. 设计资源规范

### 4.1 色彩系统
- 主色调: #1890ff
- 辅助色
  - 成功: #52c41a
  - 警告: #faad14
  - 错误: #f5222d
  - 链接: #1890ff
- 中性色
  - 标题: rgba(0, 0, 0, 0.85)
  - 正文: rgba(0, 0, 0, 0.65)
  - 辅助文字: rgba(0, 0, 0, 0.45)

### 4.2 字体系统
- 主字体: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto
- 代码字体: 'SFMono-Regular', Consolas, 'Liberation Mono'
- 字号
  - 标题: 20px/24px/16px/14px
  - 正文: 14px
  - 辅助文字: 12px

### 4.3 间距系统
- 基础间距: 8px
- 间距倍数: 8/16/24/32/40/48px
- 内容边距: 24px
- 组件间距: 16px