import React, { Component } from 'react';

import Languages from 'app/features/global/services/languages-service';
import MediumPopupManager from 'app/components/modal/modal-manager';
import EventModification from './EventModification.jsx';
import CalendarService from 'app/deprecated/Apps/Calendar/Calendar.js';
import Input from 'components/inputs/input.jsx';
import InputIcon from 'components/inputs/input-icon.jsx';
import Participants from './Part/Participants.jsx';
import DateSelector from './Part/DateSelector.jsx';
import CalendarSelector from 'components/calendar/calendar-selector/calendar-selector.jsx';
import Collections from 'app/deprecated/CollectionsV1/Collections/Collections.js';
import Button from 'components/buttons/button.jsx';
import Select from 'components/select/select.jsx';
import WorkspaceService from 'app/deprecated/workspaces/workspaces.jsx';
import Icon from 'app/components/icon/icon.jsx';

export default class EventCreation extends Component {
  constructor(props) {
    super(props);
    Collections.get('events').addListener(this);
    Collections.get('events').listenOnly([props.event.front_id], this);
  }

  UNSAFE_componentWillMount() {
    CalendarService.fullSizeModal = false;
  }

  componentDidMount() {
    MediumPopupManager.mountedComponent = this;
    this.doNotCancelEdit = false;
  }
  componentWillUnmount() {
    Collections.get('events').removeListener(this);
  }

  onMediumPopupClose() {
    if (!this.doNotCancelEdit) {
      CalendarService.closePopups();
    }
  }

  save() {
    CalendarService.saveEdit(this.props.collectionKey);
  }
  change(key, value, notify) {
    this.props.event[key] = value;

    if (notify || notify === undefined) {
      this.update_timeout && clearTimeout(this.update_timeout);
      this.update_timeout = setTimeout(() => {
        Collections.get('events').notify();
      }, 1000);
      this.setState({});
    }
  }
  render() {
    var event = this.props.event;
    var calendar_list = Collections.get('calendars').findBy({
      workspace_id: WorkspaceService.currentWorkspaceId,
    });

    return (
      <div className="eventModal event_creation" style={{ padding: '16px' }}>
        <Input
          autoFocus
          value={event.title || ''}
          placeholder={Languages.t('scenes.apps.calendar.modals.title_placeholder', [], 'Titre')}
          onChange={evt => {
            this.change('title', evt.target.value);
          }}
          className="full_width bottom-margin"
          big
        />

        <div className="bottom-margin date_and_type">
          <Select
            medium
            value={event.type || 'event'}
            onChange={value => {
              this.change('type', value);
            }}
            options={CalendarService.event_types}
            className="right-margin"
          />
          <DateSelector
            event={event}
            onChange={(from, to, all_day, repetition_definition) => {
              this.change('from', from, false);
              this.change('to', to, false);
              this.change('all_day', all_day, false);
              this.change('repetition_definition', repetition_definition);
            }}
          />
        </div>

        <div style={{ display: 'flex' }} className="full_width bottom-margin">
          <div style={{ flex: 1, display: 'flex' }} className="right-margin">
            <InputIcon
              icon={(event.location || '').slice(0, 4) == 'http' ? 'link' : 'location-point'}
              medium
              value={event.location || ''}
              placeholder={Languages.t(
                'scenes.apps.calendar.modals.event_adresse_placeholder',
                [],
                'Adresse',
              )}
              onChange={evt => {
                this.change('location', evt.target.value);
              }}
              className="full_width"
            />
          </div>
          <Button
            className="button medium secondary"
            onClick={() => {
              this.change(
                'location',
                window.location.protocol +
                  '//' +
                  window.location.host +
                  '/bundle/connectors/jitsi/call/twake_event_' +
                  (event.front_id || '').replace(/-/g, '_') +
                  '__' +
                  (event.front_id || '').replace(/-/g, '_'),
              );
            }}
          >
            <Icon type="video" />
          </Button>
        </div>

        <InputIcon
          autoHeight
          icon="align-left-justify"
          medium
          value={event.description || ''}
          placeholder={Languages.t(
            'scenes.apps.calendar.modals.description_placeholder',
            [],
            'Description',
          )}
          onChange={evt => {
            this.change('description', evt.target.value);
          }}
          className="full_width bottom-margin"
        />

        <CalendarSelector
          medium
          value={event.workspaces_calendars || []}
          onChange={workspaces_calendars => {
            this.change('workspaces_calendars', workspaces_calendars);
          }}
          calendarList={calendar_list || []}
          className=""
        />

        <div className="separator" />

        <div className="small-bottom-margin">
          <Participants
            participants={event.participants}
            owner={event.owner}
            onChange={user_id_or_mail => this.change('participants', user_id_or_mail)}
          />
        </div>

        <div className="separator" />

        <Button
          className="button medium secondary-light"
          style={{ width: 'auto' }}
          onClick={() => {
            this.doNotCancelEdit = true;
            MediumPopupManager.open(
              <EventModification
                event={CalendarService.edited}
                collectionKey={this.props.collectionKey}
              />,
              { size: { width: 600 } },
            );
          }}
        >
          {Languages.t('scenes.apps.calendar.modals.advanced_options', [], 'Options avancées')}
        </Button>
        <Button
          className="button medium btn-primary medium"
          style={{ width: 'auto', marginLeft: 10, float: 'right' }}
          onClick={() => {
            this.save();
          }}
        >
          {Languages.t('general.save', [], 'Enregistrer')}
        </Button>
      </div>
    );
  }
}
