---
description: Discover how channels are used on Twake
---

# Channels

## Create a channel

To create a channel, you must have `Administrator` rights for the workspace in question.

[rights](../../company-and-workspace/rights.md)

To create your channel, click on the `+` button right to the "Channel" inscription. Fill a name for your channel, select a wonderful emoji and select if it is a public or private channel \(by default, channels are private\).

## Channel sections

You can organize your channel by grouping them. If you are `Administrator`, you can drag a channel and drop in the section you want `Add here` or in `New group`.

To edit section name, you just have to click on it, change the name and press `Enter`

![](../../../assets/channel-move.gif)

## Public channel

Public channels are visible to all members of the workspace.

## Private channel

Private channels are channels accessible only to a limited number of users. Members not present in these channels cannot see them.

### Modify the members of a private channel

You can choose the members of a private channel when creating it. To modify the members of a private channel once created, place your mouse on the channel, click on the `...` then on `Edit channel`, in the `Participants` box, you can add or remove the members of the channel.

![](../../../assets/private-channel-member.gif)

## External member

You have the possibility to invite external members to your channel. External members are members who are not in the workspace and who are added to one, or more, specific channel\(s\).

This feature is useful for inviting users who are not in your company. Freelancers, for example, can be added to a specific channel to collaborate on a project. They will only have access to this channel, they will not see public channels.

![](../../../assets/externalmember.gif)

## Mute a channel

You can mute a channel so that you do not receive notification of it. You will not receive a new notification from that channel unless you are mentioned \(with @username\). To do it, click on `...` and `Mute`a barred bell icon will appear.

## Star a channel

If a channel is very important for you, you can star it. Stared channels are gathered at the top of your channel. It is only for your view, not for everyone. To star a channel click on `...` and `Star this channel`. Your channel will be move to the stared channel section \(at the top\).
