# Table of contents

- [☀️ Twake](index.md)

## Getting started <a href="#gettingstarted" id="gettingstarted"></a>

- [▶ Use Twake on twake.app](gettingstarted/use-twake-on-twake.app.md)
- [🏗 Install on your server](onprem/installation.md)
- [⚙ Configuration](onprem/configuration/index.md)
  - [🔒 Security](onprem/configuration/security.md)
  - [🔗 Custom domain + HTTPS](onprem/configuration/custom-domain-and-https/README.md)
    - [Apache2 configuration](onprem/configuration/custom-domain-and-https/apache2-configuration.md)
  - [💌 Configure mail server](onprem/configuration/configure-mail-server.md)
  - [🎨 Customisation](onprem/configuration/customisation.md)
  - [🔌 Connectors and plugins](onprem/configuration/connectors-and-plugins.md)
  - [👨‍💻 Authentication modes](onprem/configuration/authentication-modes/README.md)
    - [Using Keycloak (LDAP, OpenID and more)](onprem/configuration/authentication-modes/using-keycloak-ldap-openid-and-more.md)
    - [Installing Twake with LemonLDAP (LDAP, OpenID and more)](onprem/configuration/authentication-modes/installing-twake-with-lemonldap-ldap-openid-and-more.md)

## How to use it

- [👋 Welcome to Twake !](how-to-use-it/welcome.md)
- [🧰 Console](how-to-use-it/console/README.md)
  - [Users](how-to-use-it/console/users.md)
- [🏢 Company & workspace](how-to-use-it/company-and-workspace/README.md)
  - [Invite user from Chat](how-to-use-it/company-and-workspace/invite-user-from-chat.md)
  - [Rights](how-to-use-it/company-and-workspace/rights.md)
- [💠 Applications](how-to-use-it/applications/README.md)
  - [💬 Chat](how-to-use-it/applications/how-to-use-chat/README.md)
    - [Channels](how-to-use-it/applications/how-to-use-chat/channels.md)
    - [Message](how-to-use-it/applications/how-to-use-chat/message.md)
  - [📂 Drive](how-to-use-it/applications/drive/README.md)
    - [File and folder](how-to-use-it/applications/drive/file-and-folder.md)
    - [Share file with public link](how-to-use-it/applications/drive/share-file-with-public-link.md)
  - [📆 Calendar](how-to-use-it/applications/calendar.md)
  - [✅ Tasks](how-to-use-it/applications/tasks.md)
  - [🔃 Connectors](how-to-use-it/applications/connectors/README.md)
    - [n8n](how-to-use-it/applications/connectors/n8n.md)
- [🖥 Desktop and mobile app](how-to-use-it/desktop-and-mobile-app.md)
- [🔒 Privacy and security](how-to-use-it/privacy-security.md)

## Developers API

- [🏠 Home](developers-api/home.md)
- [🥇 Getting started](developers-api/get-started/README.md)
  - [Create your first application](developers-api/get-started/create-your-first-application.md)
  - [Authenticate with Postman](developers-api/get-started/authenticate-postman.md)
  - [Send a message with your application](developers-api/get-started/send-a-message-for-twake.md)
  - [Trigger action from command](developers-api/get-started/trigger-action-from-command.md)
- [⚙ Application settings](developers-api/application-settings/README.md)
  - [Api](developers-api/application-settings/api.md)
  - [Display](developers-api/application-settings/application-visibility-example.md)
  - [Privileges](developers-api/application-settings/privileges.md)
  - [Identity](developers-api/application-settings/identity.md)
- [📖 API Reference](developers-api/api-reference/README.md)
  - [Webhook](developers-api/api-reference/wehbook.md)
  - [Drive](developers-api/api-reference/drive.md)
  - [Message](developers-api/api-reference/message/README.md)
  - [Authentication](developers-api/api-reference/auth.md)
- [🧱 Blocks](developers-api/blocks.md)

## Internal Documentation

- [🥇 Get started](developers-api/run-twake-as-developer.md)
- [🎨 Twake Ecosystem Guidelines](internal-documentation/twake-ecosystem-guidelines.md)
- [📚 Our stack](internal-documentation/our-stack.md)
- [🧱 Backend and APIs](internal-documentation/backend-services/README.md)
  - [👥 Users, workspaces and companies](internal-documentation/backend-services/users/README.md)
  - [🍎 Applications](internal-documentation/backend-services/applications/README.md)
    - [Database models](internal-documentation/backend-services/applications/database-models.md)
    - [REST APIs](internal-documentation/backend-services/applications/rest-apis.md)
  - [🎩 Channels and tabs](internal-documentation/backend-services/channels/README.md)
    - [Database models](internal-documentation/backend-services/channels/database-models.md)
  - [💬 Messages](internal-documentation/backend-services/messages/README.md)
    - [Database models](internal-documentation/backend-services/messages/database-model.md)
  - [📄 Files](internal-documentation/backend-services/files/README.md)
    - [Database models](internal-documentation/backend-services/files/database-models.md)
    - [Resumable.js](internal-documentation/backend-services/files/resumablejs.md)
  - [📲 Notifications](internal-documentation/backend-services/notifications/README.md)
    - [Database models](internal-documentation/backend-services/notifications/database-models.md)
  - [🛠 Twake service development](internal-documentation/backend-services/intro/README.md)
    - [What is a service in Twake ?](internal-documentation/backend-services/intro/start-working-into-a-service.md)
    - [Create a new service](internal-documentation/backend-services/intro/create-a-new-twake-service.md)
    - [Platform/Technical services](internal-documentation/backend-services/intro/platform/README.md)
      - [Database ORM platform service](internal-documentation/backend-services/intro/platform/database-orm-platform-service.md)
- [🎭 Translation](internal-documentation/translation.md)
