# LINAGORA OPEN-SOURCE CODE OF CONDUCT



## Our Pledge

In Linagora, we foster an open and welcoming environment to build Good Tech - ethical and open-source software. We build this Good Tech to have a maximum positive impact on people, society, and the planet. We call this #GoodTech4Good. This is made possible by the support, hard work and enthusiasm of thousands of people, including those who create and use Linagora products. 

We as contributors and maintainers pledge to making participation in our project and in our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, sex characteristics, gender identity and expression, level of experience, education, socio-economic status, nationality, personal appearance, race, religion, or sexual identity and orientation. 



## Our Standards

This code of conduct outlines expectations for participants in Linagora managed open-source communities, as well as for reporting unacceptable behavior. We are committed to providing a welcoming and inspiring community for all. 

Examples of behavior that contributes to creating a positive environment include: 

- **Using welcoming and inclusive language**: Our communities welcome and support people of all backgrounds and identities. Remember you might not be communicating in someone else's primary spoken or programming language, and others may not have your level of understanding. 

- **Being respectful of differing viewpoints and experiences**: In order for the Linagora community to thrive, its members must feel comfortable and accepted. Treating one another with respect is absolutely necessary for this. In a disagreement, in the first instance assume that people mean well. Respecting other people, their work, their contributions and assuming well-meaning motivation will make community members feel comfortable and safe and will result in motivation and productivity. 

- **Gracefully accepting constructive criticism**: Disagreements, both political and technical, happen all the time. The goal is not to avoid disagreements or criticisms but to resolve them constructively. You should turn to the community to seek advice and to resolve disagreements and where possible consult the team most directly involved. Think deeply before taking a criticism personally and turning it into a public dispute. If you do feel that you or your work is being attacked, take your time to breathe through before writing heated replies. 

- **Focusing on what is best for the community**: The success and quality of open-source software depends on collaboration. As a contributor, you should aim to collaborate with other community members, as well as with other communities that are interested in or depend on the work you do. Your work should be transparent and be fed back into the community when available. Please ensure that you keep the other community members informed of your work, and publish it in a way that allows them to test, discuss and contribute to your efforts. 

  As a user, your feedback is important, as is its form. Poorly thought out comments can cause pain and demotivation of other community members, but considerate discussion of problems can bring positive results. 

- **Showing empathy towards other community members**: Our community is made strong by mutual respect, collaboration and empathy. Sometimes there are situations where this has to be defended and other community members need help. If you witness others being attacked, think first about how you can offer them personal support. If you feel that the situation is beyond your ability to help individually, go privately to the victim and ask if some form of official intervention is needed. Similarly, you should support anyone who appears to be in danger of burning out, either through work-related stress or personal problems. 

Examples of unacceptable behavior by participants include: 

- **The use of sexualized language or imagery and unwelcome sexual attention or advances.**
- **Trolling, insulting/derogatory comments, and personal or political attacks.**
- **Public or private harassments**
- **Publishing others' private information, such as physical or electronic address, without explicit permission.**
- **Other conduct which could reasonably be considered inappropriate in a professional setting.**

This code is neither exhaustive nor complete. It serves to capture our common understanding of a productive, collaborative environment. We expect the code to be followed in spirit as much as in the letter. 



## Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response to any instances of unacceptable behavior. 

Project maintainers have the right and responsibility to remove, edit, or reject comments, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful. 



## Scope

This Code of Conduct applies both within project spaces and in public spaces when an individual is representing the project or its community. Examples of representing a project or community include using an official project e-mail address, posting via an official social media account, or acting as an appointed representative at an online or offline event. Representation of a project may be further defined and clarified by project maintainers. 



## Reporting Code of Conduct Issues

We encourage all community members to resolve issues on their own whenever possible. This builds a broader and deeper understanding and ultimately a healthier interaction. In the event that an issue cannot be resolved locally, please feel free to report your concerns by contacting schauhan@linagora.com. Your report will be handled in accordance with the issue resolution process described in the Code of Conduct FAQ on our website(https://linagora.com). 

In your report please include: 

- Your contact information. 
- Names (real, usernames or pseudonyms) of any individuals involved. If there are additional witnesses, please include them as well. 
- Your account of what occurred, and if you believe the incident is ongoing. If there is a publicly available record (e.g. a mailing list archive or a public chat log), please include a link or attachment. 
- Any additional information that may be helpful. 

All reports will be reviewed by a multi-person team and will result in a response that is deemed necessary and appropriate to the circumstances. Where additional perspectives are needed, the team may seek insight from others with relevant expertise or experience. The confidentiality of the person reporting the incident will be kept at all times. Involved parties are never a part of the review team. 

Anyone asked to stop unacceptable behavior is expected to comply immediately. If an individual engages in unacceptable behavior, the review team may take an action they deem appropriate, including a permanent ban from the community. 



## Attribution

This Code of Conduct is adapted from both the [Contributor Covenant](https://www.contributor-covenant.org/), version 1.4, available at https://www.contributor-covenant.org/version/1/4/code-of-conduct.html and the template established by the [TODO Group](https://todogroup.org/). 
