const updates = 2067;
const cves = ['CVE-2022-31630', 'CVE-2022-37454', 'CVE-2022-31628', 'CVE-2022-31629', 'CVE-2022-31627', 'CVE-2022-31625',
    'CVE-2022-31626', 'CVE-2021-21708', 'CVE-2021-21703', 'CVE-2021-21706', 'CVE-2021-21707', 'CVE-2021-21704',
    'CVE-2021-21705', 'CVE-2021-21702', 'CVE-2020-7071', 'CVE-2020-7069', 'CVE-2020-7070', 'CVE-2020-7068', 'CVE-2019-11048',
    'CVE-2020-7067', 'CVE-2020-7064', 'CVE-2020-7065', 'CVE-2020-7066', 'CVE-2020-7062', 'CVE-2020-7063', 'CVE-2020-7061',
    'CVE-2020-7059', 'CVE-2020-7060', 'CVE-2019-11044', 'CVE-2019-11045', 'CVE-2019-11046', 'CVE-2019-11047', 'CVE-2019-11050',
    'CVE-2019-11049'];

const patchVersions = ['7.4.1', '7.3.13', '7.2.26', '7.4.2', '7.3.14', '7.2.27', '7.4.3', '7.3.15', '7.2.28', '7.3.16',
    '7.2.29', '7.4.4', '7.4.5', '7.3.17', '7.2.30', '7.4.6', '7.3.18', '7.2.31', '7.4.7', '7.3.19', '7.4.8', '7.3.20',
    '7.2.32', '7.4.9', '7.3.21', '7.2.33', '7.4.10', '7.3.22', '7.4.11', '7.3.23', '7.2.34', '7.3.24', '7.4.12', '7.4.13',
    '7.3.25', '8.0.1', '7.4.14', '7.3.26', '8.0.2', '7.4.15', '7.3.27', '8.0.3', '7.4.16', '7.3.28', '8.0.5', '7.4.18',
    '7.4.19', '8.0.6', '7.4.20', '8.0.7', '8.0.8', '7.3.29', '7.4.21', '8.0.9', '7.4.22', '8.0.10', '7.3.30', '7.4.23',
    '7.3.31', '8.0.11', '7.4.24', '8.0.12', '7.4.25', '7.3.32', '7.4.26', '7.3.33', '8.0.13', '7.4.27', '8.1.1', '8.0.14',
    '8.0.15', '8.1.2', '8.1.3', '8.0.16', '7.4.28', '8.0.17', '8.1.4', '7.4.29', '8.1.5', '8.0.18', '8.0.19', '8.1.6',
    '8.1.7', '7.4.30', '8.0.20', '8.0.21', '8.1.8', '8.1.9', '8.0.22', '8.1.10', '8.0.23', '7.4.32', '8.1.11', '8.0.24',
    '8.0.25', '8.1.12', '7.4.33', '8.1.13', '8.0.26'];

const minorVersions = ['8.1.0', '8.2.0'];
const majorVersionsCount = ['8.0.0'];

// hours no dups
// [
//   10,
//   493,
//   166,
//   234,
//   74,
//   258,
//   261,
//   2275,
//   257,
//   930,
//   26,
//   826,
//   145,
//   277,
//   307,
//   180,
//   433,
//   112
// ]

// hours - remove outliers
// 10, 493, 166, 234, 74, 258, 261, 257, 26, 145, 277, 307, 180, 433, 112

// https://www.calculator.net/statistics-calculator.html?numberinputs=10%2C+493%2C+166%2C+234%2C+74%2C+258%2C+261%2C+2275%2C+257%2C+930%2C+26%2C+826%2C+145%2C+277%2C+307%2C+180%2C+433%2C+112&x=92&y=21#inputfields
let rangeStatsHours = {
    average: 334,
    median: 260,
    StandardDeviation: 237
}

const phpReleaseHour = ['03:13:42+00:00', '15:28:59+00:00', '09:39:00+00:00', '13:20:39+00:00', '00:18:05+00:00', '14:33:51+02:00', '08:10:19+00:00', '17:25:36+00:00', '09:31:10+00:00', '20:50:23+00:00', '13:24:09+00:00', '08:27:58+00:00', '21:48:12+00:00', '07:44:14+00:00', '01:50:44+00:00', '17:49:29+02:00', '08:22:12+00:00', '23:34:53+00:00', '08:02:02+00:00', '23:59:59+01:00', '23:14:20+00:00', '14:37:30+00:00', '03:08:44+00:00', '11:38:32+00:00', '17:31:25+01:00', '23:33:54+00:00', '15:16:26+00:00', '17:43:08+01:00', '03:00:11+00:00', '11:02:47+00:00', '10:19:46+00:00', '08:40:01+00:00', '14:43:45+00:00', '10:08:35+00:00', '18:36:11+00:00', '14:41:58+00:00', '10:10:50+00:00', '14:44:33+00:00', '11:24:07+00:00', '10:51:05+00:00', '15:35:12+00:00', '13:26:00+00:00', '14:45:46+00:00', '11:20:10+00:00', '09:31:12+00:00', '22:08:39+00:00', '10:26:20+00:00', '13:41:40+00:00', '10:12:09+00:00', '07:18:54+00:00', '13:43:58+00:00', '10:26:18+00:00', '19:12:13+00:00', '18:23:48+00:00', '12:02:55+00:00', '11:17:26+00:00', '10:52:11+00:00', '15:44:37+00:00', '10:31:37+00:00', '09:57:50+00:00', '13:07:59+00:00', '10:30:36+00:00', '01:12:18+00:00', '17:54:57+00:00', '10:21:13+00:00', '13:28:37+00:00', '13:16:42+00:00', '13:05:27+00:00', '10:02:55+00:00', '09:19:07+00:00', '10:08:21+00:00', '08:18:53+00:00', '07:47:41+00:00', '13:54:17+00:00', '13:23:41+00:00', '13:26:32+00:00', '14:13:17+00:00', '10:51:02+00:00', '08:49:42+00:00', '08:26:30+00:00', '07:35:50+00:00', '20:23:20+00:00', '09:46:52+00:00', '08:14:04+00:00', '14:46:06+00:00', '09:56:36+00:00', '09:16:55+00:00', '20:53:17+09:00', '09:32:08+00:00', '09:01:15+00:00', '09:38:59+00:00', '09:11:36+00:00', '07:43:45+00:00', '13:02:37+00:00', '12:33:05+00:00', '11:40:20+00:00', '09:26:13+00:00', '14:20:26+00:00', '09:40:48+00:00'];

Chart.defaults.color = '#c9d1d9';
Chart.defaults.borderColor = 'gray';

const cveTimeline = {
    'CVE-2022-31630': {
        'announced': '2022-10-27T00:00:00+0000',
        'nvd': '2022-11-14T07:15:00+0000',
        'phpVersionAudit': '2022-10-28T13:58:58+00:00'
    },
    'CVE-2022-37454': {
        'announced': '2022-10-27T00:00:00+0000',
        'nvd': '2022-10-21T06:15:00+0000',
        'phpVersionAudit': '2022-10-28T13:58:58+00:00'
    },
    'CVE-2022-31628': {
        'announced': '2022-09-29T09:39:00+00:00',
        'nvd': '2022-09-28T23:15:00+00:00',
        'phpVersionAudit': '2022-09-29T14:01:00+00:00'
    },
    'CVE-2022-31629': {
        'announced': '2022-09-29T09:39:00+00:00',
        'nvd': '2022-09-28T23:15:00+00:00',
        'phpVersionAudit': '2022-09-29T14:01:00+00:00'
    },
    'CVE-2022-31627': {
        'announced': '2022-07-07T17:25:36+00:00',
        'nvd': '2022-07-28T06:15:00+00:00',
        'phpVersionAudit': '2022-07-08T03:17:23+00:00'
    },
    'CVE-2022-31625': {
        'announced': '2022-06-09T08:27:58+00:00',
        'nvd': '2022-06-16T06:15:00+00:00',
        'phpVersionAudit': '2022-06-09T13:42:05+00:00'
    },
    'CVE-2022-31626': {
        'announced': '2022-06-09T08:27:58+00:00',
        'nvd': '2022-06-16T06:15:00+00:00',
        'phpVersionAudit': '2022-06-09T13:42:05+00:00'
    },
    'CVE-2021-21708': {
        'announced': '2022-02-17T14:37:30+00:00',
        'nvd': '2022-02-27T08:15:00+00:00',
        'phpVersionAudit': '2022-02-18T02:09:23+00:00'
    },
    'CVE-2021-21703': {
        'announced': '2021-10-28T08:40:01+00:00',
        'nvd': '2021-10-25T06:15:00+00:00',
        'phpVersionAudit': '2021-10-21T13:34:07+00:00'
    },
    'CVE-2021-21706': {
        'announced': '2021-09-23T10:10:50+00:00',
        'nvd': '2021-10-04T04:15:00+00:00',
        'phpVersionAudit': '2021-09-23T13:31:16+00:00'
    },
    'CVE-2021-21707': {
        'announced': '2021-11-18T10:19:46+00:00',
        'nvd': '2021-11-29T07:15:00+00:00',
        'phpVersionAudit': '2021-11-18T13:29:28+00:00'
    },
    'CVE-2021-21704': {
        'announced': '2021-07-01T09:31:12+00:00',
        'nvd': '2021-10-04T04:15:00+00:00',
        'phpVersionAudit': '2021-07-01T13:34:33+00:00'
    },
    'CVE-2021-21705': {
        'announced': '2021-07-01T09:31:12+00:00',
        'nvd': '2021-10-04T04:15:00+00:00',
        'phpVersionAudit': '2021-07-01T13:34:33+00:00'
    },
    'CVE-2021-21702': {
        'announced': '2021-02-04T10:52:11+00:00',
        'nvd': '2021-02-15T04:15:00+00:00',
        'phpVersionAudit': '2021-02-04T13:24:15+00:00'
    },
    'CVE-2020-7071': {
        'announced': '2021-01-07T09:57:50+00:00',
        'nvd': '2021-02-15T04:15:00+00:00',
        'phpVersionAudit': '2021-01-07T18:20:04+00:00'
    },
    'CVE-2020-7069': {
        'announced': '2020-10-01T13:05:27+00:00',
        'nvd': '2020-10-02T15:15:00+00:00',
        'phpVersionAudit': '2020-10-01T14:57:45+00:00'
    },
    'CVE-2020-7070': {
        'announced': '2020-10-01T13:05:27+00:00',
        'nvd': '2020-10-02T15:15:00+00:00',
        'phpVersionAudit': '2020-10-01T14:57:45+00:00'
    },
    'CVE-2020-7068': {
        'announced': '2020-08-06T07:47:41+00:00',
        'nvd': '2020-09-09T18:15:00+00:00',
        'phpVersionAudit': '2020-08-06T12:51:33+00:00'
    },
    'CVE-2019-11048': {
        'announced': '2020-05-14T07:35:50+00:00',
        'nvd': '2020-05-20T08:15:00+00:00',
        'phpVersionAudit': '2020-05-14T14:36:22+00:00'
    },
    'CVE-2020-7067': {
        'announced': '2020-04-16T08:14:04+00:00',
        'nvd': '2020-04-27T21:15:00+00:00',
        'phpVersionAudit': '2020-04-16T13:09:39+00:00'
    },
    'CVE-2020-7064': {
        'announced': '2020-03-19T09:16:55+00:00',
        'nvd': '2020-04-01T04:15:00+00:00',
        'phpVersionAudit': '2020-03-19T14:06:17+00:00'
    },
    'CVE-2020-7065': {
        'announced': '2020-03-19T09:16:55+00:00',
        'nvd': '2020-04-01T04:15:00+00:00',
        'phpVersionAudit': '2020-03-19T14:06:17+00:00'
    },
    'CVE-2020-7066': {
        'announced': '2020-03-19T09:16:55+00:00',
        'nvd': '2020-04-01T04:15:00+00:00',
        'phpVersionAudit': '2020-03-19T14:06:17+00:00'
    },
    'CVE-2020-7062': {
        'announced': '2020-02-20T09:01:15+00:00',
        'nvd': '2020-02-27T21:15:00+00:00',
        'phpVersionAudit': '2020-02-20T14:04:02+00:00'
    },
    'CVE-2020-7063': {
        'announced': '2020-02-20T09:01:15+00:00',
        'nvd': '2020-02-27T21:15:00+00:00',
        'phpVersionAudit': '2020-02-20T14:04:02+00:00'
    },
    'CVE-2020-7061': {
        'announced': '2020-02-20T09:01:15+00:00',
        'nvd': '2020-02-27T21:15:00+00:00',
        'phpVersionAudit': '2020-02-20T14:04:02+00:00'
    },
    'CVE-2020-7059': {
        'announced': '2020-01-23T07:43:45+00:00',
        'nvd': '2020-02-10T08:15:00+00:00',
        'phpVersionAudit': '2020-01-23T13:20:56+00:00'
    },
    'CVE-2020-7060': {
        'announced': '2020-01-23T07:43:45+00:00',
        'nvd': '2020-02-10T08:15:00+00:00',
        'phpVersionAudit': '2020-01-23T13:20:56+00:00'
    },
    'CVE-2019-11044': {
        'announced': '2019-12-18T11:40:20+00:00',
        'nvd': '2019-12-23T03:15:00+00:00',
        'phpVersionAudit': '2019-12-18T14:01:16+00:00'
    },
    'CVE-2019-11045': {
        'announced': '2019-12-18T11:40:20+00:00',
        'nvd': '2019-12-23T03:15:00+00:00',
        'phpVersionAudit': '2019-12-18T14:01:16+00:00'
    },
    'CVE-2019-11046': {
        'announced': '2019-12-18T11:40:20+00:00',
        'nvd': '2019-12-23T03:15:00+00:00',
        'phpVersionAudit': '2019-12-18T14:01:16+00:00'
    },
    'CVE-2019-11047': {
        'announced': '2019-12-18T11:40:20+00:00',
        'nvd': '2019-12-23T03:15:00+00:00',
        'phpVersionAudit': '2019-12-18T14:01:16+00:00'
    },
    'CVE-2019-11050': {
        'announced': '2019-12-18T11:40:20+00:00',
        'nvd': '2019-12-23T03:15:00+00:00',
        'phpVersionAudit': '2019-12-18T14:01:16+00:00'
    },
    'CVE-2019-11049': {
        'announced': '2019-12-18T11:40:20+00:00',
        'nvd': '2019-12-23T03:15:00+00:00',
        'phpVersionAudit': '2019-12-18T14:01:16+00:00'
    },
}

let hoursFromAnnouncementToNvdPublish = Object.keys(cveTimeline).map((cve) => {
    const announced = new Date(cveTimeline[cve].announced).getTime();
    const published = new Date(cveTimeline[cve].nvd).getTime();
    return Math.round((published - announced) / 1000 / 3600);
});

hoursFromAnnouncementToNvdPublish = hoursFromAnnouncementToNvdPublish.filter(hour => hour > 0);

hoursFromAnnouncementToNvdPublishRemoveDups = [];
hoursFromAnnouncementToNvdPublish.forEach((hour) => {
    if (hoursFromAnnouncementToNvdPublishRemoveDups.length === 0) {
        hoursFromAnnouncementToNvdPublishRemoveDups.push(hour);
    } else if (hour !== hoursFromAnnouncementToNvdPublishRemoveDups[hoursFromAnnouncementToNvdPublishRemoveDups.length-1]) {
        hoursFromAnnouncementToNvdPublishRemoveDups.push(hour);
    }
});

let hoursFromAnnouncementToPhpVersionAudit = Object.keys(cveTimeline).map((cve) => {
    const announced = new Date(cveTimeline[cve].announced).getTime();
    const phpVersionAudit = new Date(cveTimeline[cve].phpVersionAudit).getTime();
    return Math.round((phpVersionAudit - announced) / 1000 / 3600);
});

hoursFromAnnouncementToPhpVersionAudit = hoursFromAnnouncementToPhpVersionAudit.filter(hour => hour > 0);

hoursFromAnnouncementToPhpVersionAuditRemoveDups = [];
hoursFromAnnouncementToPhpVersionAudit.forEach((hour) => {
    if (hoursFromAnnouncementToPhpVersionAuditRemoveDups.length === 0) {
        hoursFromAnnouncementToPhpVersionAuditRemoveDups.push(hour);
    } else if (hour !== hoursFromAnnouncementToPhpVersionAuditRemoveDups[hoursFromAnnouncementToPhpVersionAuditRemoveDups.length-1]) {
        hoursFromAnnouncementToPhpVersionAuditRemoveDups.push(hour);
    }
});

const releaseFrequency = [{'x': '2019-12-12T02:08:42+0000', 'y': 12}, {'x': '2019-12-12T14:01:53+0000', 'y': 12}, {'x': '2019-12-13T02:03:37+0000', 'y': 12}, {'x': '2019-12-13T14:02:01+0000', 'y': 12}, {'x': '2019-12-17T02:03:09+0000', 'y': 84}, {'x': '2019-12-17T14:01:57+0000', 'y': 12}, {'x': '2019-12-18T02:04:51+0000', 'y': 12}, {'x': '2019-12-18T14:01:16+0000', 'y': 12}, {'x': '2019-12-19T02:01:29+0000', 'y': 12}, {'x': '2019-12-19T14:01:37+0000', 'y': 12}, {'x': '2019-12-19T14:43:22+0000', 'y': 1}, {'x': '2019-12-19T15:43:41+0000', 'y': 1}, {'x': '2019-12-20T02:03:31+0000', 'y': 10}, {'x': '2019-12-20T14:01:56+0000', 'y': 12}, {'x': '2019-12-21T05:08:45+0000', 'y': 15}, {'x': '2019-12-21T14:02:10+0000', 'y': 9}, {'x': '2019-12-22T02:04:16+0000', 'y': 12}, {'x': '2019-12-22T14:02:17+0000', 'y': 12}, {'x': '2019-12-23T02:04:08+0000', 'y': 12}, {'x': '2019-12-23T14:02:02+0000', 'y': 12}, {'x': '2019-12-24T02:03:35+0000', 'y': 12}, {'x': '2019-12-24T14:02:27+0000', 'y': 12}, {'x': '2019-12-25T02:04:45+0000', 'y': 12}, {'x': '2019-12-25T14:02:21+0000', 'y': 12}, {'x': '2019-12-26T02:03:42+0000', 'y': 12}, {'x': '2019-12-26T14:13:03+0000', 'y': 12}, {'x': '2019-12-27T02:03:36+0000', 'y': 12}, {'x': '2019-12-27T14:02:32+0000', 'y': 12}, {'x': '2019-12-28T02:04:37+0000', 'y': 12}, {'x': '2019-12-28T14:02:14+0000', 'y': 12}, {'x': '2019-12-29T02:04:28+0000', 'y': 12}, {'x': '2019-12-29T14:02:20+0000', 'y': 12}, {'x': '2019-12-30T02:03:48+0000', 'y': 12}, {'x': '2019-12-30T14:02:19+0000', 'y': 12}, {'x': '2019-12-31T02:03:45+0000', 'y': 12}, {'x': '2019-12-31T14:02:30+0000', 'y': 12}, {'x': '2020-01-01T19:28:06+0000', 'y': 29}, {'x': '2020-01-01T20:32:17+0000', 'y': 1}, {'x': '2020-01-02T14:31:51+0000', 'y': 18}, {'x': '2020-01-02T15:08:14+0000', 'y': 1}, {'x': '2020-01-03T02:03:30+0000', 'y': 11}, {'x': '2020-01-03T14:02:09+0000', 'y': 12}, {'x': '2020-01-04T02:04:18+0000', 'y': 12}, {'x': '2020-01-04T14:02:24+0000', 'y': 12}, {'x': '2020-01-05T02:03:59+0000', 'y': 12}, {'x': '2020-01-05T14:02:25+0000', 'y': 12}, {'x': '2020-01-06T02:03:48+0000', 'y': 12}, {'x': '2020-01-06T14:02:24+0000', 'y': 12}, {'x': '2020-01-07T02:04:06+0000', 'y': 12}, {'x': '2020-01-07T14:02:35+0000', 'y': 12}, {'x': '2020-01-08T02:04:00+0000', 'y': 12}, {'x': '2020-01-08T14:02:29+0000', 'y': 12}, {'x': '2020-01-09T02:06:53+0000', 'y': 12}, {'x': '2020-01-09T14:02:35+0000', 'y': 12}, {'x': '2020-01-10T02:04:00+0000', 'y': 12}, {'x': '2020-01-10T14:11:15+0000', 'y': 12}, {'x': '2020-01-11T14:02:19+0000', 'y': 24}, {'x': '2020-01-12T02:04:18+0000', 'y': 12}, {'x': '2020-01-12T14:02:12+0000', 'y': 12}, {'x': '2020-01-13T02:03:54+0000', 'y': 12}, {'x': '2020-01-13T14:09:55+0000', 'y': 12}, {'x': '2020-01-14T04:11:33+0000', 'y': 14}, {'x': '2020-01-14T14:02:17+0000', 'y': 10}, {'x': '2020-01-15T02:04:01+0000', 'y': 12}, {'x': '2020-01-15T14:09:58+0000', 'y': 12}, {'x': '2020-01-22T14:02:06+0000', 'y': 168}, {'x': '2020-01-23T02:03:50+0000', 'y': 12}, {'x': '2020-01-23T13:20:56+0000', 'y': 11}, {'x': '2020-01-23T14:01:53+0000', 'y': 1}, {'x': '2020-01-24T02:03:44+0000', 'y': 12}, {'x': '2020-01-24T14:01:52+0000', 'y': 12}, {'x': '2020-01-25T02:03:35+0000', 'y': 12}, {'x': '2020-01-25T14:02:00+0000', 'y': 12}, {'x': '2020-01-26T02:03:48+0000', 'y': 12}, {'x': '2020-01-26T14:02:26+0000', 'y': 12}, {'x': '2020-01-27T02:03:22+0000', 'y': 12}, {'x': '2020-01-27T14:02:04+0000', 'y': 12}, {'x': '2020-01-28T02:03:59+0000', 'y': 12}, {'x': '2020-01-28T14:02:11+0000', 'y': 12}, {'x': '2020-01-29T02:03:08+0000', 'y': 12}, {'x': '2020-01-29T14:02:07+0000', 'y': 12}, {'x': '2020-01-30T02:03:53+0000', 'y': 12}, {'x': '2020-01-30T14:10:06+0000', 'y': 12}, {'x': '2020-01-31T02:01:53+0000', 'y': 12}, {'x': '2020-01-31T14:02:20+0000', 'y': 12}, {'x': '2020-02-01T02:01:52+0000', 'y': 12}, {'x': '2020-02-01T14:02:26+0000', 'y': 12}, {'x': '2020-02-02T02:02:06+0000', 'y': 12}, {'x': '2020-02-02T14:02:33+0000', 'y': 12}, {'x': '2020-02-03T02:02:00+0000', 'y': 12}, {'x': '2020-02-03T14:02:35+0000', 'y': 12}, {'x': '2020-02-04T02:01:57+0000', 'y': 12}, {'x': '2020-02-04T14:03:11+0000', 'y': 12}, {'x': '2020-02-05T02:04:38+0000', 'y': 12}, {'x': '2020-02-05T14:02:24+0000', 'y': 12}, {'x': '2020-02-06T02:02:28+0000', 'y': 12}, {'x': '2020-02-06T14:03:01+0000', 'y': 12}, {'x': '2020-02-07T02:01:49+0000', 'y': 12}, {'x': '2020-02-07T14:02:23+0000', 'y': 12}, {'x': '2020-02-08T02:02:02+0000', 'y': 12}, {'x': '2020-02-08T14:26:32+0000', 'y': 12}, {'x': '2020-02-09T14:04:01+0000', 'y': 24}, {'x': '2020-02-10T02:05:24+0000', 'y': 12}, {'x': '2020-02-10T14:03:59+0000', 'y': 12}, {'x': '2020-02-11T02:02:32+0000', 'y': 12}, {'x': '2020-02-11T14:04:02+0000', 'y': 12}, {'x': '2020-02-12T02:02:23+0000', 'y': 12}, {'x': '2020-02-12T14:04:21+0000', 'y': 12}, {'x': '2020-02-13T02:02:47+0000', 'y': 12}, {'x': '2020-02-13T14:04:21+0000', 'y': 12}, {'x': '2020-02-14T02:02:56+0000', 'y': 12}, {'x': '2020-02-14T14:04:12+0000', 'y': 12}, {'x': '2020-02-19T14:04:11+0000', 'y': 120}, {'x': '2020-02-20T02:02:38+0000', 'y': 12}, {'x': '2020-02-20T14:04:02+0000', 'y': 12}, {'x': '2020-02-21T02:02:39+0000', 'y': 12}, {'x': '2020-02-21T15:22:14+0000', 'y': 13}, {'x': '2020-02-22T02:02:37+0000', 'y': 11}, {'x': '2020-02-22T14:04:12+0000', 'y': 12}, {'x': '2020-02-23T02:02:23+0000', 'y': 12}, {'x': '2020-02-23T14:03:44+0000', 'y': 12}, {'x': '2020-02-24T02:02:24+0000', 'y': 12}, {'x': '2020-02-24T14:03:51+0000', 'y': 12}, {'x': '2020-02-25T02:02:10+0000', 'y': 12}, {'x': '2020-02-25T14:04:21+0000', 'y': 12}, {'x': '2020-02-26T02:02:17+0000', 'y': 12}, {'x': '2020-02-26T14:04:04+0000', 'y': 12}, {'x': '2020-02-27T02:02:44+0000', 'y': 12}, {'x': '2020-02-27T14:03:54+0000', 'y': 12}, {'x': '2020-02-28T02:05:24+0000', 'y': 12}, {'x': '2020-02-28T14:03:50+0000', 'y': 12}, {'x': '2020-02-29T02:02:33+0000', 'y': 12}, {'x': '2020-02-29T14:06:50+0000', 'y': 12}, {'x': '2020-03-01T02:02:32+0000', 'y': 12}, {'x': '2020-03-01T14:03:47+0000', 'y': 12}, {'x': '2020-03-02T02:05:29+0000', 'y': 12}, {'x': '2020-03-02T14:10:28+0000', 'y': 12}, {'x': '2020-03-03T02:02:27+0000', 'y': 12}, {'x': '2020-03-03T14:03:51+0000', 'y': 12}, {'x': '2020-03-04T02:02:38+0000', 'y': 12}, {'x': '2020-03-04T14:06:39+0000', 'y': 12}, {'x': '2020-03-05T02:02:52+0000', 'y': 12}, {'x': '2020-03-05T14:03:56+0000', 'y': 12}, {'x': '2020-03-06T02:16:17+0000', 'y': 12}, {'x': '2020-03-06T14:11:48+0000', 'y': 12}, {'x': '2020-03-07T14:06:56+0000', 'y': 24}, {'x': '2020-03-08T02:02:38+0000', 'y': 12}, {'x': '2020-03-08T14:03:58+0000', 'y': 12}, {'x': '2020-03-09T02:05:03+0000', 'y': 12}, {'x': '2020-03-09T14:04:15+0000', 'y': 12}, {'x': '2020-03-10T02:10:15+0000', 'y': 12}, {'x': '2020-03-10T14:12:27+0000', 'y': 12}, {'x': '2020-03-11T02:02:44+0000', 'y': 12}, {'x': '2020-03-12T02:02:18+0000', 'y': 24}, {'x': '2020-03-12T14:06:43+0000', 'y': 12}, {'x': '2020-03-13T02:02:25+0000', 'y': 12}, {'x': '2020-03-13T14:06:51+0000', 'y': 12}, {'x': '2020-03-14T02:02:30+0000', 'y': 12}, {'x': '2020-03-14T14:04:11+0000', 'y': 12}, {'x': '2020-03-15T02:02:41+0000', 'y': 12}, {'x': '2020-03-16T02:02:44+0000', 'y': 24}, {'x': '2020-03-16T14:14:37+0000', 'y': 12}, {'x': '2020-03-17T14:07:03+0000', 'y': 24}, {'x': '2020-03-18T02:02:51+0000', 'y': 12}, {'x': '2020-03-18T14:10:58+0000', 'y': 12}, {'x': '2020-03-19T02:04:54+0000', 'y': 12}, {'x': '2020-03-19T14:06:17+0000', 'y': 12}, {'x': '2020-03-20T02:02:08+0000', 'y': 12}, {'x': '2020-03-20T14:12:57+0000', 'y': 12}, {'x': '2020-03-21T14:06:13+0000', 'y': 24}, {'x': '2020-03-22T14:26:33+0000', 'y': 24}, {'x': '2020-03-23T02:05:02+0000', 'y': 12}, {'x': '2020-03-23T14:05:54+0000', 'y': 12}, {'x': '2020-03-24T02:05:01+0000', 'y': 12}, {'x': '2020-03-24T14:03:43+0000', 'y': 12}, {'x': '2020-03-25T02:11:05+0000', 'y': 12}, {'x': '2020-03-25T14:10:07+0000', 'y': 12}, {'x': '2020-03-26T02:08:14+0000', 'y': 12}, {'x': '2020-03-26T14:14:14+0000', 'y': 12}, {'x': '2020-03-27T02:05:08+0000', 'y': 12}, {'x': '2020-03-27T14:06:46+0000', 'y': 12}, {'x': '2020-03-28T02:04:45+0000', 'y': 12}, {'x': '2020-03-28T14:06:12+0000', 'y': 12}, {'x': '2020-03-29T02:04:55+0000', 'y': 12}, {'x': '2020-03-30T02:04:55+0000', 'y': 24}, {'x': '2020-03-30T14:06:12+0000', 'y': 12}, {'x': '2020-03-31T02:05:37+0000', 'y': 12}, {'x': '2020-03-31T14:06:06+0000', 'y': 12}, {'x': '2020-04-02T02:04:57+0000', 'y': 36}, {'x': '2020-04-02T14:06:20+0000', 'y': 12}, {'x': '2020-04-03T02:05:07+0000', 'y': 12}, {'x': '2020-04-03T14:15:23+0000', 'y': 12}, {'x': '2020-04-04T02:08:01+0000', 'y': 12}, {'x': '2020-04-04T14:08:27+0000', 'y': 12}, {'x': '2020-04-05T02:04:56+0000', 'y': 12}, {'x': '2020-04-05T14:05:26+0000', 'y': 12}, {'x': '2020-04-06T02:07:54+0000', 'y': 12}, {'x': '2020-04-06T14:05:43+0000', 'y': 12}, {'x': '2020-04-07T14:12:55+0000', 'y': 24}, {'x': '2020-04-08T02:04:36+0000', 'y': 12}, {'x': '2020-04-08T14:03:06+0000', 'y': 12}, {'x': '2020-04-09T02:04:45+0000', 'y': 12}, {'x': '2020-04-09T14:05:29+0000', 'y': 12}, {'x': '2020-04-10T14:06:09+0000', 'y': 24}, {'x': '2020-04-12T03:23:37+0000', 'y': 37}, {'x': '2020-04-12T14:05:44+0000', 'y': 11}, {'x': '2020-04-13T02:04:52+0000', 'y': 12}, {'x': '2020-04-14T14:06:05+0000', 'y': 36}, {'x': '2020-04-15T02:05:05+0000', 'y': 12}, {'x': '2020-04-16T02:04:50+0000', 'y': 24}, {'x': '2020-04-16T13:09:39+0000', 'y': 11}, {'x': '2020-04-17T14:09:18+0000', 'y': 25}, {'x': '2020-04-19T02:09:49+0000', 'y': 36}, {'x': '2020-04-19T14:10:48+0000', 'y': 12}, {'x': '2020-04-20T02:12:02+0000', 'y': 12}, {'x': '2020-04-20T14:16:26+0000', 'y': 12}, {'x': '2020-04-22T14:10:02+0000', 'y': 48}, {'x': '2020-04-23T02:12:09+0000', 'y': 12}, {'x': '2020-04-24T02:12:21+0000', 'y': 24}, {'x': '2020-04-26T02:12:15+0000', 'y': 48}, {'x': '2020-04-26T14:10:34+0000', 'y': 12}, {'x': '2020-04-27T02:12:05+0000', 'y': 12}, {'x': '2020-04-28T02:11:58+0000', 'y': 24}, {'x': '2020-04-28T14:11:42+0000', 'y': 12}, {'x': '2020-04-29T02:11:55+0000', 'y': 12}, {'x': '2020-04-29T14:13:13+0000', 'y': 12}, {'x': '2020-04-30T02:11:54+0000', 'y': 12}, {'x': '2020-04-30T14:10:03+0000', 'y': 12}, {'x': '2020-05-02T02:11:52+0000', 'y': 36}, {'x': '2020-05-03T02:12:06+0000', 'y': 24}, {'x': '2020-05-03T14:10:15+0000', 'y': 12}, {'x': '2020-05-04T02:12:02+0000', 'y': 12}, {'x': '2020-05-04T14:08:20+0000', 'y': 12}, {'x': '2020-05-06T13:28:45+0000', 'y': 47}, {'x': '2020-05-06T14:07:35+0000', 'y': 1}, {'x': '2020-05-08T14:11:57+0000', 'y': 48}, {'x': '2020-05-09T14:12:54+0000', 'y': 24}, {'x': '2020-05-10T02:10:28+0000', 'y': 12}, {'x': '2020-05-10T14:12:15+0000', 'y': 12}, {'x': '2020-05-11T02:12:12+0000', 'y': 12}, {'x': '2020-05-12T02:12:14+0000', 'y': 24}, {'x': '2020-05-13T14:11:11+0000', 'y': 36}, {'x': '2020-05-14T14:36:22+0000', 'y': 24}, {'x': '2020-05-15T02:13:10+0000', 'y': 12}, {'x': '2020-05-16T02:12:55+0000', 'y': 24}, {'x': '2020-05-16T14:08:45+0000', 'y': 12}, {'x': '2020-05-17T02:10:52+0000', 'y': 12}, {'x': '2020-05-18T02:10:24+0000', 'y': 24}, {'x': '2020-05-19T02:14:19+0000', 'y': 24}, {'x': '2020-05-19T14:09:06+0000', 'y': 12}, {'x': '2020-05-20T14:08:07+0000', 'y': 24}, {'x': '2020-05-21T02:12:03+0000', 'y': 12}, {'x': '2020-05-21T14:14:42+0000', 'y': 12}, {'x': '2020-05-22T02:16:33+0000', 'y': 12}, {'x': '2020-05-22T14:25:03+0000', 'y': 12}, {'x': '2020-05-26T12:45:57+0000', 'y': 94}, {'x': '2020-05-28T14:15:17+0000', 'y': 49}, {'x': '2020-05-29T13:46:30+0000', 'y': 24}, {'x': '2020-06-01T12:33:20+0000', 'y': 71}, {'x': '2020-06-02T12:29:49+0000', 'y': 24}, {'x': '2020-06-03T14:31:10+0000', 'y': 26}, {'x': '2020-06-04T14:40:15+0000', 'y': 24}, {'x': '2020-06-05T12:56:18+0000', 'y': 22}, {'x': '2020-06-08T12:47:03+0000', 'y': 72}, {'x': '2020-06-09T15:20:51+0000', 'y': 27}, {'x': '2020-06-10T14:29:34+0000', 'y': 23}, {'x': '2020-06-11T14:32:34+0000', 'y': 24}, {'x': '2020-06-15T01:28:24+0000', 'y': 83}, {'x': '2020-06-15T13:12:17+0000', 'y': 12}, {'x': '2020-06-15T14:15:04+0000', 'y': 1}, {'x': '2020-06-17T12:49:30+0000', 'y': 47}, {'x': '2020-06-18T14:33:04+0000', 'y': 26}, {'x': '2020-06-19T14:00:00+0000', 'y': 23}, {'x': '2020-06-22T14:59:24+0000', 'y': 73}, {'x': '2020-06-23T19:19:19+0000', 'y': 28}, {'x': '2020-06-24T12:47:42+0000', 'y': 17}, {'x': '2020-06-25T14:33:00+0000', 'y': 26}, {'x': '2020-06-26T15:34:06+0000', 'y': 25}, {'x': '2020-06-28T14:20:38+0000', 'y': 47}, {'x': '2020-06-29T14:11:56+0000', 'y': 24}, {'x': '2020-07-01T12:54:49+0000', 'y': 47}, {'x': '2020-07-02T14:39:03+0000', 'y': 26}, {'x': '2020-07-05T03:03:05+0000', 'y': 60}, {'x': '2020-07-07T16:07:56+0000', 'y': 61}, {'x': '2020-07-09T14:37:47+0000', 'y': 46}, {'x': '2020-07-10T13:25:20+0000', 'y': 23}, {'x': '2020-07-13T14:04:52+0000', 'y': 73}, {'x': '2020-07-15T13:20:13+0000', 'y': 47}, {'x': '2020-07-16T14:40:42+0000', 'y': 25}, {'x': '2020-07-17T14:36:11+0000', 'y': 24}, {'x': '2020-07-19T20:56:47+0000', 'y': 54}, {'x': '2020-07-21T12:25:53+0000', 'y': 39}, {'x': '2020-07-22T13:05:41+0000', 'y': 25}, {'x': '2020-07-23T14:37:26+0000', 'y': 26}, {'x': '2020-07-24T13:07:23+0000', 'y': 22}, {'x': '2020-07-24T14:18:23+0000', 'y': 1}, {'x': '2020-07-27T17:19:02+0000', 'y': 75}, {'x': '2020-07-28T13:52:00+0000', 'y': 21}, {'x': '2020-07-28T14:17:51+0000', 'y': 0}, {'x': '2020-07-30T14:45:07+0000', 'y': 48}, {'x': '2020-07-31T13:27:22+0000', 'y': 23}, {'x': '2020-08-03T14:37:49+0000', 'y': 73}, {'x': '2020-08-05T14:38:09+0000', 'y': 48}, {'x': '2020-08-06T02:18:49+0000', 'y': 12}, {'x': '2020-08-06T12:51:33+0000', 'y': 11}, {'x': '2020-08-06T14:18:12+0000', 'y': 1}, {'x': '2020-08-07T02:18:59+0000', 'y': 12}, {'x': '2020-08-07T14:16:13+0000', 'y': 12}, {'x': '2020-08-07T14:17:52+0000', 'y': 0}, {'x': '2020-08-08T02:18:51+0000', 'y': 12}, {'x': '2020-08-08T14:17:32+0000', 'y': 12}, {'x': '2020-08-09T02:18:42+0000', 'y': 12}, {'x': '2020-08-09T14:17:14+0000', 'y': 12}, {'x': '2020-08-10T02:19:43+0000', 'y': 12}, {'x': '2020-08-10T11:45:26+0000', 'y': 9}, {'x': '2020-08-10T12:40:36+0000', 'y': 1}, {'x': '2020-08-10T14:18:11+0000', 'y': 2}, {'x': '2020-08-11T02:19:19+0000', 'y': 12}, {'x': '2020-08-11T14:18:17+0000', 'y': 12}, {'x': '2020-08-11T16:31:56+0000', 'y': 2}, {'x': '2020-08-11T18:32:15+0000', 'y': 2}, {'x': '2020-08-11T19:32:57+0000', 'y': 1}, {'x': '2020-08-11T20:05:18+0000', 'y': 1}, {'x': '2020-08-12T01:18:16+0000', 'y': 5}, {'x': '2020-08-12T13:16:50+0000', 'y': 12}, {'x': '2020-08-13T01:18:46+0000', 'y': 12}, {'x': '2020-08-13T13:17:03+0000', 'y': 12}, {'x': '2020-08-14T01:15:46+0000', 'y': 12}, {'x': '2020-08-14T13:16:44+0000', 'y': 12}, {'x': '2020-08-15T01:18:30+0000', 'y': 12}, {'x': '2020-08-15T13:17:04+0000', 'y': 12}, {'x': '2020-08-16T01:18:42+0000', 'y': 12}, {'x': '2020-08-16T13:16:28+0000', 'y': 12}, {'x': '2020-08-17T01:18:56+0000', 'y': 12}, {'x': '2020-08-17T13:17:59+0000', 'y': 12}, {'x': '2020-08-18T01:18:56+0000', 'y': 12}, {'x': '2020-08-18T13:17:18+0000', 'y': 12}, {'x': '2020-08-19T01:19:17+0000', 'y': 12}, {'x': '2020-08-19T13:17:44+0000', 'y': 12}, {'x': '2020-08-20T01:20:05+0000', 'y': 12}, {'x': '2020-08-20T13:18:00+0000', 'y': 12}, {'x': '2020-08-21T01:19:26+0000', 'y': 12}, {'x': '2020-08-21T13:18:03+0000', 'y': 12}, {'x': '2020-08-22T01:19:58+0000', 'y': 12}, {'x': '2020-08-22T13:17:22+0000', 'y': 12}, {'x': '2020-08-23T01:18:43+0000', 'y': 12}, {'x': '2020-08-23T13:17:23+0000', 'y': 12}, {'x': '2020-08-24T01:18:48+0000', 'y': 12}, {'x': '2020-08-24T13:18:10+0000', 'y': 12}, {'x': '2020-08-25T01:19:04+0000', 'y': 12}, {'x': '2020-08-25T13:17:57+0000', 'y': 12}, {'x': '2020-08-26T01:19:14+0000', 'y': 12}, {'x': '2020-08-26T13:18:04+0000', 'y': 12}, {'x': '2020-08-27T01:19:25+0000', 'y': 12}, {'x': '2020-08-27T13:18:04+0000', 'y': 12}, {'x': '2020-08-28T01:22:35+0000', 'y': 12}, {'x': '2020-08-28T13:19:10+0000', 'y': 12}, {'x': '2020-08-29T01:12:47+0000', 'y': 12}, {'x': '2020-08-29T13:11:56+0000', 'y': 12}, {'x': '2020-08-30T01:11:52+0000', 'y': 12}, {'x': '2020-08-30T13:13:02+0000', 'y': 12}, {'x': '2020-08-31T01:12:29+0000', 'y': 12}, {'x': '2020-08-31T13:09:12+0000', 'y': 12}, {'x': '2020-09-01T01:23:52+0000', 'y': 12}, {'x': '2020-09-01T13:19:45+0000', 'y': 12}, {'x': '2020-09-02T01:18:21+0000', 'y': 12}, {'x': '2020-09-02T13:19:36+0000', 'y': 12}, {'x': '2020-09-03T01:23:04+0000', 'y': 12}, {'x': '2020-09-03T13:19:42+0000', 'y': 12}, {'x': '2020-09-04T01:23:42+0000', 'y': 12}, {'x': '2020-09-04T13:19:41+0000', 'y': 12}, {'x': '2020-09-05T02:17:33+0000', 'y': 13}, {'x': '2020-09-05T13:38:03+0000', 'y': 11}, {'x': '2020-09-06T01:24:54+0000', 'y': 12}, {'x': '2020-09-06T13:19:25+0000', 'y': 12}, {'x': '2020-09-07T01:25:02+0000', 'y': 12}, {'x': '2020-09-07T13:20:06+0000', 'y': 12}, {'x': '2020-09-08T01:24:50+0000', 'y': 12}, {'x': '2020-09-08T13:20:25+0000', 'y': 12}, {'x': '2020-09-09T01:25:13+0000', 'y': 12}, {'x': '2020-09-09T13:20:28+0000', 'y': 12}, {'x': '2020-09-10T01:22:57+0000', 'y': 12}, {'x': '2020-09-10T13:19:31+0000', 'y': 12}, {'x': '2020-09-11T01:23:28+0000', 'y': 12}, {'x': '2020-09-11T13:19:38+0000', 'y': 12}, {'x': '2020-09-12T01:24:12+0000', 'y': 12}, {'x': '2020-09-12T13:19:18+0000', 'y': 12}, {'x': '2020-09-13T01:26:05+0000', 'y': 12}, {'x': '2020-09-13T13:19:23+0000', 'y': 12}, {'x': '2020-09-14T01:25:46+0000', 'y': 12}, {'x': '2020-09-14T13:20:24+0000', 'y': 12}, {'x': '2020-09-15T01:25:32+0000', 'y': 12}, {'x': '2020-09-15T13:21:06+0000', 'y': 12}, {'x': '2020-09-16T01:25:33+0000', 'y': 12}, {'x': '2020-09-16T13:20:15+0000', 'y': 12}, {'x': '2020-09-17T01:26:29+0000', 'y': 12}, {'x': '2020-09-17T13:20:23+0000', 'y': 12}, {'x': '2020-09-18T01:26:42+0000', 'y': 12}, {'x': '2020-09-18T13:20:13+0000', 'y': 12}, {'x': '2020-09-19T01:26:10+0000', 'y': 12}, {'x': '2020-09-19T13:20:03+0000', 'y': 12}, {'x': '2020-09-20T01:27:35+0000', 'y': 12}, {'x': '2020-09-20T13:19:58+0000', 'y': 12}, {'x': '2020-09-21T01:28:08+0000', 'y': 12}, {'x': '2020-09-21T13:20:36+0000', 'y': 12}, {'x': '2020-09-22T01:27:58+0000', 'y': 12}, {'x': '2020-09-22T13:20:44+0000', 'y': 12}, {'x': '2020-09-23T01:27:53+0000', 'y': 12}, {'x': '2020-09-23T13:20:36+0000', 'y': 12}, {'x': '2020-09-24T01:29:44+0000', 'y': 12}, {'x': '2020-09-24T13:20:49+0000', 'y': 12}, {'x': '2020-09-25T01:28:52+0000', 'y': 12}, {'x': '2020-09-25T13:21:40+0000', 'y': 12}, {'x': '2020-09-26T01:28:30+0000', 'y': 12}, {'x': '2020-09-26T13:20:21+0000', 'y': 12}, {'x': '2020-09-27T01:30:08+0000', 'y': 12}, {'x': '2020-09-27T13:21:00+0000', 'y': 12}, {'x': '2020-09-28T01:30:19+0000', 'y': 12}, {'x': '2020-09-28T13:21:22+0000', 'y': 12}, {'x': '2020-09-29T01:30:51+0000', 'y': 12}, {'x': '2020-09-29T13:22:41+0000', 'y': 12}, {'x': '2020-09-30T01:30:08+0000', 'y': 12}, {'x': '2020-09-30T13:21:56+0000', 'y': 12}, {'x': '2020-10-01T01:32:16+0000', 'y': 12}, {'x': '2020-10-01T13:21:40+0000', 'y': 12}, {'x': '2020-10-01T14:57:45+0000', 'y': 2}, {'x': '2020-10-01T15:01:54+0000', 'y': 0}, {'x': '2020-10-02T01:31:15+0000', 'y': 10}, {'x': '2020-10-02T13:22:16+0000', 'y': 12}, {'x': '2020-10-03T01:31:35+0000', 'y': 12}, {'x': '2020-10-03T13:21:26+0000', 'y': 12}, {'x': '2020-10-04T01:33:50+0000', 'y': 12}, {'x': '2020-10-04T13:21:16+0000', 'y': 12}, {'x': '2020-10-05T01:33:58+0000', 'y': 12}, {'x': '2020-10-05T13:22:32+0000', 'y': 12}, {'x': '2020-10-06T01:33:27+0000', 'y': 12}, {'x': '2020-10-06T13:22:31+0000', 'y': 12}, {'x': '2020-10-07T01:34:15+0000', 'y': 12}, {'x': '2020-10-07T13:22:44+0000', 'y': 12}, {'x': '2020-10-08T01:23:40+0000', 'y': 12}, {'x': '2020-10-08T13:23:01+0000', 'y': 12}, {'x': '2020-10-09T01:35:26+0000', 'y': 12}, {'x': '2020-10-09T13:23:12+0000', 'y': 12}, {'x': '2020-10-10T01:35:50+0000', 'y': 12}, {'x': '2020-10-10T13:22:58+0000', 'y': 12}, {'x': '2020-10-11T01:38:27+0000', 'y': 12}, {'x': '2020-10-11T13:22:37+0000', 'y': 12}, {'x': '2020-10-12T01:38:23+0000', 'y': 12}, {'x': '2020-10-12T13:23:43+0000', 'y': 12}, {'x': '2020-10-13T01:38:48+0000', 'y': 12}, {'x': '2020-10-13T13:23:58+0000', 'y': 12}, {'x': '2020-10-14T01:38:47+0000', 'y': 12}, {'x': '2020-10-14T13:24:10+0000', 'y': 12}, {'x': '2020-10-15T01:39:55+0000', 'y': 12}, {'x': '2020-10-15T13:24:42+0000', 'y': 12}, {'x': '2020-10-16T01:40:48+0000', 'y': 12}, {'x': '2020-10-16T13:24:23+0000', 'y': 12}, {'x': '2020-10-17T01:41:21+0000', 'y': 12}, {'x': '2020-10-17T13:23:32+0000', 'y': 12}, {'x': '2020-10-18T01:42:53+0000', 'y': 12}, {'x': '2020-10-18T13:23:41+0000', 'y': 12}, {'x': '2020-10-19T01:43:10+0000', 'y': 12}, {'x': '2020-10-19T13:25:06+0000', 'y': 12}, {'x': '2020-10-20T01:43:11+0000', 'y': 12}, {'x': '2020-10-20T13:25:13+0000', 'y': 12}, {'x': '2020-10-21T01:42:06+0000', 'y': 12}, {'x': '2020-10-21T13:25:32+0000', 'y': 12}, {'x': '2020-10-22T01:44:53+0000', 'y': 12}, {'x': '2020-10-22T13:26:04+0000', 'y': 12}, {'x': '2020-10-23T01:45:59+0000', 'y': 12}, {'x': '2020-10-23T13:25:02+0000', 'y': 12}, {'x': '2020-10-24T01:45:25+0000', 'y': 12}, {'x': '2020-10-24T13:24:51+0000', 'y': 12}, {'x': '2020-10-25T01:48:48+0000', 'y': 12}, {'x': '2020-10-25T13:25:01+0000', 'y': 12}, {'x': '2020-10-26T01:49:27+0000', 'y': 12}, {'x': '2020-10-26T13:25:59+0000', 'y': 12}, {'x': '2020-10-27T01:49:58+0000', 'y': 12}, {'x': '2020-10-27T13:26:35+0000', 'y': 12}, {'x': '2020-10-28T01:52:01+0000', 'y': 12}, {'x': '2020-10-28T13:26:49+0000', 'y': 12}, {'x': '2020-10-29T01:54:23+0000', 'y': 12}, {'x': '2020-10-29T13:59:09+0000', 'y': 12}, {'x': '2020-10-30T13:21:11+0000', 'y': 23}, {'x': '2020-11-02T15:59:07+0000', 'y': 75}, {'x': '2020-11-02T16:05:51+0000', 'y': 0}, {'x': '2020-11-02T18:18:14+0000', 'y': 2}, {'x': '2020-11-03T05:18:16+0000', 'y': 11}, {'x': '2020-11-03T14:08:49+0000', 'y': 9}, {'x': '2020-11-03T18:18:17+0000', 'y': 4}, {'x': '2020-11-04T01:22:27+0000', 'y': 7}, {'x': '2020-11-04T05:18:23+0000', 'y': 4}, {'x': '2020-11-04T13:17:08+0000', 'y': 8}, {'x': '2020-11-04T18:19:13+0000', 'y': 5}, {'x': '2020-11-05T01:24:28+0000', 'y': 7}, {'x': '2020-11-05T05:18:16+0000', 'y': 4}, {'x': '2020-11-05T13:17:01+0000', 'y': 8}, {'x': '2020-11-05T18:19:05+0000', 'y': 5}, {'x': '2020-11-06T01:26:10+0000', 'y': 7}, {'x': '2020-11-06T05:18:15+0000', 'y': 4}, {'x': '2020-11-06T13:17:48+0000', 'y': 8}, {'x': '2020-11-06T18:21:32+0000', 'y': 5}, {'x': '2020-11-07T01:27:47+0000', 'y': 7}, {'x': '2020-11-07T05:18:19+0000', 'y': 4}, {'x': '2020-11-07T13:17:19+0000', 'y': 8}, {'x': '2020-11-07T18:18:44+0000', 'y': 5}, {'x': '2020-11-08T01:30:18+0000', 'y': 7}, {'x': '2020-11-08T05:18:15+0000', 'y': 4}, {'x': '2020-11-08T13:17:30+0000', 'y': 8}, {'x': '2020-11-08T18:18:52+0000', 'y': 5}, {'x': '2020-11-09T01:31:25+0000', 'y': 7}, {'x': '2020-11-09T05:18:18+0000', 'y': 4}, {'x': '2020-11-09T13:18:41+0000', 'y': 8}, {'x': '2020-11-09T18:19:51+0000', 'y': 5}, {'x': '2020-11-10T01:33:39+0000', 'y': 7}, {'x': '2020-11-10T05:18:16+0000', 'y': 4}, {'x': '2020-11-10T13:17:48+0000', 'y': 8}, {'x': '2020-11-10T18:19:32+0000', 'y': 5}, {'x': '2020-11-11T01:19:18+0000', 'y': 7}, {'x': '2020-11-11T05:18:16+0000', 'y': 4}, {'x': '2020-11-11T13:16:08+0000', 'y': 8}, {'x': '2020-11-11T18:19:42+0000', 'y': 5}, {'x': '2020-11-12T01:19:20+0000', 'y': 7}, {'x': '2020-11-12T05:18:16+0000', 'y': 4}, {'x': '2020-11-12T13:16:25+0000', 'y': 8}, {'x': '2020-11-12T18:18:34+0000', 'y': 5}, {'x': '2020-11-13T01:20:48+0000', 'y': 7}, {'x': '2020-11-13T05:18:15+0000', 'y': 4}, {'x': '2020-11-13T13:16:38+0000', 'y': 8}, {'x': '2020-11-13T18:19:57+0000', 'y': 5}, {'x': '2020-11-14T01:21:45+0000', 'y': 7}, {'x': '2020-11-14T05:18:15+0000', 'y': 4}, {'x': '2020-11-14T13:15:57+0000', 'y': 8}, {'x': '2020-11-14T18:19:40+0000', 'y': 5}, {'x': '2020-11-15T01:24:04+0000', 'y': 7}, {'x': '2020-11-15T05:18:15+0000', 'y': 4}, {'x': '2020-11-15T13:15:52+0000', 'y': 8}, {'x': '2020-11-15T18:18:37+0000', 'y': 5}, {'x': '2020-11-16T01:24:18+0000', 'y': 7}, {'x': '2020-11-16T05:18:16+0000', 'y': 4}, {'x': '2020-11-16T13:16:49+0000', 'y': 8}, {'x': '2020-11-16T18:18:36+0000', 'y': 5}, {'x': '2020-11-17T01:26:18+0000', 'y': 7}, {'x': '2020-11-17T05:18:15+0000', 'y': 4}, {'x': '2020-11-17T13:17:14+0000', 'y': 8}, {'x': '2020-11-17T18:21:00+0000', 'y': 5}, {'x': '2020-11-18T01:25:37+0000', 'y': 7}, {'x': '2020-11-18T05:18:18+0000', 'y': 4}, {'x': '2020-11-18T13:18:00+0000', 'y': 8}, {'x': '2020-11-18T18:19:11+0000', 'y': 5}, {'x': '2020-11-19T01:26:26+0000', 'y': 7}, {'x': '2020-11-19T05:18:19+0000', 'y': 4}, {'x': '2020-11-19T13:18:13+0000', 'y': 8}, {'x': '2020-11-19T18:18:57+0000', 'y': 5}, {'x': '2020-11-20T01:27:10+0000', 'y': 7}, {'x': '2020-11-20T05:18:19+0000', 'y': 4}, {'x': '2020-11-20T13:17:51+0000', 'y': 8}, {'x': '2020-11-20T18:19:08+0000', 'y': 5}, {'x': '2020-11-21T01:27:18+0000', 'y': 7}, {'x': '2020-11-21T05:18:18+0000', 'y': 4}, {'x': '2020-11-21T13:17:38+0000', 'y': 8}, {'x': '2020-11-21T18:20:04+0000', 'y': 5}, {'x': '2020-11-22T01:29:40+0000', 'y': 7}, {'x': '2020-11-22T05:18:39+0000', 'y': 4}, {'x': '2020-11-22T13:17:44+0000', 'y': 8}, {'x': '2020-11-22T18:18:50+0000', 'y': 5}, {'x': '2020-11-23T01:29:51+0000', 'y': 7}, {'x': '2020-11-23T05:18:17+0000', 'y': 4}, {'x': '2020-11-23T13:19:27+0000', 'y': 8}, {'x': '2020-11-23T18:18:29+0000', 'y': 5}, {'x': '2020-11-24T01:30:00+0000', 'y': 7}, {'x': '2020-11-24T05:18:18+0000', 'y': 4}, {'x': '2020-11-24T13:19:04+0000', 'y': 8}, {'x': '2020-11-24T18:20:21+0000', 'y': 5}, {'x': '2020-11-25T01:30:47+0000', 'y': 7}, {'x': '2020-11-25T05:18:21+0000', 'y': 4}, {'x': '2020-11-25T13:19:24+0000', 'y': 8}, {'x': '2020-11-26T01:31:03+0000', 'y': 12}, {'x': '2020-11-26T13:19:08+0000', 'y': 12}, {'x': '2020-11-27T01:34:03+0000', 'y': 12}, {'x': '2020-11-27T13:19:56+0000', 'y': 12}, {'x': '2020-11-28T01:33:48+0000', 'y': 12}, {'x': '2020-11-28T13:19:09+0000', 'y': 12}, {'x': '2020-11-29T01:37:34+0000', 'y': 12}, {'x': '2020-11-29T13:19:40+0000', 'y': 12}, {'x': '2020-11-30T01:38:19+0000', 'y': 12}, {'x': '2020-11-30T13:21:19+0000', 'y': 12}, {'x': '2020-12-01T01:39:25+0000', 'y': 12}, {'x': '2020-12-01T13:21:31+0000', 'y': 12}, {'x': '2020-12-02T01:39:00+0000', 'y': 12}, {'x': '2020-12-02T13:22:20+0000', 'y': 12}, {'x': '2020-12-03T01:38:55+0000', 'y': 12}, {'x': '2020-12-03T13:21:45+0000', 'y': 12}, {'x': '2020-12-04T01:41:53+0000', 'y': 12}, {'x': '2020-12-04T13:22:39+0000', 'y': 12}, {'x': '2020-12-05T01:42:04+0000', 'y': 12}, {'x': '2020-12-05T13:22:25+0000', 'y': 12}, {'x': '2020-12-06T01:44:27+0000', 'y': 12}, {'x': '2020-12-06T13:22:30+0000', 'y': 12}, {'x': '2020-12-07T01:44:49+0000', 'y': 12}, {'x': '2020-12-07T13:23:57+0000', 'y': 12}, {'x': '2020-12-08T01:45:24+0000', 'y': 12}, {'x': '2020-12-08T13:24:09+0000', 'y': 12}, {'x': '2020-12-09T01:46:31+0000', 'y': 12}, {'x': '2020-12-09T13:24:18+0000', 'y': 12}, {'x': '2020-12-10T01:49:41+0000', 'y': 12}, {'x': '2020-12-10T13:24:26+0000', 'y': 12}, {'x': '2020-12-11T01:49:27+0000', 'y': 12}, {'x': '2020-12-11T13:24:42+0000', 'y': 12}, {'x': '2020-12-12T01:49:40+0000', 'y': 12}, {'x': '2020-12-12T13:23:46+0000', 'y': 12}, {'x': '2020-12-13T01:52:49+0000', 'y': 12}, {'x': '2020-12-13T13:24:21+0000', 'y': 12}, {'x': '2020-12-14T01:53:12+0000', 'y': 12}, {'x': '2020-12-14T13:25:54+0000', 'y': 12}, {'x': '2020-12-15T01:52:18+0000', 'y': 12}, {'x': '2020-12-15T13:25:55+0000', 'y': 12}, {'x': '2020-12-16T01:54:42+0000', 'y': 12}, {'x': '2020-12-16T13:26:08+0000', 'y': 12}, {'x': '2020-12-17T14:30:09+0000', 'y': 25}, {'x': '2020-12-17T18:18:33+0000', 'y': 4}, {'x': '2020-12-18T05:18:33+0000', 'y': 11}, {'x': '2020-12-18T18:19:02+0000', 'y': 13}, {'x': '2020-12-19T05:18:32+0000', 'y': 11}, {'x': '2020-12-19T18:18:54+0000', 'y': 13}, {'x': '2020-12-20T05:18:33+0000', 'y': 11}, {'x': '2020-12-20T18:18:41+0000', 'y': 13}, {'x': '2020-12-21T05:18:32+0000', 'y': 11},
    {'x': '2020-12-21T18:18:58+0000', 'y': 13}, {'x': '2020-12-22T05:18:32+0000', 'y': 11}, {'x': '2020-12-22T18:19:03+0000', 'y': 13}, {'x': '2020-12-23T05:18:35+0000', 'y': 11}, {'x': '2020-12-23T18:19:00+0000', 'y': 13}, {'x': '2020-12-24T05:18:31+0000', 'y': 11}, {'x': '2020-12-24T18:19:44+0000', 'y': 13}, {'x': '2020-12-25T05:18:31+0000', 'y': 11}, {'x': '2020-12-25T18:19:00+0000', 'y': 13}, {'x': '2020-12-26T05:18:32+0000', 'y': 11}, {'x': '2020-12-26T18:18:50+0000', 'y': 13}, {'x': '2020-12-27T05:18:33+0000', 'y': 11}, {'x': '2020-12-27T18:18:42+0000', 'y': 13}, {'x': '2020-12-28T05:18:55+0000', 'y': 11}, {'x': '2020-12-28T18:18:42+0000', 'y': 13}, {'x': '2020-12-29T05:18:32+0000', 'y': 11}, {'x': '2020-12-29T18:19:01+0000', 'y': 13}, {'x': '2020-12-30T05:18:35+0000', 'y': 11}, {'x': '2020-12-30T18:19:04+0000', 'y': 13}, {'x': '2020-12-31T05:18:33+0000', 'y': 11}, {'x': '2020-12-31T18:19:09+0000', 'y': 13}, {'x': '2021-01-01T05:20:36+0000', 'y': 11}, {'x': '2021-01-01T18:19:26+0000', 'y': 13}, {'x': '2021-01-02T05:18:41+0000', 'y': 11}, {'x': '2021-01-02T18:19:03+0000', 'y': 13}, {'x': '2021-01-03T05:18:38+0000', 'y': 11}, {'x': '2021-01-03T18:19:09+0000', 'y': 13}, {'x': '2021-01-04T05:18:49+0000', 'y': 11}, {'x': '2021-01-04T18:19:33+0000', 'y': 13}, {'x': '2021-01-05T05:18:37+0000', 'y': 11}, {'x': '2021-01-05T18:19:52+0000', 'y': 13}, {'x': '2021-01-06T05:18:41+0000', 'y': 11}, {'x': '2021-01-06T18:19:43+0000', 'y': 13}, {'x': '2021-01-07T05:18:37+0000', 'y': 11}, {'x': '2021-01-07T18:20:04+0000', 'y': 13}, {'x': '2021-01-08T05:18:59+0000', 'y': 11}, {'x': '2021-01-08T18:20:03+0000', 'y': 13}, {'x': '2021-01-09T05:18:38+0000', 'y': 11}, {'x': '2021-01-09T18:20:12+0000', 'y': 13}, {'x': '2021-01-10T05:18:41+0000', 'y': 11}, {'x': '2021-01-10T18:18:49+0000', 'y': 13}, {'x': '2021-01-11T05:18:40+0000', 'y': 11}, {'x': '2021-01-11T18:18:58+0000', 'y': 13}, {'x': '2021-01-12T05:18:38+0000', 'y': 11}, {'x': '2021-01-12T18:19:35+0000', 'y': 13}, {'x': '2021-01-13T05:18:43+0000', 'y': 11}, {'x': '2021-01-13T18:20:39+0000', 'y': 13}, {'x': '2021-01-14T05:18:46+0000', 'y': 11}, {'x': '2021-01-14T18:19:51+0000', 'y': 13}, {'x': '2021-01-15T05:18:43+0000', 'y': 11}, {'x': '2021-01-15T18:19:24+0000', 'y': 13}, {'x': '2021-01-16T05:21:36+0000', 'y': 11}, {'x': '2021-01-16T18:19:45+0000', 'y': 13}, {'x': '2021-01-17T05:19:15+0000', 'y': 11}, {'x': '2021-01-17T18:19:08+0000', 'y': 13}, {'x': '2021-01-18T05:18:44+0000', 'y': 11}, {'x': '2021-01-18T18:19:52+0000', 'y': 13}, {'x': '2021-01-19T05:18:45+0000', 'y': 11}, {'x': '2021-01-19T18:20:03+0000', 'y': 13}, {'x': '2021-01-20T05:18:36+0000', 'y': 11}, {'x': '2021-01-20T18:20:13+0000', 'y': 13}, {'x': '2021-01-21T05:18:38+0000', 'y': 11}, {'x': '2021-01-21T18:19:53+0000', 'y': 13}, {'x': '2021-01-22T05:18:37+0000', 'y': 11}, {'x': '2021-01-22T18:19:35+0000', 'y': 13}, {'x': '2021-01-23T05:18:39+0000', 'y': 11}, {'x': '2021-01-23T18:19:08+0000', 'y': 13}, {'x': '2021-01-24T05:18:40+0000', 'y': 11}, {'x': '2021-01-24T18:18:58+0000', 'y': 13}, {'x': '2021-01-25T05:18:37+0000', 'y': 11}, {'x': '2021-01-25T18:18:38+0000', 'y': 13}, {'x': '2021-01-26T05:18:59+0000', 'y': 11}, {'x': '2021-01-26T18:20:04+0000', 'y': 13}, {'x': '2021-01-27T05:18:37+0000', 'y': 11}, {'x': '2021-01-27T18:20:56+0000', 'y': 13}, {'x': '2021-01-28T05:18:40+0000', 'y': 11}, {'x': '2021-01-28T18:19:43+0000', 'y': 13}, {'x': '2021-01-29T05:18:41+0000', 'y': 11}, {'x': '2021-01-29T18:19:41+0000', 'y': 13}, {'x': '2021-01-30T02:05:37+0000', 'y': 8}, {'x': '2021-01-30T05:18:38+0000', 'y': 3}, {'x': '2021-01-30T13:33:53+0000', 'y': 8}, {'x': '2021-01-30T18:19:45+0000', 'y': 5}, {'x': '2021-01-31T02:09:08+0000', 'y': 8}, {'x': '2021-01-31T13:34:04+0000', 'y': 11}, {'x': '2021-02-01T02:09:32+0000', 'y': 13}, {'x': '2021-02-01T13:36:21+0000', 'y': 11}, {'x': '2021-02-02T02:05:52+0000', 'y': 12}, {'x': '2021-02-02T13:36:35+0000', 'y': 12}, {'x': '2021-02-03T01:57:42+0000', 'y': 12}, {'x': '2021-02-03T13:31:42+0000', 'y': 12}, {'x': '2021-02-04T01:48:21+0000', 'y': 12}, {'x': '2021-02-04T13:24:15+0000', 'y': 12}, {'x': '2021-02-05T01:48:51+0000', 'y': 12}, {'x': '2021-02-05T13:24:21+0000', 'y': 12}, {'x': '2021-02-06T01:47:15+0000', 'y': 12}, {'x': '2021-02-06T13:23:36+0000', 'y': 12}, {'x': '2021-02-07T01:49:44+0000', 'y': 12}, {'x': '2021-02-07T13:23:51+0000', 'y': 12}, {'x': '2021-02-08T01:49:14+0000', 'y': 12}, {'x': '2021-02-08T13:24:43+0000', 'y': 12}, {'x': '2021-02-09T01:48:30+0000', 'y': 12}, {'x': '2021-02-09T13:24:24+0000', 'y': 12}, {'x': '2021-02-10T01:47:43+0000', 'y': 12}, {'x': '2021-02-10T13:24:32+0000', 'y': 12}, {'x': '2021-02-11T01:48:53+0000', 'y': 12}, {'x': '2021-02-11T13:24:59+0000', 'y': 12}, {'x': '2021-02-12T01:49:23+0000', 'y': 12}, {'x': '2021-02-12T13:24:54+0000', 'y': 12}, {'x': '2021-02-13T01:48:23+0000', 'y': 12}, {'x': '2021-02-13T13:24:08+0000', 'y': 12}, {'x': '2021-02-14T01:50:13+0000', 'y': 12}, {'x': '2021-02-14T13:24:21+0000', 'y': 12}, {'x': '2021-02-15T01:50:28+0000', 'y': 12}, {'x': '2021-02-15T13:26:04+0000', 'y': 12}, {'x': '2021-02-16T01:49:42+0000', 'y': 12}, {'x': '2021-02-16T13:25:09+0000', 'y': 12}, {'x': '2021-02-17T01:48:48+0000', 'y': 12}, {'x': '2021-02-17T13:25:45+0000', 'y': 12}, {'x': '2021-02-18T01:50:04+0000', 'y': 12}, {'x': '2021-02-18T13:25:41+0000', 'y': 12}, {'x': '2021-02-19T01:50:32+0000', 'y': 12}, {'x': '2021-02-19T13:25:34+0000', 'y': 12}, {'x': '2021-02-20T01:49:38+0000', 'y': 12}, {'x': '2021-02-20T13:24:50+0000', 'y': 12}, {'x': '2021-02-21T01:51:21+0000', 'y': 12}, {'x': '2021-02-21T13:24:39+0000', 'y': 12}, {'x': '2021-02-22T01:52:25+0000', 'y': 12}, {'x': '2021-02-22T13:21:41+0000', 'y': 11}, {'x': '2021-02-23T01:51:47+0000', 'y': 13}, {'x': '2021-02-23T13:30:54+0000', 'y': 12}, {'x': '2021-02-24T01:52:44+0000', 'y': 12}, {'x': '2021-02-24T13:31:25+0000', 'y': 12}, {'x': '2021-02-25T01:53:00+0000', 'y': 12}, {'x': '2021-02-25T13:25:54+0000', 'y': 12}, {'x': '2021-02-26T01:53:10+0000', 'y': 12}, {'x': '2021-02-26T13:25:59+0000', 'y': 12}, {'x': '2021-02-27T01:52:07+0000', 'y': 12}, {'x': '2021-02-27T13:25:23+0000', 'y': 12}, {'x': '2021-02-28T01:54:11+0000', 'y': 12}, {'x': '2021-02-28T13:25:28+0000', 'y': 12}, {'x': '2021-03-01T01:55:56+0000', 'y': 13}, {'x': '2021-03-01T13:26:49+0000', 'y': 12}, {'x': '2021-03-02T01:36:30+0000', 'y': 12}, {'x': '2021-03-02T13:21:58+0000', 'y': 12}, {'x': '2021-03-03T01:53:47+0000', 'y': 13}, {'x': '2021-03-03T13:26:43+0000', 'y': 12}, {'x': '2021-03-04T01:59:51+0000', 'y': 13}, {'x': '2021-03-04T13:32:33+0000', 'y': 12}, {'x': '2021-03-05T01:58:40+0000', 'y': 12}, {'x': '2021-03-05T13:32:27+0000', 'y': 12}, {'x': '2021-03-06T01:54:08+0000', 'y': 12}, {'x': '2021-03-06T13:26:32+0000', 'y': 12}, {'x': '2021-03-07T01:57:02+0000', 'y': 13}, {'x': '2021-03-07T13:31:06+0000', 'y': 12}, {'x': '2021-03-08T02:01:15+0000', 'y': 13}, {'x': '2021-03-08T13:32:01+0000', 'y': 12}, {'x': '2021-03-09T01:55:58+0000', 'y': 12}, {'x': '2021-03-09T13:37:09+0000', 'y': 12}, {'x': '2021-03-10T01:56:41+0000', 'y': 12}, {'x': '2021-03-10T13:28:13+0000', 'y': 12}, {'x': '2021-03-11T01:56:53+0000', 'y': 12}, {'x': '2021-03-11T13:33:26+0000', 'y': 12}, {'x': '2021-03-12T01:57:57+0000', 'y': 12}, {'x': '2021-03-12T13:33:24+0000', 'y': 12}, {'x': '2021-03-13T01:57:23+0000', 'y': 12}, {'x': '2021-03-13T13:27:33+0000', 'y': 12}, {'x': '2021-03-14T01:59:07+0000', 'y': 13}, {'x': '2021-03-14T13:27:25+0000', 'y': 11}, {'x': '2021-03-15T02:00:53+0000', 'y': 13}, {'x': '2021-03-15T13:32:08+0000', 'y': 12}, {'x': '2021-03-16T01:56:49+0000', 'y': 12}, {'x': '2021-03-16T13:32:16+0000', 'y': 12}, {'x': '2021-03-17T01:58:13+0000', 'y': 12}, {'x': '2021-03-17T13:33:09+0000', 'y': 12}, {'x': '2021-03-18T01:58:16+0000', 'y': 12}, {'x': '2021-03-18T13:33:07+0000', 'y': 12}, {'x': '2021-03-19T01:59:49+0000', 'y': 12}, {'x': '2021-03-19T13:32:36+0000', 'y': 12}, {'x': '2021-03-20T01:58:22+0000', 'y': 12}, {'x': '2021-03-20T13:27:54+0000', 'y': 11}, {'x': '2021-03-21T02:02:45+0000', 'y': 13}, {'x': '2021-03-21T13:29:11+0000', 'y': 11}, {'x': '2021-03-22T02:02:12+0000', 'y': 13}, {'x': '2021-03-22T13:30:49+0000', 'y': 11}, {'x': '2021-03-23T02:00:51+0000', 'y': 13}, {'x': '2021-03-23T13:37:30+0000', 'y': 12}, {'x': '2021-03-24T02:02:46+0000', 'y': 12}, {'x': '2021-03-24T13:22:49+0000', 'y': 11}, {'x': '2021-03-25T01:28:35+0000', 'y': 12}, {'x': '2021-03-25T13:34:25+0000', 'y': 12}, {'x': '2021-03-26T01:52:06+0000', 'y': 12}, {'x': '2021-03-26T13:34:43+0000', 'y': 12}, {'x': '2021-03-27T02:11:11+0000', 'y': 13}, {'x': '2021-03-27T13:33:53+0000', 'y': 11}, {'x': '2021-03-28T02:09:25+0000', 'y': 13}, {'x': '2021-03-28T13:33:55+0000', 'y': 11}, {'x': '2021-03-29T02:12:34+0000', 'y': 13}, {'x': '2021-03-29T13:35:00+0000', 'y': 11}, {'x': '2021-03-30T02:10:05+0000', 'y': 13}, {'x': '2021-03-30T13:36:33+0000', 'y': 11}, {'x': '2021-03-31T02:09:51+0000', 'y': 13}, {'x': '2021-03-31T13:34:59+0000', 'y': 11}, {'x': '2021-04-01T02:17:23+0000', 'y': 13}, {'x': '2021-04-01T13:36:30+0000', 'y': 11}, {'x': '2021-04-02T02:20:21+0000', 'y': 13}, {'x': '2021-04-02T13:36:18+0000', 'y': 11}, {'x': '2021-04-03T02:12:31+0000', 'y': 13}, {'x': '2021-04-03T13:32:50+0000', 'y': 11}, {'x': '2021-04-04T02:15:20+0000', 'y': 13}, {'x': '2021-04-04T13:33:33+0000', 'y': 11}, {'x': '2021-04-05T02:14:16+0000', 'y': 13}, {'x': '2021-04-05T13:35:41+0000', 'y': 11}, {'x': '2021-04-06T02:15:33+0000', 'y': 13}, {'x': '2021-04-06T13:36:29+0000', 'y': 11}, {'x': '2021-04-07T02:16:29+0000', 'y': 13}, {'x': '2021-04-07T13:35:02+0000', 'y': 11}, {'x': '2021-04-08T02:16:53+0000', 'y': 13}, {'x': '2021-04-08T13:34:34+0000', 'y': 11}, {'x': '2021-04-09T02:11:32+0000', 'y': 13}, {'x': '2021-04-09T13:33:50+0000', 'y': 11}, {'x': '2021-04-10T02:10:31+0000', 'y': 13}, {'x': '2021-04-10T13:32:12+0000', 'y': 11}, {'x': '2021-04-11T02:14:56+0000', 'y': 13}, {'x': '2021-04-11T13:32:21+0000', 'y': 11}, {'x': '2021-04-12T02:15:37+0000', 'y': 13}, {'x': '2021-04-12T13:35:59+0000', 'y': 11}, {'x': '2021-04-13T02:14:19+0000', 'y': 13}, {'x': '2021-04-13T13:34:15+0000', 'y': 11}, {'x': '2021-04-14T02:09:51+0000', 'y': 13}, {'x': '2021-04-14T13:32:43+0000', 'y': 11}, {'x': '2021-04-15T02:10:19+0000', 'y': 13}, {'x': '2021-04-15T13:32:58+0000', 'y': 11}, {'x': '2021-04-16T02:13:08+0000', 'y': 13}, {'x': '2021-04-16T13:34:13+0000', 'y': 11}, {'x': '2021-04-17T02:09:09+0000', 'y': 13}, {'x': '2021-04-17T13:31:19+0000', 'y': 11}, {'x': '2021-04-18T02:14:25+0000', 'y': 13}, {'x': '2021-04-18T13:32:20+0000', 'y': 11}, {'x': '2021-04-19T02:12:53+0000', 'y': 13}, {'x': '2021-04-19T13:34:08+0000', 'y': 11}, {'x': '2021-04-20T02:11:39+0000', 'y': 13}, {'x': '2021-04-20T13:34:50+0000', 'y': 11}, {'x': '2021-04-21T02:12:34+0000', 'y': 13}, {'x': '2021-04-21T13:34:48+0000', 'y': 11}, {'x': '2021-04-22T02:12:54+0000', 'y': 13}, {'x': '2021-04-22T13:35:05+0000', 'y': 11}, {'x': '2021-04-23T02:18:56+0000', 'y': 13}, {'x': '2021-04-23T13:34:44+0000', 'y': 11}, {'x': '2021-04-24T02:14:58+0000', 'y': 13}, {'x': '2021-04-24T13:34:26+0000', 'y': 11}, {'x': '2021-04-25T02:19:54+0000', 'y': 13}, {'x': '2021-04-25T13:33:30+0000', 'y': 11}, {'x': '2021-04-26T02:19:43+0000', 'y': 13}, {'x': '2021-04-26T13:35:50+0000', 'y': 11}, {'x': '2021-04-27T02:13:27+0000', 'y': 13}, {'x': '2021-04-27T13:34:41+0000', 'y': 11}, {'x': '2021-04-28T02:14:38+0000', 'y': 13}, {'x': '2021-04-28T13:35:03+0000', 'y': 11}, {'x': '2021-04-29T02:13:01+0000', 'y': 13}, {'x': '2021-04-29T13:35:03+0000', 'y': 11}, {'x': '2021-04-29T15:24:24+0000', 'y': 2}, {'x': '2021-04-30T02:15:18+0000', 'y': 11}, {'x': '2021-04-30T13:33:39+0000', 'y': 11}, {'x': '2021-05-01T02:19:14+0000', 'y': 13}, {'x': '2021-05-01T13:33:25+0000', 'y': 11}, {'x': '2021-05-02T02:23:14+0000', 'y': 13}, {'x': '2021-05-02T13:33:33+0000', 'y': 11}, {'x': '2021-05-03T02:19:16+0000', 'y': 13}, {'x': '2021-05-03T13:35:19+0000', 'y': 11}, {'x': '2021-05-04T02:17:09+0000', 'y': 13}, {'x': '2021-05-04T13:32:36+0000', 'y': 11}, {'x': '2021-05-05T02:11:17+0000', 'y': 13}, {'x': '2021-05-05T13:35:01+0000', 'y': 11}, {'x': '2021-05-06T02:11:47+0000', 'y': 13}, {'x': '2021-05-06T13:34:09+0000', 'y': 11}, {'x': '2021-05-07T02:15:48+0000', 'y': 13}, {'x': '2021-05-07T13:33:40+0000', 'y': 11}, {'x': '2021-05-08T02:14:06+0000', 'y': 13}, {'x': '2021-05-08T13:32:50+0000', 'y': 11}, {'x': '2021-05-09T02:15:59+0000', 'y': 13}, {'x': '2021-05-09T13:32:05+0000', 'y': 11}, {'x': '2021-05-10T02:20:30+0000', 'y': 13}, {'x': '2021-05-10T13:34:03+0000', 'y': 11}, {'x': '2021-05-11T02:17:41+0000', 'y': 13}, {'x': '2021-05-11T13:34:50+0000', 'y': 11}, {'x': '2021-05-12T02:18:41+0000', 'y': 13}, {'x': '2021-05-12T13:37:44+0000', 'y': 11}, {'x': '2021-05-13T02:25:08+0000', 'y': 13}, {'x': '2021-05-13T13:37:19+0000', 'y': 11}, {'x': '2021-05-14T02:25:27+0000', 'y': 13}, {'x': '2021-05-15T02:22:24+0000', 'y': 24}, {'x': '2021-05-15T13:35:30+0000', 'y': 11}, {'x': '2021-05-16T02:31:15+0000', 'y': 13}, {'x': '2021-05-16T13:36:00+0000', 'y': 11}, {'x': '2021-05-17T02:26:57+0000', 'y': 13}, {'x': '2021-05-17T13:38:54+0000', 'y': 11}, {'x': '2021-05-18T02:27:20+0000', 'y': 13}, {'x': '2021-05-19T02:21:03+0000', 'y': 24}, {'x': '2021-05-19T13:38:10+0000', 'y': 11}, {'x': '2021-05-20T02:21:39+0000', 'y': 13}, {'x': '2021-05-20T13:38:34+0000', 'y': 11}, {'x': '2021-05-21T02:24:15+0000', 'y': 13}, {'x': '2021-05-21T13:40:10+0000', 'y': 11}, {'x': '2021-05-22T02:24:54+0000', 'y': 13}, {'x': '2021-05-22T13:37:17+0000', 'y': 11}, {'x': '2021-05-23T02:35:08+0000', 'y': 13}, {'x': '2021-05-23T13:38:25+0000', 'y': 11}, {'x': '2021-05-24T02:33:27+0000', 'y': 13}, {'x': '2021-05-24T13:43:45+0000', 'y': 11}, {'x': '2021-05-25T02:38:37+0000', 'y': 13}, {'x': '2021-05-25T13:49:09+0000', 'y': 11}, {'x': '2021-05-26T03:00:42+0000', 'y': 13}, {'x': '2021-05-26T13:57:19+0000', 'y': 11}, {'x': '2021-05-27T03:18:42+0000', 'y': 13}, {'x': '2021-05-27T14:02:02+0000', 'y': 11}, {'x': '2021-05-28T03:41:09+0000', 'y': 14}, {'x': '2021-05-28T14:08:02+0000', 'y': 10}, {'x': '2021-05-29T04:05:30+0000', 'y': 14}, {'x': '2021-05-29T14:19:00+0000', 'y': 10}, {'x': '2021-05-30T04:16:28+0000', 'y': 14}, {'x': '2021-05-30T14:17:27+0000', 'y': 10}, {'x': '2021-05-31T04:23:38+0000', 'y': 14}, {'x': '2021-05-31T14:22:18+0000', 'y': 10}, {'x': '2021-06-01T04:46:22+0000', 'y': 14}, {'x': '2021-06-01T14:36:51+0000', 'y': 10}, {'x': '2021-06-02T04:43:47+0000', 'y': 14}, {'x': '2021-06-02T14:43:20+0000', 'y': 10}, {'x': '2021-06-03T04:19:34+0000', 'y': 14}, {'x': '2021-06-03T14:14:22+0000', 'y': 10}, {'x': '2021-06-04T03:27:15+0000', 'y': 13}, {'x': '2021-06-04T14:33:31+0000', 'y': 11}, {'x': '2021-06-05T03:14:13+0000', 'y': 13}, {'x': '2021-06-05T14:13:46+0000', 'y': 11}, {'x': '2021-06-06T03:06:25+0000', 'y': 13}, {'x': '2021-06-06T14:14:56+0000', 'y': 11}, {'x': '2021-06-07T03:19:52+0000', 'y': 13}, {'x': '2021-06-07T14:33:52+0000', 'y': 11}, {'x': '2021-06-08T02:54:16+0000', 'y': 12}, {'x': '2021-06-08T13:41:33+0000', 'y': 11}, {'x': '2021-06-09T02:27:24+0000', 'y': 13}, {'x': '2021-06-09T13:13:32+0000', 'y': 11}, {'x': '2021-06-09T13:32:26+0000', 'y': 0}, {'x': '2021-06-09T13:44:23+0000', 'y': 0}, {'x': '2021-06-09T14:39:13+0000', 'y': 1}, {'x': '2021-06-10T02:24:52+0000', 'y': 12}, {'x': '2021-06-10T13:42:39+0000', 'y': 11}, {'x': '2021-06-11T02:15:15+0000', 'y': 13}, {'x': '2021-06-11T13:35:03+0000', 'y': 11}, {'x': '2021-06-12T02:03:58+0000', 'y': 12}, {'x': '2021-06-12T13:32:44+0000', 'y': 11}, {'x': '2021-06-13T02:10:29+0000', 'y': 13}, {'x': '2021-06-13T13:34:23+0000', 'y': 11}, {'x': '2021-06-14T02:11:27+0000', 'y': 13}, {'x': '2021-06-14T13:35:14+0000', 'y': 11}, {'x': '2021-06-15T02:16:22+0000', 'y': 13}, {'x': '2021-06-15T13:34:15+0000', 'y': 11}, {'x': '2021-06-16T02:11:25+0000', 'y': 13}, {'x': '2021-06-16T13:35:23+0000', 'y': 11}, {'x': '2021-06-17T02:06:56+0000', 'y': 13}, {'x': '2021-06-17T13:36:59+0000', 'y': 12}, {'x': '2021-06-18T02:14:22+0000', 'y': 13}, {'x': '2021-06-18T13:38:12+0000', 'y': 11}, {'x': '2021-06-19T02:13:09+0000', 'y': 13}, {'x': '2021-06-19T13:33:12+0000', 'y': 11}, {'x': '2021-06-20T02:16:35+0000', 'y': 13}, {'x': '2021-06-20T13:33:08+0000', 'y': 11}, {'x': '2021-06-21T02:15:46+0000', 'y': 13}, {'x': '2021-06-21T13:38:19+0000', 'y': 11}, {'x': '2021-06-22T02:06:21+0000', 'y': 12}, {'x': '2021-06-22T13:33:32+0000', 'y': 11}, {'x': '2021-06-23T01:58:35+0000', 'y': 12}, {'x': '2021-06-23T13:29:47+0000', 'y': 12}, {'x': '2021-06-24T01:55:07+0000', 'y': 12}, {'x': '2021-06-24T13:32:29+0000', 'y': 12}, {'x': '2021-06-25T02:06:58+0000', 'y': 13}, {'x': '2021-06-25T13:29:02+0000', 'y': 11}, {'x': '2021-06-26T01:59:34+0000', 'y': 13}, {'x': '2021-06-26T13:26:49+0000', 'y': 11}, {'x': '2021-06-27T02:08:19+0000', 'y': 13}, {'x': '2021-06-27T13:26:56+0000', 'y': 11}, {'x': '2021-06-28T02:05:02+0000', 'y': 13}, {'x': '2021-06-28T13:33:47+0000', 'y': 11}, {'x': '2021-06-29T02:03:31+0000', 'y': 12}, {'x': '2021-06-29T13:29:11+0000', 'y': 11}, {'x': '2021-06-30T02:07:30+0000', 'y': 13}, {'x': '2021-06-30T13:34:09+0000', 'y': 11}, {'x': '2021-07-01T02:06:36+0000', 'y': 13}, {'x': '2021-07-01T13:34:33+0000', 'y': 11}, {'x': '2021-07-01T15:05:55+0000', 'y': 2}, {'x': '2021-07-02T02:05:34+0000', 'y': 11}, {'x': '2021-07-02T13:26:52+0000', 'y': 11}, {'x': '2021-07-03T01:58:37+0000', 'y': 13}, {'x': '2021-07-03T13:25:37+0000', 'y': 11}, {'x': '2021-07-04T02:02:05+0000', 'y': 13}, {'x': '2021-07-04T13:25:05+0000', 'y': 11}, {'x': '2021-07-05T02:03:04+0000', 'y': 13}, {'x': '2021-07-05T13:32:18+0000', 'y': 11}, {'x': '2021-07-06T02:05:24+0000', 'y': 13}, {'x': '2021-07-06T13:31:11+0000', 'y': 11}, {'x': '2021-07-07T02:04:31+0000', 'y': 13}, {'x': '2021-07-07T13:35:38+0000', 'y': 12}, {'x': '2021-07-08T02:05:28+0000', 'y': 12}, {'x': '2021-07-08T13:36:57+0000', 'y': 12}, {'x': '2021-07-09T02:05:10+0000', 'y': 12}, {'x': '2021-07-09T13:27:47+0000', 'y': 11}, {'x': '2021-07-10T02:00:26+0000', 'y': 13}, {'x': '2021-07-10T13:25:22+0000', 'y': 11}, {'x': '2021-07-11T02:06:20+0000', 'y': 13}, {'x': '2021-07-11T13:25:49+0000', 'y': 11}, {'x': '2021-07-12T02:03:19+0000', 'y': 13}, {'x': '2021-07-12T13:33:41+0000', 'y': 12}, {'x': '2021-07-13T02:05:19+0000', 'y': 13}, {'x': '2021-07-13T13:30:05+0000', 'y': 11}, {'x': '2021-07-14T02:02:00+0000', 'y': 13}, {'x': '2021-07-14T13:30:44+0000', 'y': 11}, {'x': '2021-07-15T02:05:12+0000', 'y': 13}, {'x': '2021-07-15T13:29:44+0000', 'y': 11}, {'x': '2021-07-16T02:07:18+0000', 'y': 13}, {'x': '2021-07-16T13:28:48+0000', 'y': 11}, {'x': '2021-07-17T02:01:23+0000', 'y': 13}, {'x': '2021-07-17T13:25:27+0000', 'y': 11}, {'x': '2021-07-18T02:04:26+0000', 'y': 13}, {'x': '2021-07-18T13:25:27+0000', 'y': 11}, {'x': '2021-07-19T02:05:42+0000', 'y': 13}, {'x': '2021-07-19T13:34:38+0000', 'y': 11}, {'x': '2021-07-20T02:10:23+0000', 'y': 13}, {'x': '2021-07-20T13:31:49+0000', 'y': 11}, {'x': '2021-07-21T02:07:11+0000', 'y': 13}, {'x': '2021-07-21T13:32:42+0000', 'y': 11}, {'x': '2021-07-22T02:08:44+0000', 'y': 13}, {'x': '2021-07-22T13:28:27+0000', 'y': 11}, {'x': '2021-07-23T02:06:24+0000', 'y': 13}, {'x': '2021-07-23T13:27:31+0000', 'y': 11}, {'x': '2021-07-24T02:02:39+0000', 'y': 13}, {'x': '2021-07-24T13:25:39+0000', 'y': 11}, {'x': '2021-07-25T02:04:03+0000', 'y': 13}, {'x': '2021-07-25T13:25:39+0000', 'y': 11}, {'x': '2021-07-26T02:07:15+0000', 'y': 13}, {'x': '2021-07-26T13:33:36+0000', 'y': 11}, {'x': '2021-07-27T02:10:03+0000', 'y': 13}, {'x': '2021-07-27T13:27:56+0000', 'y': 11}, {'x': '2021-07-28T02:08:25+0000', 'y': 13}, {'x': '2021-07-28T13:35:45+0000', 'y': 11}, {'x': '2021-07-29T02:07:06+0000', 'y': 13}, {'x': '2021-07-29T13:33:47+0000', 'y': 11}, {'x': '2021-07-30T02:10:31+0000', 'y': 13}, {'x': '2021-07-30T13:28:59+0000', 'y': 11}, {'x': '2021-07-31T02:03:09+0000', 'y': 13}, {'x': '2021-07-31T13:26:09+0000', 'y': 11}, {'x': '2021-08-01T02:09:59+0000', 'y': 13}, {'x': '2021-08-01T13:25:48+0000', 'y': 11}, {'x': '2021-08-02T02:04:31+0000', 'y': 13}, {'x': '2021-08-02T13:33:13+0000', 'y': 11}, {'x': '2021-08-03T02:11:44+0000', 'y': 13}, {'x': '2021-08-03T13:29:55+0000', 'y': 11}, {'x': '2021-08-04T02:05:28+0000', 'y': 13}, {'x': '2021-08-04T13:33:55+0000', 'y': 11}, {'x': '2021-08-05T02:03:10+0000', 'y': 12}, {'x': '2021-08-05T13:35:31+0000', 'y': 12}, {'x': '2021-08-06T02:03:30+0000', 'y': 12}, {'x': '2021-08-06T13:36:43+0000', 'y': 12}, {'x': '2021-08-07T01:59:14+0000', 'y': 12}, {'x': '2021-08-07T13:26:31+0000', 'y': 11}, {'x': '2021-08-08T02:02:40+0000', 'y': 13}, {'x': '2021-08-08T13:25:45+0000', 'y': 11}, {'x': '2021-08-09T02:03:40+0000', 'y': 13}, {'x': '2021-08-09T13:32:56+0000', 'y': 11}, {'x': '2021-08-10T02:06:09+0000', 'y': 13}, {'x': '2021-08-10T13:33:50+0000', 'y': 11}, {'x': '2021-08-11T02:01:37+0000', 'y': 12}, {'x': '2021-08-11T13:33:28+0000', 'y': 12}, {'x': '2021-08-12T02:02:40+0000', 'y': 12}, {'x': '2021-08-12T13:33:40+0000', 'y': 12}, {'x': '2021-08-13T02:02:50+0000', 'y': 12}, {'x': '2021-08-13T13:31:43+0000', 'y': 11}, {'x': '2021-08-14T13:25:22+0000', 'y': 24}, {'x': '2021-08-15T02:01:14+0000', 'y': 13}, {'x': '2021-08-15T13:26:13+0000', 'y': 11}, {'x': '2021-08-16T02:01:31+0000', 'y': 13}, {'x': '2021-08-16T13:58:44+0000', 'y': 12}, {'x': '2021-08-17T02:00:55+0000', 'y': 12}, {'x': '2021-08-17T13:32:54+0000', 'y': 12}, {'x': '2021-08-18T02:01:11+0000', 'y': 12}, {'x': '2021-08-18T13:32:41+0000', 'y': 12}, {'x': '2021-08-19T01:55:17+0000', 'y': 12}, {'x': '2021-08-19T13:32:44+0000', 'y': 12}, {'x': '2021-08-20T01:59:58+0000', 'y': 12}, {'x': '2021-08-20T13:32:21+0000', 'y': 12}, {'x': '2021-08-21T01:59:46+0000', 'y': 12}, {'x': '2021-08-21T13:26:02+0000', 'y': 11}, {'x': '2021-08-22T02:00:57+0000', 'y': 13}, {'x': '2021-08-22T13:27:04+0000', 'y': 11}, {'x': '2021-08-23T01:56:06+0000', 'y': 12}, {'x': '2021-08-23T13:32:41+0000', 'y': 12}, {'x': '2021-08-24T01:58:23+0000', 'y': 12}, {'x': '2021-08-24T13:31:51+0000', 'y': 12}, {'x': '2021-08-25T02:01:06+0000', 'y': 12}, {'x': '2021-08-25T13:28:22+0000', 'y': 11}, {'x': '2021-08-26T01:58:20+0000', 'y': 12}, {'x': '2021-08-26T13:32:59+0000', 'y': 12}, {'x': '2021-08-27T02:03:58+0000', 'y': 13}, {'x': '2021-08-27T13:31:43+0000', 'y': 11}, {'x': '2021-08-28T01:57:34+0000', 'y': 12}, {'x': '2021-08-28T13:25:20+0000', 'y': 11}, {'x': '2021-08-29T02:03:02+0000', 'y': 13}, {'x': '2021-08-29T13:25:30+0000', 'y': 11}, {'x': '2021-08-30T02:01:01+0000', 'y': 13}, {'x': '2021-08-30T13:32:50+0000', 'y': 12}, {'x': '2021-08-31T02:01:32+0000', 'y': 12}, {'x': '2021-08-31T13:29:00+0000', 'y': 11}, {'x': '2021-09-01T02:06:36+0000', 'y': 13}, {'x': '2021-09-01T13:32:37+0000', 'y': 11}, {'x': '2021-09-02T02:01:01+0000', 'y': 12}, {'x': '2021-09-02T13:31:53+0000', 'y': 12}, {'x': '2021-09-03T02:02:27+0000', 'y': 13}, {'x': '2021-09-03T13:33:17+0000', 'y': 12}, {'x': '2021-09-04T02:02:59+0000', 'y': 12}, {'x': '2021-09-04T13:26:26+0000', 'y': 11}, {'x': '2021-09-05T02:03:40+0000', 'y': 13}, {'x': '2021-09-05T13:26:37+0000', 'y': 11}, {'x': '2021-09-06T02:06:25+0000', 'y': 13}, {'x': '2021-09-06T13:30:18+0000', 'y': 11}, {'x': '2021-09-07T02:00:48+0000', 'y': 13}, {'x': '2021-09-07T13:27:49+0000', 'y': 11}, {'x': '2021-09-08T02:01:36+0000', 'y': 13}, {'x': '2021-09-08T13:28:23+0000', 'y': 11}, {'x': '2021-09-09T02:04:35+0000', 'y': 13}, {'x': '2021-09-09T13:29:47+0000', 'y': 11}, {'x': '2021-09-09T14:03:50+0000', 'y': 1}, {'x': '2021-09-10T02:05:00+0000', 'y': 12}, {'x': '2021-09-10T13:29:14+0000', 'y': 11}, {'x': '2021-09-11T02:00:37+0000', 'y': 13}, {'x': '2021-09-11T13:26:30+0000', 'y': 11}, {'x': '2021-09-12T02:05:06+0000', 'y': 13}, {'x': '2021-09-12T13:26:49+0000', 'y': 11}, {'x': '2021-09-13T02:04:49+0000', 'y': 13}, {'x': '2021-09-13T13:31:49+0000', 'y': 11}, {'x': '2021-09-14T02:03:39+0000', 'y': 13}, {'x': '2021-09-14T13:29:03+0000', 'y': 11}, {'x': '2021-09-15T02:03:07+0000', 'y': 13}, {'x': '2021-09-15T13:28:15+0000', 'y': 11}, {'x': '2021-09-16T02:08:43+0000', 'y': 13}, {'x': '2021-09-16T13:29:45+0000', 'y': 11}, {'x': '2021-09-17T02:09:09+0000', 'y': 13}, {'x': '2021-09-17T13:27:57+0000', 'y': 11}, {'x': '2021-09-18T02:06:12+0000', 'y': 13}, {'x': '2021-09-18T13:26:56+0000', 'y': 11}, {'x': '2021-09-19T02:05:34+0000', 'y': 13}, {'x': '2021-09-19T13:26:14+0000', 'y': 11}, {'x': '2021-09-20T02:05:42+0000', 'y': 13}, {'x': '2021-09-20T13:29:39+0000', 'y': 11}, {'x': '2021-09-21T02:06:19+0000', 'y': 13}, {'x': '2021-09-21T13:29:15+0000', 'y': 11}, {'x': '2021-09-22T02:06:17+0000', 'y': 13}, {'x': '2021-09-22T13:28:51+0000', 'y': 11}, {'x': '2021-09-23T02:08:44+0000', 'y': 13}, {'x': '2021-09-23T13:31:16+0000', 'y': 11}, {'x': '2021-09-24T02:04:12+0000', 'y': 13}, {'x': '2021-09-24T13:27:00+0000', 'y': 11}, {'x': '2021-09-25T02:03:14+0000', 'y': 13}, {'x': '2021-09-25T13:26:14+0000', 'y': 11}, {'x': '2021-09-26T02:04:23+0000', 'y': 13}, {'x': '2021-09-26T13:26:49+0000', 'y': 11}, {'x': '2021-09-27T02:05:46+0000', 'y': 13}, {'x': '2021-09-27T13:29:09+0000', 'y': 11}, {'x': '2021-09-28T02:05:53+0000', 'y': 13}, {'x': '2021-09-28T13:28:53+0000', 'y': 11}, {'x': '2021-09-29T01:59:19+0000', 'y': 13}, {'x': '2021-09-29T13:28:29+0000', 'y': 11}, {'x': '2021-09-30T02:10:20+0000', 'y': 13}, {'x': '2021-09-30T13:28:47+0000', 'y': 11}, {'x': '2021-10-01T02:11:31+0000', 'y': 13}, {'x': '2021-10-01T13:28:50+0000', 'y': 11}, {'x': '2021-10-02T02:03:39+0000', 'y': 13}, {'x': '2021-10-02T13:26:16+0000', 'y': 11}, {'x': '2021-10-03T02:06:50+0000', 'y': 13}, {'x': '2021-10-03T13:26:05+0000', 'y': 11}, {'x': '2021-10-04T02:10:45+0000', 'y': 13}, {'x': '2021-10-04T13:28:26+0000', 'y': 11}, {'x': '2021-10-05T02:05:42+0000', 'y': 13}, {'x': '2021-10-05T13:28:50+0000', 'y': 11}, {'x': '2021-10-06T02:05:56+0000', 'y': 13}, {'x': '2021-10-06T13:43:11+0000', 'y': 12}, {'x': '2021-10-07T02:10:11+0000', 'y': 12}, {'x': '2021-10-07T13:31:55+0000', 'y': 11}, {'x': '2021-10-08T02:09:59+0000', 'y': 13}, {'x': '2021-10-08T13:27:48+0000', 'y': 11}, {'x': '2021-10-09T02:01:02+0000', 'y': 13}, {'x': '2021-10-09T13:26:36+0000', 'y': 11}, {'x': '2021-10-10T02:04:59+0000', 'y': 13}, {'x': '2021-10-10T13:26:27+0000', 'y': 11}, {'x': '2021-10-11T02:08:52+0000', 'y': 13}, {'x': '2021-10-11T13:28:46+0000', 'y': 11}, {'x': '2021-10-12T02:08:22+0000', 'y': 13}, {'x': '2021-10-12T13:32:55+0000', 'y': 11}, {'x': '2021-10-13T02:09:42+0000', 'y': 13}, {'x': '2021-10-13T13:32:49+0000', 'y': 11}, {'x': '2021-10-14T02:06:59+0000', 'y': 13}, {'x': '2021-10-14T13:28:38+0000', 'y': 11}, {'x': '2021-10-15T02:06:58+0000', 'y': 13}, {'x': '2021-10-15T13:28:28+0000', 'y': 11}, {'x': '2021-10-16T02:10:02+0000', 'y': 13}, {'x': '2021-10-16T13:26:23+0000', 'y': 11}, {'x': '2021-10-17T02:05:01+0000', 'y': 13}, {'x': '2021-10-17T13:26:42+0000', 'y': 11}, {'x': '2021-10-18T02:13:15+0000', 'y': 13}, {'x': '2021-10-18T13:32:23+0000', 'y': 11}, {'x': '2021-10-19T02:07:38+0000', 'y': 13}, {'x': '2021-10-19T13:28:54+0000', 'y': 11}, {'x': '2021-10-20T02:08:48+0000', 'y': 13}, {'x': '2021-10-20T13:34:18+0000', 'y': 11}, {'x': '2021-10-21T02:13:35+0000', 'y': 13}, {'x': '2021-10-21T13:34:07+0000', 'y': 11}, {'x': '2021-10-22T02:15:24+0000', 'y': 13}, {'x': '2021-10-22T13:29:09+0000', 'y': 11}, {'x': '2021-10-23T02:08:02+0000', 'y': 13}, {'x': '2021-10-23T13:27:01+0000', 'y': 11}, {'x': '2021-10-24T02:06:28+0000', 'y': 13}, {'x': '2021-10-24T13:27:03+0000', 'y': 11}, {'x': '2021-10-25T02:06:58+0000', 'y': 13}, {'x': '2021-10-25T13:30:12+0000', 'y': 11}, {'x': '2021-10-26T02:02:26+0000', 'y': 13}, {'x': '2021-10-26T13:33:14+0000', 'y': 12}, {'x': '2021-10-27T02:02:53+0000', 'y': 12}, {'x': '2021-10-27T13:31:52+0000', 'y': 11},
    {'x': '2021-10-28T02:02:58+0000', 'y': 13}, {'x': '2021-10-28T13:34:09+0000', 'y': 12}, {'x': '2021-10-29T02:02:53+0000', 'y': 12}, {'x': '2021-10-29T13:33:41+0000', 'y': 12}, {'x': '2021-10-30T02:01:42+0000', 'y': 12}, {'x': '2021-10-30T13:27:04+0000', 'y': 11}, {'x': '2021-10-31T02:05:36+0000', 'y': 13}, {'x': '2021-10-31T13:27:49+0000', 'y': 11}, {'x': '2021-11-01T02:06:11+0000', 'y': 13}, {'x': '2021-11-01T13:29:53+0000', 'y': 11}, {'x': '2021-11-02T02:06:38+0000', 'y': 13}, {'x': '2021-11-02T13:34:34+0000', 'y': 11}, {'x': '2021-11-03T02:03:31+0000', 'y': 12}, {'x': '2021-11-03T13:33:21+0000', 'y': 11}, {'x': '2021-11-04T02:06:19+0000', 'y': 13}, {'x': '2021-11-04T13:34:08+0000', 'y': 11}, {'x': '2021-11-05T02:04:57+0000', 'y': 13}, {'x': '2021-11-05T13:28:45+0000', 'y': 11}, {'x': '2021-11-06T02:00:35+0000', 'y': 13}, {'x': '2021-11-06T13:28:07+0000', 'y': 11}, {'x': '2021-11-07T02:06:17+0000', 'y': 13}, {'x': '2021-11-07T13:27:27+0000', 'y': 11}, {'x': '2021-11-08T02:03:54+0000', 'y': 13}, {'x': '2021-11-08T13:33:44+0000', 'y': 11}, {'x': '2021-11-09T02:03:36+0000', 'y': 12}, {'x': '2021-11-09T13:34:49+0000', 'y': 12}, {'x': '2021-11-10T02:03:30+0000', 'y': 12}, {'x': '2021-11-10T13:33:33+0000', 'y': 12}, {'x': '2021-11-11T02:04:16+0000', 'y': 13}, {'x': '2021-11-11T13:27:42+0000', 'y': 11}, {'x': '2021-11-12T02:04:49+0000', 'y': 13}, {'x': '2021-11-12T13:29:17+0000', 'y': 11}, {'x': '2021-11-13T02:01:50+0000', 'y': 13}, {'x': '2021-11-13T13:27:03+0000', 'y': 11}, {'x': '2021-11-14T02:04:29+0000', 'y': 13}, {'x': '2021-11-14T13:28:18+0000', 'y': 11}, {'x': '2021-11-15T02:03:31+0000', 'y': 13}, {'x': '2021-11-15T13:31:30+0000', 'y': 11}, {'x': '2021-11-16T02:03:35+0000', 'y': 13}, {'x': '2021-11-16T13:29:04+0000', 'y': 11}, {'x': '2021-11-17T02:04:00+0000', 'y': 13}, {'x': '2021-11-17T13:29:18+0000', 'y': 11}, {'x': '2021-11-18T02:04:30+0000', 'y': 13}, {'x': '2021-11-18T13:29:28+0000', 'y': 11}, {'x': '2021-11-19T02:05:01+0000', 'y': 13}, {'x': '2021-11-19T13:31:32+0000', 'y': 11}, {'x': '2021-11-20T02:01:54+0000', 'y': 13}, {'x': '2021-11-20T13:27:34+0000', 'y': 11}, {'x': '2021-11-21T02:05:14+0000', 'y': 13}, {'x': '2021-11-21T13:27:39+0000', 'y': 11}, {'x': '2021-11-22T02:04:30+0000', 'y': 13}, {'x': '2021-11-22T13:34:25+0000', 'y': 11}, {'x': '2021-11-23T02:03:14+0000', 'y': 12}, {'x': '2021-11-23T13:29:16+0000', 'y': 11}, {'x': '2021-11-24T02:03:39+0000', 'y': 13}, {'x': '2021-11-24T13:29:14+0000', 'y': 11}, {'x': '2021-11-25T02:04:40+0000', 'y': 13}, {'x': '2021-11-25T13:29:38+0000', 'y': 11}, {'x': '2021-11-26T02:02:04+0000', 'y': 13}, {'x': '2021-11-26T13:29:01+0000', 'y': 11}, {'x': '2021-11-27T02:01:20+0000', 'y': 13}, {'x': '2021-11-27T13:27:30+0000', 'y': 11}, {'x': '2021-11-28T02:00:15+0000', 'y': 13}, {'x': '2021-11-28T13:27:42+0000', 'y': 11}, {'x': '2021-11-29T02:04:11+0000', 'y': 13}, {'x': '2021-11-29T13:31:36+0000', 'y': 11}, {'x': '2021-11-30T01:54:53+0000', 'y': 12}, {'x': '2021-11-30T13:20:48+0000', 'y': 11}, {'x': '2021-12-01T02:10:01+0000', 'y': 13}, {'x': '2021-12-01T13:30:41+0000', 'y': 11}, {'x': '2021-12-02T02:04:41+0000', 'y': 13}, {'x': '2021-12-02T13:29:24+0000', 'y': 11}, {'x': '2021-12-03T02:04:10+0000', 'y': 13}, {'x': '2021-12-03T13:32:52+0000', 'y': 11}, {'x': '2021-12-04T02:04:43+0000', 'y': 13}, {'x': '2021-12-04T13:31:13+0000', 'y': 11}, {'x': '2021-12-05T02:11:04+0000', 'y': 13}, {'x': '2021-12-05T13:28:12+0000', 'y': 11}, {'x': '2021-12-06T02:07:18+0000', 'y': 13}, {'x': '2021-12-06T13:31:31+0000', 'y': 11}, {'x': '2021-12-07T02:11:03+0000', 'y': 13}, {'x': '2021-12-07T13:34:05+0000', 'y': 11}, {'x': '2021-12-08T02:08:08+0000', 'y': 13}, {'x': '2021-12-08T13:32:09+0000', 'y': 11}, {'x': '2021-12-09T02:07:30+0000', 'y': 13}, {'x': '2021-12-09T13:31:05+0000', 'y': 11}, {'x': '2021-12-10T02:02:42+0000', 'y': 13}, {'x': '2021-12-10T13:29:51+0000', 'y': 11}, {'x': '2021-12-11T02:04:19+0000', 'y': 13}, {'x': '2021-12-11T13:28:25+0000', 'y': 11}, {'x': '2021-12-12T02:09:00+0000', 'y': 13}, {'x': '2021-12-12T13:28:06+0000', 'y': 11}, {'x': '2021-12-13T02:07:06+0000', 'y': 13}, {'x': '2021-12-13T13:30:56+0000', 'y': 11}, {'x': '2021-12-14T02:09:18+0000', 'y': 13}, {'x': '2021-12-14T13:29:39+0000', 'y': 11}, {'x': '2021-12-15T02:06:43+0000', 'y': 13}, {'x': '2021-12-15T13:30:13+0000', 'y': 11}, {'x': '2021-12-16T02:05:52+0000', 'y': 13}, {'x': '2021-12-16T13:31:06+0000', 'y': 11}, {'x': '2021-12-17T02:09:50+0000', 'y': 13}, {'x': '2021-12-17T13:28:25+0000', 'y': 11}, {'x': '2021-12-18T02:10:49+0000', 'y': 13}, {'x': '2021-12-18T13:29:49+0000', 'y': 11}, {'x': '2021-12-19T02:13:54+0000', 'y': 13}, {'x': '2021-12-19T13:29:31+0000', 'y': 11}, {'x': '2021-12-20T02:11:00+0000', 'y': 13}, {'x': '2021-12-20T13:32:17+0000', 'y': 11}, {'x': '2021-12-21T02:11:28+0000', 'y': 13}, {'x': '2021-12-21T13:31:47+0000', 'y': 11}, {'x': '2021-12-22T02:11:47+0000', 'y': 13}, {'x': '2021-12-22T13:31:53+0000', 'y': 11}, {'x': '2021-12-23T02:10:34+0000', 'y': 13}, {'x': '2021-12-23T13:32:19+0000', 'y': 11}, {'x': '2021-12-24T02:08:07+0000', 'y': 13}, {'x': '2021-12-24T13:31:14+0000', 'y': 11}, {'x': '2021-12-25T02:07:27+0000', 'y': 13}, {'x': '2021-12-25T13:29:13+0000', 'y': 11}, {'x': '2021-12-26T02:12:52+0000', 'y': 13}, {'x': '2021-12-26T13:30:10+0000', 'y': 11}, {'x': '2021-12-27T02:20:02+0000', 'y': 13}, {'x': '2021-12-27T13:35:59+0000', 'y': 11}, {'x': '2021-12-28T02:09:06+0000', 'y': 13}, {'x': '2021-12-28T13:31:11+0000', 'y': 11}, {'x': '2021-12-29T02:08:48+0000', 'y': 13}, {'x': '2021-12-29T13:31:33+0000', 'y': 11}, {'x': '2021-12-30T02:09:22+0000', 'y': 13}, {'x': '2021-12-30T13:30:59+0000', 'y': 11}, {'x': '2021-12-31T02:10:47+0000', 'y': 13}, {'x': '2021-12-31T13:31:31+0000', 'y': 11}, {'x': '2022-01-01T02:14:05+0000', 'y': 13}, {'x': '2022-01-01T13:29:25+0000', 'y': 11}, {'x': '2022-01-02T02:13:39+0000', 'y': 13}, {'x': '2022-01-02T13:29:40+0000', 'y': 11}, {'x': '2022-01-03T02:10:28+0000', 'y': 13}, {'x': '2022-01-03T13:32:38+0000', 'y': 11}, {'x': '2022-01-04T02:11:35+0000', 'y': 13}, {'x': '2022-01-04T13:31:37+0000', 'y': 11}, {'x': '2022-01-05T02:13:51+0000', 'y': 13}, {'x': '2022-01-05T13:32:24+0000', 'y': 11}, {'x': '2022-01-06T02:18:14+0000', 'y': 13}, {'x': '2022-01-06T13:32:50+0000', 'y': 11}, {'x': '2022-01-07T02:17:00+0000', 'y': 13}, {'x': '2022-01-07T13:32:55+0000', 'y': 11}, {'x': '2022-01-08T02:10:47+0000', 'y': 13}, {'x': '2022-01-08T13:30:39+0000', 'y': 11}, {'x': '2022-01-09T02:14:48+0000', 'y': 13}, {'x': '2022-01-09T13:30:36+0000', 'y': 11}, {'x': '2022-01-10T02:12:01+0000', 'y': 13}, {'x': '2022-01-10T13:33:18+0000', 'y': 11}, {'x': '2022-01-11T02:13:02+0000', 'y': 13}, {'x': '2022-01-11T13:32:54+0000', 'y': 11}, {'x': '2022-01-12T13:33:38+0000', 'y': 24}, {'x': '2022-01-13T02:15:08+0000', 'y': 13}, {'x': '2022-01-13T13:32:59+0000', 'y': 11}, {'x': '2022-01-14T02:13:33+0000', 'y': 13}, {'x': '2022-01-14T13:32:59+0000', 'y': 11}, {'x': '2022-01-15T02:11:21+0000', 'y': 13}, {'x': '2022-01-15T13:31:47+0000', 'y': 11}, {'x': '2022-01-16T02:16:25+0000', 'y': 13}, {'x': '2022-01-16T13:30:45+0000', 'y': 11}, {'x': '2022-01-17T02:14:16+0000', 'y': 13}, {'x': '2022-01-17T13:33:51+0000', 'y': 11}, {'x': '2022-01-18T02:13:52+0000', 'y': 13}, {'x': '2022-01-18T13:37:52+0000', 'y': 11}, {'x': '2022-01-19T02:00:57+0000', 'y': 12}, {'x': '2022-01-19T13:26:33+0000', 'y': 11}, {'x': '2022-01-20T02:16:41+0000', 'y': 13}, {'x': '2022-01-20T13:26:54+0000', 'y': 11}, {'x': '2022-01-21T02:04:47+0000', 'y': 13}, {'x': '2022-01-21T13:26:01+0000', 'y': 11}, {'x': '2022-01-22T01:59:38+0000', 'y': 13}, {'x': '2022-01-22T13:23:53+0000', 'y': 11}, {'x': '2022-01-23T02:01:59+0000', 'y': 13}, {'x': '2022-01-23T13:25:01+0000', 'y': 11}, {'x': '2022-01-24T02:09:00+0000', 'y': 13}, {'x': '2022-01-24T13:27:53+0000', 'y': 11}, {'x': '2022-01-25T02:09:44+0000', 'y': 13}, {'x': '2022-01-25T13:28:10+0000', 'y': 11}, {'x': '2022-01-26T02:10:01+0000', 'y': 13}, {'x': '2022-01-26T13:31:40+0000', 'y': 11}, {'x': '2022-01-27T02:04:00+0000', 'y': 13}, {'x': '2022-01-27T13:31:18+0000', 'y': 11}, {'x': '2022-01-28T02:04:08+0000', 'y': 13}, {'x': '2022-01-28T13:25:30+0000', 'y': 11}, {'x': '2022-01-29T01:58:03+0000', 'y': 13}, {'x': '2022-01-29T13:23:39+0000', 'y': 11}, {'x': '2022-01-30T02:02:02+0000', 'y': 13}, {'x': '2022-01-30T13:23:23+0000', 'y': 11}, {'x': '2022-01-31T02:01:00+0000', 'y': 13}, {'x': '2022-01-31T13:28:13+0000', 'y': 11}, {'x': '2022-02-01T02:06:18+0000', 'y': 13}, {'x': '2022-02-01T13:26:09+0000', 'y': 11}, {'x': '2022-02-02T02:03:32+0000', 'y': 13}, {'x': '2022-02-02T13:26:12+0000', 'y': 11}, {'x': '2022-02-03T02:00:24+0000', 'y': 13}, {'x': '2022-02-03T13:26:31+0000', 'y': 11}, {'x': '2022-02-04T01:53:39+0000', 'y': 12}, {'x': '2022-02-04T13:20:11+0000', 'y': 11}, {'x': '2022-02-05T01:44:17+0000', 'y': 12}, {'x': '2022-02-05T13:19:53+0000', 'y': 12}, {'x': '2022-02-06T02:16:16+0000', 'y': 13}, {'x': '2022-02-06T13:24:03+0000', 'y': 11}, {'x': '2022-02-07T02:03:09+0000', 'y': 13}, {'x': '2022-02-07T13:34:10+0000', 'y': 12}, {'x': '2022-02-08T02:04:42+0000', 'y': 13}, {'x': '2022-02-08T13:32:16+0000', 'y': 11}, {'x': '2022-02-09T02:09:15+0000', 'y': 13}, {'x': '2022-02-09T13:31:11+0000', 'y': 11}, {'x': '2022-02-10T02:03:13+0000', 'y': 13}, {'x': '2022-02-10T13:26:36+0000', 'y': 11}, {'x': '2022-02-11T02:05:56+0000', 'y': 13}, {'x': '2022-02-11T13:25:10+0000', 'y': 11}, {'x': '2022-02-12T02:08:55+0000', 'y': 13}, {'x': '2022-02-12T13:23:40+0000', 'y': 11}, {'x': '2022-02-13T02:06:57+0000', 'y': 13}, {'x': '2022-02-13T13:23:49+0000', 'y': 11}, {'x': '2022-02-14T02:00:55+0000', 'y': 13}, {'x': '2022-02-14T13:26:23+0000', 'y': 11}, {'x': '2022-02-15T13:30:58+0000', 'y': 24}, {'x': '2022-02-16T02:11:18+0000', 'y': 13}, {'x': '2022-02-16T13:27:28+0000', 'y': 11}, {'x': '2022-02-17T01:58:46+0000', 'y': 13}, {'x': '2022-02-17T13:28:07+0000', 'y': 11}, {'x': '2022-02-18T02:09:23+0000', 'y': 13}, {'x': '2022-02-18T13:26:29+0000', 'y': 11}, {'x': '2022-02-19T02:04:40+0000', 'y': 13}, {'x': '2022-02-19T13:24:27+0000', 'y': 11}, {'x': '2022-02-20T02:08:48+0000', 'y': 13}, {'x': '2022-02-20T13:24:37+0000', 'y': 11}, {'x': '2022-02-21T02:04:23+0000', 'y': 13}, {'x': '2022-02-21T13:28:15+0000', 'y': 11}, {'x': '2022-02-22T02:04:41+0000', 'y': 13}, {'x': '2022-02-22T13:27:11+0000', 'y': 11}, {'x': '2022-02-23T02:11:59+0000', 'y': 13}, {'x': '2022-02-23T13:32:02+0000', 'y': 11}, {'x': '2022-02-24T02:12:15+0000', 'y': 13}, {'x': '2022-02-24T13:27:32+0000', 'y': 11}, {'x': '2022-02-25T02:11:40+0000', 'y': 13}, {'x': '2022-02-25T13:27:02+0000', 'y': 11}, {'x': '2022-02-26T02:02:58+0000', 'y': 13}, {'x': '2022-02-26T13:25:31+0000', 'y': 11}, {'x': '2022-02-27T02:09:28+0000', 'y': 13}, {'x': '2022-02-27T13:26:05+0000', 'y': 11}, {'x': '2022-02-28T02:10:55+0000', 'y': 13}, {'x': '2022-02-28T13:27:51+0000', 'y': 11}, {'x': '2022-03-01T02:22:19+0000', 'y': 13}, {'x': '2022-03-01T13:28:22+0000', 'y': 11}, {'x': '2022-03-02T02:17:52+0000', 'y': 13}, {'x': '2022-03-02T13:27:50+0000', 'y': 11}, {'x': '2022-03-03T02:20:05+0000', 'y': 13}, {'x': '2022-03-03T13:28:59+0000', 'y': 11}, {'x': '2022-03-04T02:22:26+0000', 'y': 13}, {'x': '2022-03-04T13:27:57+0000', 'y': 11}, {'x': '2022-03-05T02:12:40+0000', 'y': 13}, {'x': '2022-03-05T13:26:47+0000', 'y': 11}, {'x': '2022-03-06T02:12:54+0000', 'y': 13}, {'x': '2022-03-06T13:26:54+0000', 'y': 11}, {'x': '2022-03-07T02:16:24+0000', 'y': 13}, {'x': '2022-03-07T13:29:21+0000', 'y': 11}, {'x': '2022-03-08T02:14:13+0000', 'y': 13}, {'x': '2022-03-08T13:34:01+0000', 'y': 11}, {'x': '2022-03-09T02:19:25+0000', 'y': 13}, {'x': '2022-03-09T13:33:10+0000', 'y': 11}, {'x': '2022-03-10T02:25:52+0000', 'y': 13}, {'x': '2022-03-10T13:33:40+0000', 'y': 11}, {'x': '2022-03-11T02:20:35+0000', 'y': 13}, {'x': '2022-03-11T13:29:15+0000', 'y': 11}, {'x': '2022-03-12T02:07:16+0000', 'y': 13}, {'x': '2022-03-12T13:26:43+0000', 'y': 11}, {'x': '2022-03-13T02:10:09+0000', 'y': 13}, {'x': '2022-03-13T13:26:55+0000', 'y': 11}, {'x': '2022-03-14T02:17:26+0000', 'y': 13}, {'x': '2022-03-14T13:33:53+0000', 'y': 11}, {'x': '2022-03-15T02:20:35+0000', 'y': 13}, {'x': '2022-03-15T13:29:41+0000', 'y': 11}, {'x': '2022-03-16T02:26:01+0000', 'y': 13}, {'x': '2022-03-16T13:33:37+0000', 'y': 11}, {'x': '2022-03-17T02:20:59+0000', 'y': 13}, {'x': '2022-03-17T13:34:05+0000', 'y': 11}, {'x': '2022-03-18T02:25:49+0000', 'y': 13}, {'x': '2022-03-18T13:29:32+0000', 'y': 11}, {'x': '2022-03-19T02:16:10+0000', 'y': 13}, {'x': '2022-03-19T13:27:56+0000', 'y': 11}, {'x': '2022-03-20T02:17:52+0000', 'y': 13}, {'x': '2022-03-20T13:27:49+0000', 'y': 11}, {'x': '2022-03-21T02:36:56+0000', 'y': 13}, {'x': '2022-03-21T13:35:33+0000', 'y': 11}, {'x': '2022-03-22T02:36:23+0000', 'y': 13}, {'x': '2022-03-22T13:35:54+0000', 'y': 11}, {'x': '2022-03-23T02:39:51+0000', 'y': 13}, {'x': '2022-03-23T13:36:54+0000', 'y': 11}, {'x': '2022-03-24T02:33:21+0000', 'y': 13}, {'x': '2022-03-24T13:34:56+0000', 'y': 11}, {'x': '2022-03-25T02:24:57+0000', 'y': 13}, {'x': '2022-03-25T13:52:22+0000', 'y': 11}, {'x': '2022-03-26T02:26:14+0000', 'y': 13}, {'x': '2022-03-26T13:28:16+0000', 'y': 11}, {'x': '2022-03-27T02:26:17+0000', 'y': 13}, {'x': '2022-03-27T13:27:49+0000', 'y': 11}, {'x': '2022-03-28T02:43:07+0000', 'y': 13}, {'x': '2022-03-28T13:36:53+0000', 'y': 11}, {'x': '2022-03-29T02:43:41+0000', 'y': 13}, {'x': '2022-03-29T13:39:08+0000', 'y': 11}, {'x': '2022-03-30T02:41:16+0000', 'y': 13}, {'x': '2022-03-30T13:38:54+0000', 'y': 11}, {'x': '2022-03-31T02:38:43+0000', 'y': 13}, {'x': '2022-03-31T13:39:42+0000', 'y': 11}, {'x': '2022-04-01T02:59:49+0000', 'y': 13}, {'x': '2022-04-01T13:40:19+0000', 'y': 11}, {'x': '2022-04-02T02:37:50+0000', 'y': 13}, {'x': '2022-04-02T13:29:29+0000', 'y': 11}, {'x': '2022-04-03T02:37:40+0000', 'y': 13}, {'x': '2022-04-03T13:29:12+0000', 'y': 11}, {'x': '2022-04-04T02:48:53+0000', 'y': 13}, {'x': '2022-04-04T13:39:25+0000', 'y': 11}, {'x': '2022-04-05T02:38:43+0000', 'y': 13}, {'x': '2022-04-05T13:34:27+0000', 'y': 11}, {'x': '2022-04-06T02:39:26+0000', 'y': 13}, {'x': '2022-04-06T13:37:57+0000', 'y': 11}, {'x': '2022-04-06T17:48:29+0000', 'y': 4}, {'x': '2022-04-07T02:37:59+0000', 'y': 9}, {'x': '2022-04-07T13:35:35+0000', 'y': 11}, {'x': '2022-04-08T02:47:01+0000', 'y': 13}, {'x': '2022-04-08T13:41:52+0000', 'y': 11}, {'x': '2022-04-09T02:28:08+0000', 'y': 13}, {'x': '2022-04-09T13:29:34+0000', 'y': 11}, {'x': '2022-04-10T02:39:54+0000', 'y': 13}, {'x': '2022-04-10T13:29:46+0000', 'y': 11}, {'x': '2022-04-11T02:53:20+0000', 'y': 13}, {'x': '2022-04-11T13:35:50+0000', 'y': 11}, {'x': '2022-04-12T02:45:19+0000', 'y': 13}, {'x': '2022-04-12T13:36:40+0000', 'y': 11}, {'x': '2022-04-13T02:48:21+0000', 'y': 13}, {'x': '2022-04-13T13:34:30+0000', 'y': 11}, {'x': '2022-04-14T02:49:30+0000', 'y': 13}, {'x': '2022-04-14T13:37:22+0000', 'y': 11}, {'x': '2022-04-15T03:07:41+0000', 'y': 14}, {'x': '2022-04-15T13:33:15+0000', 'y': 10}, {'x': '2022-04-16T02:35:29+0000', 'y': 13}, {'x': '2022-04-16T13:31:59+0000', 'y': 11}, {'x': '2022-04-17T02:41:01+0000', 'y': 13}, {'x': '2022-04-17T13:30:51+0000', 'y': 11}, {'x': '2022-04-18T02:58:48+0000', 'y': 13}, {'x': '2022-04-18T13:36:04+0000', 'y': 11}, {'x': '2022-04-19T03:04:25+0000', 'y': 13}, {'x': '2022-04-19T13:44:15+0000', 'y': 11}, {'x': '2022-04-20T03:15:08+0000', 'y': 14}, {'x': '2022-04-20T13:41:36+0000', 'y': 10}, {'x': '2022-04-21T03:06:22+0000', 'y': 13}, {'x': '2022-04-21T13:38:19+0000', 'y': 11}, {'x': '2022-04-22T03:19:54+0000', 'y': 14}, {'x': '2022-04-22T13:44:43+0000', 'y': 10}, {'x': '2022-04-23T02:41:51+0000', 'y': 13}, {'x': '2022-04-23T13:31:10+0000', 'y': 11}, {'x': '2022-04-24T02:38:08+0000', 'y': 13}, {'x': '2022-04-24T13:32:13+0000', 'y': 11}, {'x': '2022-04-25T02:58:02+0000', 'y': 13}, {'x': '2022-04-25T13:49:57+0000', 'y': 11}, {'x': '2022-04-26T03:08:14+0000', 'y': 13}, {'x': '2022-04-26T13:44:11+0000', 'y': 11}, {'x': '2022-04-27T03:17:54+0000', 'y': 14}, {'x': '2022-04-27T13:42:24+0000', 'y': 10}, {'x': '2022-04-28T03:43:56+0000', 'y': 14}, {'x': '2022-04-28T13:44:30+0000', 'y': 10}, {'x': '2022-04-29T03:09:19+0000', 'y': 13}, {'x': '2022-04-29T13:50:55+0000', 'y': 11}, {'x': '2022-04-30T02:59:30+0000', 'y': 13}, {'x': '2022-04-30T13:32:21+0000', 'y': 11}, {'x': '2022-05-01T03:18:59+0000', 'y': 14}, {'x': '2022-05-01T13:33:46+0000', 'y': 10}, {'x': '2022-05-02T03:31:27+0000', 'y': 14}, {'x': '2022-05-02T13:45:17+0000', 'y': 10}, {'x': '2022-05-03T03:06:09+0000', 'y': 13}, {'x': '2022-05-03T13:48:42+0000', 'y': 11}, {'x': '2022-05-04T03:06:37+0000', 'y': 13}, {'x': '2022-05-04T13:45:23+0000', 'y': 11}, {'x': '2022-05-05T03:00:58+0000', 'y': 13}, {'x': '2022-05-05T13:43:02+0000', 'y': 11}, {'x': '2022-05-06T02:48:11+0000', 'y': 13}, {'x': '2022-05-06T13:40:39+0000', 'y': 11}, {'x': '2022-05-07T02:41:33+0000', 'y': 13}, {'x': '2022-05-07T13:34:01+0000', 'y': 11}, {'x': '2022-05-08T02:57:14+0000', 'y': 13}, {'x': '2022-05-08T13:33:42+0000', 'y': 11}, {'x': '2022-05-09T03:02:23+0000', 'y': 13}, {'x': '2022-05-09T13:45:22+0000', 'y': 11}, {'x': '2022-05-10T02:26:17+0000', 'y': 13}, {'x': '2022-05-10T13:55:06+0000', 'y': 11}, {'x': '2022-05-11T03:02:43+0000', 'y': 13}, {'x': '2022-05-11T13:46:46+0000', 'y': 11}, {'x': '2022-05-12T02:56:58+0000', 'y': 13}, {'x': '2022-05-12T13:52:39+0000', 'y': 11}, {'x': '2022-05-13T03:21:09+0000', 'y': 13}, {'x': '2022-05-13T14:01:06+0000', 'y': 11}, {'x': '2022-05-14T03:29:25+0000', 'y': 13}, {'x': '2022-05-14T13:43:28+0000', 'y': 10}, {'x': '2022-05-15T02:57:02+0000', 'y': 13}, {'x': '2022-05-15T13:39:07+0000', 'y': 11}, {'x': '2022-05-16T02:43:24+0000', 'y': 13}, {'x': '2022-05-16T13:49:32+0000', 'y': 11}, {'x': '2022-05-17T03:05:05+0000', 'y': 13}, {'x': '2022-05-17T13:52:55+0000', 'y': 11}, {'x': '2022-05-18T03:00:33+0000', 'y': 13}, {'x': '2022-05-18T13:49:21+0000', 'y': 11}, {'x': '2022-05-19T03:08:15+0000', 'y': 13}, {'x': '2022-05-19T13:47:31+0000', 'y': 11}, {'x': '2022-05-20T02:56:27+0000', 'y': 13}, {'x': '2022-05-20T13:45:05+0000', 'y': 11}, {'x': '2022-05-21T02:25:17+0000', 'y': 13}, {'x': '2022-05-21T13:34:35+0000', 'y': 11}, {'x': '2022-05-22T02:50:57+0000', 'y': 13}, {'x': '2022-05-22T13:35:14+0000', 'y': 11}, {'x': '2022-05-23T03:01:31+0000', 'y': 13}, {'x': '2022-05-23T13:46:07+0000', 'y': 11}, {'x': '2022-05-24T03:05:55+0000', 'y': 13}, {'x': '2022-05-24T13:46:32+0000', 'y': 11}, {'x': '2022-05-25T03:02:19+0000', 'y': 13}, {'x': '2022-05-25T13:48:57+0000', 'y': 11}, {'x': '2022-05-26T03:06:53+0000', 'y': 13}, {'x': '2022-05-26T13:43:50+0000', 'y': 11}, {'x': '2022-05-27T03:07:53+0000', 'y': 13}, {'x': '2022-05-27T13:45:45+0000', 'y': 11}, {'x': '2022-05-28T02:49:46+0000', 'y': 13}, {'x': '2022-05-28T13:35:26+0000', 'y': 11}, {'x': '2022-05-29T03:10:18+0000', 'y': 14}, {'x': '2022-05-29T13:36:25+0000', 'y': 10}, {'x': '2022-05-30T03:12:33+0000', 'y': 14}, {'x': '2022-05-30T13:49:39+0000', 'y': 11}, {'x': '2022-05-31T03:04:29+0000', 'y': 13}, {'x': '2022-05-31T13:48:43+0000', 'y': 11}, {'x': '2022-06-01T03:37:20+0000', 'y': 14}, {'x': '2022-06-01T13:56:36+0000', 'y': 10}, {'x': '2022-06-02T03:21:19+0000', 'y': 13}, {'x': '2022-06-02T13:54:01+0000', 'y': 11}, {'x': '2022-06-03T02:56:11+0000', 'y': 13}, {'x': '2022-06-03T13:37:12+0000', 'y': 11}, {'x': '2022-06-04T02:51:34+0000', 'y': 13}, {'x': '2022-06-04T13:29:09+0000', 'y': 11}, {'x': '2022-06-05T02:54:21+0000', 'y': 13}, {'x': '2022-06-05T13:30:49+0000', 'y': 11}, {'x': '2022-06-06T02:59:49+0000', 'y': 13}, {'x': '2022-06-06T13:46:43+0000', 'y': 11}, {'x': '2022-06-07T03:00:33+0000', 'y': 13}, {'x': '2022-06-07T13:43:00+0000', 'y': 11}, {'x': '2022-06-08T03:02:59+0000', 'y': 13}, {'x': '2022-06-08T13:46:33+0000', 'y': 11}, {'x': '2022-06-09T03:04:51+0000', 'y': 13}, {'x': '2022-06-09T13:42:05+0000', 'y': 11}, {'x': '2022-06-10T03:02:50+0000', 'y': 13}, {'x': '2022-06-10T13:42:14+0000', 'y': 11}, {'x': '2022-06-11T03:01:00+0000', 'y': 13}, {'x': '2022-06-11T13:30:22+0000', 'y': 10}, {'x': '2022-06-12T03:07:31+0000', 'y': 14}, {'x': '2022-06-12T13:29:52+0000', 'y': 10}, {'x': '2022-06-13T03:10:07+0000', 'y': 14}, {'x': '2022-06-13T13:44:48+0000', 'y': 11}, {'x': '2022-06-14T03:21:19+0000', 'y': 14}, {'x': '2022-06-14T13:40:06+0000', 'y': 10}, {'x': '2022-06-15T03:15:02+0000', 'y': 14}, {'x': '2022-06-15T13:45:19+0000', 'y': 11}, {'x': '2022-06-16T03:04:08+0000', 'y': 13}, {'x': '2022-06-16T13:44:23+0000', 'y': 11}, {'x': '2022-06-17T03:07:48+0000', 'y': 13}, {'x': '2022-06-17T13:40:18+0000', 'y': 11}, {'x': '2022-06-18T03:02:37+0000', 'y': 13}, {'x': '2022-06-18T13:32:18+0000', 'y': 10}, {'x': '2022-06-19T03:17:29+0000', 'y': 14}, {'x': '2022-06-19T13:31:34+0000', 'y': 10}, {'x': '2022-06-20T02:58:14+0000', 'y': 13}, {'x': '2022-06-20T13:46:05+0000', 'y': 11}, {'x': '2022-06-21T03:11:31+0000', 'y': 13}, {'x': '2022-06-21T13:50:08+0000', 'y': 11}, {'x': '2022-06-22T03:11:34+0000', 'y': 13}, {'x': '2022-06-22T13:47:21+0000', 'y': 11}, {'x': '2022-06-23T03:13:20+0000', 'y': 13}, {'x': '2022-06-23T13:45:53+0000', 'y': 11}, {'x': '2022-06-24T03:16:40+0000', 'y': 14}, {'x': '2022-06-24T13:45:29+0000', 'y': 10}, {'x': '2022-06-25T03:12:28+0000', 'y': 13}, {'x': '2022-06-25T13:31:36+0000', 'y': 10}, {'x': '2022-06-26T03:16:33+0000', 'y': 14}, {'x': '2022-06-26T13:31:21+0000', 'y': 10}, {'x': '2022-06-27T03:20:50+0000', 'y': 14}, {'x': '2022-06-27T13:51:14+0000', 'y': 11}, {'x': '2022-06-28T03:16:07+0000', 'y': 13}, {'x': '2022-06-28T13:46:51+0000', 'y': 11}, {'x': '2022-06-29T03:23:37+0000', 'y': 14}, {'x': '2022-06-29T13:47:31+0000', 'y': 10}, {'x': '2022-06-30T03:18:21+0000', 'y': 14}, {'x': '2022-06-30T13:44:53+0000', 'y': 10}, {'x': '2022-07-01T03:33:03+0000', 'y': 14}, {'x': '2022-07-01T13:47:03+0000', 'y': 10}, {'x': '2022-07-02T03:18:41+0000', 'y': 14}, {'x': '2022-07-02T13:31:18+0000', 'y': 10}, {'x': '2022-07-03T03:13:06+0000', 'y': 14}, {'x': '2022-07-03T13:31:57+0000', 'y': 10}, {'x': '2022-07-04T03:23:05+0000', 'y': 14}, {'x': '2022-07-04T13:56:10+0000', 'y': 11}, {'x': '2022-07-05T03:20:01+0000', 'y': 13}, {'x': '2022-07-05T14:01:06+0000', 'y': 11}, {'x': '2022-07-06T03:26:34+0000', 'y': 13}, {'x': '2022-07-06T13:50:24+0000', 'y': 10}, {'x': '2022-07-07T03:24:26+0000', 'y': 14}, {'x': '2022-07-07T13:54:35+0000', 'y': 11}, {'x': '2022-07-08T03:17:23+0000', 'y': 13}, {'x': '2022-07-08T13:43:09+0000', 'y': 10}, {'x': '2022-07-09T03:02:16+0000', 'y': 13}, {'x': '2022-07-09T13:34:00+0000', 'y': 11}, {'x': '2022-07-10T03:14:49+0000', 'y': 14}, {'x': '2022-07-10T13:32:59+0000', 'y': 10}, {'x': '2022-07-11T03:16:22+0000', 'y': 14}, {'x': '2022-07-11T13:56:50+0000', 'y': 11}, {'x': '2022-07-12T03:32:16+0000', 'y': 14}, {'x': '2022-07-12T13:58:22+0000', 'y': 10}, {'x': '2022-07-13T03:19:20+0000', 'y': 13}, {'x': '2022-07-13T13:51:36+0000', 'y': 11}, {'x': '2022-07-14T03:26:11+0000', 'y': 14}, {'x': '2022-07-14T13:50:26+0000', 'y': 10}, {'x': '2022-07-15T03:28:08+0000', 'y': 14}, {'x': '2022-07-15T13:54:58+0000', 'y': 10}, {'x': '2022-07-16T03:08:35+0000', 'y': 13}, {'x': '2022-07-16T13:32:40+0000', 'y': 10}, {'x': '2022-07-17T03:20:19+0000', 'y': 14}, {'x': '2022-07-17T13:33:23+0000', 'y': 10}, {'x': '2022-07-18T03:21:26+0000', 'y': 14}, {'x': '2022-07-18T13:53:40+0000', 'y': 11}, {'x': '2022-07-19T03:31:37+0000', 'y': 14}, {'x': '2022-07-19T13:51:03+0000', 'y': 10}, {'x': '2022-07-20T03:18:01+0000', 'y': 13}, {'x': '2022-07-20T13:51:09+0000', 'y': 11}, {'x': '2022-07-21T03:19:03+0000', 'y': 13}, {'x': '2022-07-21T13:49:32+0000', 'y': 11}, {'x': '2022-07-22T03:24:48+0000', 'y': 14}, {'x': '2022-07-22T13:45:37+0000', 'y': 10}, {'x': '2022-07-23T03:11:36+0000', 'y': 13}, {'x': '2022-07-23T13:35:53+0000', 'y': 10}, {'x': '2022-07-24T03:17:30+0000', 'y': 14}, {'x': '2022-07-24T13:36:31+0000', 'y': 10}, {'x': '2022-07-25T03:22:40+0000', 'y': 14}, {'x': '2022-07-25T13:50:35+0000', 'y': 10}, {'x': '2022-07-26T03:37:22+0000', 'y': 14}, {'x': '2022-07-26T13:48:32+0000', 'y': 10}, {'x': '2022-07-27T03:24:48+0000', 'y': 14}, {'x': '2022-07-27T13:53:13+0000', 'y': 10}, {'x': '2022-07-28T03:17:45+0000', 'y': 13}, {'x': '2022-07-28T13:53:12+0000', 'y': 11}, {'x': '2022-07-29T03:29:41+0000', 'y': 14}, {'x': '2022-07-29T13:48:39+0000', 'y': 10}, {'x': '2022-07-30T03:21:52+0000', 'y': 14}, {'x': '2022-07-30T13:33:47+0000', 'y': 10}, {'x': '2022-07-31T03:20:36+0000', 'y': 14}, {'x': '2022-07-31T13:34:48+0000', 'y': 10}, {'x': '2022-08-01T03:38:10+0000', 'y': 14}, {'x': '2022-08-01T13:52:13+0000', 'y': 10}, {'x': '2022-08-02T03:38:28+0000', 'y': 14}, {'x': '2022-08-02T13:49:48+0000', 'y': 10}, {'x': '2022-08-03T03:27:11+0000', 'y': 14}, {'x': '2022-08-03T13:47:34+0000', 'y': 10}, {'x': '2022-08-04T03:08:21+0000', 'y': 13}, {'x': '2022-08-04T13:45:48+0000', 'y': 11}, {'x': '2022-08-05T03:19:42+0000', 'y': 14}, {'x': '2022-08-05T13:49:48+0000', 'y': 11}, {'x': '2022-08-06T03:01:43+0000', 'y': 13}, {'x': '2022-08-06T13:33:47+0000', 'y': 11}, {'x': '2022-08-07T03:07:14+0000', 'y': 14}, {'x': '2022-08-07T13:34:06+0000', 'y': 10}, {'x': '2022-08-08T03:16:12+0000', 'y': 14}, {'x': '2022-08-08T13:50:40+0000', 'y': 11}, {'x': '2022-08-09T03:20:05+0000', 'y': 13}, {'x': '2022-08-09T13:55:04+0000', 'y': 11}, {'x': '2022-08-10T02:47:06+0000', 'y': 13}, {'x': '2022-08-10T13:41:01+0000', 'y': 11}, {'x': '2022-08-11T03:02:41+0000', 'y': 13}, {'x': '2022-08-11T13:47:02+0000', 'y': 11}, {'x': '2022-08-12T13:49:36+0000', 'y': 24}, {'x': '2022-08-13T03:01:44+0000', 'y': 13}, {'x': '2022-08-13T13:34:22+0000', 'y': 11}, {'x': '2022-08-14T03:15:30+0000', 'y': 14}, {'x': '2022-08-14T13:37:07+0000', 'y': 10}, {'x': '2022-08-15T03:30:54+0000', 'y': 14}, {'x': '2022-08-15T13:49:12+0000', 'y': 10}, {'x': '2022-08-16T03:22:34+0000', 'y': 14}, {'x': '2022-08-16T13:37:44+0000', 'y': 10}, {'x': '2022-08-17T03:33:31+0000', 'y': 14}, {'x': '2022-08-17T13:56:31+0000', 'y': 10}, {'x': '2022-08-18T03:34:10+0000', 'y': 14}, {'x': '2022-08-18T13:50:57+0000', 'y': 10}, {'x': '2022-08-19T03:25:47+0000', 'y': 14}, {'x': '2022-08-19T13:48:07+0000', 'y': 10}, {'x': '2022-08-20T03:15:16+0000', 'y': 13}, {'x': '2022-08-20T13:35:53+0000', 'y': 10}, {'x': '2022-08-21T03:19:49+0000', 'y': 14}, {'x': '2022-08-21T13:36:15+0000', 'y': 10}, {'x': '2022-08-22T03:30:53+0000', 'y': 14}, {'x': '2022-08-22T13:48:17+0000', 'y': 10}, {'x': '2022-08-23T03:41:27+0000', 'y': 14}, {'x': '2022-08-23T13:46:37+0000', 'y': 10}, {'x': '2022-08-24T03:41:17+0000', 'y': 14}, {'x': '2022-08-24T13:43:38+0000', 'y': 10}, {'x': '2022-08-25T03:44:07+0000', 'y': 14}, {'x': '2022-08-25T13:50:53+0000', 'y': 10}, {'x': '2022-08-26T03:48:28+0000', 'y': 14}, {'x': '2022-08-26T13:45:26+0000', 'y': 10}, {'x': '2022-08-27T03:34:42+0000', 'y': 14}, {'x': '2022-08-27T13:36:16+0000', 'y': 10}, {'x': '2022-08-28T03:33:03+0000', 'y': 14}, {'x': '2022-08-28T13:36:23+0000', 'y': 10}, {'x': '2022-08-29T03:43:31+0000', 'y': 14}, {'x': '2022-08-29T13:48:23+0000', 'y': 10}, {'x': '2022-08-30T03:49:53+0000', 'y': 14}, {'x': '2022-08-30T13:51:57+0000', 'y': 10}, {'x': '2022-08-31T04:06:09+0000', 'y': 14}, {'x': '2022-08-31T13:50:43+0000', 'y': 10}, {'x': '2022-09-01T03:40:52+0000', 'y': 14}, {'x': '2022-09-01T13:44:23+0000', 'y': 10}, {'x': '2022-09-02T03:46:58+0000', 'y': 14}, {'x': '2022-09-02T13:46:37+0000', 'y': 10}, {'x': '2022-09-03T03:34:16+0000', 'y': 14}, {'x': '2022-09-03T13:36:49+0000', 'y': 10}, {'x': '2022-09-04T03:43:33+0000', 'y': 14}, {'x': '2022-09-04T13:37:58+0000', 'y': 10}, {'x': '2022-09-05T03:49:58+0000', 'y': 14}, {'x': '2022-09-05T13:52:17+0000', 'y': 10}, {'x': '2022-09-06T03:52:14+0000', 'y': 14}, {'x': '2022-09-06T13:51:59+0000', 'y': 10},
    {'x': '2022-09-07T03:53:02+0000', 'y': 14}, {'x': '2022-09-07T13:59:46+0000', 'y': 10}, {'x': '2022-09-08T03:42:34+0000', 'y': 14}, {'x': '2022-09-08T13:41:08+0000', 'y': 10}, {'x': '2022-09-09T03:37:09+0000', 'y': 14}, {'x': '2022-09-09T13:56:01+0000', 'y': 10}, {'x': '2022-09-10T03:43:49+0000', 'y': 14}, {'x': '2022-09-10T13:40:58+0000', 'y': 10}, {'x': '2022-09-11T03:41:54+0000', 'y': 14}, {'x': '2022-09-11T13:40:24+0000', 'y': 10}, {'x': '2022-09-12T03:57:02+0000', 'y': 14}, {'x': '2022-09-12T13:55:42+0000', 'y': 10}, {'x': '2022-09-13T03:52:50+0000', 'y': 14}, {'x': '2022-09-13T13:59:25+0000', 'y': 10}, {'x': '2022-09-14T03:47:10+0000', 'y': 14}, {'x': '2022-09-14T14:00:22+0000', 'y': 10}, {'x': '2022-09-15T03:53:20+0000', 'y': 14}, {'x': '2022-09-15T13:59:30+0000', 'y': 10}, {'x': '2022-09-16T03:55:48+0000', 'y': 14}, {'x': '2022-09-16T13:58:33+0000', 'y': 10}, {'x': '2022-09-17T03:32:22+0000', 'y': 14}, {'x': '2022-09-17T13:40:53+0000', 'y': 10}, {'x': '2022-09-18T03:52:33+0000', 'y': 14}, {'x': '2022-09-18T13:42:50+0000', 'y': 10}, {'x': '2022-09-19T03:58:07+0000', 'y': 14}, {'x': '2022-09-19T13:59:47+0000', 'y': 10}, {'x': '2022-09-20T03:45:51+0000', 'y': 14}, {'x': '2022-09-20T14:00:57+0000', 'y': 10}, {'x': '2022-09-21T03:55:40+0000', 'y': 14}, {'x': '2022-09-21T14:02:38+0000', 'y': 10}, {'x': '2022-09-22T03:44:51+0000', 'y': 14}, {'x': '2022-09-22T13:58:26+0000', 'y': 10}, {'x': '2022-09-23T03:51:17+0000', 'y': 14}, {'x': '2022-09-23T13:59:16+0000', 'y': 10}, {'x': '2022-09-24T03:48:52+0000', 'y': 14}, {'x': '2022-09-24T13:49:43+0000', 'y': 10}, {'x': '2022-09-25T03:44:46+0000', 'y': 14}, {'x': '2022-09-25T13:42:21+0000', 'y': 10}, {'x': '2022-09-26T03:55:42+0000', 'y': 14}, {'x': '2022-09-26T14:03:38+0000', 'y': 10}, {'x': '2022-09-27T03:38:54+0000', 'y': 14}, {'x': '2022-09-27T14:03:52+0000', 'y': 10}, {'x': '2022-09-28T03:46:25+0000', 'y': 14}, {'x': '2022-09-28T14:03:06+0000', 'y': 10}, {'x': '2022-09-29T03:49:10+0000', 'y': 14}, {'x': '2022-09-29T14:01:00+0000', 'y': 10}, {'x': '2022-09-30T04:06:38+0000', 'y': 14}, {'x': '2022-09-30T14:03:14+0000', 'y': 10}, {'x': '2022-10-01T03:57:15+0000', 'y': 14}, {'x': '2022-10-01T13:51:35+0000', 'y': 10}, {'x': '2022-10-02T03:50:36+0000', 'y': 14}, {'x': '2022-10-02T13:46:50+0000', 'y': 10}, {'x': '2022-10-03T03:07:56+0000', 'y': 13}, {'x': '2022-10-03T14:05:59+0000', 'y': 11}, {'x': '2022-10-04T03:15:28+0000', 'y': 13}, {'x': '2022-10-04T14:05:17+0000', 'y': 11}, {'x': '2022-10-05T03:14:25+0000', 'y': 13}, {'x': '2022-10-05T14:24:34+0000', 'y': 11}, {'x': '2022-10-06T03:12:20+0000', 'y': 13}, {'x': '2022-10-06T14:03:23+0000', 'y': 11}, {'x': '2022-10-07T03:24:03+0000', 'y': 13}, {'x': '2022-10-07T14:02:29+0000', 'y': 11}, {'x': '2022-10-08T03:08:08+0000', 'y': 13}, {'x': '2022-10-08T13:51:50+0000', 'y': 11}, {'x': '2022-10-09T03:37:48+0000', 'y': 14}, {'x': '2022-10-09T13:49:20+0000', 'y': 10}, {'x': '2022-10-10T03:43:36+0000', 'y': 14}, {'x': '2022-10-10T14:09:56+0000', 'y': 10}, {'x': '2022-10-11T03:41:24+0000', 'y': 14}, {'x': '2022-10-11T14:05:07+0000', 'y': 10}, {'x': '2022-10-12T03:38:50+0000', 'y': 14}, {'x': '2022-10-12T14:05:36+0000', 'y': 10}, {'x': '2022-10-13T03:44:35+0000', 'y': 14}, {'x': '2022-10-13T14:02:43+0000', 'y': 10}, {'x': '2022-10-14T03:53:20+0000', 'y': 14}, {'x': '2022-10-14T14:08:48+0000', 'y': 10}, {'x': '2022-10-15T03:42:10+0000', 'y': 14}, {'x': '2022-10-15T13:49:57+0000', 'y': 10}, {'x': '2022-10-16T03:49:11+0000', 'y': 14}, {'x': '2022-10-16T13:48:36+0000', 'y': 10}, {'x': '2022-10-17T04:05:40+0000', 'y': 14}, {'x': '2022-10-17T14:09:51+0000', 'y': 10}, {'x': '2022-10-18T03:48:00+0000', 'y': 14}, {'x': '2022-10-18T14:07:04+0000', 'y': 10}, {'x': '2022-10-19T03:47:08+0000', 'y': 14}, {'x': '2022-10-19T14:05:12+0000', 'y': 10}, {'x': '2022-10-20T03:39:17+0000', 'y': 14}, {'x': '2022-10-20T14:08:32+0000', 'y': 10}, {'x': '2022-10-21T03:12:06+0000', 'y': 13}, {'x': '2022-10-23T15:11:10+0000', 'y': 60}, {'x': '2022-10-24T03:57:32+0000', 'y': 13}, {'x': '2022-10-24T14:09:47+0000', 'y': 10}, {'x': '2022-10-25T03:52:55+0000', 'y': 14}, {'x': '2022-10-25T14:09:56+0000', 'y': 10}, {'x': '2022-10-26T03:20:10+0000', 'y': 13}, {'x': '2022-10-26T13:59:35+0000', 'y': 11}, {'x': '2022-10-27T03:15:29+0000', 'y': 13}, {'x': '2022-10-27T13:56:31+0000', 'y': 11}, {'x': '2022-10-28T03:22:30+0000', 'y': 13}, {'x': '2022-10-28T13:58:58+0000', 'y': 11}, {'x': '2022-10-29T03:10:02+0000', 'y': 13}, {'x': '2022-10-29T13:39:26+0000', 'y': 10}, {'x': '2022-10-30T03:26:42+0000', 'y': 14}, {'x': '2022-10-30T13:39:44+0000', 'y': 10}, {'x': '2022-10-31T03:22:00+0000', 'y': 14}, {'x': '2022-10-31T14:01:22+0000', 'y': 11}, {'x': '2022-11-01T03:37:47+0000', 'y': 14}, {'x': '2022-11-01T13:55:03+0000', 'y': 10}, {'x': '2022-11-02T03:27:01+0000', 'y': 14}, {'x': '2022-11-02T14:00:36+0000', 'y': 11}, {'x': '2022-11-03T03:08:57+0000', 'y': 13}, {'x': '2022-11-03T13:52:46+0000', 'y': 11}, {'x': '2022-11-04T03:14:39+0000', 'y': 13}, {'x': '2022-11-04T13:48:01+0000', 'y': 11}, {'x': '2022-11-05T03:03:35+0000', 'y': 13}, {'x': '2022-11-05T13:35:22+0000', 'y': 11}, {'x': '2022-11-06T03:07:26+0000', 'y': 14}, {'x': '2022-11-06T13:36:21+0000', 'y': 10}, {'x': '2022-11-07T03:06:53+0000', 'y': 14}, {'x': '2022-11-07T13:53:57+0000', 'y': 11}, {'x': '2022-11-08T03:04:21+0000', 'y': 13}, {'x': '2022-11-08T13:52:34+0000', 'y': 11}, {'x': '2022-11-09T03:12:14+0000', 'y': 13}, {'x': '2022-11-09T13:55:27+0000', 'y': 11}, {'x': '2022-11-10T03:06:53+0000', 'y': 13}, {'x': '2022-11-10T13:57:42+0000', 'y': 11}, {'x': '2022-11-11T03:07:49+0000', 'y': 13}, {'x': '2022-11-11T13:52:47+0000', 'y': 11}, {'x': '2022-11-12T03:02:07+0000', 'y': 13}, {'x': '2022-11-12T13:36:08+0000', 'y': 11}, {'x': '2022-11-13T03:04:11+0000', 'y': 13}, {'x': '2022-11-13T13:36:21+0000', 'y': 11}, {'x': '2022-11-14T03:04:57+0000', 'y': 13}, {'x': '2022-11-14T13:55:25+0000', 'y': 11}, {'x': '2022-11-15T02:56:04+0000', 'y': 13}, {'x': '2022-11-16T02:56:48+0000', 'y': 24}, {'x': '2022-11-16T13:44:56+0000', 'y': 11}, {'x': '2022-11-17T02:52:08+0000', 'y': 13}, {'x': '2022-11-17T13:42:24+0000', 'y': 11}, {'x': '2022-11-18T02:56:52+0000', 'y': 13}, {'x': '2022-11-18T13:42:58+0000', 'y': 11}, {'x': '2022-11-19T02:50:11+0000', 'y': 13}, {'x': '2022-11-19T13:32:40+0000', 'y': 11}, {'x': '2022-11-20T02:59:29+0000', 'y': 13}, {'x': '2022-11-20T13:34:09+0000', 'y': 11}, {'x': '2022-11-21T02:56:47+0000', 'y': 13}, {'x': '2022-11-21T13:48:28+0000', 'y': 11}, {'x': '2022-11-22T02:53:55+0000', 'y': 13}, {'x': '2022-11-22T13:37:43+0000', 'y': 11}, {'x': '2022-11-23T02:45:39+0000', 'y': 13}, {'x': '2022-11-23T13:37:30+0000', 'y': 11}, {'x': '2022-11-24T02:35:59+0000', 'y': 13}, {'x': '2022-11-24T13:35:11+0000', 'y': 11}, {'x': '2022-11-25T02:41:59+0000', 'y': 13}, {'x': '2022-11-25T13:32:48+0000', 'y': 11}, {'x': '2022-11-26T02:30:42+0000', 'y': 13}, {'x': '2022-11-26T13:29:08+0000', 'y': 11}, {'x': '2022-11-27T02:45:28+0000', 'y': 13}, {'x': '2022-11-27T13:29:17+0000', 'y': 11}, {'x': '2022-11-28T02:39:46+0000', 'y': 13}, {'x': '2022-11-28T13:34:01+0000', 'y': 11}, {'x': '2022-11-29T02:35:50+0000', 'y': 13}, {'x': '2022-11-29T13:36:53+0000', 'y': 11}, {'x': '2022-11-30T02:31:17+0000', 'y': 13}, {'x': '2022-11-30T13:36:10+0000', 'y': 11}, {'x': '2022-12-01T02:52:13+0000', 'y': 13}, {'x': '2022-12-01T13:40:06+0000', 'y': 11}, {'x': '2022-12-02T02:26:23+0000', 'y': 13}, {'x': '2022-12-02T13:29:02+0000', 'y': 11}, {'x': '2022-12-03T02:16:20+0000', 'y': 13}, {'x': '2022-12-03T13:26:52+0000', 'y': 11}, {'x': '2022-12-04T02:23:00+0000', 'y': 13}, {'x': '2022-12-04T13:26:49+0000', 'y': 11}, {'x': '2022-12-05T02:21:22+0000', 'y': 13}, {'x': '2022-12-05T13:29:53+0000', 'y': 11}, {'x': '2022-12-06T02:22:04+0000', 'y': 13}, {'x': '2022-12-06T13:31:28+0000', 'y': 11}, {'x': '2022-12-07T02:30:51+0000', 'y': 13}, {'x': '2022-12-07T13:30:14+0000', 'y': 11}, {'x': '2022-12-08T02:23:44+0000', 'y': 13}, {'x': '2022-12-08T13:29:24+0000', 'y': 11}, {'x': '2022-12-10T03:51:21+0000', 'y': 38}, {'x': '2022-12-10T04:04:32+0000', 'y': 0}, {'x': '2022-12-10T13:27:13+0000', 'y': 9}, {'x': '2022-12-11T02:30:46+0000', 'y': 13}, {'x': '2022-12-11T13:27:03+0000', 'y': 11}, {'x': '2022-12-12T02:24:28+0000', 'y': 13}];

const phpReleaseByHour = [1, 1, 1, 3, 0, 0, 1, 1, 12, 7, 19, 8, 3, 11, 6, 9, 2, 1, 6, 2, 1, 2, 2, 1, 3];


const releaseFrequencyCanvas = document.getElementById('releaseFrequencyCanvas');
const releaseFrequencyChart = new Chart(releaseFrequencyCanvas, {
    type: 'scatter',
    data: {
        datasets: [
            {
                label: 'update',
                data: releaseFrequency,
                color: '#c9d1d9',
                backgroundColor: '#777bb3',
                yAxisID: 'hoursElapsed',
                borderWidth: 0
            }
        ]
    },
    options: {
        plugins: {
            title: {
                display: true,
                text: 'Update Frequency'
            }
        },
        scales: {
            y: {
                display: false
            },
            hoursElapsed: {
                title: {
                    display: true,
                    text: 'hours since previous release'
                },
                position: 'left',
                display: true,
            },
            x: {
                title: {
                    display: true,
                    text: 'release date'
                },
                type: 'time',
                time: {
                    unit: 'month'
                },
                min: '2019-12-01T00:00:00+00:00'
            }
          }
        }
    }
);

const phpReleaseByHourCanvas = document.getElementById('phpReleaseByHourCanvas');
/*const phpReleaseByHourChart = new Chart(phpReleaseByHourCanvas, {
        type: 'bar',
        data: {
            labels: ['1:00','2:00','3:00', '4:00', '5:00', '6:00', '7:00', '8:00', '9:00', '10:00', '10:00', '11:00', '12:00', '13:00',
                '14:00', '15:00', '16:00', '17:00', '18:00', '19:00', '20:00', '21:00', '22:00', '23:00', '24:00',],
            datasets: [
                {
                    data: [1, 1, 1, 3, 0, 0, 0, 1, 11, 7, 19, 8, 3, 11, 5, 9, 2, 1, 5, 2, 1, 2, 2, 1, 3],
                    backgroundColor: '#777bb3',
                    label: 'Hour, UTC'
                }
            ]
        },
        options: {
            plugins: {
                title: {
                    display: true,
                    text: 'PHP Version Announcements by Hour'
                }
            },
        }
    }
);*/


const hoursTillCveDatabasePublish = document.getElementById('hoursTillCveDatabasePublish');
const hoursTillCveDatabasePublishChart = new Chart(hoursTillCveDatabasePublish, {
        type: 'bar',
        data: {
            labels: ['0-100', '100-200', '200-300', '300-400', '400-600'],
            datasets: [
                {
                    data: [1, 4, 5, 1, 3],
                    backgroundColor: '#777bb3',
                    label: 'Hours'
                }
            ]
        },
        options: {
            plugins: {
                title: {
                    display: true,
                    text: 'CVE Database update after php release announcement'
                }
            },
        }
    }
);

const hoursTillPhpVersionAuditPublish = document.getElementById('hoursTillPhpVersionAuditPublish');
const hoursTillPhpVersionAuditPublishChart = new Chart(hoursTillPhpVersionAuditPublish, {
        type: 'bar',
        data: {
            labels: ['2-5', '5-8', '8-11', '11-14'],
            datasets: [
                {
                    data: [6, 5, 2, 1],
                    backgroundColor: '#777bb3',
                    label: 'Hours'
                }
            ]
        },
        options: {
            plugins: {
                title: {
                    display: true,
                    text: 'PHP Version Audit update after php release announcement'
                }
            }
        }
    }
);

