# Lightrail - A Platform for Cross-App AI Actions

[![Discord](https://img.shields.io/discord/1126247706789167264?label=&logo=discord&logoColor=ffffff&color=7389D8&labelColor=6A7EC2)](https://discord.gg/WPCCe7jZuS)

<div style="text-align: center; padding: 24px 0">
    <img src="./assets/screenshot5-with-bg.jpeg" height="280" />
</div>

<br />

- Run [AI Actions](https://docs.lightrail.ai/sdk/intro) that can manipulate & pull context from your existing tools/editors/apps
- Write & distribute new Actions with a [simple Typescript SDK](https://docs.lightrail.ai/sdk/workflow)
- [Read more here](https://docs.lightrail.ai/)

<br />

[**Download for OS X** (Apple Silicon)](https://github.com/lightrail-ai/lightrail/releases/latest/download/lightrail-core-osx-arm64.dmg) | [**Download for OS X** (Intel)](https://github.com/lightrail-ai/lightrail/releases/latest/download/lightrail-core-osx-x64.dmg) | [**Download for Ubuntu**](https://github.com/lightrail-ai/lightrail/releases/latest/download/lightrail-core.deb) | [**Download for Fedora**](https://github.com/lightrail-ai/lightrail/releases/latest/download/lightrail-core.rpm)

[**Demo Video**](https://vimeo.com/861792302?share=copy) | [**Documentation**](https://docs.lightrail.ai)

## Features

- Always-available launcher-style desktop app to run AI actions
- Integrations with [VS Code](https://docs.lightrail.ai/tracks/vscode), [JupyterLab](https://docs.lightrail.ai/tracks/datasci), [PostgreSQL](https://docs.lightrail.ai/tracks/sql), [Chrome](https://docs.lightrail.ai/tracks/chrome), and more!
  - [video - VS Code + Chrome](https://vimeo.com/861792302?share=copy)
  - [video - JupyterLab](https://vimeo.com/882695481?share=copy)
- Use screenshots in prompts to `gpt-4-vision-preview` (✨ new ✨)
  - Only available for users that provide their own API key
  - [video](https://vimeo.com/882694040?share=copy)
- Long-term memory / [Knowledge Base](https://docs.lightrail.ai/tracks/kb) using a local vector DB (⚠️ pre-release, please report bugs!)
  - [video](https://vimeo.com/882693396?share=copy)
- [simple Typescript SDK](https://docs.lightrail.ai/sdk/workflow) for building new Actions & custom sources of context (Tokens)

## Installation

To get started, just download the appropriate Lightrail package for your operating system:

- OS X (Apple Silicon / M1 / M2): [lightrail-core-osx-arm64.dmg](https://github.com/lightrail-ai/lightrail/releases/latest/download/lightrail-core-osx-arm64.dmg)
- OS X (Intel): [lightrail-core-osx-x64.dmg](https://github.com/lightrail-ai/lightrail/releases/latest/download/lightrail-core-osx-x64.dmg)
- Ubuntu: [lightrail-core.deb](https://github.com/lightrail-ai/lightrail/releases/latest/download/lightrail-core.deb)
- Fedora: [lightrail-core.rpm](https://github.com/lightrail-ai/lightrail/releases/latest/download/lightrail-core.rpm)

## Usage

- Launch Lightrail initially as you would normally start an application on your platform (i.e. from your application launcher). Consider adding it to your startup items ([OS X](https://support.apple.com/guide/mac-help/open-items-automatically-when-you-log-in-mh15189/mac), [Gnome](https://help.gnome.org/users/gnome-help/stable/shell-apps-auto-start.html.en)), so that it automatically starts on boot.
- When Lightrail is running on your system, it can be activated at any time by pressing the keyboard combination `Cmd/Ctrl-Shift-Space`.
- Use the up- and down-arrow keys to browse actions, and hit `enter/return` to select one (while in 'Choose an action' mode).
- To change the action afterwards, press `esc` or `@`, or click on the current action
- After selecting an action, enter the prompt (or any other required arguments). Your prompt can include special Tokens, which pull in additional context from external sources:
  - Type the forward-slash at any point in a prompt (`/`) to open the Tokens menu. Use the arrow keys to select a token and hit enter to insert that token into your prompt.
  - In general, try to be explicit about what sources of content you'd like to include for best results.
- `Cmd/Ctrl-Up` and `Cmd/Ctrl-Down` cycle through the prompt history.
- By default, the application uses a lightrail.ai-provided gateway to access OpenAI's LLMs. If you'd like to switch to using your own API key and accessing the OpenAI API directly, you can configure that in Settings (click the gear icon in the prompt input box).

## Troubleshooting

Some common issues, and how to fix them:

- **Q: I get `i is not iterable` as an error**
- **A:** This occurs when the action expects a prompt but one isn't provided. Almost all actions currently available only work if the user has entered a prompt, so make sure you're providing one before you hit `enter/return`.
- **Q: I'm on Linux and the keyboard shortcut to open Lightrail isn't working for me**
- **A:** If you're using Wayland, this is a known bug, caused by [this issue](https://github.com/electron/electron/issues/15863). Currently, the only fix is using your system's settings to manually assign a keyboard shortcut to launching Lightrail. If you have any idea how to work-around this bug, I'd love to hear it!

Any other issues? Let me know [on Discord](https://discord.gg/WPCCe7jZuS) or [make an issue](https://github.com/lightrail-ai/lightrail/issues) and I'll address it ASAP!

### Reporting Bugs

When [creating an issue](https://github.com/lightrail-ai/lightrail/issues) or describing a but on Discord, please include the contents of the Lightrail log file, available at the following location:

- **on Linux:** `~/.config/lightrail-core/logs/main.log`
- **on macOS:** `~/Library/Logs/lightrail-core/main.log`

## Writing Tracks & Clients

The `lightrail-sdk` npm package makes it easy to create additional tracks and extend Lightrail's functionality, or to make Clients that integrate Lightrail with other platforms.
For thorough documentation on creating Tracks & Clients, [see our developer documentation here](https://docs.lightrail.ai/sdk/intro).

## Contributing

We'd love to have your contributions added to Lightrail! If you would like to contribute, please follow this guidelines:

- Fork the repository
- Create a new branch: `git checkout -b feature/my-feature`
- Make your changes
- Commit your changes: `git commit -m "Add new feature"`
- Push to the branch: `git push origin feature/my-feature`
- Submit a pull request

## License

This project is licensed under the MIT License. See the [LICENSE](./LICENSE) file for more details.
