// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package walletrpc

import (
	context "context"
	lnrpc "github.com/lightningnetwork/lnd/lnrpc"
	signrpc "github.com/lightningnetwork/lnd/lnrpc/signrpc"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// WalletKitClient is the client API for WalletKit service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type WalletKitClient interface {
	// ListUnspent returns a list of all utxos spendable by the wallet with a
	// number of confirmations between the specified minimum and maximum. By
	// default, all utxos are listed. To list only the unconfirmed utxos, set
	// the unconfirmed_only to true.
	ListUnspent(ctx context.Context, in *ListUnspentRequest, opts ...grpc.CallOption) (*ListUnspentResponse, error)
	// lncli: `wallet leaseoutput`
	// LeaseOutput locks an output to the given ID, preventing it from being
	// available for any future coin selection attempts. The absolute time of the
	// lock's expiration is returned. The expiration of the lock can be extended by
	// successive invocations of this RPC. Outputs can be unlocked before their
	// expiration through `ReleaseOutput`.
	LeaseOutput(ctx context.Context, in *LeaseOutputRequest, opts ...grpc.CallOption) (*LeaseOutputResponse, error)
	// lncli: `wallet releaseoutput`
	// ReleaseOutput unlocks an output, allowing it to be available for coin
	// selection if it remains unspent. The ID should match the one used to
	// originally lock the output.
	ReleaseOutput(ctx context.Context, in *ReleaseOutputRequest, opts ...grpc.CallOption) (*ReleaseOutputResponse, error)
	// lncli: `wallet listleases`
	// ListLeases lists all currently locked utxos.
	ListLeases(ctx context.Context, in *ListLeasesRequest, opts ...grpc.CallOption) (*ListLeasesResponse, error)
	// DeriveNextKey attempts to derive the *next* key within the key family
	// (account in BIP43) specified. This method should return the next external
	// child within this branch.
	DeriveNextKey(ctx context.Context, in *KeyReq, opts ...grpc.CallOption) (*signrpc.KeyDescriptor, error)
	// DeriveKey attempts to derive an arbitrary key specified by the passed
	// KeyLocator.
	DeriveKey(ctx context.Context, in *signrpc.KeyLocator, opts ...grpc.CallOption) (*signrpc.KeyDescriptor, error)
	// NextAddr returns the next unused address within the wallet.
	NextAddr(ctx context.Context, in *AddrRequest, opts ...grpc.CallOption) (*AddrResponse, error)
	// lncli: `wallet gettx`
	// GetTransaction returns details for a transaction found in the wallet.
	GetTransaction(ctx context.Context, in *GetTransactionRequest, opts ...grpc.CallOption) (*lnrpc.Transaction, error)
	// lncli: `wallet accounts list`
	// ListAccounts retrieves all accounts belonging to the wallet by default. A
	// name and key scope filter can be provided to filter through all of the
	// wallet accounts and return only those matching.
	ListAccounts(ctx context.Context, in *ListAccountsRequest, opts ...grpc.CallOption) (*ListAccountsResponse, error)
	// lncli: `wallet requiredreserve`
	// RequiredReserve returns the minimum amount of satoshis that should be kept
	// in the wallet in order to fee bump anchor channels if necessary. The value
	// scales with the number of public anchor channels but is capped at a maximum.
	RequiredReserve(ctx context.Context, in *RequiredReserveRequest, opts ...grpc.CallOption) (*RequiredReserveResponse, error)
	// lncli: `wallet addresses list`
	// ListAddresses retrieves all the addresses along with their balance. An
	// account name filter can be provided to filter through all of the
	// wallet accounts and return the addresses of only those matching.
	ListAddresses(ctx context.Context, in *ListAddressesRequest, opts ...grpc.CallOption) (*ListAddressesResponse, error)
	// lncli: `wallet addresses signmessage`
	// SignMessageWithAddr returns the compact signature (base64 encoded) created
	// with the private key of the provided address. This requires the address
	// to be solely based on a public key lock (no scripts). Obviously the internal
	// lnd wallet has to possess the private key of the address otherwise
	// an error is returned.
	//
	// This method aims to provide full compatibility with the bitcoin-core and
	// btcd implementation. Bitcoin-core's algorithm is not specified in a
	// BIP and only applicable for legacy addresses. This method enhances the
	// signing for additional address types: P2WKH, NP2WKH, P2TR.
	// For P2TR addresses this represents a special case. ECDSA is used to create
	// a compact signature which makes the public key of the signature recoverable.
	SignMessageWithAddr(ctx context.Context, in *SignMessageWithAddrRequest, opts ...grpc.CallOption) (*SignMessageWithAddrResponse, error)
	// lncli: `wallet addresses verifymessage`
	// VerifyMessageWithAddr returns the validity and the recovered public key of
	// the provided compact signature (base64 encoded). The verification is
	// twofold. First the validity of the signature itself is checked and then
	// it is verified that the recovered public key of the signature equals
	// the public key of the provided address. There is no dependence on the
	// private key of the address therefore also external addresses are allowed
	// to verify signatures.
	// Supported address types are P2PKH, P2WKH, NP2WKH, P2TR.
	//
	// This method is the counterpart of the related signing method
	// (SignMessageWithAddr) and aims to provide full compatibility to
	// bitcoin-core's implementation. Although bitcoin-core/btcd only provide
	// this functionality for legacy addresses this function enhances it to
	// the address types: P2PKH, P2WKH, NP2WKH, P2TR.
	//
	// The verification for P2TR addresses is a special case and requires the
	// ECDSA compact signature to compare the reovered public key to the internal
	// taproot key. The compact ECDSA signature format was used because there
	// are still no known compact signature schemes for schnorr signatures.
	VerifyMessageWithAddr(ctx context.Context, in *VerifyMessageWithAddrRequest, opts ...grpc.CallOption) (*VerifyMessageWithAddrResponse, error)
	// lncli: `wallet accounts import`
	// ImportAccount imports an account backed by an account extended public key.
	// The master key fingerprint denotes the fingerprint of the root key
	// corresponding to the account public key (also known as the key with
	// derivation path m/). This may be required by some hardware wallets for
	// proper identification and signing.
	//
	// The address type can usually be inferred from the key's version, but may be
	// required for certain keys to map them into the proper scope.
	//
	// For BIP-0044 keys, an address type must be specified as we intend to not
	// support importing BIP-0044 keys into the wallet using the legacy
	// pay-to-pubkey-hash (P2PKH) scheme. A nested witness address type will force
	// the standard BIP-0049 derivation scheme, while a witness address type will
	// force the standard BIP-0084 derivation scheme.
	//
	// For BIP-0049 keys, an address type must also be specified to make a
	// distinction between the standard BIP-0049 address schema (nested witness
	// pubkeys everywhere) and our own BIP-0049Plus address schema (nested pubkeys
	// externally, witness pubkeys internally).
	//
	// NOTE: Events (deposits/spends) for keys derived from an account will only be
	// detected by lnd if they happen after the import. Rescans to detect past
	// events will be supported later on.
	ImportAccount(ctx context.Context, in *ImportAccountRequest, opts ...grpc.CallOption) (*ImportAccountResponse, error)
	// lncli: `wallet accounts import-pubkey`
	// ImportPublicKey imports a public key as watch-only into the wallet. The
	// public key is converted into a simple address of the given type and that
	// address script is watched on chain. For Taproot keys, this will only watch
	// the BIP-0086 style output script. Use ImportTapscript for more advanced key
	// spend or script spend outputs.
	//
	// NOTE: Events (deposits/spends) for a key will only be detected by lnd if
	// they happen after the import. Rescans to detect past events will be
	// supported later on.
	ImportPublicKey(ctx context.Context, in *ImportPublicKeyRequest, opts ...grpc.CallOption) (*ImportPublicKeyResponse, error)
	// ImportTapscript imports a Taproot script and internal key and adds the
	// resulting Taproot output key as a watch-only output script into the wallet.
	// For BIP-0086 style Taproot keys (no root hash commitment and no script spend
	// path) use ImportPublicKey.
	//
	// NOTE: Events (deposits/spends) for a key will only be detected by lnd if
	// they happen after the import. Rescans to detect past events will be
	// supported later on.
	//
	// NOTE: Taproot keys imported through this RPC currently _cannot_ be used for
	// funding PSBTs. Only tracking the balance and UTXOs is currently supported.
	ImportTapscript(ctx context.Context, in *ImportTapscriptRequest, opts ...grpc.CallOption) (*ImportTapscriptResponse, error)
	// lncli: `wallet publishtx`
	// PublishTransaction attempts to publish the passed transaction to the
	// network. Once this returns without an error, the wallet will continually
	// attempt to re-broadcast the transaction on start up, until it enters the
	// chain.
	PublishTransaction(ctx context.Context, in *Transaction, opts ...grpc.CallOption) (*PublishResponse, error)
	// lncli: `wallet removetx`
	// RemoveTransaction attempts to remove the provided transaction from the
	// internal transaction store of the wallet.
	RemoveTransaction(ctx context.Context, in *GetTransactionRequest, opts ...grpc.CallOption) (*RemoveTransactionResponse, error)
	// SendOutputs is similar to the existing sendmany call in Bitcoind, and
	// allows the caller to create a transaction that sends to several outputs at
	// once. This is ideal when wanting to batch create a set of transactions.
	SendOutputs(ctx context.Context, in *SendOutputsRequest, opts ...grpc.CallOption) (*SendOutputsResponse, error)
	// lncli: `wallet estimatefeerate`
	// EstimateFee attempts to query the internal fee estimator of the wallet to
	// determine the fee (in sat/kw) to attach to a transaction in order to
	// achieve the confirmation target.
	EstimateFee(ctx context.Context, in *EstimateFeeRequest, opts ...grpc.CallOption) (*EstimateFeeResponse, error)
	// lncli: `wallet pendingsweeps`
	// PendingSweeps returns lists of on-chain outputs that lnd is currently
	// attempting to sweep within its central batching engine. Outputs with similar
	// fee rates are batched together in order to sweep them within a single
	// transaction.
	//
	// NOTE: Some of the fields within PendingSweepsRequest are not guaranteed to
	// remain supported. This is an advanced API that depends on the internals of
	// the UtxoSweeper, so things may change.
	PendingSweeps(ctx context.Context, in *PendingSweepsRequest, opts ...grpc.CallOption) (*PendingSweepsResponse, error)
	// lncli: `wallet bumpfee`
	// BumpFee is an endpoint that allows users to interact with lnd's sweeper
	// directly. It takes an outpoint from an unconfirmed transaction and sends it
	// to the sweeper for potential fee bumping. Depending on whether the outpoint
	// has been registered in the sweeper (an existing input, e.g., an anchor
	// output) or not (a new input, e.g., an unconfirmed wallet utxo), this will
	// either be an RBF or CPFP attempt.
	//
	// When receiving an input, lnd’s sweeper needs to understand its time
	// sensitivity to make economical fee bumps - internally a fee function is
	// created using the deadline and budget to guide the process. When the
	// deadline is approaching, the fee function will increase the fee rate and
	// perform an RBF.
	//
	// When a force close happens, all the outputs from the force closing
	// transaction will be registered in the sweeper. The sweeper will then handle
	// the creation, publish, and fee bumping of the sweeping transactions.
	// Everytime a new block comes in, unless the sweeping transaction is
	// confirmed, an RBF is attempted. To interfere with this automatic process,
	// users can use BumpFee to specify customized fee rate, budget, deadline, and
	// whether the sweep should happen immediately. It's recommended to call
	// `ListSweeps` to understand the shape of the existing sweeping transaction
	// first - depending on the number of inputs in this transaction, the RBF
	// requirements can be quite different.
	//
	// This RPC also serves useful when wanting to perform a Child-Pays-For-Parent
	// (CPFP), where the child transaction pays for its parent's fee. This can be
	// done by specifying an outpoint within the low fee transaction that is under
	// the control of the wallet.
	BumpFee(ctx context.Context, in *BumpFeeRequest, opts ...grpc.CallOption) (*BumpFeeResponse, error)
	// lncli: `wallet bumpforceclosefee`
	// BumpForceCloseFee is an endpoint that allows users to bump the fee of a
	// channel force close. This only works for channels with option_anchors.
	BumpForceCloseFee(ctx context.Context, in *BumpForceCloseFeeRequest, opts ...grpc.CallOption) (*BumpForceCloseFeeResponse, error)
	// lncli: `wallet listsweeps`
	// ListSweeps returns a list of the sweep transactions our node has produced.
	// Note that these sweeps may not be confirmed yet, as we record sweeps on
	// broadcast, not confirmation.
	ListSweeps(ctx context.Context, in *ListSweepsRequest, opts ...grpc.CallOption) (*ListSweepsResponse, error)
	// lncli: `wallet labeltx`
	// LabelTransaction adds a label to a transaction. If the transaction already
	// has a label the call will fail unless the overwrite bool is set. This will
	// overwrite the existing transaction label. Labels must not be empty, and
	// cannot exceed 500 characters.
	LabelTransaction(ctx context.Context, in *LabelTransactionRequest, opts ...grpc.CallOption) (*LabelTransactionResponse, error)
	// lncli: `wallet psbt fund`
	// FundPsbt creates a fully populated PSBT that contains enough inputs to fund
	// the outputs specified in the template. There are three ways a user can
	// specify what we call the template (a list of inputs and outputs to use in
	// the PSBT): Either as a PSBT packet directly with no coin selection (using
	// the legacy "psbt" field), a PSBT with advanced coin selection support (using
	// the new "coin_select" field) or as a raw RPC message (using the "raw"
	// field).
	// The legacy "psbt" and "raw" modes, the following restrictions apply:
	// 1. If there are no inputs specified in the template, coin selection is
	// performed automatically.
	// 2. If the template does contain any inputs, it is assumed that full
	// coin selection happened externally and no additional inputs are added. If
	// the specified inputs aren't enough to fund the outputs with the given fee
	// rate, an error is returned.
	//
	// The new "coin_select" mode does not have these restrictions and allows the
	// user to specify a PSBT with inputs and outputs and still perform coin
	// selection on top of that.
	// For all modes this RPC requires any inputs that are specified to be locked
	// by the user (if they belong to this node in the first place).
	//
	// After either selecting or verifying the inputs, all input UTXOs are locked
	// with an internal app ID.
	//
	// NOTE: If this method returns without an error, it is the caller's
	// responsibility to either spend the locked UTXOs (by finalizing and then
	// publishing the transaction) or to unlock/release the locked UTXOs in case of
	// an error on the caller's side.
	FundPsbt(ctx context.Context, in *FundPsbtRequest, opts ...grpc.CallOption) (*FundPsbtResponse, error)
	// SignPsbt expects a partial transaction with all inputs and outputs fully
	// declared and tries to sign all unsigned inputs that have all required fields
	// (UTXO information, BIP32 derivation information, witness or sig scripts)
	// set.
	// If no error is returned, the PSBT is ready to be given to the next signer or
	// to be finalized if lnd was the last signer.
	//
	// NOTE: This RPC only signs inputs (and only those it can sign), it does not
	// perform any other tasks (such as coin selection, UTXO locking or
	// input/output/fee value validation, PSBT finalization). Any input that is
	// incomplete will be skipped.
	SignPsbt(ctx context.Context, in *SignPsbtRequest, opts ...grpc.CallOption) (*SignPsbtResponse, error)
	// lncli: `wallet psbt finalize`
	// FinalizePsbt expects a partial transaction with all inputs and outputs fully
	// declared and tries to sign all inputs that belong to the wallet. Lnd must be
	// the last signer of the transaction. That means, if there are any unsigned
	// non-witness inputs or inputs without UTXO information attached or inputs
	// without witness data that do not belong to lnd's wallet, this method will
	// fail. If no error is returned, the PSBT is ready to be extracted and the
	// final TX within to be broadcast.
	//
	// NOTE: This method does NOT publish the transaction once finalized. It is the
	// caller's responsibility to either publish the transaction on success or
	// unlock/release any locked UTXOs in case of an error in this method.
	FinalizePsbt(ctx context.Context, in *FinalizePsbtRequest, opts ...grpc.CallOption) (*FinalizePsbtResponse, error)
}

type walletKitClient struct {
	cc grpc.ClientConnInterface
}

func NewWalletKitClient(cc grpc.ClientConnInterface) WalletKitClient {
	return &walletKitClient{cc}
}

func (c *walletKitClient) ListUnspent(ctx context.Context, in *ListUnspentRequest, opts ...grpc.CallOption) (*ListUnspentResponse, error) {
	out := new(ListUnspentResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/ListUnspent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) LeaseOutput(ctx context.Context, in *LeaseOutputRequest, opts ...grpc.CallOption) (*LeaseOutputResponse, error) {
	out := new(LeaseOutputResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/LeaseOutput", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) ReleaseOutput(ctx context.Context, in *ReleaseOutputRequest, opts ...grpc.CallOption) (*ReleaseOutputResponse, error) {
	out := new(ReleaseOutputResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/ReleaseOutput", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) ListLeases(ctx context.Context, in *ListLeasesRequest, opts ...grpc.CallOption) (*ListLeasesResponse, error) {
	out := new(ListLeasesResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/ListLeases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) DeriveNextKey(ctx context.Context, in *KeyReq, opts ...grpc.CallOption) (*signrpc.KeyDescriptor, error) {
	out := new(signrpc.KeyDescriptor)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/DeriveNextKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) DeriveKey(ctx context.Context, in *signrpc.KeyLocator, opts ...grpc.CallOption) (*signrpc.KeyDescriptor, error) {
	out := new(signrpc.KeyDescriptor)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/DeriveKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) NextAddr(ctx context.Context, in *AddrRequest, opts ...grpc.CallOption) (*AddrResponse, error) {
	out := new(AddrResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/NextAddr", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) GetTransaction(ctx context.Context, in *GetTransactionRequest, opts ...grpc.CallOption) (*lnrpc.Transaction, error) {
	out := new(lnrpc.Transaction)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/GetTransaction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) ListAccounts(ctx context.Context, in *ListAccountsRequest, opts ...grpc.CallOption) (*ListAccountsResponse, error) {
	out := new(ListAccountsResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/ListAccounts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) RequiredReserve(ctx context.Context, in *RequiredReserveRequest, opts ...grpc.CallOption) (*RequiredReserveResponse, error) {
	out := new(RequiredReserveResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/RequiredReserve", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) ListAddresses(ctx context.Context, in *ListAddressesRequest, opts ...grpc.CallOption) (*ListAddressesResponse, error) {
	out := new(ListAddressesResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/ListAddresses", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) SignMessageWithAddr(ctx context.Context, in *SignMessageWithAddrRequest, opts ...grpc.CallOption) (*SignMessageWithAddrResponse, error) {
	out := new(SignMessageWithAddrResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/SignMessageWithAddr", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) VerifyMessageWithAddr(ctx context.Context, in *VerifyMessageWithAddrRequest, opts ...grpc.CallOption) (*VerifyMessageWithAddrResponse, error) {
	out := new(VerifyMessageWithAddrResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/VerifyMessageWithAddr", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) ImportAccount(ctx context.Context, in *ImportAccountRequest, opts ...grpc.CallOption) (*ImportAccountResponse, error) {
	out := new(ImportAccountResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/ImportAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) ImportPublicKey(ctx context.Context, in *ImportPublicKeyRequest, opts ...grpc.CallOption) (*ImportPublicKeyResponse, error) {
	out := new(ImportPublicKeyResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/ImportPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) ImportTapscript(ctx context.Context, in *ImportTapscriptRequest, opts ...grpc.CallOption) (*ImportTapscriptResponse, error) {
	out := new(ImportTapscriptResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/ImportTapscript", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) PublishTransaction(ctx context.Context, in *Transaction, opts ...grpc.CallOption) (*PublishResponse, error) {
	out := new(PublishResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/PublishTransaction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) RemoveTransaction(ctx context.Context, in *GetTransactionRequest, opts ...grpc.CallOption) (*RemoveTransactionResponse, error) {
	out := new(RemoveTransactionResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/RemoveTransaction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) SendOutputs(ctx context.Context, in *SendOutputsRequest, opts ...grpc.CallOption) (*SendOutputsResponse, error) {
	out := new(SendOutputsResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/SendOutputs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) EstimateFee(ctx context.Context, in *EstimateFeeRequest, opts ...grpc.CallOption) (*EstimateFeeResponse, error) {
	out := new(EstimateFeeResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/EstimateFee", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) PendingSweeps(ctx context.Context, in *PendingSweepsRequest, opts ...grpc.CallOption) (*PendingSweepsResponse, error) {
	out := new(PendingSweepsResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/PendingSweeps", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) BumpFee(ctx context.Context, in *BumpFeeRequest, opts ...grpc.CallOption) (*BumpFeeResponse, error) {
	out := new(BumpFeeResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/BumpFee", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) BumpForceCloseFee(ctx context.Context, in *BumpForceCloseFeeRequest, opts ...grpc.CallOption) (*BumpForceCloseFeeResponse, error) {
	out := new(BumpForceCloseFeeResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/BumpForceCloseFee", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) ListSweeps(ctx context.Context, in *ListSweepsRequest, opts ...grpc.CallOption) (*ListSweepsResponse, error) {
	out := new(ListSweepsResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/ListSweeps", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) LabelTransaction(ctx context.Context, in *LabelTransactionRequest, opts ...grpc.CallOption) (*LabelTransactionResponse, error) {
	out := new(LabelTransactionResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/LabelTransaction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) FundPsbt(ctx context.Context, in *FundPsbtRequest, opts ...grpc.CallOption) (*FundPsbtResponse, error) {
	out := new(FundPsbtResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/FundPsbt", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) SignPsbt(ctx context.Context, in *SignPsbtRequest, opts ...grpc.CallOption) (*SignPsbtResponse, error) {
	out := new(SignPsbtResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/SignPsbt", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *walletKitClient) FinalizePsbt(ctx context.Context, in *FinalizePsbtRequest, opts ...grpc.CallOption) (*FinalizePsbtResponse, error) {
	out := new(FinalizePsbtResponse)
	err := c.cc.Invoke(ctx, "/walletrpc.WalletKit/FinalizePsbt", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WalletKitServer is the server API for WalletKit service.
// All implementations must embed UnimplementedWalletKitServer
// for forward compatibility
type WalletKitServer interface {
	// ListUnspent returns a list of all utxos spendable by the wallet with a
	// number of confirmations between the specified minimum and maximum. By
	// default, all utxos are listed. To list only the unconfirmed utxos, set
	// the unconfirmed_only to true.
	ListUnspent(context.Context, *ListUnspentRequest) (*ListUnspentResponse, error)
	// lncli: `wallet leaseoutput`
	// LeaseOutput locks an output to the given ID, preventing it from being
	// available for any future coin selection attempts. The absolute time of the
	// lock's expiration is returned. The expiration of the lock can be extended by
	// successive invocations of this RPC. Outputs can be unlocked before their
	// expiration through `ReleaseOutput`.
	LeaseOutput(context.Context, *LeaseOutputRequest) (*LeaseOutputResponse, error)
	// lncli: `wallet releaseoutput`
	// ReleaseOutput unlocks an output, allowing it to be available for coin
	// selection if it remains unspent. The ID should match the one used to
	// originally lock the output.
	ReleaseOutput(context.Context, *ReleaseOutputRequest) (*ReleaseOutputResponse, error)
	// lncli: `wallet listleases`
	// ListLeases lists all currently locked utxos.
	ListLeases(context.Context, *ListLeasesRequest) (*ListLeasesResponse, error)
	// DeriveNextKey attempts to derive the *next* key within the key family
	// (account in BIP43) specified. This method should return the next external
	// child within this branch.
	DeriveNextKey(context.Context, *KeyReq) (*signrpc.KeyDescriptor, error)
	// DeriveKey attempts to derive an arbitrary key specified by the passed
	// KeyLocator.
	DeriveKey(context.Context, *signrpc.KeyLocator) (*signrpc.KeyDescriptor, error)
	// NextAddr returns the next unused address within the wallet.
	NextAddr(context.Context, *AddrRequest) (*AddrResponse, error)
	// lncli: `wallet gettx`
	// GetTransaction returns details for a transaction found in the wallet.
	GetTransaction(context.Context, *GetTransactionRequest) (*lnrpc.Transaction, error)
	// lncli: `wallet accounts list`
	// ListAccounts retrieves all accounts belonging to the wallet by default. A
	// name and key scope filter can be provided to filter through all of the
	// wallet accounts and return only those matching.
	ListAccounts(context.Context, *ListAccountsRequest) (*ListAccountsResponse, error)
	// lncli: `wallet requiredreserve`
	// RequiredReserve returns the minimum amount of satoshis that should be kept
	// in the wallet in order to fee bump anchor channels if necessary. The value
	// scales with the number of public anchor channels but is capped at a maximum.
	RequiredReserve(context.Context, *RequiredReserveRequest) (*RequiredReserveResponse, error)
	// lncli: `wallet addresses list`
	// ListAddresses retrieves all the addresses along with their balance. An
	// account name filter can be provided to filter through all of the
	// wallet accounts and return the addresses of only those matching.
	ListAddresses(context.Context, *ListAddressesRequest) (*ListAddressesResponse, error)
	// lncli: `wallet addresses signmessage`
	// SignMessageWithAddr returns the compact signature (base64 encoded) created
	// with the private key of the provided address. This requires the address
	// to be solely based on a public key lock (no scripts). Obviously the internal
	// lnd wallet has to possess the private key of the address otherwise
	// an error is returned.
	//
	// This method aims to provide full compatibility with the bitcoin-core and
	// btcd implementation. Bitcoin-core's algorithm is not specified in a
	// BIP and only applicable for legacy addresses. This method enhances the
	// signing for additional address types: P2WKH, NP2WKH, P2TR.
	// For P2TR addresses this represents a special case. ECDSA is used to create
	// a compact signature which makes the public key of the signature recoverable.
	SignMessageWithAddr(context.Context, *SignMessageWithAddrRequest) (*SignMessageWithAddrResponse, error)
	// lncli: `wallet addresses verifymessage`
	// VerifyMessageWithAddr returns the validity and the recovered public key of
	// the provided compact signature (base64 encoded). The verification is
	// twofold. First the validity of the signature itself is checked and then
	// it is verified that the recovered public key of the signature equals
	// the public key of the provided address. There is no dependence on the
	// private key of the address therefore also external addresses are allowed
	// to verify signatures.
	// Supported address types are P2PKH, P2WKH, NP2WKH, P2TR.
	//
	// This method is the counterpart of the related signing method
	// (SignMessageWithAddr) and aims to provide full compatibility to
	// bitcoin-core's implementation. Although bitcoin-core/btcd only provide
	// this functionality for legacy addresses this function enhances it to
	// the address types: P2PKH, P2WKH, NP2WKH, P2TR.
	//
	// The verification for P2TR addresses is a special case and requires the
	// ECDSA compact signature to compare the reovered public key to the internal
	// taproot key. The compact ECDSA signature format was used because there
	// are still no known compact signature schemes for schnorr signatures.
	VerifyMessageWithAddr(context.Context, *VerifyMessageWithAddrRequest) (*VerifyMessageWithAddrResponse, error)
	// lncli: `wallet accounts import`
	// ImportAccount imports an account backed by an account extended public key.
	// The master key fingerprint denotes the fingerprint of the root key
	// corresponding to the account public key (also known as the key with
	// derivation path m/). This may be required by some hardware wallets for
	// proper identification and signing.
	//
	// The address type can usually be inferred from the key's version, but may be
	// required for certain keys to map them into the proper scope.
	//
	// For BIP-0044 keys, an address type must be specified as we intend to not
	// support importing BIP-0044 keys into the wallet using the legacy
	// pay-to-pubkey-hash (P2PKH) scheme. A nested witness address type will force
	// the standard BIP-0049 derivation scheme, while a witness address type will
	// force the standard BIP-0084 derivation scheme.
	//
	// For BIP-0049 keys, an address type must also be specified to make a
	// distinction between the standard BIP-0049 address schema (nested witness
	// pubkeys everywhere) and our own BIP-0049Plus address schema (nested pubkeys
	// externally, witness pubkeys internally).
	//
	// NOTE: Events (deposits/spends) for keys derived from an account will only be
	// detected by lnd if they happen after the import. Rescans to detect past
	// events will be supported later on.
	ImportAccount(context.Context, *ImportAccountRequest) (*ImportAccountResponse, error)
	// lncli: `wallet accounts import-pubkey`
	// ImportPublicKey imports a public key as watch-only into the wallet. The
	// public key is converted into a simple address of the given type and that
	// address script is watched on chain. For Taproot keys, this will only watch
	// the BIP-0086 style output script. Use ImportTapscript for more advanced key
	// spend or script spend outputs.
	//
	// NOTE: Events (deposits/spends) for a key will only be detected by lnd if
	// they happen after the import. Rescans to detect past events will be
	// supported later on.
	ImportPublicKey(context.Context, *ImportPublicKeyRequest) (*ImportPublicKeyResponse, error)
	// ImportTapscript imports a Taproot script and internal key and adds the
	// resulting Taproot output key as a watch-only output script into the wallet.
	// For BIP-0086 style Taproot keys (no root hash commitment and no script spend
	// path) use ImportPublicKey.
	//
	// NOTE: Events (deposits/spends) for a key will only be detected by lnd if
	// they happen after the import. Rescans to detect past events will be
	// supported later on.
	//
	// NOTE: Taproot keys imported through this RPC currently _cannot_ be used for
	// funding PSBTs. Only tracking the balance and UTXOs is currently supported.
	ImportTapscript(context.Context, *ImportTapscriptRequest) (*ImportTapscriptResponse, error)
	// lncli: `wallet publishtx`
	// PublishTransaction attempts to publish the passed transaction to the
	// network. Once this returns without an error, the wallet will continually
	// attempt to re-broadcast the transaction on start up, until it enters the
	// chain.
	PublishTransaction(context.Context, *Transaction) (*PublishResponse, error)
	// lncli: `wallet removetx`
	// RemoveTransaction attempts to remove the provided transaction from the
	// internal transaction store of the wallet.
	RemoveTransaction(context.Context, *GetTransactionRequest) (*RemoveTransactionResponse, error)
	// SendOutputs is similar to the existing sendmany call in Bitcoind, and
	// allows the caller to create a transaction that sends to several outputs at
	// once. This is ideal when wanting to batch create a set of transactions.
	SendOutputs(context.Context, *SendOutputsRequest) (*SendOutputsResponse, error)
	// lncli: `wallet estimatefeerate`
	// EstimateFee attempts to query the internal fee estimator of the wallet to
	// determine the fee (in sat/kw) to attach to a transaction in order to
	// achieve the confirmation target.
	EstimateFee(context.Context, *EstimateFeeRequest) (*EstimateFeeResponse, error)
	// lncli: `wallet pendingsweeps`
	// PendingSweeps returns lists of on-chain outputs that lnd is currently
	// attempting to sweep within its central batching engine. Outputs with similar
	// fee rates are batched together in order to sweep them within a single
	// transaction.
	//
	// NOTE: Some of the fields within PendingSweepsRequest are not guaranteed to
	// remain supported. This is an advanced API that depends on the internals of
	// the UtxoSweeper, so things may change.
	PendingSweeps(context.Context, *PendingSweepsRequest) (*PendingSweepsResponse, error)
	// lncli: `wallet bumpfee`
	// BumpFee is an endpoint that allows users to interact with lnd's sweeper
	// directly. It takes an outpoint from an unconfirmed transaction and sends it
	// to the sweeper for potential fee bumping. Depending on whether the outpoint
	// has been registered in the sweeper (an existing input, e.g., an anchor
	// output) or not (a new input, e.g., an unconfirmed wallet utxo), this will
	// either be an RBF or CPFP attempt.
	//
	// When receiving an input, lnd’s sweeper needs to understand its time
	// sensitivity to make economical fee bumps - internally a fee function is
	// created using the deadline and budget to guide the process. When the
	// deadline is approaching, the fee function will increase the fee rate and
	// perform an RBF.
	//
	// When a force close happens, all the outputs from the force closing
	// transaction will be registered in the sweeper. The sweeper will then handle
	// the creation, publish, and fee bumping of the sweeping transactions.
	// Everytime a new block comes in, unless the sweeping transaction is
	// confirmed, an RBF is attempted. To interfere with this automatic process,
	// users can use BumpFee to specify customized fee rate, budget, deadline, and
	// whether the sweep should happen immediately. It's recommended to call
	// `ListSweeps` to understand the shape of the existing sweeping transaction
	// first - depending on the number of inputs in this transaction, the RBF
	// requirements can be quite different.
	//
	// This RPC also serves useful when wanting to perform a Child-Pays-For-Parent
	// (CPFP), where the child transaction pays for its parent's fee. This can be
	// done by specifying an outpoint within the low fee transaction that is under
	// the control of the wallet.
	BumpFee(context.Context, *BumpFeeRequest) (*BumpFeeResponse, error)
	// lncli: `wallet bumpforceclosefee`
	// BumpForceCloseFee is an endpoint that allows users to bump the fee of a
	// channel force close. This only works for channels with option_anchors.
	BumpForceCloseFee(context.Context, *BumpForceCloseFeeRequest) (*BumpForceCloseFeeResponse, error)
	// lncli: `wallet listsweeps`
	// ListSweeps returns a list of the sweep transactions our node has produced.
	// Note that these sweeps may not be confirmed yet, as we record sweeps on
	// broadcast, not confirmation.
	ListSweeps(context.Context, *ListSweepsRequest) (*ListSweepsResponse, error)
	// lncli: `wallet labeltx`
	// LabelTransaction adds a label to a transaction. If the transaction already
	// has a label the call will fail unless the overwrite bool is set. This will
	// overwrite the existing transaction label. Labels must not be empty, and
	// cannot exceed 500 characters.
	LabelTransaction(context.Context, *LabelTransactionRequest) (*LabelTransactionResponse, error)
	// lncli: `wallet psbt fund`
	// FundPsbt creates a fully populated PSBT that contains enough inputs to fund
	// the outputs specified in the template. There are three ways a user can
	// specify what we call the template (a list of inputs and outputs to use in
	// the PSBT): Either as a PSBT packet directly with no coin selection (using
	// the legacy "psbt" field), a PSBT with advanced coin selection support (using
	// the new "coin_select" field) or as a raw RPC message (using the "raw"
	// field).
	// The legacy "psbt" and "raw" modes, the following restrictions apply:
	// 1. If there are no inputs specified in the template, coin selection is
	// performed automatically.
	// 2. If the template does contain any inputs, it is assumed that full
	// coin selection happened externally and no additional inputs are added. If
	// the specified inputs aren't enough to fund the outputs with the given fee
	// rate, an error is returned.
	//
	// The new "coin_select" mode does not have these restrictions and allows the
	// user to specify a PSBT with inputs and outputs and still perform coin
	// selection on top of that.
	// For all modes this RPC requires any inputs that are specified to be locked
	// by the user (if they belong to this node in the first place).
	//
	// After either selecting or verifying the inputs, all input UTXOs are locked
	// with an internal app ID.
	//
	// NOTE: If this method returns without an error, it is the caller's
	// responsibility to either spend the locked UTXOs (by finalizing and then
	// publishing the transaction) or to unlock/release the locked UTXOs in case of
	// an error on the caller's side.
	FundPsbt(context.Context, *FundPsbtRequest) (*FundPsbtResponse, error)
	// SignPsbt expects a partial transaction with all inputs and outputs fully
	// declared and tries to sign all unsigned inputs that have all required fields
	// (UTXO information, BIP32 derivation information, witness or sig scripts)
	// set.
	// If no error is returned, the PSBT is ready to be given to the next signer or
	// to be finalized if lnd was the last signer.
	//
	// NOTE: This RPC only signs inputs (and only those it can sign), it does not
	// perform any other tasks (such as coin selection, UTXO locking or
	// input/output/fee value validation, PSBT finalization). Any input that is
	// incomplete will be skipped.
	SignPsbt(context.Context, *SignPsbtRequest) (*SignPsbtResponse, error)
	// lncli: `wallet psbt finalize`
	// FinalizePsbt expects a partial transaction with all inputs and outputs fully
	// declared and tries to sign all inputs that belong to the wallet. Lnd must be
	// the last signer of the transaction. That means, if there are any unsigned
	// non-witness inputs or inputs without UTXO information attached or inputs
	// without witness data that do not belong to lnd's wallet, this method will
	// fail. If no error is returned, the PSBT is ready to be extracted and the
	// final TX within to be broadcast.
	//
	// NOTE: This method does NOT publish the transaction once finalized. It is the
	// caller's responsibility to either publish the transaction on success or
	// unlock/release any locked UTXOs in case of an error in this method.
	FinalizePsbt(context.Context, *FinalizePsbtRequest) (*FinalizePsbtResponse, error)
	mustEmbedUnimplementedWalletKitServer()
}

// UnimplementedWalletKitServer must be embedded to have forward compatible implementations.
type UnimplementedWalletKitServer struct {
}

func (UnimplementedWalletKitServer) ListUnspent(context.Context, *ListUnspentRequest) (*ListUnspentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUnspent not implemented")
}
func (UnimplementedWalletKitServer) LeaseOutput(context.Context, *LeaseOutputRequest) (*LeaseOutputResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LeaseOutput not implemented")
}
func (UnimplementedWalletKitServer) ReleaseOutput(context.Context, *ReleaseOutputRequest) (*ReleaseOutputResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReleaseOutput not implemented")
}
func (UnimplementedWalletKitServer) ListLeases(context.Context, *ListLeasesRequest) (*ListLeasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLeases not implemented")
}
func (UnimplementedWalletKitServer) DeriveNextKey(context.Context, *KeyReq) (*signrpc.KeyDescriptor, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeriveNextKey not implemented")
}
func (UnimplementedWalletKitServer) DeriveKey(context.Context, *signrpc.KeyLocator) (*signrpc.KeyDescriptor, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeriveKey not implemented")
}
func (UnimplementedWalletKitServer) NextAddr(context.Context, *AddrRequest) (*AddrResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NextAddr not implemented")
}
func (UnimplementedWalletKitServer) GetTransaction(context.Context, *GetTransactionRequest) (*lnrpc.Transaction, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTransaction not implemented")
}
func (UnimplementedWalletKitServer) ListAccounts(context.Context, *ListAccountsRequest) (*ListAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccounts not implemented")
}
func (UnimplementedWalletKitServer) RequiredReserve(context.Context, *RequiredReserveRequest) (*RequiredReserveResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RequiredReserve not implemented")
}
func (UnimplementedWalletKitServer) ListAddresses(context.Context, *ListAddressesRequest) (*ListAddressesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAddresses not implemented")
}
func (UnimplementedWalletKitServer) SignMessageWithAddr(context.Context, *SignMessageWithAddrRequest) (*SignMessageWithAddrResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SignMessageWithAddr not implemented")
}
func (UnimplementedWalletKitServer) VerifyMessageWithAddr(context.Context, *VerifyMessageWithAddrRequest) (*VerifyMessageWithAddrResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method VerifyMessageWithAddr not implemented")
}
func (UnimplementedWalletKitServer) ImportAccount(context.Context, *ImportAccountRequest) (*ImportAccountResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportAccount not implemented")
}
func (UnimplementedWalletKitServer) ImportPublicKey(context.Context, *ImportPublicKeyRequest) (*ImportPublicKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportPublicKey not implemented")
}
func (UnimplementedWalletKitServer) ImportTapscript(context.Context, *ImportTapscriptRequest) (*ImportTapscriptResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportTapscript not implemented")
}
func (UnimplementedWalletKitServer) PublishTransaction(context.Context, *Transaction) (*PublishResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PublishTransaction not implemented")
}
func (UnimplementedWalletKitServer) RemoveTransaction(context.Context, *GetTransactionRequest) (*RemoveTransactionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveTransaction not implemented")
}
func (UnimplementedWalletKitServer) SendOutputs(context.Context, *SendOutputsRequest) (*SendOutputsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendOutputs not implemented")
}
func (UnimplementedWalletKitServer) EstimateFee(context.Context, *EstimateFeeRequest) (*EstimateFeeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EstimateFee not implemented")
}
func (UnimplementedWalletKitServer) PendingSweeps(context.Context, *PendingSweepsRequest) (*PendingSweepsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PendingSweeps not implemented")
}
func (UnimplementedWalletKitServer) BumpFee(context.Context, *BumpFeeRequest) (*BumpFeeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BumpFee not implemented")
}
func (UnimplementedWalletKitServer) BumpForceCloseFee(context.Context, *BumpForceCloseFeeRequest) (*BumpForceCloseFeeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BumpForceCloseFee not implemented")
}
func (UnimplementedWalletKitServer) ListSweeps(context.Context, *ListSweepsRequest) (*ListSweepsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSweeps not implemented")
}
func (UnimplementedWalletKitServer) LabelTransaction(context.Context, *LabelTransactionRequest) (*LabelTransactionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LabelTransaction not implemented")
}
func (UnimplementedWalletKitServer) FundPsbt(context.Context, *FundPsbtRequest) (*FundPsbtResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FundPsbt not implemented")
}
func (UnimplementedWalletKitServer) SignPsbt(context.Context, *SignPsbtRequest) (*SignPsbtResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SignPsbt not implemented")
}
func (UnimplementedWalletKitServer) FinalizePsbt(context.Context, *FinalizePsbtRequest) (*FinalizePsbtResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FinalizePsbt not implemented")
}
func (UnimplementedWalletKitServer) mustEmbedUnimplementedWalletKitServer() {}

// UnsafeWalletKitServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to WalletKitServer will
// result in compilation errors.
type UnsafeWalletKitServer interface {
	mustEmbedUnimplementedWalletKitServer()
}

func RegisterWalletKitServer(s grpc.ServiceRegistrar, srv WalletKitServer) {
	s.RegisterService(&WalletKit_ServiceDesc, srv)
}

func _WalletKit_ListUnspent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUnspentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).ListUnspent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/ListUnspent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).ListUnspent(ctx, req.(*ListUnspentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_LeaseOutput_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LeaseOutputRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).LeaseOutput(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/LeaseOutput",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).LeaseOutput(ctx, req.(*LeaseOutputRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_ReleaseOutput_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReleaseOutputRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).ReleaseOutput(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/ReleaseOutput",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).ReleaseOutput(ctx, req.(*ReleaseOutputRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_ListLeases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLeasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).ListLeases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/ListLeases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).ListLeases(ctx, req.(*ListLeasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_DeriveNextKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KeyReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).DeriveNextKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/DeriveNextKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).DeriveNextKey(ctx, req.(*KeyReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_DeriveKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(signrpc.KeyLocator)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).DeriveKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/DeriveKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).DeriveKey(ctx, req.(*signrpc.KeyLocator))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_NextAddr_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddrRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).NextAddr(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/NextAddr",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).NextAddr(ctx, req.(*AddrRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_GetTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).GetTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/GetTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).GetTransaction(ctx, req.(*GetTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_ListAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).ListAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/ListAccounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).ListAccounts(ctx, req.(*ListAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_RequiredReserve_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RequiredReserveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).RequiredReserve(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/RequiredReserve",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).RequiredReserve(ctx, req.(*RequiredReserveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_ListAddresses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAddressesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).ListAddresses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/ListAddresses",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).ListAddresses(ctx, req.(*ListAddressesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_SignMessageWithAddr_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignMessageWithAddrRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).SignMessageWithAddr(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/SignMessageWithAddr",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).SignMessageWithAddr(ctx, req.(*SignMessageWithAddrRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_VerifyMessageWithAddr_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VerifyMessageWithAddrRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).VerifyMessageWithAddr(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/VerifyMessageWithAddr",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).VerifyMessageWithAddr(ctx, req.(*VerifyMessageWithAddrRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_ImportAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).ImportAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/ImportAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).ImportAccount(ctx, req.(*ImportAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_ImportPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).ImportPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/ImportPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).ImportPublicKey(ctx, req.(*ImportPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_ImportTapscript_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportTapscriptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).ImportTapscript(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/ImportTapscript",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).ImportTapscript(ctx, req.(*ImportTapscriptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_PublishTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Transaction)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).PublishTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/PublishTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).PublishTransaction(ctx, req.(*Transaction))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_RemoveTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).RemoveTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/RemoveTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).RemoveTransaction(ctx, req.(*GetTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_SendOutputs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendOutputsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).SendOutputs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/SendOutputs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).SendOutputs(ctx, req.(*SendOutputsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_EstimateFee_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EstimateFeeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).EstimateFee(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/EstimateFee",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).EstimateFee(ctx, req.(*EstimateFeeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_PendingSweeps_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PendingSweepsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).PendingSweeps(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/PendingSweeps",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).PendingSweeps(ctx, req.(*PendingSweepsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_BumpFee_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BumpFeeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).BumpFee(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/BumpFee",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).BumpFee(ctx, req.(*BumpFeeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_BumpForceCloseFee_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BumpForceCloseFeeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).BumpForceCloseFee(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/BumpForceCloseFee",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).BumpForceCloseFee(ctx, req.(*BumpForceCloseFeeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_ListSweeps_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSweepsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).ListSweeps(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/ListSweeps",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).ListSweeps(ctx, req.(*ListSweepsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_LabelTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).LabelTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/LabelTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).LabelTransaction(ctx, req.(*LabelTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_FundPsbt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FundPsbtRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).FundPsbt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/FundPsbt",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).FundPsbt(ctx, req.(*FundPsbtRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_SignPsbt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignPsbtRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).SignPsbt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/SignPsbt",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).SignPsbt(ctx, req.(*SignPsbtRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WalletKit_FinalizePsbt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinalizePsbtRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WalletKitServer).FinalizePsbt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/walletrpc.WalletKit/FinalizePsbt",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WalletKitServer).FinalizePsbt(ctx, req.(*FinalizePsbtRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// WalletKit_ServiceDesc is the grpc.ServiceDesc for WalletKit service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var WalletKit_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "walletrpc.WalletKit",
	HandlerType: (*WalletKitServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListUnspent",
			Handler:    _WalletKit_ListUnspent_Handler,
		},
		{
			MethodName: "LeaseOutput",
			Handler:    _WalletKit_LeaseOutput_Handler,
		},
		{
			MethodName: "ReleaseOutput",
			Handler:    _WalletKit_ReleaseOutput_Handler,
		},
		{
			MethodName: "ListLeases",
			Handler:    _WalletKit_ListLeases_Handler,
		},
		{
			MethodName: "DeriveNextKey",
			Handler:    _WalletKit_DeriveNextKey_Handler,
		},
		{
			MethodName: "DeriveKey",
			Handler:    _WalletKit_DeriveKey_Handler,
		},
		{
			MethodName: "NextAddr",
			Handler:    _WalletKit_NextAddr_Handler,
		},
		{
			MethodName: "GetTransaction",
			Handler:    _WalletKit_GetTransaction_Handler,
		},
		{
			MethodName: "ListAccounts",
			Handler:    _WalletKit_ListAccounts_Handler,
		},
		{
			MethodName: "RequiredReserve",
			Handler:    _WalletKit_RequiredReserve_Handler,
		},
		{
			MethodName: "ListAddresses",
			Handler:    _WalletKit_ListAddresses_Handler,
		},
		{
			MethodName: "SignMessageWithAddr",
			Handler:    _WalletKit_SignMessageWithAddr_Handler,
		},
		{
			MethodName: "VerifyMessageWithAddr",
			Handler:    _WalletKit_VerifyMessageWithAddr_Handler,
		},
		{
			MethodName: "ImportAccount",
			Handler:    _WalletKit_ImportAccount_Handler,
		},
		{
			MethodName: "ImportPublicKey",
			Handler:    _WalletKit_ImportPublicKey_Handler,
		},
		{
			MethodName: "ImportTapscript",
			Handler:    _WalletKit_ImportTapscript_Handler,
		},
		{
			MethodName: "PublishTransaction",
			Handler:    _WalletKit_PublishTransaction_Handler,
		},
		{
			MethodName: "RemoveTransaction",
			Handler:    _WalletKit_RemoveTransaction_Handler,
		},
		{
			MethodName: "SendOutputs",
			Handler:    _WalletKit_SendOutputs_Handler,
		},
		{
			MethodName: "EstimateFee",
			Handler:    _WalletKit_EstimateFee_Handler,
		},
		{
			MethodName: "PendingSweeps",
			Handler:    _WalletKit_PendingSweeps_Handler,
		},
		{
			MethodName: "BumpFee",
			Handler:    _WalletKit_BumpFee_Handler,
		},
		{
			MethodName: "BumpForceCloseFee",
			Handler:    _WalletKit_BumpForceCloseFee_Handler,
		},
		{
			MethodName: "ListSweeps",
			Handler:    _WalletKit_ListSweeps_Handler,
		},
		{
			MethodName: "LabelTransaction",
			Handler:    _WalletKit_LabelTransaction_Handler,
		},
		{
			MethodName: "FundPsbt",
			Handler:    _WalletKit_FundPsbt_Handler,
		},
		{
			MethodName: "SignPsbt",
			Handler:    _WalletKit_SignPsbt_Handler,
		},
		{
			MethodName: "FinalizePsbt",
			Handler:    _WalletKit_FinalizePsbt_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "walletrpc/walletkit.proto",
}
