// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v3.21.12
// source: walletrpc/walletkit.proto

package walletrpc

import (
	lnrpc "github.com/lightningnetwork/lnd/lnrpc"
	signrpc "github.com/lightningnetwork/lnd/lnrpc/signrpc"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type AddressType int32

const (
	AddressType_UNKNOWN                           AddressType = 0
	AddressType_WITNESS_PUBKEY_HASH               AddressType = 1
	AddressType_NESTED_WITNESS_PUBKEY_HASH        AddressType = 2
	AddressType_HYBRID_NESTED_WITNESS_PUBKEY_HASH AddressType = 3
	AddressType_TAPROOT_PUBKEY                    AddressType = 4
)

// Enum value maps for AddressType.
var (
	AddressType_name = map[int32]string{
		0: "UNKNOWN",
		1: "WITNESS_PUBKEY_HASH",
		2: "NESTED_WITNESS_PUBKEY_HASH",
		3: "HYBRID_NESTED_WITNESS_PUBKEY_HASH",
		4: "TAPROOT_PUBKEY",
	}
	AddressType_value = map[string]int32{
		"UNKNOWN":                           0,
		"WITNESS_PUBKEY_HASH":               1,
		"NESTED_WITNESS_PUBKEY_HASH":        2,
		"HYBRID_NESTED_WITNESS_PUBKEY_HASH": 3,
		"TAPROOT_PUBKEY":                    4,
	}
)

func (x AddressType) Enum() *AddressType {
	p := new(AddressType)
	*p = x
	return p
}

func (x AddressType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AddressType) Descriptor() protoreflect.EnumDescriptor {
	return file_walletrpc_walletkit_proto_enumTypes[0].Descriptor()
}

func (AddressType) Type() protoreflect.EnumType {
	return &file_walletrpc_walletkit_proto_enumTypes[0]
}

func (x AddressType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AddressType.Descriptor instead.
func (AddressType) EnumDescriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{0}
}

type WitnessType int32

const (
	WitnessType_UNKNOWN_WITNESS WitnessType = 0
	// A witness that allows us to spend the output of a commitment transaction
	// after a relative lock-time lockout.
	WitnessType_COMMITMENT_TIME_LOCK WitnessType = 1
	// A witness that allows us to spend a settled no-delay output immediately on a
	// counterparty's commitment transaction.
	WitnessType_COMMITMENT_NO_DELAY WitnessType = 2
	// A witness that allows us to sweep the settled output of a malicious
	// counterparty's who broadcasts a revoked commitment transaction.
	WitnessType_COMMITMENT_REVOKE WitnessType = 3
	// A witness that allows us to sweep an HTLC which we offered to the remote
	// party in the case that they broadcast a revoked commitment state.
	WitnessType_HTLC_OFFERED_REVOKE WitnessType = 4
	// A witness that allows us to sweep an HTLC output sent to us in the case that
	// the remote party broadcasts a revoked commitment state.
	WitnessType_HTLC_ACCEPTED_REVOKE WitnessType = 5
	// A witness that allows us to sweep an HTLC output that we extended to a
	// party, but was never fulfilled.  This HTLC output isn't directly on the
	// commitment transaction, but is the result of a confirmed second-level HTLC
	// transaction. As a result, we can only spend this after a CSV delay.
	WitnessType_HTLC_OFFERED_TIMEOUT_SECOND_LEVEL WitnessType = 6
	// A witness that allows us to sweep an HTLC output that was offered to us, and
	// for which we have a payment preimage. This HTLC output isn't directly on our
	// commitment transaction, but is the result of confirmed second-level HTLC
	// transaction. As a result, we can only spend this after a CSV delay.
	WitnessType_HTLC_ACCEPTED_SUCCESS_SECOND_LEVEL WitnessType = 7
	// A witness that allows us to sweep an HTLC that we offered to the remote
	// party which lies in the commitment transaction of the remote party. We can
	// spend this output after the absolute CLTV timeout of the HTLC as passed.
	WitnessType_HTLC_OFFERED_REMOTE_TIMEOUT WitnessType = 8
	// A witness that allows us to sweep an HTLC that was offered to us by the
	// remote party. We use this witness in the case that the remote party goes to
	// chain, and we know the pre-image to the HTLC. We can sweep this without any
	// additional timeout.
	WitnessType_HTLC_ACCEPTED_REMOTE_SUCCESS WitnessType = 9
	// A witness that allows us to sweep an HTLC from the remote party's commitment
	// transaction in the case that the broadcast a revoked commitment, but then
	// also immediately attempt to go to the second level to claim the HTLC.
	WitnessType_HTLC_SECOND_LEVEL_REVOKE WitnessType = 10
	// A witness type that allows us to spend a regular p2wkh output that's sent to
	// an output which is under complete control of the backing wallet.
	WitnessType_WITNESS_KEY_HASH WitnessType = 11
	// A witness type that allows us to sweep an output that sends to a nested P2SH
	// script that pays to a key solely under our control.
	WitnessType_NESTED_WITNESS_KEY_HASH WitnessType = 12
	// A witness type that allows us to spend our anchor on the commitment
	// transaction.
	WitnessType_COMMITMENT_ANCHOR WitnessType = 13
	// A witness type that is similar to the COMMITMENT_NO_DELAY type,
	// but it omits the tweak that randomizes the key we need to
	// spend with a channel peer supplied set of randomness.
	WitnessType_COMMITMENT_NO_DELAY_TWEAKLESS WitnessType = 14
	// A witness type that allows us to spend our output on the counterparty's
	// commitment transaction after a confirmation.
	WitnessType_COMMITMENT_TO_REMOTE_CONFIRMED WitnessType = 15
	// A witness type that allows us to sweep an HTLC output that we extended
	// to a party, but was never fulfilled. This _is_ the HTLC output directly
	// on our commitment transaction, and the input to the second-level HTLC
	// timeout transaction. It can only be spent after CLTV expiry, and
	// commitment confirmation.
	WitnessType_HTLC_OFFERED_TIMEOUT_SECOND_LEVEL_INPUT_CONFIRMED WitnessType = 16
	// A witness type that allows us to sweep an HTLC output that was offered
	// to us, and for which we have a payment preimage. This _is_ the HTLC
	// output directly on our commitment transaction, and the input to the
	// second-level HTLC success transaction. It can only be spent after the
	// commitment has confirmed.
	WitnessType_HTLC_ACCEPTED_SUCCESS_SECOND_LEVEL_INPUT_CONFIRMED WitnessType = 17
	// A witness type that allows us to spend our output on our local
	// commitment transaction after a relative and absolute lock-time lockout as
	// part of the script enforced lease commitment type.
	WitnessType_LEASE_COMMITMENT_TIME_LOCK WitnessType = 18
	// A witness type that allows us to spend our output on the counterparty's
	// commitment transaction after a confirmation and absolute locktime as part
	// of the script enforced lease commitment type.
	WitnessType_LEASE_COMMITMENT_TO_REMOTE_CONFIRMED WitnessType = 19
	// A witness type that allows us to sweep an HTLC output that we extended
	// to a party, but was never fulfilled. This HTLC output isn't directly on
	// the commitment transaction, but is the result of a confirmed second-level
	// HTLC transaction. As a result, we can only spend this after a CSV delay
	// and CLTV locktime as part of the script enforced lease commitment type.
	WitnessType_LEASE_HTLC_OFFERED_TIMEOUT_SECOND_LEVEL WitnessType = 20
	// A witness type that allows us to sweep an HTLC output that was offered
	// to us, and for which we have a payment preimage. This HTLC output isn't
	// directly on our commitment transaction, but is the result of confirmed
	// second-level HTLC transaction. As a result, we can only spend this after
	// a CSV delay and CLTV locktime as part of the script enforced lease
	// commitment type.
	WitnessType_LEASE_HTLC_ACCEPTED_SUCCESS_SECOND_LEVEL WitnessType = 21
	// A witness type that allows us to spend a regular p2tr output that's sent
	// to an output which is under complete control of the backing wallet.
	WitnessType_TAPROOT_PUB_KEY_SPEND WitnessType = 22
	// A witness type that allows us to spend our settled local commitment after a
	// CSV delay when we force close the channel.
	WitnessType_TAPROOT_LOCAL_COMMIT_SPEND WitnessType = 23
	// A witness type that allows us to spend our settled local commitment after
	// a CSV delay when the remote party has force closed the channel.
	WitnessType_TAPROOT_REMOTE_COMMIT_SPEND WitnessType = 24
	// A witness type that we'll use for spending our own anchor output.
	WitnessType_TAPROOT_ANCHOR_SWEEP_SPEND WitnessType = 25
	// A witness that allows us to timeout an HTLC we offered to the remote party
	// on our commitment transaction. We use this when we need to go on chain to
	// time out an HTLC.
	WitnessType_TAPROOT_HTLC_OFFERED_TIMEOUT_SECOND_LEVEL WitnessType = 26
	// A witness type that allows us to sweep an HTLC we accepted on our commitment
	// transaction after we go to the second level on chain.
	WitnessType_TAPROOT_HTLC_ACCEPTED_SUCCESS_SECOND_LEVEL WitnessType = 27
	// A witness that allows us to sweep an HTLC on the revoked transaction of the
	// remote party that goes to the second level.
	WitnessType_TAPROOT_HTLC_SECOND_LEVEL_REVOKE WitnessType = 28
	// A witness that allows us to sweep an HTLC sent to us by the remote party
	// in the event that they broadcast a revoked state.
	WitnessType_TAPROOT_HTLC_ACCEPTED_REVOKE WitnessType = 29
	// A witness that allows us to sweep an HTLC we offered to the remote party if
	// they broadcast a revoked commitment.
	WitnessType_TAPROOT_HTLC_OFFERED_REVOKE WitnessType = 30
	// A witness that allows us to sweep an HTLC we offered to the remote party
	// that lies on the commitment transaction for the remote party. We can spend
	// this output after the absolute CLTV timeout of the HTLC as passed.
	WitnessType_TAPROOT_HTLC_OFFERED_REMOTE_TIMEOUT WitnessType = 31
	// A witness type that allows us to sign the second level HTLC timeout
	// transaction when spending from an HTLC residing on our local commitment
	// transaction.
	// This is used by the sweeper to re-sign inputs if it needs to aggregate
	// several second level HTLCs.
	WitnessType_TAPROOT_HTLC_LOCAL_OFFERED_TIMEOUT WitnessType = 32
	// A witness that allows us to sweep an HTLC that was offered to us by the
	// remote party for a taproot channels. We use this witness in the case that
	// the remote party goes to chain, and we know the pre-image to the HTLC. We
	// can sweep this without any additional timeout.
	WitnessType_TAPROOT_HTLC_ACCEPTED_REMOTE_SUCCESS WitnessType = 33
	// A witness type that allows us to sweep the HTLC offered to us on our local
	// commitment transaction. We'll use this when we need to go on chain to sweep
	// the HTLC. In this case, this is the second level HTLC success transaction.
	WitnessType_TAPROOT_HTLC_ACCEPTED_LOCAL_SUCCESS WitnessType = 34
	// A witness that allows us to sweep the settled output of a malicious
	// counterparty's who broadcasts a revoked taproot commitment transaction.
	WitnessType_TAPROOT_COMMITMENT_REVOKE WitnessType = 35
)

// Enum value maps for WitnessType.
var (
	WitnessType_name = map[int32]string{
		0:  "UNKNOWN_WITNESS",
		1:  "COMMITMENT_TIME_LOCK",
		2:  "COMMITMENT_NO_DELAY",
		3:  "COMMITMENT_REVOKE",
		4:  "HTLC_OFFERED_REVOKE",
		5:  "HTLC_ACCEPTED_REVOKE",
		6:  "HTLC_OFFERED_TIMEOUT_SECOND_LEVEL",
		7:  "HTLC_ACCEPTED_SUCCESS_SECOND_LEVEL",
		8:  "HTLC_OFFERED_REMOTE_TIMEOUT",
		9:  "HTLC_ACCEPTED_REMOTE_SUCCESS",
		10: "HTLC_SECOND_LEVEL_REVOKE",
		11: "WITNESS_KEY_HASH",
		12: "NESTED_WITNESS_KEY_HASH",
		13: "COMMITMENT_ANCHOR",
		14: "COMMITMENT_NO_DELAY_TWEAKLESS",
		15: "COMMITMENT_TO_REMOTE_CONFIRMED",
		16: "HTLC_OFFERED_TIMEOUT_SECOND_LEVEL_INPUT_CONFIRMED",
		17: "HTLC_ACCEPTED_SUCCESS_SECOND_LEVEL_INPUT_CONFIRMED",
		18: "LEASE_COMMITMENT_TIME_LOCK",
		19: "LEASE_COMMITMENT_TO_REMOTE_CONFIRMED",
		20: "LEASE_HTLC_OFFERED_TIMEOUT_SECOND_LEVEL",
		21: "LEASE_HTLC_ACCEPTED_SUCCESS_SECOND_LEVEL",
		22: "TAPROOT_PUB_KEY_SPEND",
		23: "TAPROOT_LOCAL_COMMIT_SPEND",
		24: "TAPROOT_REMOTE_COMMIT_SPEND",
		25: "TAPROOT_ANCHOR_SWEEP_SPEND",
		26: "TAPROOT_HTLC_OFFERED_TIMEOUT_SECOND_LEVEL",
		27: "TAPROOT_HTLC_ACCEPTED_SUCCESS_SECOND_LEVEL",
		28: "TAPROOT_HTLC_SECOND_LEVEL_REVOKE",
		29: "TAPROOT_HTLC_ACCEPTED_REVOKE",
		30: "TAPROOT_HTLC_OFFERED_REVOKE",
		31: "TAPROOT_HTLC_OFFERED_REMOTE_TIMEOUT",
		32: "TAPROOT_HTLC_LOCAL_OFFERED_TIMEOUT",
		33: "TAPROOT_HTLC_ACCEPTED_REMOTE_SUCCESS",
		34: "TAPROOT_HTLC_ACCEPTED_LOCAL_SUCCESS",
		35: "TAPROOT_COMMITMENT_REVOKE",
	}
	WitnessType_value = map[string]int32{
		"UNKNOWN_WITNESS":                                    0,
		"COMMITMENT_TIME_LOCK":                               1,
		"COMMITMENT_NO_DELAY":                                2,
		"COMMITMENT_REVOKE":                                  3,
		"HTLC_OFFERED_REVOKE":                                4,
		"HTLC_ACCEPTED_REVOKE":                               5,
		"HTLC_OFFERED_TIMEOUT_SECOND_LEVEL":                  6,
		"HTLC_ACCEPTED_SUCCESS_SECOND_LEVEL":                 7,
		"HTLC_OFFERED_REMOTE_TIMEOUT":                        8,
		"HTLC_ACCEPTED_REMOTE_SUCCESS":                       9,
		"HTLC_SECOND_LEVEL_REVOKE":                           10,
		"WITNESS_KEY_HASH":                                   11,
		"NESTED_WITNESS_KEY_HASH":                            12,
		"COMMITMENT_ANCHOR":                                  13,
		"COMMITMENT_NO_DELAY_TWEAKLESS":                      14,
		"COMMITMENT_TO_REMOTE_CONFIRMED":                     15,
		"HTLC_OFFERED_TIMEOUT_SECOND_LEVEL_INPUT_CONFIRMED":  16,
		"HTLC_ACCEPTED_SUCCESS_SECOND_LEVEL_INPUT_CONFIRMED": 17,
		"LEASE_COMMITMENT_TIME_LOCK":                         18,
		"LEASE_COMMITMENT_TO_REMOTE_CONFIRMED":               19,
		"LEASE_HTLC_OFFERED_TIMEOUT_SECOND_LEVEL":            20,
		"LEASE_HTLC_ACCEPTED_SUCCESS_SECOND_LEVEL":           21,
		"TAPROOT_PUB_KEY_SPEND":                              22,
		"TAPROOT_LOCAL_COMMIT_SPEND":                         23,
		"TAPROOT_REMOTE_COMMIT_SPEND":                        24,
		"TAPROOT_ANCHOR_SWEEP_SPEND":                         25,
		"TAPROOT_HTLC_OFFERED_TIMEOUT_SECOND_LEVEL":          26,
		"TAPROOT_HTLC_ACCEPTED_SUCCESS_SECOND_LEVEL":         27,
		"TAPROOT_HTLC_SECOND_LEVEL_REVOKE":                   28,
		"TAPROOT_HTLC_ACCEPTED_REVOKE":                       29,
		"TAPROOT_HTLC_OFFERED_REVOKE":                        30,
		"TAPROOT_HTLC_OFFERED_REMOTE_TIMEOUT":                31,
		"TAPROOT_HTLC_LOCAL_OFFERED_TIMEOUT":                 32,
		"TAPROOT_HTLC_ACCEPTED_REMOTE_SUCCESS":               33,
		"TAPROOT_HTLC_ACCEPTED_LOCAL_SUCCESS":                34,
		"TAPROOT_COMMITMENT_REVOKE":                          35,
	}
)

func (x WitnessType) Enum() *WitnessType {
	p := new(WitnessType)
	*p = x
	return p
}

func (x WitnessType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WitnessType) Descriptor() protoreflect.EnumDescriptor {
	return file_walletrpc_walletkit_proto_enumTypes[1].Descriptor()
}

func (WitnessType) Type() protoreflect.EnumType {
	return &file_walletrpc_walletkit_proto_enumTypes[1]
}

func (x WitnessType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WitnessType.Descriptor instead.
func (WitnessType) EnumDescriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{1}
}

// The possible change address types for default accounts and single imported
// public keys. By default, P2WPKH will be used. We don't provide the
// possibility to choose P2PKH as it is a legacy key scope, nor NP2WPKH as
// no key scope permits to do so. For custom accounts, no change type should
// be provided as the coin selection key scope will always be used to generate
// the change address.
type ChangeAddressType int32

const (
	// CHANGE_ADDRESS_TYPE_UNSPECIFIED indicates that no change address type is
	// provided. We will then use P2WPKH address type for change (BIP0084 key
	// scope).
	ChangeAddressType_CHANGE_ADDRESS_TYPE_UNSPECIFIED ChangeAddressType = 0
	// CHANGE_ADDRESS_TYPE_P2TR indicates to use P2TR address for change output
	// (BIP0086 key scope).
	ChangeAddressType_CHANGE_ADDRESS_TYPE_P2TR ChangeAddressType = 1
)

// Enum value maps for ChangeAddressType.
var (
	ChangeAddressType_name = map[int32]string{
		0: "CHANGE_ADDRESS_TYPE_UNSPECIFIED",
		1: "CHANGE_ADDRESS_TYPE_P2TR",
	}
	ChangeAddressType_value = map[string]int32{
		"CHANGE_ADDRESS_TYPE_UNSPECIFIED": 0,
		"CHANGE_ADDRESS_TYPE_P2TR":        1,
	}
)

func (x ChangeAddressType) Enum() *ChangeAddressType {
	p := new(ChangeAddressType)
	*p = x
	return p
}

func (x ChangeAddressType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ChangeAddressType) Descriptor() protoreflect.EnumDescriptor {
	return file_walletrpc_walletkit_proto_enumTypes[2].Descriptor()
}

func (ChangeAddressType) Type() protoreflect.EnumType {
	return &file_walletrpc_walletkit_proto_enumTypes[2]
}

func (x ChangeAddressType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ChangeAddressType.Descriptor instead.
func (ChangeAddressType) EnumDescriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{2}
}

type ListUnspentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The minimum number of confirmations to be included.
	MinConfs int32 `protobuf:"varint,1,opt,name=min_confs,json=minConfs,proto3" json:"min_confs,omitempty"`
	// The maximum number of confirmations to be included.
	MaxConfs int32 `protobuf:"varint,2,opt,name=max_confs,json=maxConfs,proto3" json:"max_confs,omitempty"`
	// An optional filter to only include outputs belonging to an account.
	Account string `protobuf:"bytes,3,opt,name=account,proto3" json:"account,omitempty"`
	// When min_confs and max_confs are zero, setting false implicitly
	// overrides max_confs to be MaxInt32, otherwise max_confs remains
	// zero. An error is returned if the value is true and both min_confs
	// and max_confs are non-zero. (default: false)
	UnconfirmedOnly bool `protobuf:"varint,4,opt,name=unconfirmed_only,json=unconfirmedOnly,proto3" json:"unconfirmed_only,omitempty"`
}

func (x *ListUnspentRequest) Reset() {
	*x = ListUnspentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUnspentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUnspentRequest) ProtoMessage() {}

func (x *ListUnspentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUnspentRequest.ProtoReflect.Descriptor instead.
func (*ListUnspentRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{0}
}

func (x *ListUnspentRequest) GetMinConfs() int32 {
	if x != nil {
		return x.MinConfs
	}
	return 0
}

func (x *ListUnspentRequest) GetMaxConfs() int32 {
	if x != nil {
		return x.MaxConfs
	}
	return 0
}

func (x *ListUnspentRequest) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *ListUnspentRequest) GetUnconfirmedOnly() bool {
	if x != nil {
		return x.UnconfirmedOnly
	}
	return false
}

type ListUnspentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of utxos satisfying the specified number of confirmations.
	Utxos []*lnrpc.Utxo `protobuf:"bytes,1,rep,name=utxos,proto3" json:"utxos,omitempty"`
}

func (x *ListUnspentResponse) Reset() {
	*x = ListUnspentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUnspentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUnspentResponse) ProtoMessage() {}

func (x *ListUnspentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUnspentResponse.ProtoReflect.Descriptor instead.
func (*ListUnspentResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{1}
}

func (x *ListUnspentResponse) GetUtxos() []*lnrpc.Utxo {
	if x != nil {
		return x.Utxos
	}
	return nil
}

type LeaseOutputRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An ID of 32 random bytes that must be unique for each distinct application
	// using this RPC which will be used to bound the output lease to.
	Id []byte `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The identifying outpoint of the output being leased.
	Outpoint *lnrpc.OutPoint `protobuf:"bytes,2,opt,name=outpoint,proto3" json:"outpoint,omitempty"`
	// The time in seconds before the lock expires. If set to zero, the default
	// lock duration is used.
	ExpirationSeconds uint64 `protobuf:"varint,3,opt,name=expiration_seconds,json=expirationSeconds,proto3" json:"expiration_seconds,omitempty"`
}

func (x *LeaseOutputRequest) Reset() {
	*x = LeaseOutputRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LeaseOutputRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LeaseOutputRequest) ProtoMessage() {}

func (x *LeaseOutputRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LeaseOutputRequest.ProtoReflect.Descriptor instead.
func (*LeaseOutputRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{2}
}

func (x *LeaseOutputRequest) GetId() []byte {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *LeaseOutputRequest) GetOutpoint() *lnrpc.OutPoint {
	if x != nil {
		return x.Outpoint
	}
	return nil
}

func (x *LeaseOutputRequest) GetExpirationSeconds() uint64 {
	if x != nil {
		return x.ExpirationSeconds
	}
	return 0
}

type LeaseOutputResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The absolute expiration of the output lease represented as a unix timestamp.
	Expiration uint64 `protobuf:"varint,1,opt,name=expiration,proto3" json:"expiration,omitempty"`
}

func (x *LeaseOutputResponse) Reset() {
	*x = LeaseOutputResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LeaseOutputResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LeaseOutputResponse) ProtoMessage() {}

func (x *LeaseOutputResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LeaseOutputResponse.ProtoReflect.Descriptor instead.
func (*LeaseOutputResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{3}
}

func (x *LeaseOutputResponse) GetExpiration() uint64 {
	if x != nil {
		return x.Expiration
	}
	return 0
}

type ReleaseOutputRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique ID that was used to lock the output.
	Id []byte `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The identifying outpoint of the output being released.
	Outpoint *lnrpc.OutPoint `protobuf:"bytes,2,opt,name=outpoint,proto3" json:"outpoint,omitempty"`
}

func (x *ReleaseOutputRequest) Reset() {
	*x = ReleaseOutputRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReleaseOutputRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReleaseOutputRequest) ProtoMessage() {}

func (x *ReleaseOutputRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReleaseOutputRequest.ProtoReflect.Descriptor instead.
func (*ReleaseOutputRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{4}
}

func (x *ReleaseOutputRequest) GetId() []byte {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *ReleaseOutputRequest) GetOutpoint() *lnrpc.OutPoint {
	if x != nil {
		return x.Outpoint
	}
	return nil
}

type ReleaseOutputResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status of the release operation.
	Status string `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *ReleaseOutputResponse) Reset() {
	*x = ReleaseOutputResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReleaseOutputResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReleaseOutputResponse) ProtoMessage() {}

func (x *ReleaseOutputResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReleaseOutputResponse.ProtoReflect.Descriptor instead.
func (*ReleaseOutputResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{5}
}

func (x *ReleaseOutputResponse) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

type KeyReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Is the key finger print of the root pubkey that this request is targeting.
	// This allows the WalletKit to possibly serve out keys for multiple HD chains
	// via public derivation.
	KeyFingerPrint int32 `protobuf:"varint,1,opt,name=key_finger_print,json=keyFingerPrint,proto3" json:"key_finger_print,omitempty"`
	// The target key family to derive a key from. In other contexts, this is
	// known as the "account".
	KeyFamily int32 `protobuf:"varint,2,opt,name=key_family,json=keyFamily,proto3" json:"key_family,omitempty"`
}

func (x *KeyReq) Reset() {
	*x = KeyReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyReq) ProtoMessage() {}

func (x *KeyReq) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyReq.ProtoReflect.Descriptor instead.
func (*KeyReq) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{6}
}

func (x *KeyReq) GetKeyFingerPrint() int32 {
	if x != nil {
		return x.KeyFingerPrint
	}
	return 0
}

func (x *KeyReq) GetKeyFamily() int32 {
	if x != nil {
		return x.KeyFamily
	}
	return 0
}

type AddrRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the account to retrieve the next address of. If empty, the
	// default wallet account is used.
	Account string `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// The type of address to derive.
	Type AddressType `protobuf:"varint,2,opt,name=type,proto3,enum=walletrpc.AddressType" json:"type,omitempty"`
	// Whether a change address should be derived.
	Change bool `protobuf:"varint,3,opt,name=change,proto3" json:"change,omitempty"`
}

func (x *AddrRequest) Reset() {
	*x = AddrRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddrRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddrRequest) ProtoMessage() {}

func (x *AddrRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddrRequest.ProtoReflect.Descriptor instead.
func (*AddrRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{7}
}

func (x *AddrRequest) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *AddrRequest) GetType() AddressType {
	if x != nil {
		return x.Type
	}
	return AddressType_UNKNOWN
}

func (x *AddrRequest) GetChange() bool {
	if x != nil {
		return x.Change
	}
	return false
}

type AddrResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The address encoded using a bech32 format.
	Addr string `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
}

func (x *AddrResponse) Reset() {
	*x = AddrResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddrResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddrResponse) ProtoMessage() {}

func (x *AddrResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddrResponse.ProtoReflect.Descriptor instead.
func (*AddrResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{8}
}

func (x *AddrResponse) GetAddr() string {
	if x != nil {
		return x.Addr
	}
	return ""
}

type Account struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name used to identify the account.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The type of addresses the account supports.
	AddressType AddressType `protobuf:"varint,2,opt,name=address_type,json=addressType,proto3,enum=walletrpc.AddressType" json:"address_type,omitempty"`
	// The public key backing the account that all keys are derived from
	// represented as an extended key. This will always be empty for the default
	// imported account in which single public keys are imported into.
	ExtendedPublicKey string `protobuf:"bytes,3,opt,name=extended_public_key,json=extendedPublicKey,proto3" json:"extended_public_key,omitempty"`
	// The fingerprint of the root key from which the account public key was
	// derived from. This will always be zero for the default imported account in
	// which single public keys are imported into. The bytes are in big-endian
	// order.
	MasterKeyFingerprint []byte `protobuf:"bytes,4,opt,name=master_key_fingerprint,json=masterKeyFingerprint,proto3" json:"master_key_fingerprint,omitempty"`
	// The derivation path corresponding to the account public key. This will
	// always be empty for the default imported account in which single public keys
	// are imported into.
	DerivationPath string `protobuf:"bytes,5,opt,name=derivation_path,json=derivationPath,proto3" json:"derivation_path,omitempty"`
	// The number of keys derived from the external branch of the account public
	// key. This will always be zero for the default imported account in which
	// single public keys are imported into.
	ExternalKeyCount uint32 `protobuf:"varint,6,opt,name=external_key_count,json=externalKeyCount,proto3" json:"external_key_count,omitempty"`
	// The number of keys derived from the internal branch of the account public
	// key. This will always be zero for the default imported account in which
	// single public keys are imported into.
	InternalKeyCount uint32 `protobuf:"varint,7,opt,name=internal_key_count,json=internalKeyCount,proto3" json:"internal_key_count,omitempty"`
	// Whether the wallet stores private keys for the account.
	WatchOnly bool `protobuf:"varint,8,opt,name=watch_only,json=watchOnly,proto3" json:"watch_only,omitempty"`
}

func (x *Account) Reset() {
	*x = Account{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Account) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Account) ProtoMessage() {}

func (x *Account) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Account.ProtoReflect.Descriptor instead.
func (*Account) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{9}
}

func (x *Account) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Account) GetAddressType() AddressType {
	if x != nil {
		return x.AddressType
	}
	return AddressType_UNKNOWN
}

func (x *Account) GetExtendedPublicKey() string {
	if x != nil {
		return x.ExtendedPublicKey
	}
	return ""
}

func (x *Account) GetMasterKeyFingerprint() []byte {
	if x != nil {
		return x.MasterKeyFingerprint
	}
	return nil
}

func (x *Account) GetDerivationPath() string {
	if x != nil {
		return x.DerivationPath
	}
	return ""
}

func (x *Account) GetExternalKeyCount() uint32 {
	if x != nil {
		return x.ExternalKeyCount
	}
	return 0
}

func (x *Account) GetInternalKeyCount() uint32 {
	if x != nil {
		return x.InternalKeyCount
	}
	return 0
}

func (x *Account) GetWatchOnly() bool {
	if x != nil {
		return x.WatchOnly
	}
	return false
}

type AddressProperty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The address encoded using the appropriate format depending on the
	// address type (base58, bech32, bech32m).
	//
	// Note that lnd's internal/custom keys for channels and other
	// functionality are derived from the same scope. Since they
	// aren't really used as addresses and will never have an
	// on-chain balance, we'll show the public key instead (only if
	// the show_custom_accounts flag is provided).
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Denotes if the address is a change address.
	IsInternal bool `protobuf:"varint,2,opt,name=is_internal,json=isInternal,proto3" json:"is_internal,omitempty"`
	// The balance of the address.
	Balance int64 `protobuf:"varint,3,opt,name=balance,proto3" json:"balance,omitempty"`
	// The full derivation path of the address. This will be empty for imported
	// addresses.
	DerivationPath string `protobuf:"bytes,4,opt,name=derivation_path,json=derivationPath,proto3" json:"derivation_path,omitempty"`
	// The public key of the address. This will be empty for imported addresses.
	PublicKey []byte `protobuf:"bytes,5,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
}

func (x *AddressProperty) Reset() {
	*x = AddressProperty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddressProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddressProperty) ProtoMessage() {}

func (x *AddressProperty) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddressProperty.ProtoReflect.Descriptor instead.
func (*AddressProperty) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{10}
}

func (x *AddressProperty) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *AddressProperty) GetIsInternal() bool {
	if x != nil {
		return x.IsInternal
	}
	return false
}

func (x *AddressProperty) GetBalance() int64 {
	if x != nil {
		return x.Balance
	}
	return 0
}

func (x *AddressProperty) GetDerivationPath() string {
	if x != nil {
		return x.DerivationPath
	}
	return ""
}

func (x *AddressProperty) GetPublicKey() []byte {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

type AccountWithAddresses struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name used to identify the account.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The type of addresses the account supports.
	AddressType AddressType `protobuf:"varint,2,opt,name=address_type,json=addressType,proto3,enum=walletrpc.AddressType" json:"address_type,omitempty"`
	// The derivation path corresponding to the account public key. This will
	// always be empty for the default imported account in which single public keys
	// are imported into.
	DerivationPath string `protobuf:"bytes,3,opt,name=derivation_path,json=derivationPath,proto3" json:"derivation_path,omitempty"`
	// List of address, its type internal/external & balance.
	// Note that the order of addresses will be random and not according to the
	// derivation index, since that information is not stored by the underlying
	// wallet.
	Addresses []*AddressProperty `protobuf:"bytes,4,rep,name=addresses,proto3" json:"addresses,omitempty"`
}

func (x *AccountWithAddresses) Reset() {
	*x = AccountWithAddresses{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccountWithAddresses) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccountWithAddresses) ProtoMessage() {}

func (x *AccountWithAddresses) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccountWithAddresses.ProtoReflect.Descriptor instead.
func (*AccountWithAddresses) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{11}
}

func (x *AccountWithAddresses) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AccountWithAddresses) GetAddressType() AddressType {
	if x != nil {
		return x.AddressType
	}
	return AddressType_UNKNOWN
}

func (x *AccountWithAddresses) GetDerivationPath() string {
	if x != nil {
		return x.DerivationPath
	}
	return ""
}

func (x *AccountWithAddresses) GetAddresses() []*AddressProperty {
	if x != nil {
		return x.Addresses
	}
	return nil
}

type ListAccountsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An optional filter to only return accounts matching this name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An optional filter to only return accounts matching this address type.
	AddressType AddressType `protobuf:"varint,2,opt,name=address_type,json=addressType,proto3,enum=walletrpc.AddressType" json:"address_type,omitempty"`
}

func (x *ListAccountsRequest) Reset() {
	*x = ListAccountsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountsRequest) ProtoMessage() {}

func (x *ListAccountsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountsRequest.ProtoReflect.Descriptor instead.
func (*ListAccountsRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{12}
}

func (x *ListAccountsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListAccountsRequest) GetAddressType() AddressType {
	if x != nil {
		return x.AddressType
	}
	return AddressType_UNKNOWN
}

type ListAccountsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Accounts []*Account `protobuf:"bytes,1,rep,name=accounts,proto3" json:"accounts,omitempty"`
}

func (x *ListAccountsResponse) Reset() {
	*x = ListAccountsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountsResponse) ProtoMessage() {}

func (x *ListAccountsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountsResponse.ProtoReflect.Descriptor instead.
func (*ListAccountsResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{13}
}

func (x *ListAccountsResponse) GetAccounts() []*Account {
	if x != nil {
		return x.Accounts
	}
	return nil
}

type RequiredReserveRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of additional channels the user would like to open.
	AdditionalPublicChannels uint32 `protobuf:"varint,1,opt,name=additional_public_channels,json=additionalPublicChannels,proto3" json:"additional_public_channels,omitempty"`
}

func (x *RequiredReserveRequest) Reset() {
	*x = RequiredReserveRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequiredReserveRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequiredReserveRequest) ProtoMessage() {}

func (x *RequiredReserveRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequiredReserveRequest.ProtoReflect.Descriptor instead.
func (*RequiredReserveRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{14}
}

func (x *RequiredReserveRequest) GetAdditionalPublicChannels() uint32 {
	if x != nil {
		return x.AdditionalPublicChannels
	}
	return 0
}

type RequiredReserveResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The amount of reserve required.
	RequiredReserve int64 `protobuf:"varint,1,opt,name=required_reserve,json=requiredReserve,proto3" json:"required_reserve,omitempty"`
}

func (x *RequiredReserveResponse) Reset() {
	*x = RequiredReserveResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequiredReserveResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequiredReserveResponse) ProtoMessage() {}

func (x *RequiredReserveResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequiredReserveResponse.ProtoReflect.Descriptor instead.
func (*RequiredReserveResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{15}
}

func (x *RequiredReserveResponse) GetRequiredReserve() int64 {
	if x != nil {
		return x.RequiredReserve
	}
	return 0
}

type ListAddressesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An optional filter to only return addresses matching this account.
	AccountName string `protobuf:"bytes,1,opt,name=account_name,json=accountName,proto3" json:"account_name,omitempty"`
	// An optional flag to return LND's custom accounts (Purpose=1017)
	// public key along with other addresses.
	ShowCustomAccounts bool `protobuf:"varint,2,opt,name=show_custom_accounts,json=showCustomAccounts,proto3" json:"show_custom_accounts,omitempty"`
}

func (x *ListAddressesRequest) Reset() {
	*x = ListAddressesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAddressesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAddressesRequest) ProtoMessage() {}

func (x *ListAddressesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAddressesRequest.ProtoReflect.Descriptor instead.
func (*ListAddressesRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{16}
}

func (x *ListAddressesRequest) GetAccountName() string {
	if x != nil {
		return x.AccountName
	}
	return ""
}

func (x *ListAddressesRequest) GetShowCustomAccounts() bool {
	if x != nil {
		return x.ShowCustomAccounts
	}
	return false
}

type ListAddressesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of all the accounts and their addresses.
	AccountWithAddresses []*AccountWithAddresses `protobuf:"bytes,1,rep,name=account_with_addresses,json=accountWithAddresses,proto3" json:"account_with_addresses,omitempty"`
}

func (x *ListAddressesResponse) Reset() {
	*x = ListAddressesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAddressesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAddressesResponse) ProtoMessage() {}

func (x *ListAddressesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAddressesResponse.ProtoReflect.Descriptor instead.
func (*ListAddressesResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{17}
}

func (x *ListAddressesResponse) GetAccountWithAddresses() []*AccountWithAddresses {
	if x != nil {
		return x.AccountWithAddresses
	}
	return nil
}

type GetTransactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The txid of the transaction.
	Txid string `protobuf:"bytes,1,opt,name=txid,proto3" json:"txid,omitempty"`
}

func (x *GetTransactionRequest) Reset() {
	*x = GetTransactionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTransactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTransactionRequest) ProtoMessage() {}

func (x *GetTransactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTransactionRequest.ProtoReflect.Descriptor instead.
func (*GetTransactionRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{18}
}

func (x *GetTransactionRequest) GetTxid() string {
	if x != nil {
		return x.Txid
	}
	return ""
}

type SignMessageWithAddrRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The message to be signed. When using REST, this field must be encoded as
	// base64.
	Msg []byte `protobuf:"bytes,1,opt,name=msg,proto3" json:"msg,omitempty"`
	// The address which will be used to look up the private key and sign the
	// corresponding message.
	Addr string `protobuf:"bytes,2,opt,name=addr,proto3" json:"addr,omitempty"`
}

func (x *SignMessageWithAddrRequest) Reset() {
	*x = SignMessageWithAddrRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignMessageWithAddrRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignMessageWithAddrRequest) ProtoMessage() {}

func (x *SignMessageWithAddrRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignMessageWithAddrRequest.ProtoReflect.Descriptor instead.
func (*SignMessageWithAddrRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{19}
}

func (x *SignMessageWithAddrRequest) GetMsg() []byte {
	if x != nil {
		return x.Msg
	}
	return nil
}

func (x *SignMessageWithAddrRequest) GetAddr() string {
	if x != nil {
		return x.Addr
	}
	return ""
}

type SignMessageWithAddrResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The compact ECDSA signature for the given message encoded in base64.
	Signature string `protobuf:"bytes,1,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (x *SignMessageWithAddrResponse) Reset() {
	*x = SignMessageWithAddrResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignMessageWithAddrResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignMessageWithAddrResponse) ProtoMessage() {}

func (x *SignMessageWithAddrResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignMessageWithAddrResponse.ProtoReflect.Descriptor instead.
func (*SignMessageWithAddrResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{20}
}

func (x *SignMessageWithAddrResponse) GetSignature() string {
	if x != nil {
		return x.Signature
	}
	return ""
}

type VerifyMessageWithAddrRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The message to be signed. When using REST, this field must be encoded as
	// base64.
	Msg []byte `protobuf:"bytes,1,opt,name=msg,proto3" json:"msg,omitempty"`
	// The compact ECDSA signature to be verified over the given message
	// ecoded in base64.
	Signature string `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
	// The address which will be used to look up the public key and verify the
	// the signature.
	Addr string `protobuf:"bytes,3,opt,name=addr,proto3" json:"addr,omitempty"`
}

func (x *VerifyMessageWithAddrRequest) Reset() {
	*x = VerifyMessageWithAddrRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyMessageWithAddrRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyMessageWithAddrRequest) ProtoMessage() {}

func (x *VerifyMessageWithAddrRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyMessageWithAddrRequest.ProtoReflect.Descriptor instead.
func (*VerifyMessageWithAddrRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{21}
}

func (x *VerifyMessageWithAddrRequest) GetMsg() []byte {
	if x != nil {
		return x.Msg
	}
	return nil
}

func (x *VerifyMessageWithAddrRequest) GetSignature() string {
	if x != nil {
		return x.Signature
	}
	return ""
}

func (x *VerifyMessageWithAddrRequest) GetAddr() string {
	if x != nil {
		return x.Addr
	}
	return ""
}

type VerifyMessageWithAddrResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the signature was valid over the given message.
	Valid bool `protobuf:"varint,1,opt,name=valid,proto3" json:"valid,omitempty"`
	// The pubkey recovered from the signature.
	Pubkey []byte `protobuf:"bytes,2,opt,name=pubkey,proto3" json:"pubkey,omitempty"`
}

func (x *VerifyMessageWithAddrResponse) Reset() {
	*x = VerifyMessageWithAddrResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyMessageWithAddrResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyMessageWithAddrResponse) ProtoMessage() {}

func (x *VerifyMessageWithAddrResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyMessageWithAddrResponse.ProtoReflect.Descriptor instead.
func (*VerifyMessageWithAddrResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{22}
}

func (x *VerifyMessageWithAddrResponse) GetValid() bool {
	if x != nil {
		return x.Valid
	}
	return false
}

func (x *VerifyMessageWithAddrResponse) GetPubkey() []byte {
	if x != nil {
		return x.Pubkey
	}
	return nil
}

type ImportAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A name to identify the account with.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A public key that corresponds to a wallet account represented as an extended
	// key. It must conform to a derivation path of the form
	// m/purpose'/coin_type'/account'.
	ExtendedPublicKey string `protobuf:"bytes,2,opt,name=extended_public_key,json=extendedPublicKey,proto3" json:"extended_public_key,omitempty"`
	// The fingerprint of the root key (also known as the key with derivation path
	// m/) from which the account public key was derived from. This may be required
	// by some hardware wallets for proper identification and signing. The bytes
	// must be in big-endian order.
	MasterKeyFingerprint []byte `protobuf:"bytes,3,opt,name=master_key_fingerprint,json=masterKeyFingerprint,proto3" json:"master_key_fingerprint,omitempty"`
	// An address type is only required when the extended account public key has a
	// legacy version (xpub, tpub, etc.), such that the wallet cannot detect what
	// address scheme it belongs to.
	AddressType AddressType `protobuf:"varint,4,opt,name=address_type,json=addressType,proto3,enum=walletrpc.AddressType" json:"address_type,omitempty"`
	// Whether a dry run should be attempted when importing the account. This
	// serves as a way to confirm whether the account is being imported correctly
	// by returning the first N addresses for the external and internal branches of
	// the account. If these addresses match as expected, then it should be safe to
	// import the account as is.
	DryRun bool `protobuf:"varint,5,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
}

func (x *ImportAccountRequest) Reset() {
	*x = ImportAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportAccountRequest) ProtoMessage() {}

func (x *ImportAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportAccountRequest.ProtoReflect.Descriptor instead.
func (*ImportAccountRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{23}
}

func (x *ImportAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ImportAccountRequest) GetExtendedPublicKey() string {
	if x != nil {
		return x.ExtendedPublicKey
	}
	return ""
}

func (x *ImportAccountRequest) GetMasterKeyFingerprint() []byte {
	if x != nil {
		return x.MasterKeyFingerprint
	}
	return nil
}

func (x *ImportAccountRequest) GetAddressType() AddressType {
	if x != nil {
		return x.AddressType
	}
	return AddressType_UNKNOWN
}

func (x *ImportAccountRequest) GetDryRun() bool {
	if x != nil {
		return x.DryRun
	}
	return false
}

type ImportAccountResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The details of the imported account.
	Account *Account `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// The first N addresses that belong to the external branch of the account.
	// The external branch is typically used for external non-change addresses.
	// These are only returned if a dry run was specified within the request.
	DryRunExternalAddrs []string `protobuf:"bytes,2,rep,name=dry_run_external_addrs,json=dryRunExternalAddrs,proto3" json:"dry_run_external_addrs,omitempty"`
	// The first N addresses that belong to the internal branch of the account.
	// The internal branch is typically used for change addresses. These are only
	// returned if a dry run was specified within the request.
	DryRunInternalAddrs []string `protobuf:"bytes,3,rep,name=dry_run_internal_addrs,json=dryRunInternalAddrs,proto3" json:"dry_run_internal_addrs,omitempty"`
}

func (x *ImportAccountResponse) Reset() {
	*x = ImportAccountResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportAccountResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportAccountResponse) ProtoMessage() {}

func (x *ImportAccountResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportAccountResponse.ProtoReflect.Descriptor instead.
func (*ImportAccountResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{24}
}

func (x *ImportAccountResponse) GetAccount() *Account {
	if x != nil {
		return x.Account
	}
	return nil
}

func (x *ImportAccountResponse) GetDryRunExternalAddrs() []string {
	if x != nil {
		return x.DryRunExternalAddrs
	}
	return nil
}

func (x *ImportAccountResponse) GetDryRunInternalAddrs() []string {
	if x != nil {
		return x.DryRunInternalAddrs
	}
	return nil
}

type ImportPublicKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A compressed public key represented as raw bytes.
	PublicKey []byte `protobuf:"bytes,1,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// The type of address that will be generated from the public key.
	AddressType AddressType `protobuf:"varint,2,opt,name=address_type,json=addressType,proto3,enum=walletrpc.AddressType" json:"address_type,omitempty"`
}

func (x *ImportPublicKeyRequest) Reset() {
	*x = ImportPublicKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportPublicKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportPublicKeyRequest) ProtoMessage() {}

func (x *ImportPublicKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportPublicKeyRequest.ProtoReflect.Descriptor instead.
func (*ImportPublicKeyRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{25}
}

func (x *ImportPublicKeyRequest) GetPublicKey() []byte {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

func (x *ImportPublicKeyRequest) GetAddressType() AddressType {
	if x != nil {
		return x.AddressType
	}
	return AddressType_UNKNOWN
}

type ImportPublicKeyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status of the import operation.
	Status string `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *ImportPublicKeyResponse) Reset() {
	*x = ImportPublicKeyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportPublicKeyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportPublicKeyResponse) ProtoMessage() {}

func (x *ImportPublicKeyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportPublicKeyResponse.ProtoReflect.Descriptor instead.
func (*ImportPublicKeyResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{26}
}

func (x *ImportPublicKeyResponse) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

type ImportTapscriptRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The internal public key, serialized as 32-byte x-only public key.
	InternalPublicKey []byte `protobuf:"bytes,1,opt,name=internal_public_key,json=internalPublicKey,proto3" json:"internal_public_key,omitempty"`
	// Types that are assignable to Script:
	//
	//	*ImportTapscriptRequest_FullTree
	//	*ImportTapscriptRequest_PartialReveal
	//	*ImportTapscriptRequest_RootHashOnly
	//	*ImportTapscriptRequest_FullKeyOnly
	Script isImportTapscriptRequest_Script `protobuf_oneof:"script"`
}

func (x *ImportTapscriptRequest) Reset() {
	*x = ImportTapscriptRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportTapscriptRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportTapscriptRequest) ProtoMessage() {}

func (x *ImportTapscriptRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportTapscriptRequest.ProtoReflect.Descriptor instead.
func (*ImportTapscriptRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{27}
}

func (x *ImportTapscriptRequest) GetInternalPublicKey() []byte {
	if x != nil {
		return x.InternalPublicKey
	}
	return nil
}

func (m *ImportTapscriptRequest) GetScript() isImportTapscriptRequest_Script {
	if m != nil {
		return m.Script
	}
	return nil
}

func (x *ImportTapscriptRequest) GetFullTree() *TapscriptFullTree {
	if x, ok := x.GetScript().(*ImportTapscriptRequest_FullTree); ok {
		return x.FullTree
	}
	return nil
}

func (x *ImportTapscriptRequest) GetPartialReveal() *TapscriptPartialReveal {
	if x, ok := x.GetScript().(*ImportTapscriptRequest_PartialReveal); ok {
		return x.PartialReveal
	}
	return nil
}

func (x *ImportTapscriptRequest) GetRootHashOnly() []byte {
	if x, ok := x.GetScript().(*ImportTapscriptRequest_RootHashOnly); ok {
		return x.RootHashOnly
	}
	return nil
}

func (x *ImportTapscriptRequest) GetFullKeyOnly() bool {
	if x, ok := x.GetScript().(*ImportTapscriptRequest_FullKeyOnly); ok {
		return x.FullKeyOnly
	}
	return false
}

type isImportTapscriptRequest_Script interface {
	isImportTapscriptRequest_Script()
}

type ImportTapscriptRequest_FullTree struct {
	// The full script tree with all individual leaves is known and the root
	// hash can be constructed from the full tree directly.
	FullTree *TapscriptFullTree `protobuf:"bytes,2,opt,name=full_tree,json=fullTree,proto3,oneof"`
}

type ImportTapscriptRequest_PartialReveal struct {
	// Only a single script leaf is known. To construct the root hash, the full
	// inclusion proof must also be provided.
	PartialReveal *TapscriptPartialReveal `protobuf:"bytes,3,opt,name=partial_reveal,json=partialReveal,proto3,oneof"`
}

type ImportTapscriptRequest_RootHashOnly struct {
	// Only the root hash of the Taproot script tree (or other form of Taproot
	// commitment) is known.
	RootHashOnly []byte `protobuf:"bytes,4,opt,name=root_hash_only,json=rootHashOnly,proto3,oneof"`
}

type ImportTapscriptRequest_FullKeyOnly struct {
	// Only the final, tweaked Taproot key is known and no additional
	// information about the internal key or type of tweak that was used to
	// derive it. When this is set, the wallet treats the key in
	// internal_public_key as the Taproot key directly. This can be useful for
	// tracking arbitrary Taproot outputs without the goal of ever being able
	// to spend from them through the internal wallet.
	FullKeyOnly bool `protobuf:"varint,5,opt,name=full_key_only,json=fullKeyOnly,proto3,oneof"`
}

func (*ImportTapscriptRequest_FullTree) isImportTapscriptRequest_Script() {}

func (*ImportTapscriptRequest_PartialReveal) isImportTapscriptRequest_Script() {}

func (*ImportTapscriptRequest_RootHashOnly) isImportTapscriptRequest_Script() {}

func (*ImportTapscriptRequest_FullKeyOnly) isImportTapscriptRequest_Script() {}

type TapscriptFullTree struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The complete, ordered list of all tap leaves of the tree.
	AllLeaves []*TapLeaf `protobuf:"bytes,1,rep,name=all_leaves,json=allLeaves,proto3" json:"all_leaves,omitempty"`
}

func (x *TapscriptFullTree) Reset() {
	*x = TapscriptFullTree{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TapscriptFullTree) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TapscriptFullTree) ProtoMessage() {}

func (x *TapscriptFullTree) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TapscriptFullTree.ProtoReflect.Descriptor instead.
func (*TapscriptFullTree) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{28}
}

func (x *TapscriptFullTree) GetAllLeaves() []*TapLeaf {
	if x != nil {
		return x.AllLeaves
	}
	return nil
}

type TapLeaf struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The leaf version. Should be 0xc0 (192) in case of a SegWit v1 script.
	LeafVersion uint32 `protobuf:"varint,1,opt,name=leaf_version,json=leafVersion,proto3" json:"leaf_version,omitempty"`
	// The script of the tap leaf.
	Script []byte `protobuf:"bytes,2,opt,name=script,proto3" json:"script,omitempty"`
}

func (x *TapLeaf) Reset() {
	*x = TapLeaf{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TapLeaf) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TapLeaf) ProtoMessage() {}

func (x *TapLeaf) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TapLeaf.ProtoReflect.Descriptor instead.
func (*TapLeaf) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{29}
}

func (x *TapLeaf) GetLeafVersion() uint32 {
	if x != nil {
		return x.LeafVersion
	}
	return 0
}

func (x *TapLeaf) GetScript() []byte {
	if x != nil {
		return x.Script
	}
	return nil
}

type TapscriptPartialReveal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The tap leaf that is known and will be revealed.
	RevealedLeaf *TapLeaf `protobuf:"bytes,1,opt,name=revealed_leaf,json=revealedLeaf,proto3" json:"revealed_leaf,omitempty"`
	// The BIP-0341 serialized inclusion proof that is required to prove that
	// the revealed leaf is part of the tree. This contains 0..n blocks of 32
	// bytes. If the tree only contained a single leaf (which is the revealed
	// leaf), this can be empty.
	FullInclusionProof []byte `protobuf:"bytes,2,opt,name=full_inclusion_proof,json=fullInclusionProof,proto3" json:"full_inclusion_proof,omitempty"`
}

func (x *TapscriptPartialReveal) Reset() {
	*x = TapscriptPartialReveal{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TapscriptPartialReveal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TapscriptPartialReveal) ProtoMessage() {}

func (x *TapscriptPartialReveal) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TapscriptPartialReveal.ProtoReflect.Descriptor instead.
func (*TapscriptPartialReveal) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{30}
}

func (x *TapscriptPartialReveal) GetRevealedLeaf() *TapLeaf {
	if x != nil {
		return x.RevealedLeaf
	}
	return nil
}

func (x *TapscriptPartialReveal) GetFullInclusionProof() []byte {
	if x != nil {
		return x.FullInclusionProof
	}
	return nil
}

type ImportTapscriptResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resulting pay-to-Taproot address that represents the imported internal
	// key with the script committed to it.
	P2TrAddress string `protobuf:"bytes,1,opt,name=p2tr_address,json=p2trAddress,proto3" json:"p2tr_address,omitempty"`
}

func (x *ImportTapscriptResponse) Reset() {
	*x = ImportTapscriptResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportTapscriptResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportTapscriptResponse) ProtoMessage() {}

func (x *ImportTapscriptResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportTapscriptResponse.ProtoReflect.Descriptor instead.
func (*ImportTapscriptResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{31}
}

func (x *ImportTapscriptResponse) GetP2TrAddress() string {
	if x != nil {
		return x.P2TrAddress
	}
	return ""
}

type Transaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The raw serialized transaction. Despite the field name, this does need to be
	// specified in raw bytes (or base64 encoded when using REST) and not in hex.
	// To not break existing software, the field can't simply be renamed.
	TxHex []byte `protobuf:"bytes,1,opt,name=tx_hex,json=txHex,proto3" json:"tx_hex,omitempty"`
	// An optional label to save with the transaction. Limited to 500 characters.
	Label string `protobuf:"bytes,2,opt,name=label,proto3" json:"label,omitempty"`
}

func (x *Transaction) Reset() {
	*x = Transaction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Transaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Transaction) ProtoMessage() {}

func (x *Transaction) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Transaction.ProtoReflect.Descriptor instead.
func (*Transaction) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{32}
}

func (x *Transaction) GetTxHex() []byte {
	if x != nil {
		return x.TxHex
	}
	return nil
}

func (x *Transaction) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

type PublishResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If blank, then no error occurred and the transaction was successfully
	// published. If not the empty string, then a string representation of the
	// broadcast error.
	//
	// TODO(roasbeef): map to a proper enum type
	PublishError string `protobuf:"bytes,1,opt,name=publish_error,json=publishError,proto3" json:"publish_error,omitempty"`
}

func (x *PublishResponse) Reset() {
	*x = PublishResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublishResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublishResponse) ProtoMessage() {}

func (x *PublishResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublishResponse.ProtoReflect.Descriptor instead.
func (*PublishResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{33}
}

func (x *PublishResponse) GetPublishError() string {
	if x != nil {
		return x.PublishError
	}
	return ""
}

type RemoveTransactionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status of the remove transaction operation.
	Status string `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *RemoveTransactionResponse) Reset() {
	*x = RemoveTransactionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveTransactionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveTransactionResponse) ProtoMessage() {}

func (x *RemoveTransactionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveTransactionResponse.ProtoReflect.Descriptor instead.
func (*RemoveTransactionResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{34}
}

func (x *RemoveTransactionResponse) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

type SendOutputsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of satoshis per kilo weight that should be used when crafting
	// this transaction.
	SatPerKw int64 `protobuf:"varint,1,opt,name=sat_per_kw,json=satPerKw,proto3" json:"sat_per_kw,omitempty"`
	// A slice of the outputs that should be created in the transaction produced.
	Outputs []*signrpc.TxOut `protobuf:"bytes,2,rep,name=outputs,proto3" json:"outputs,omitempty"`
	// An optional label for the transaction, limited to 500 characters.
	Label string `protobuf:"bytes,3,opt,name=label,proto3" json:"label,omitempty"`
	// The minimum number of confirmations each one of your outputs used for
	// the transaction must satisfy.
	MinConfs int32 `protobuf:"varint,4,opt,name=min_confs,json=minConfs,proto3" json:"min_confs,omitempty"`
	// Whether unconfirmed outputs should be used as inputs for the transaction.
	SpendUnconfirmed bool `protobuf:"varint,5,opt,name=spend_unconfirmed,json=spendUnconfirmed,proto3" json:"spend_unconfirmed,omitempty"`
	// The strategy to use for selecting coins during sending the outputs.
	CoinSelectionStrategy lnrpc.CoinSelectionStrategy `protobuf:"varint,6,opt,name=coin_selection_strategy,json=coinSelectionStrategy,proto3,enum=lnrpc.CoinSelectionStrategy" json:"coin_selection_strategy,omitempty"`
}

func (x *SendOutputsRequest) Reset() {
	*x = SendOutputsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SendOutputsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendOutputsRequest) ProtoMessage() {}

func (x *SendOutputsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendOutputsRequest.ProtoReflect.Descriptor instead.
func (*SendOutputsRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{35}
}

func (x *SendOutputsRequest) GetSatPerKw() int64 {
	if x != nil {
		return x.SatPerKw
	}
	return 0
}

func (x *SendOutputsRequest) GetOutputs() []*signrpc.TxOut {
	if x != nil {
		return x.Outputs
	}
	return nil
}

func (x *SendOutputsRequest) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *SendOutputsRequest) GetMinConfs() int32 {
	if x != nil {
		return x.MinConfs
	}
	return 0
}

func (x *SendOutputsRequest) GetSpendUnconfirmed() bool {
	if x != nil {
		return x.SpendUnconfirmed
	}
	return false
}

func (x *SendOutputsRequest) GetCoinSelectionStrategy() lnrpc.CoinSelectionStrategy {
	if x != nil {
		return x.CoinSelectionStrategy
	}
	return lnrpc.CoinSelectionStrategy(0)
}

type SendOutputsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The serialized transaction sent out on the network.
	RawTx []byte `protobuf:"bytes,1,opt,name=raw_tx,json=rawTx,proto3" json:"raw_tx,omitempty"`
}

func (x *SendOutputsResponse) Reset() {
	*x = SendOutputsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SendOutputsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendOutputsResponse) ProtoMessage() {}

func (x *SendOutputsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendOutputsResponse.ProtoReflect.Descriptor instead.
func (*SendOutputsResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{36}
}

func (x *SendOutputsResponse) GetRawTx() []byte {
	if x != nil {
		return x.RawTx
	}
	return nil
}

type EstimateFeeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of confirmations to shoot for when estimating the fee.
	ConfTarget int32 `protobuf:"varint,1,opt,name=conf_target,json=confTarget,proto3" json:"conf_target,omitempty"`
}

func (x *EstimateFeeRequest) Reset() {
	*x = EstimateFeeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EstimateFeeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EstimateFeeRequest) ProtoMessage() {}

func (x *EstimateFeeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EstimateFeeRequest.ProtoReflect.Descriptor instead.
func (*EstimateFeeRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{37}
}

func (x *EstimateFeeRequest) GetConfTarget() int32 {
	if x != nil {
		return x.ConfTarget
	}
	return 0
}

type EstimateFeeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The amount of satoshis per kw that should be used in order to reach the
	// confirmation target in the request.
	SatPerKw int64 `protobuf:"varint,1,opt,name=sat_per_kw,json=satPerKw,proto3" json:"sat_per_kw,omitempty"`
	// The current minimum relay fee based on our chain backend in sat/kw.
	MinRelayFeeSatPerKw int64 `protobuf:"varint,2,opt,name=min_relay_fee_sat_per_kw,json=minRelayFeeSatPerKw,proto3" json:"min_relay_fee_sat_per_kw,omitempty"`
}

func (x *EstimateFeeResponse) Reset() {
	*x = EstimateFeeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EstimateFeeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EstimateFeeResponse) ProtoMessage() {}

func (x *EstimateFeeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EstimateFeeResponse.ProtoReflect.Descriptor instead.
func (*EstimateFeeResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{38}
}

func (x *EstimateFeeResponse) GetSatPerKw() int64 {
	if x != nil {
		return x.SatPerKw
	}
	return 0
}

func (x *EstimateFeeResponse) GetMinRelayFeeSatPerKw() int64 {
	if x != nil {
		return x.MinRelayFeeSatPerKw
	}
	return 0
}

type PendingSweep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The outpoint of the output we're attempting to sweep.
	Outpoint *lnrpc.OutPoint `protobuf:"bytes,1,opt,name=outpoint,proto3" json:"outpoint,omitempty"`
	// The witness type of the output we're attempting to sweep.
	WitnessType WitnessType `protobuf:"varint,2,opt,name=witness_type,json=witnessType,proto3,enum=walletrpc.WitnessType" json:"witness_type,omitempty"`
	// The value of the output we're attempting to sweep.
	AmountSat uint32 `protobuf:"varint,3,opt,name=amount_sat,json=amountSat,proto3" json:"amount_sat,omitempty"`
	// Deprecated, use sat_per_vbyte.
	// The fee rate we'll use to sweep the output, expressed in sat/vbyte. The fee
	// rate is only determined once a sweeping transaction for the output is
	// created, so it's possible for this to be 0 before this.
	//
	// Deprecated: Marked as deprecated in walletrpc/walletkit.proto.
	SatPerByte uint32 `protobuf:"varint,4,opt,name=sat_per_byte,json=satPerByte,proto3" json:"sat_per_byte,omitempty"`
	// The number of broadcast attempts we've made to sweep the output.
	BroadcastAttempts uint32 `protobuf:"varint,5,opt,name=broadcast_attempts,json=broadcastAttempts,proto3" json:"broadcast_attempts,omitempty"`
	// Deprecated.
	// The next height of the chain at which we'll attempt to broadcast the
	// sweep transaction of the output.
	//
	// Deprecated: Marked as deprecated in walletrpc/walletkit.proto.
	NextBroadcastHeight uint32 `protobuf:"varint,6,opt,name=next_broadcast_height,json=nextBroadcastHeight,proto3" json:"next_broadcast_height,omitempty"`
	// Deprecated, use immediate.
	// Whether this input must be force-swept. This means that it is swept
	// immediately.
	//
	// Deprecated: Marked as deprecated in walletrpc/walletkit.proto.
	Force bool `protobuf:"varint,7,opt,name=force,proto3" json:"force,omitempty"`
	// Deprecated, use deadline.
	// The requested confirmation target for this output, which is the deadline
	// used by the sweeper.
	//
	// Deprecated: Marked as deprecated in walletrpc/walletkit.proto.
	RequestedConfTarget uint32 `protobuf:"varint,8,opt,name=requested_conf_target,json=requestedConfTarget,proto3" json:"requested_conf_target,omitempty"`
	// Deprecated, use requested_sat_per_vbyte.
	// The requested fee rate, expressed in sat/vbyte, for this output.
	//
	// Deprecated: Marked as deprecated in walletrpc/walletkit.proto.
	RequestedSatPerByte uint32 `protobuf:"varint,9,opt,name=requested_sat_per_byte,json=requestedSatPerByte,proto3" json:"requested_sat_per_byte,omitempty"`
	// The current fee rate we'll use to sweep the output, expressed in sat/vbyte.
	// The fee rate is only determined once a sweeping transaction for the output
	// is created, so it's possible for this to be 0 before this.
	SatPerVbyte uint64 `protobuf:"varint,10,opt,name=sat_per_vbyte,json=satPerVbyte,proto3" json:"sat_per_vbyte,omitempty"`
	// The requested starting fee rate, expressed in sat/vbyte, for this
	// output. When not requested, this field will be 0.
	RequestedSatPerVbyte uint64 `protobuf:"varint,11,opt,name=requested_sat_per_vbyte,json=requestedSatPerVbyte,proto3" json:"requested_sat_per_vbyte,omitempty"`
	// Whether this input will be swept immediately.
	Immediate bool `protobuf:"varint,12,opt,name=immediate,proto3" json:"immediate,omitempty"`
	// The budget for this sweep, expressed in satoshis. This is the maximum amount
	// that can be spent as fees to sweep this output.
	Budget uint64 `protobuf:"varint,13,opt,name=budget,proto3" json:"budget,omitempty"`
	// The deadline height used for this output when perform fee bumping.
	DeadlineHeight uint32 `protobuf:"varint,14,opt,name=deadline_height,json=deadlineHeight,proto3" json:"deadline_height,omitempty"`
}

func (x *PendingSweep) Reset() {
	*x = PendingSweep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PendingSweep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PendingSweep) ProtoMessage() {}

func (x *PendingSweep) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PendingSweep.ProtoReflect.Descriptor instead.
func (*PendingSweep) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{39}
}

func (x *PendingSweep) GetOutpoint() *lnrpc.OutPoint {
	if x != nil {
		return x.Outpoint
	}
	return nil
}

func (x *PendingSweep) GetWitnessType() WitnessType {
	if x != nil {
		return x.WitnessType
	}
	return WitnessType_UNKNOWN_WITNESS
}

func (x *PendingSweep) GetAmountSat() uint32 {
	if x != nil {
		return x.AmountSat
	}
	return 0
}

// Deprecated: Marked as deprecated in walletrpc/walletkit.proto.
func (x *PendingSweep) GetSatPerByte() uint32 {
	if x != nil {
		return x.SatPerByte
	}
	return 0
}

func (x *PendingSweep) GetBroadcastAttempts() uint32 {
	if x != nil {
		return x.BroadcastAttempts
	}
	return 0
}

// Deprecated: Marked as deprecated in walletrpc/walletkit.proto.
func (x *PendingSweep) GetNextBroadcastHeight() uint32 {
	if x != nil {
		return x.NextBroadcastHeight
	}
	return 0
}

// Deprecated: Marked as deprecated in walletrpc/walletkit.proto.
func (x *PendingSweep) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Deprecated: Marked as deprecated in walletrpc/walletkit.proto.
func (x *PendingSweep) GetRequestedConfTarget() uint32 {
	if x != nil {
		return x.RequestedConfTarget
	}
	return 0
}

// Deprecated: Marked as deprecated in walletrpc/walletkit.proto.
func (x *PendingSweep) GetRequestedSatPerByte() uint32 {
	if x != nil {
		return x.RequestedSatPerByte
	}
	return 0
}

func (x *PendingSweep) GetSatPerVbyte() uint64 {
	if x != nil {
		return x.SatPerVbyte
	}
	return 0
}

func (x *PendingSweep) GetRequestedSatPerVbyte() uint64 {
	if x != nil {
		return x.RequestedSatPerVbyte
	}
	return 0
}

func (x *PendingSweep) GetImmediate() bool {
	if x != nil {
		return x.Immediate
	}
	return false
}

func (x *PendingSweep) GetBudget() uint64 {
	if x != nil {
		return x.Budget
	}
	return 0
}

func (x *PendingSweep) GetDeadlineHeight() uint32 {
	if x != nil {
		return x.DeadlineHeight
	}
	return 0
}

type PendingSweepsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PendingSweepsRequest) Reset() {
	*x = PendingSweepsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PendingSweepsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PendingSweepsRequest) ProtoMessage() {}

func (x *PendingSweepsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PendingSweepsRequest.ProtoReflect.Descriptor instead.
func (*PendingSweepsRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{40}
}

type PendingSweepsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of outputs currently being swept by lnd's central batching engine.
	PendingSweeps []*PendingSweep `protobuf:"bytes,1,rep,name=pending_sweeps,json=pendingSweeps,proto3" json:"pending_sweeps,omitempty"`
}

func (x *PendingSweepsResponse) Reset() {
	*x = PendingSweepsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PendingSweepsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PendingSweepsResponse) ProtoMessage() {}

func (x *PendingSweepsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PendingSweepsResponse.ProtoReflect.Descriptor instead.
func (*PendingSweepsResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{41}
}

func (x *PendingSweepsResponse) GetPendingSweeps() []*PendingSweep {
	if x != nil {
		return x.PendingSweeps
	}
	return nil
}

type BumpFeeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The input we're attempting to bump the fee of.
	Outpoint *lnrpc.OutPoint `protobuf:"bytes,1,opt,name=outpoint,proto3" json:"outpoint,omitempty"`
	// Optional. The deadline in number of blocks that the input should be spent
	// within. When not set, for new inputs, the default value (1008) is used;
	// for existing inputs, their current values will be retained.
	TargetConf uint32 `protobuf:"varint,2,opt,name=target_conf,json=targetConf,proto3" json:"target_conf,omitempty"`
	// Deprecated, use sat_per_vbyte.
	// The fee rate, expressed in sat/vbyte, that should be used to spend the input
	// with.
	//
	// Deprecated: Marked as deprecated in walletrpc/walletkit.proto.
	SatPerByte uint32 `protobuf:"varint,3,opt,name=sat_per_byte,json=satPerByte,proto3" json:"sat_per_byte,omitempty"`
	// Deprecated, use immediate.
	// Whether this input must be force-swept. This means that it is swept
	// immediately.
	//
	// Deprecated: Marked as deprecated in walletrpc/walletkit.proto.
	Force bool `protobuf:"varint,4,opt,name=force,proto3" json:"force,omitempty"`
	// Optional. The starting fee rate, expressed in sat/vbyte, that will be used
	// to spend the input with initially. This value will be used by the sweeper's
	// fee function as its starting fee rate. When not set, the sweeper will use
	// the estimated fee rate using the `target_conf` as the starting fee rate.
	SatPerVbyte uint64 `protobuf:"varint,5,opt,name=sat_per_vbyte,json=satPerVbyte,proto3" json:"sat_per_vbyte,omitempty"`
	// Optional. Whether this input will be swept immediately. When set to true,
	// the sweeper will sweep this input without waiting for the next batch.
	Immediate bool `protobuf:"varint,6,opt,name=immediate,proto3" json:"immediate,omitempty"`
	// Optional. The max amount in sats that can be used as the fees. Setting this
	// value greater than the input's value may result in CPFP - one or more wallet
	// utxos will be used to pay the fees specified by the budget. If not set, for
	// new inputs, by default 50% of the input's value will be treated as the
	// budget for fee bumping; for existing inputs, their current budgets will be
	// retained.
	Budget uint64 `protobuf:"varint,7,opt,name=budget,proto3" json:"budget,omitempty"`
}

func (x *BumpFeeRequest) Reset() {
	*x = BumpFeeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BumpFeeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BumpFeeRequest) ProtoMessage() {}

func (x *BumpFeeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BumpFeeRequest.ProtoReflect.Descriptor instead.
func (*BumpFeeRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{42}
}

func (x *BumpFeeRequest) GetOutpoint() *lnrpc.OutPoint {
	if x != nil {
		return x.Outpoint
	}
	return nil
}

func (x *BumpFeeRequest) GetTargetConf() uint32 {
	if x != nil {
		return x.TargetConf
	}
	return 0
}

// Deprecated: Marked as deprecated in walletrpc/walletkit.proto.
func (x *BumpFeeRequest) GetSatPerByte() uint32 {
	if x != nil {
		return x.SatPerByte
	}
	return 0
}

// Deprecated: Marked as deprecated in walletrpc/walletkit.proto.
func (x *BumpFeeRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *BumpFeeRequest) GetSatPerVbyte() uint64 {
	if x != nil {
		return x.SatPerVbyte
	}
	return 0
}

func (x *BumpFeeRequest) GetImmediate() bool {
	if x != nil {
		return x.Immediate
	}
	return false
}

func (x *BumpFeeRequest) GetBudget() uint64 {
	if x != nil {
		return x.Budget
	}
	return 0
}

type BumpFeeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status of the bump fee operation.
	Status string `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *BumpFeeResponse) Reset() {
	*x = BumpFeeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BumpFeeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BumpFeeResponse) ProtoMessage() {}

func (x *BumpFeeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BumpFeeResponse.ProtoReflect.Descriptor instead.
func (*BumpFeeResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{43}
}

func (x *BumpFeeResponse) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

type BumpForceCloseFeeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The channel point which force close transaction we are attempting to
	// bump the fee rate for.
	ChanPoint *lnrpc.ChannelPoint `protobuf:"bytes,1,opt,name=chan_point,json=chanPoint,proto3" json:"chan_point,omitempty"`
	// Optional. The deadline delta in number of blocks that the anchor output
	// should be spent within to bump the closing transaction.
	DeadlineDelta uint32 `protobuf:"varint,2,opt,name=deadline_delta,json=deadlineDelta,proto3" json:"deadline_delta,omitempty"`
	// Optional. The starting fee rate, expressed in sat/vbyte. This value will be
	// used by the sweeper's fee function as its starting fee rate. When not set,
	// the sweeper will use the estimated fee rate using the target_conf as the
	// starting fee rate.
	StartingFeerate uint64 `protobuf:"varint,3,opt,name=starting_feerate,json=startingFeerate,proto3" json:"starting_feerate,omitempty"`
	// Optional. Whether this cpfp transaction will be triggered immediately. When
	// set to true, the sweeper will consider all currently registered sweeps and
	// trigger new batch transactions including the sweeping of the anchor output
	// related to the selected force close transaction.
	Immediate bool `protobuf:"varint,4,opt,name=immediate,proto3" json:"immediate,omitempty"`
	// Optional. The max amount in sats that can be used as the fees. For already
	// registered anchor outputs if not set explicitly the old value will be used.
	// For channel force closes which have no HTLCs in their commitment transaction
	// this value has to be set to an appropriate amount to pay for the cpfp
	// transaction of the force closed channel otherwise the fee bumping will fail.
	Budget uint64 `protobuf:"varint,5,opt,name=budget,proto3" json:"budget,omitempty"`
}

func (x *BumpForceCloseFeeRequest) Reset() {
	*x = BumpForceCloseFeeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BumpForceCloseFeeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BumpForceCloseFeeRequest) ProtoMessage() {}

func (x *BumpForceCloseFeeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BumpForceCloseFeeRequest.ProtoReflect.Descriptor instead.
func (*BumpForceCloseFeeRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{44}
}

func (x *BumpForceCloseFeeRequest) GetChanPoint() *lnrpc.ChannelPoint {
	if x != nil {
		return x.ChanPoint
	}
	return nil
}

func (x *BumpForceCloseFeeRequest) GetDeadlineDelta() uint32 {
	if x != nil {
		return x.DeadlineDelta
	}
	return 0
}

func (x *BumpForceCloseFeeRequest) GetStartingFeerate() uint64 {
	if x != nil {
		return x.StartingFeerate
	}
	return 0
}

func (x *BumpForceCloseFeeRequest) GetImmediate() bool {
	if x != nil {
		return x.Immediate
	}
	return false
}

func (x *BumpForceCloseFeeRequest) GetBudget() uint64 {
	if x != nil {
		return x.Budget
	}
	return 0
}

type BumpForceCloseFeeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status of the force close fee bump operation.
	Status string `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *BumpForceCloseFeeResponse) Reset() {
	*x = BumpForceCloseFeeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BumpForceCloseFeeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BumpForceCloseFeeResponse) ProtoMessage() {}

func (x *BumpForceCloseFeeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BumpForceCloseFeeResponse.ProtoReflect.Descriptor instead.
func (*BumpForceCloseFeeResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{45}
}

func (x *BumpForceCloseFeeResponse) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

type ListSweepsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Retrieve the full sweep transaction details. If false, only the sweep txids
	// will be returned. Note that some sweeps that LND publishes will have been
	// replaced-by-fee, so will not be included in this output.
	Verbose bool `protobuf:"varint,1,opt,name=verbose,proto3" json:"verbose,omitempty"`
	// The start height to use when fetching sweeps. If not specified (0), the
	// result will start from the earliest sweep. If set to -1 the result will
	// only include unconfirmed sweeps (at the time of the call).
	StartHeight int32 `protobuf:"varint,2,opt,name=start_height,json=startHeight,proto3" json:"start_height,omitempty"`
}

func (x *ListSweepsRequest) Reset() {
	*x = ListSweepsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSweepsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSweepsRequest) ProtoMessage() {}

func (x *ListSweepsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSweepsRequest.ProtoReflect.Descriptor instead.
func (*ListSweepsRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{46}
}

func (x *ListSweepsRequest) GetVerbose() bool {
	if x != nil {
		return x.Verbose
	}
	return false
}

func (x *ListSweepsRequest) GetStartHeight() int32 {
	if x != nil {
		return x.StartHeight
	}
	return 0
}

type ListSweepsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Sweeps:
	//
	//	*ListSweepsResponse_TransactionDetails
	//	*ListSweepsResponse_TransactionIds
	Sweeps isListSweepsResponse_Sweeps `protobuf_oneof:"sweeps"`
}

func (x *ListSweepsResponse) Reset() {
	*x = ListSweepsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSweepsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSweepsResponse) ProtoMessage() {}

func (x *ListSweepsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSweepsResponse.ProtoReflect.Descriptor instead.
func (*ListSweepsResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{47}
}

func (m *ListSweepsResponse) GetSweeps() isListSweepsResponse_Sweeps {
	if m != nil {
		return m.Sweeps
	}
	return nil
}

func (x *ListSweepsResponse) GetTransactionDetails() *lnrpc.TransactionDetails {
	if x, ok := x.GetSweeps().(*ListSweepsResponse_TransactionDetails); ok {
		return x.TransactionDetails
	}
	return nil
}

func (x *ListSweepsResponse) GetTransactionIds() *ListSweepsResponse_TransactionIDs {
	if x, ok := x.GetSweeps().(*ListSweepsResponse_TransactionIds); ok {
		return x.TransactionIds
	}
	return nil
}

type isListSweepsResponse_Sweeps interface {
	isListSweepsResponse_Sweeps()
}

type ListSweepsResponse_TransactionDetails struct {
	TransactionDetails *lnrpc.TransactionDetails `protobuf:"bytes,1,opt,name=transaction_details,json=transactionDetails,proto3,oneof"`
}

type ListSweepsResponse_TransactionIds struct {
	TransactionIds *ListSweepsResponse_TransactionIDs `protobuf:"bytes,2,opt,name=transaction_ids,json=transactionIds,proto3,oneof"`
}

func (*ListSweepsResponse_TransactionDetails) isListSweepsResponse_Sweeps() {}

func (*ListSweepsResponse_TransactionIds) isListSweepsResponse_Sweeps() {}

type LabelTransactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The txid of the transaction to label. Note: When using gRPC, the bytes
	// must be in little-endian (reverse) order.
	Txid []byte `protobuf:"bytes,1,opt,name=txid,proto3" json:"txid,omitempty"`
	// The label to add to the transaction, limited to 500 characters.
	Label string `protobuf:"bytes,2,opt,name=label,proto3" json:"label,omitempty"`
	// Whether to overwrite the existing label, if it is present.
	Overwrite bool `protobuf:"varint,3,opt,name=overwrite,proto3" json:"overwrite,omitempty"`
}

func (x *LabelTransactionRequest) Reset() {
	*x = LabelTransactionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LabelTransactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelTransactionRequest) ProtoMessage() {}

func (x *LabelTransactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelTransactionRequest.ProtoReflect.Descriptor instead.
func (*LabelTransactionRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{48}
}

func (x *LabelTransactionRequest) GetTxid() []byte {
	if x != nil {
		return x.Txid
	}
	return nil
}

func (x *LabelTransactionRequest) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *LabelTransactionRequest) GetOverwrite() bool {
	if x != nil {
		return x.Overwrite
	}
	return false
}

type LabelTransactionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status of the label operation.
	Status string `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *LabelTransactionResponse) Reset() {
	*x = LabelTransactionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LabelTransactionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelTransactionResponse) ProtoMessage() {}

func (x *LabelTransactionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelTransactionResponse.ProtoReflect.Descriptor instead.
func (*LabelTransactionResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{49}
}

func (x *LabelTransactionResponse) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

type FundPsbtRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Template:
	//
	//	*FundPsbtRequest_Psbt
	//	*FundPsbtRequest_Raw
	//	*FundPsbtRequest_CoinSelect
	Template isFundPsbtRequest_Template `protobuf_oneof:"template"`
	// Types that are assignable to Fees:
	//
	//	*FundPsbtRequest_TargetConf
	//	*FundPsbtRequest_SatPerVbyte
	//	*FundPsbtRequest_SatPerKw
	Fees isFundPsbtRequest_Fees `protobuf_oneof:"fees"`
	// The name of the account to fund the PSBT with. If empty, the default wallet
	// account is used.
	Account string `protobuf:"bytes,5,opt,name=account,proto3" json:"account,omitempty"`
	// The minimum number of confirmations each one of your outputs used for
	// the transaction must satisfy.
	MinConfs int32 `protobuf:"varint,6,opt,name=min_confs,json=minConfs,proto3" json:"min_confs,omitempty"`
	// Whether unconfirmed outputs should be used as inputs for the transaction.
	SpendUnconfirmed bool `protobuf:"varint,7,opt,name=spend_unconfirmed,json=spendUnconfirmed,proto3" json:"spend_unconfirmed,omitempty"`
	// The address type for the change. If empty, P2WPKH addresses will be used
	// for default accounts and single imported public keys. For custom
	// accounts, no change type should be provided as the coin selection key
	// scope will always be used to generate the change address.
	ChangeType ChangeAddressType `protobuf:"varint,8,opt,name=change_type,json=changeType,proto3,enum=walletrpc.ChangeAddressType" json:"change_type,omitempty"`
	// The strategy to use for selecting coins during funding the PSBT.
	CoinSelectionStrategy lnrpc.CoinSelectionStrategy `protobuf:"varint,10,opt,name=coin_selection_strategy,json=coinSelectionStrategy,proto3,enum=lnrpc.CoinSelectionStrategy" json:"coin_selection_strategy,omitempty"`
	// The max fee to total output amount ratio that this psbt should adhere to.
	MaxFeeRatio float64 `protobuf:"fixed64,12,opt,name=max_fee_ratio,json=maxFeeRatio,proto3" json:"max_fee_ratio,omitempty"`
}

func (x *FundPsbtRequest) Reset() {
	*x = FundPsbtRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FundPsbtRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FundPsbtRequest) ProtoMessage() {}

func (x *FundPsbtRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FundPsbtRequest.ProtoReflect.Descriptor instead.
func (*FundPsbtRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{50}
}

func (m *FundPsbtRequest) GetTemplate() isFundPsbtRequest_Template {
	if m != nil {
		return m.Template
	}
	return nil
}

func (x *FundPsbtRequest) GetPsbt() []byte {
	if x, ok := x.GetTemplate().(*FundPsbtRequest_Psbt); ok {
		return x.Psbt
	}
	return nil
}

func (x *FundPsbtRequest) GetRaw() *TxTemplate {
	if x, ok := x.GetTemplate().(*FundPsbtRequest_Raw); ok {
		return x.Raw
	}
	return nil
}

func (x *FundPsbtRequest) GetCoinSelect() *PsbtCoinSelect {
	if x, ok := x.GetTemplate().(*FundPsbtRequest_CoinSelect); ok {
		return x.CoinSelect
	}
	return nil
}

func (m *FundPsbtRequest) GetFees() isFundPsbtRequest_Fees {
	if m != nil {
		return m.Fees
	}
	return nil
}

func (x *FundPsbtRequest) GetTargetConf() uint32 {
	if x, ok := x.GetFees().(*FundPsbtRequest_TargetConf); ok {
		return x.TargetConf
	}
	return 0
}

func (x *FundPsbtRequest) GetSatPerVbyte() uint64 {
	if x, ok := x.GetFees().(*FundPsbtRequest_SatPerVbyte); ok {
		return x.SatPerVbyte
	}
	return 0
}

func (x *FundPsbtRequest) GetSatPerKw() uint64 {
	if x, ok := x.GetFees().(*FundPsbtRequest_SatPerKw); ok {
		return x.SatPerKw
	}
	return 0
}

func (x *FundPsbtRequest) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *FundPsbtRequest) GetMinConfs() int32 {
	if x != nil {
		return x.MinConfs
	}
	return 0
}

func (x *FundPsbtRequest) GetSpendUnconfirmed() bool {
	if x != nil {
		return x.SpendUnconfirmed
	}
	return false
}

func (x *FundPsbtRequest) GetChangeType() ChangeAddressType {
	if x != nil {
		return x.ChangeType
	}
	return ChangeAddressType_CHANGE_ADDRESS_TYPE_UNSPECIFIED
}

func (x *FundPsbtRequest) GetCoinSelectionStrategy() lnrpc.CoinSelectionStrategy {
	if x != nil {
		return x.CoinSelectionStrategy
	}
	return lnrpc.CoinSelectionStrategy(0)
}

func (x *FundPsbtRequest) GetMaxFeeRatio() float64 {
	if x != nil {
		return x.MaxFeeRatio
	}
	return 0
}

type isFundPsbtRequest_Template interface {
	isFundPsbtRequest_Template()
}

type FundPsbtRequest_Psbt struct {
	// Use an existing PSBT packet as the template for the funded PSBT.
	//
	// The packet must contain at least one non-dust output. If one or more
	// inputs are specified, no coin selection is performed. In that case every
	// input must be an UTXO known to the wallet that has not been locked
	// before. The sum of all inputs must be sufficiently greater than the sum
	// of all outputs to pay a miner fee with the specified fee rate. A change
	// output is added to the PSBT if necessary.
	Psbt []byte `protobuf:"bytes,1,opt,name=psbt,proto3,oneof"`
}

type FundPsbtRequest_Raw struct {
	// Use the outputs and optional inputs from this raw template.
	Raw *TxTemplate `protobuf:"bytes,2,opt,name=raw,proto3,oneof"`
}

type FundPsbtRequest_CoinSelect struct {
	// Use an existing PSBT packet as the template for the funded PSBT.
	//
	// The difference to the pure PSBT template above is that coin selection is
	// performed even if inputs are specified. The output amounts are summed up
	// and used as the target amount for coin selection. A change output must
	// either already exist in the PSBT and be marked as such, otherwise a new
	// change output of the specified output type will be added. Any inputs
	// already specified in the PSBT must already be locked (if they belong to
	// this node), only newly added inputs will be locked by this RPC.
	//
	// In case the sum of the already provided inputs exceeds the required
	// output amount, no new coins are selected. Instead only the fee and
	// change amount calculation is performed (e.g. a change output is added if
	// requested or the change is added to the specified existing change
	// output, given there is any non-dust change). This can be identified by
	// the returned locked UTXOs being empty.
	CoinSelect *PsbtCoinSelect `protobuf:"bytes,9,opt,name=coin_select,json=coinSelect,proto3,oneof"`
}

func (*FundPsbtRequest_Psbt) isFundPsbtRequest_Template() {}

func (*FundPsbtRequest_Raw) isFundPsbtRequest_Template() {}

func (*FundPsbtRequest_CoinSelect) isFundPsbtRequest_Template() {}

type isFundPsbtRequest_Fees interface {
	isFundPsbtRequest_Fees()
}

type FundPsbtRequest_TargetConf struct {
	// The target number of blocks that the transaction should be confirmed in.
	TargetConf uint32 `protobuf:"varint,3,opt,name=target_conf,json=targetConf,proto3,oneof"`
}

type FundPsbtRequest_SatPerVbyte struct {
	// The fee rate, expressed in sat/vbyte, that should be used to spend the
	// input with.
	SatPerVbyte uint64 `protobuf:"varint,4,opt,name=sat_per_vbyte,json=satPerVbyte,proto3,oneof"`
}

type FundPsbtRequest_SatPerKw struct {
	// The fee rate, expressed in sat/kWU, that should be used to spend the
	// input with.
	SatPerKw uint64 `protobuf:"varint,11,opt,name=sat_per_kw,json=satPerKw,proto3,oneof"`
}

func (*FundPsbtRequest_TargetConf) isFundPsbtRequest_Fees() {}

func (*FundPsbtRequest_SatPerVbyte) isFundPsbtRequest_Fees() {}

func (*FundPsbtRequest_SatPerKw) isFundPsbtRequest_Fees() {}

type FundPsbtResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The funded but not yet signed PSBT packet.
	FundedPsbt []byte `protobuf:"bytes,1,opt,name=funded_psbt,json=fundedPsbt,proto3" json:"funded_psbt,omitempty"`
	// The index of the added change output or -1 if no change was left over.
	ChangeOutputIndex int32 `protobuf:"varint,2,opt,name=change_output_index,json=changeOutputIndex,proto3" json:"change_output_index,omitempty"`
	// The list of lock leases that were acquired for the inputs in the funded PSBT
	// packet. Only inputs added to the PSBT by this RPC are locked, inputs that
	// were already present in the PSBT are not locked.
	LockedUtxos []*UtxoLease `protobuf:"bytes,3,rep,name=locked_utxos,json=lockedUtxos,proto3" json:"locked_utxos,omitempty"`
}

func (x *FundPsbtResponse) Reset() {
	*x = FundPsbtResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FundPsbtResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FundPsbtResponse) ProtoMessage() {}

func (x *FundPsbtResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FundPsbtResponse.ProtoReflect.Descriptor instead.
func (*FundPsbtResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{51}
}

func (x *FundPsbtResponse) GetFundedPsbt() []byte {
	if x != nil {
		return x.FundedPsbt
	}
	return nil
}

func (x *FundPsbtResponse) GetChangeOutputIndex() int32 {
	if x != nil {
		return x.ChangeOutputIndex
	}
	return 0
}

func (x *FundPsbtResponse) GetLockedUtxos() []*UtxoLease {
	if x != nil {
		return x.LockedUtxos
	}
	return nil
}

type TxTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An optional list of inputs to use. Every input must be an UTXO known to the
	// wallet that has not been locked before. The sum of all inputs must be
	// sufficiently greater than the sum of all outputs to pay a miner fee with the
	// fee rate specified in the parent message.
	//
	// If no inputs are specified, coin selection will be performed instead and
	// inputs of sufficient value will be added to the resulting PSBT.
	Inputs []*lnrpc.OutPoint `protobuf:"bytes,1,rep,name=inputs,proto3" json:"inputs,omitempty"`
	// A map of all addresses and the amounts to send to in the funded PSBT.
	Outputs map[string]uint64 `protobuf:"bytes,2,rep,name=outputs,proto3" json:"outputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (x *TxTemplate) Reset() {
	*x = TxTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TxTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TxTemplate) ProtoMessage() {}

func (x *TxTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TxTemplate.ProtoReflect.Descriptor instead.
func (*TxTemplate) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{52}
}

func (x *TxTemplate) GetInputs() []*lnrpc.OutPoint {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *TxTemplate) GetOutputs() map[string]uint64 {
	if x != nil {
		return x.Outputs
	}
	return nil
}

type PsbtCoinSelect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The template to use for the funded PSBT. The template must contain at least
	// one non-dust output. The amount to be funded is calculated by summing up the
	// amounts of all outputs in the template, subtracting all the input values of
	// the already specified inputs. The change value is added to the output that
	// is marked as such (or a new change output is added if none is marked). For
	// the input amount calculation to be correct, the template must have the
	// WitnessUtxo field set for all inputs. Any inputs already specified in the
	// PSBT must already be locked (if they belong to this node), only newly added
	// inputs will be locked by this RPC.
	Psbt []byte `protobuf:"bytes,1,opt,name=psbt,proto3" json:"psbt,omitempty"`
	// Types that are assignable to ChangeOutput:
	//
	//	*PsbtCoinSelect_ExistingOutputIndex
	//	*PsbtCoinSelect_Add
	ChangeOutput isPsbtCoinSelect_ChangeOutput `protobuf_oneof:"change_output"`
}

func (x *PsbtCoinSelect) Reset() {
	*x = PsbtCoinSelect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PsbtCoinSelect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PsbtCoinSelect) ProtoMessage() {}

func (x *PsbtCoinSelect) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PsbtCoinSelect.ProtoReflect.Descriptor instead.
func (*PsbtCoinSelect) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{53}
}

func (x *PsbtCoinSelect) GetPsbt() []byte {
	if x != nil {
		return x.Psbt
	}
	return nil
}

func (m *PsbtCoinSelect) GetChangeOutput() isPsbtCoinSelect_ChangeOutput {
	if m != nil {
		return m.ChangeOutput
	}
	return nil
}

func (x *PsbtCoinSelect) GetExistingOutputIndex() int32 {
	if x, ok := x.GetChangeOutput().(*PsbtCoinSelect_ExistingOutputIndex); ok {
		return x.ExistingOutputIndex
	}
	return 0
}

func (x *PsbtCoinSelect) GetAdd() bool {
	if x, ok := x.GetChangeOutput().(*PsbtCoinSelect_Add); ok {
		return x.Add
	}
	return false
}

type isPsbtCoinSelect_ChangeOutput interface {
	isPsbtCoinSelect_ChangeOutput()
}

type PsbtCoinSelect_ExistingOutputIndex struct {
	// Use the existing output within the template PSBT with the specified
	// index as the change output. Any leftover change will be added to the
	// already specified amount of that output. To add a new change output to
	// the PSBT, set the "add" field below instead. The type of change output
	// added is defined by change_type in the parent message.
	ExistingOutputIndex int32 `protobuf:"varint,2,opt,name=existing_output_index,json=existingOutputIndex,proto3,oneof"`
}

type PsbtCoinSelect_Add struct {
	// Add a new change output to the PSBT using the change_type specified in
	// the parent message.
	Add bool `protobuf:"varint,3,opt,name=add,proto3,oneof"`
}

func (*PsbtCoinSelect_ExistingOutputIndex) isPsbtCoinSelect_ChangeOutput() {}

func (*PsbtCoinSelect_Add) isPsbtCoinSelect_ChangeOutput() {}

type UtxoLease struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A 32 byte random ID that identifies the lease.
	Id []byte `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The identifying outpoint of the output being leased.
	Outpoint *lnrpc.OutPoint `protobuf:"bytes,2,opt,name=outpoint,proto3" json:"outpoint,omitempty"`
	// The absolute expiration of the output lease represented as a unix timestamp.
	Expiration uint64 `protobuf:"varint,3,opt,name=expiration,proto3" json:"expiration,omitempty"`
	// The public key script of the leased output.
	PkScript []byte `protobuf:"bytes,4,opt,name=pk_script,json=pkScript,proto3" json:"pk_script,omitempty"`
	// The value of the leased output in satoshis.
	Value uint64 `protobuf:"varint,5,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *UtxoLease) Reset() {
	*x = UtxoLease{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UtxoLease) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UtxoLease) ProtoMessage() {}

func (x *UtxoLease) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UtxoLease.ProtoReflect.Descriptor instead.
func (*UtxoLease) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{54}
}

func (x *UtxoLease) GetId() []byte {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *UtxoLease) GetOutpoint() *lnrpc.OutPoint {
	if x != nil {
		return x.Outpoint
	}
	return nil
}

func (x *UtxoLease) GetExpiration() uint64 {
	if x != nil {
		return x.Expiration
	}
	return 0
}

func (x *UtxoLease) GetPkScript() []byte {
	if x != nil {
		return x.PkScript
	}
	return nil
}

func (x *UtxoLease) GetValue() uint64 {
	if x != nil {
		return x.Value
	}
	return 0
}

type SignPsbtRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The PSBT that should be signed. The PSBT must contain all required inputs,
	// outputs, UTXO data and custom fields required to identify the signing key.
	FundedPsbt []byte `protobuf:"bytes,1,opt,name=funded_psbt,json=fundedPsbt,proto3" json:"funded_psbt,omitempty"`
}

func (x *SignPsbtRequest) Reset() {
	*x = SignPsbtRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignPsbtRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignPsbtRequest) ProtoMessage() {}

func (x *SignPsbtRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignPsbtRequest.ProtoReflect.Descriptor instead.
func (*SignPsbtRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{55}
}

func (x *SignPsbtRequest) GetFundedPsbt() []byte {
	if x != nil {
		return x.FundedPsbt
	}
	return nil
}

type SignPsbtResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The signed transaction in PSBT format.
	SignedPsbt []byte `protobuf:"bytes,1,opt,name=signed_psbt,json=signedPsbt,proto3" json:"signed_psbt,omitempty"`
	// The indices of signed inputs.
	SignedInputs []uint32 `protobuf:"varint,2,rep,packed,name=signed_inputs,json=signedInputs,proto3" json:"signed_inputs,omitempty"`
}

func (x *SignPsbtResponse) Reset() {
	*x = SignPsbtResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignPsbtResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignPsbtResponse) ProtoMessage() {}

func (x *SignPsbtResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignPsbtResponse.ProtoReflect.Descriptor instead.
func (*SignPsbtResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{56}
}

func (x *SignPsbtResponse) GetSignedPsbt() []byte {
	if x != nil {
		return x.SignedPsbt
	}
	return nil
}

func (x *SignPsbtResponse) GetSignedInputs() []uint32 {
	if x != nil {
		return x.SignedInputs
	}
	return nil
}

type FinalizePsbtRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A PSBT that should be signed and finalized. The PSBT must contain all
	// required inputs, outputs, UTXO data and partial signatures of all other
	// signers.
	FundedPsbt []byte `protobuf:"bytes,1,opt,name=funded_psbt,json=fundedPsbt,proto3" json:"funded_psbt,omitempty"`
	// The name of the account to finalize the PSBT with. If empty, the default
	// wallet account is used.
	Account string `protobuf:"bytes,5,opt,name=account,proto3" json:"account,omitempty"`
}

func (x *FinalizePsbtRequest) Reset() {
	*x = FinalizePsbtRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizePsbtRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizePsbtRequest) ProtoMessage() {}

func (x *FinalizePsbtRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizePsbtRequest.ProtoReflect.Descriptor instead.
func (*FinalizePsbtRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{57}
}

func (x *FinalizePsbtRequest) GetFundedPsbt() []byte {
	if x != nil {
		return x.FundedPsbt
	}
	return nil
}

func (x *FinalizePsbtRequest) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

type FinalizePsbtResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fully signed and finalized transaction in PSBT format.
	SignedPsbt []byte `protobuf:"bytes,1,opt,name=signed_psbt,json=signedPsbt,proto3" json:"signed_psbt,omitempty"`
	// The fully signed and finalized transaction in the raw wire format.
	RawFinalTx []byte `protobuf:"bytes,2,opt,name=raw_final_tx,json=rawFinalTx,proto3" json:"raw_final_tx,omitempty"`
}

func (x *FinalizePsbtResponse) Reset() {
	*x = FinalizePsbtResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizePsbtResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizePsbtResponse) ProtoMessage() {}

func (x *FinalizePsbtResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizePsbtResponse.ProtoReflect.Descriptor instead.
func (*FinalizePsbtResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{58}
}

func (x *FinalizePsbtResponse) GetSignedPsbt() []byte {
	if x != nil {
		return x.SignedPsbt
	}
	return nil
}

func (x *FinalizePsbtResponse) GetRawFinalTx() []byte {
	if x != nil {
		return x.RawFinalTx
	}
	return nil
}

type ListLeasesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ListLeasesRequest) Reset() {
	*x = ListLeasesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLeasesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLeasesRequest) ProtoMessage() {}

func (x *ListLeasesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLeasesRequest.ProtoReflect.Descriptor instead.
func (*ListLeasesRequest) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{59}
}

type ListLeasesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of currently leased utxos.
	LockedUtxos []*UtxoLease `protobuf:"bytes,1,rep,name=locked_utxos,json=lockedUtxos,proto3" json:"locked_utxos,omitempty"`
}

func (x *ListLeasesResponse) Reset() {
	*x = ListLeasesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLeasesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLeasesResponse) ProtoMessage() {}

func (x *ListLeasesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLeasesResponse.ProtoReflect.Descriptor instead.
func (*ListLeasesResponse) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{60}
}

func (x *ListLeasesResponse) GetLockedUtxos() []*UtxoLease {
	if x != nil {
		return x.LockedUtxos
	}
	return nil
}

type ListSweepsResponse_TransactionIDs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Reversed, hex-encoded string representing the transaction ids of the
	// sweeps that our node has broadcast. Note that these transactions may
	// not have confirmed yet, we record sweeps on broadcast, not confirmation.
	TransactionIds []string `protobuf:"bytes,1,rep,name=transaction_ids,json=transactionIds,proto3" json:"transaction_ids,omitempty"`
}

func (x *ListSweepsResponse_TransactionIDs) Reset() {
	*x = ListSweepsResponse_TransactionIDs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_walletrpc_walletkit_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSweepsResponse_TransactionIDs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSweepsResponse_TransactionIDs) ProtoMessage() {}

func (x *ListSweepsResponse_TransactionIDs) ProtoReflect() protoreflect.Message {
	mi := &file_walletrpc_walletkit_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSweepsResponse_TransactionIDs.ProtoReflect.Descriptor instead.
func (*ListSweepsResponse_TransactionIDs) Descriptor() ([]byte, []int) {
	return file_walletrpc_walletkit_proto_rawDescGZIP(), []int{47, 0}
}

func (x *ListSweepsResponse_TransactionIDs) GetTransactionIds() []string {
	if x != nil {
		return x.TransactionIds
	}
	return nil
}

var File_walletrpc_walletkit_proto protoreflect.FileDescriptor

var file_walletrpc_walletkit_proto_rawDesc = []byte{
	0x0a, 0x19, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2f, 0x77, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x6b, 0x69, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x09, 0x77, 0x61, 0x6c,
	0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x1a, 0x0f, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x14, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63,
	0x2f, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x93, 0x01,
	0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x6e, 0x73, 0x70, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x73, 0x12, 0x18,
	0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x75, 0x6e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0f, 0x75, 0x6e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x4f,
	0x6e, 0x6c, 0x79, 0x22, 0x38, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x6e, 0x73, 0x70, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x05, 0x75, 0x74,
	0x78, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x6c, 0x6e, 0x72, 0x70,
	0x63, 0x2e, 0x55, 0x74, 0x78, 0x6f, 0x52, 0x05, 0x75, 0x74, 0x78, 0x6f, 0x73, 0x22, 0x80, 0x01,
	0x0a, 0x12, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x2b, 0x0a, 0x08, 0x6f, 0x75, 0x74, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x6c, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4f,
	0x75, 0x74, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x6f, 0x75, 0x74, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x12, 0x2d, 0x0a, 0x12, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x11, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73,
	0x22, 0x35, 0x0a, 0x13, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x65, 0x78, 0x70,
	0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x53, 0x0a, 0x14, 0x52, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x2b, 0x0a, 0x08, 0x6f, 0x75, 0x74, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x0f, 0x2e, 0x6c, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4f, 0x75, 0x74, 0x50, 0x6f, 0x69,
	0x6e, 0x74, 0x52, 0x08, 0x6f, 0x75, 0x74, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22, 0x2f, 0x0a, 0x15,
	0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x51, 0x0a,
	0x06, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x12, 0x28, 0x0a, 0x10, 0x6b, 0x65, 0x79, 0x5f, 0x66,
	0x69, 0x6e, 0x67, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0e, 0x6b, 0x65, 0x79, 0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x50, 0x72, 0x69, 0x6e,
	0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x6b, 0x65, 0x79, 0x5f, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x6b, 0x65, 0x79, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79,
	0x22, 0x6b, 0x0a, 0x0b, 0x41, 0x64, 0x64, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x18, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x72, 0x70, 0x63, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x22, 0x0a,
	0x0c, 0x41, 0x64, 0x64, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x61, 0x64, 0x64,
	0x72, 0x22, 0xe2, 0x02, 0x0a, 0x07, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x39, 0x0a, 0x0c, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x72, 0x70, 0x63, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0b, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2e, 0x0a, 0x13,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x64, 0x65, 0x64, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x34, 0x0a, 0x16,
	0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x66, 0x69, 0x6e, 0x67, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x14, 0x6d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x64, 0x65, 0x72, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x64, 0x65, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x12, 0x2c, 0x0a, 0x12, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x10, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x4b, 0x65, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x4b,
	0x65, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x77, 0x61, 0x74, 0x63, 0x68,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x77, 0x61, 0x74,
	0x63, 0x68, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xae, 0x01, 0x0a, 0x0f, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x73, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x69, 0x73, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x12, 0x18, 0x0a, 0x07, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x27, 0x0a, 0x0f, 0x64, 0x65, 0x72, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x64, 0x65, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x22, 0xc8, 0x01, 0x0a, 0x14, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x57, 0x69, 0x74, 0x68, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x0c, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x77, 0x61, 0x6c,
	0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0b, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x27, 0x0a, 0x0f, 0x64, 0x65, 0x72, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x64, 0x65, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x12, 0x38, 0x0a, 0x09, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x77, 0x61,
	0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x65, 0x73, 0x22, 0x64, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a,
	0x0c, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x22, 0x46, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x2e, 0x0a, 0x08, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x08, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x22, 0x56, 0x0a, 0x16, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x1a, 0x61, 0x64,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x18,
	0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x22, 0x44, 0x0a, 0x17, 0x52, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x72,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x22, 0x6b,
	0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x68, 0x6f,
	0x77, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x73, 0x68, 0x6f, 0x77, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x22, 0x6e, 0x0a, 0x15, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x16, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x77, 0x69, 0x74, 0x68, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63,
	0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x57, 0x69, 0x74, 0x68, 0x41, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x65, 0x73, 0x52, 0x14, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x57, 0x69,
	0x74, 0x68, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x22, 0x2b, 0x0a, 0x15, 0x47,
	0x65, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x78, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x74, 0x78, 0x69, 0x64, 0x22, 0x42, 0x0a, 0x1a, 0x53, 0x69, 0x67, 0x6e,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x57, 0x69, 0x74, 0x68, 0x41, 0x64, 0x64, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x73, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x03, 0x6d, 0x73, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x61, 0x64, 0x64, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x61, 0x64, 0x64, 0x72, 0x22, 0x3b, 0x0a, 0x1b,
	0x53, 0x69, 0x67, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x57, 0x69, 0x74, 0x68, 0x41,
	0x64, 0x64, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x73,
	0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0x62, 0x0a, 0x1c, 0x56, 0x65, 0x72,
	0x69, 0x66, 0x79, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x57, 0x69, 0x74, 0x68, 0x41, 0x64,
	0x64, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x73, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x6d, 0x73, 0x67, 0x12, 0x1c, 0x0a, 0x09, 0x73,
	0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x61, 0x64, 0x64,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x61, 0x64, 0x64, 0x72, 0x22, 0x4d, 0x0a,
	0x1d, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x57, 0x69,
	0x74, 0x68, 0x41, 0x64, 0x64, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x75, 0x62, 0x6b, 0x65, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x70, 0x75, 0x62, 0x6b, 0x65, 0x79, 0x22, 0xe4, 0x01, 0x0a,
	0x14, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x34, 0x0a, 0x16, 0x6d, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x66, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x14, 0x6d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x4b, 0x65, 0x79, 0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12,
	0x39, 0x0a, 0x0c, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70,
	0x63, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x72,
	0x79, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x64, 0x72, 0x79,
	0x52, 0x75, 0x6e, 0x22, 0xaf, 0x01, 0x0a, 0x15, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a,
	0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x33, 0x0a, 0x16, 0x64,
	0x72, 0x79, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f,
	0x61, 0x64, 0x64, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x64, 0x72, 0x79,
	0x52, 0x75, 0x6e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x73,
	0x12, 0x33, 0x0a, 0x16, 0x64, 0x72, 0x79, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x13, 0x64, 0x72, 0x79, 0x52, 0x75, 0x6e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x41, 0x64, 0x64, 0x72, 0x73, 0x22, 0x72, 0x0a, 0x16, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x39,
	0x0a, 0x0c, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63,
	0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x22, 0x31, 0x0a, 0x17, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xa9, 0x02, 0x0a,
	0x16, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x70, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x11, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x3b, 0x0a, 0x09, 0x66, 0x75, 0x6c, 0x6c, 0x5f,
	0x74, 0x72, 0x65, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x77, 0x61, 0x6c,
	0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x54, 0x61, 0x70, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x46, 0x75, 0x6c, 0x6c, 0x54, 0x72, 0x65, 0x65, 0x48, 0x00, 0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c,
	0x54, 0x72, 0x65, 0x65, 0x12, 0x4a, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f,
	0x72, 0x65, 0x76, 0x65, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x77,
	0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x54, 0x61, 0x70, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x76, 0x65, 0x61, 0x6c, 0x48,
	0x00, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x76, 0x65, 0x61, 0x6c,
	0x12, 0x26, 0x0a, 0x0e, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0c, 0x72, 0x6f, 0x6f, 0x74,
	0x48, 0x61, 0x73, 0x68, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x24, 0x0a, 0x0d, 0x66, 0x75, 0x6c, 0x6c,
	0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x00, 0x52, 0x0b, 0x66, 0x75, 0x6c, 0x6c, 0x4b, 0x65, 0x79, 0x4f, 0x6e, 0x6c, 0x79, 0x42, 0x08,
	0x0a, 0x06, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0x46, 0x0a, 0x11, 0x54, 0x61, 0x70, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x46, 0x75, 0x6c, 0x6c, 0x54, 0x72, 0x65, 0x65, 0x12, 0x31, 0x0a,
	0x0a, 0x61, 0x6c, 0x6c, 0x5f, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x54, 0x61,
	0x70, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x09, 0x61, 0x6c, 0x6c, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73,
	0x22, 0x44, 0x0a, 0x07, 0x54, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x66, 0x12, 0x21, 0x0a, 0x0c, 0x6c,
	0x65, 0x61, 0x66, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0b, 0x6c, 0x65, 0x61, 0x66, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0x83, 0x01, 0x0a, 0x16, 0x54, 0x61, 0x70, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x76, 0x65, 0x61,
	0x6c, 0x12, 0x37, 0x0a, 0x0d, 0x72, 0x65, 0x76, 0x65, 0x61, 0x6c, 0x65, 0x64, 0x5f, 0x6c, 0x65,
	0x61, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65,
	0x74, 0x72, 0x70, 0x63, 0x2e, 0x54, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x0c, 0x72, 0x65,
	0x76, 0x65, 0x61, 0x6c, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x66, 0x12, 0x30, 0x0a, 0x14, 0x66, 0x75,
	0x6c, 0x6c, 0x5f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f,
	0x6f, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x49, 0x6e,
	0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x22, 0x3c, 0x0a, 0x17,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x70, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x32, 0x74, 0x72, 0x5f,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70,
	0x32, 0x74, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x3a, 0x0a, 0x0b, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a, 0x06, 0x74, 0x78, 0x5f,
	0x68, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x74, 0x78, 0x48, 0x65, 0x78,
	0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x36, 0x0a, 0x0f, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x33,
	0x0a, 0x19, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x22, 0x92, 0x02, 0x0a, 0x12, 0x53, 0x65, 0x6e, 0x64, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1c, 0x0a, 0x0a, 0x73, 0x61,
	0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6b, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08,
	0x73, 0x61, 0x74, 0x50, 0x65, 0x72, 0x4b, 0x77, 0x12, 0x28, 0x0a, 0x07, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x69, 0x67, 0x6e,
	0x72, 0x70, 0x63, 0x2e, 0x54, 0x78, 0x4f, 0x75, 0x74, 0x52, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x6d, 0x69, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x5f, 0x75,
	0x6e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x10, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x55, 0x6e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d,
	0x65, 0x64, 0x12, 0x54, 0x0a, 0x17, 0x63, 0x6f, 0x69, 0x6e, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x6c, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x6f, 0x69, 0x6e,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67,
	0x79, 0x52, 0x15, 0x63, 0x6f, 0x69, 0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x22, 0x2c, 0x0a, 0x13, 0x53, 0x65, 0x6e, 0x64,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x15, 0x0a, 0x06, 0x72, 0x61, 0x77, 0x5f, 0x74, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x05, 0x72, 0x61, 0x77, 0x54, 0x78, 0x22, 0x35, 0x0a, 0x12, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61,
	0x74, 0x65, 0x46, 0x65, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b,
	0x63, 0x6f, 0x6e, 0x66, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x6a, 0x0a,
	0x13, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1c, 0x0a, 0x0a, 0x73, 0x61, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f,
	0x6b, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x73, 0x61, 0x74, 0x50, 0x65, 0x72,
	0x4b, 0x77, 0x12, 0x35, 0x0a, 0x18, 0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x5f,
	0x66, 0x65, 0x65, 0x5f, 0x73, 0x61, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6b, 0x77, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x6d, 0x69, 0x6e, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x46, 0x65,
	0x65, 0x53, 0x61, 0x74, 0x50, 0x65, 0x72, 0x4b, 0x77, 0x22, 0xe7, 0x04, 0x0a, 0x0c, 0x50, 0x65,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x77, 0x65, 0x65, 0x70, 0x12, 0x2b, 0x0a, 0x08, 0x6f, 0x75,
	0x74, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x6c,
	0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4f, 0x75, 0x74, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x6f,
	0x75, 0x74, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x0c, 0x77, 0x69, 0x74, 0x6e, 0x65,
	0x73, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e,
	0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x57, 0x69, 0x74, 0x6e, 0x65, 0x73,
	0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x77, 0x69, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x73, 0x61, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x61,
	0x74, 0x12, 0x24, 0x0a, 0x0c, 0x73, 0x61, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x74,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x73, 0x61, 0x74,
	0x50, 0x65, 0x72, 0x42, 0x79, 0x74, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x62, 0x72, 0x6f, 0x61, 0x64,
	0x63, 0x61, 0x73, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x11, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x41, 0x74,
	0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x12, 0x36, 0x0a, 0x15, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x62,
	0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x5f, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x02, 0x18, 0x01, 0x52, 0x13, 0x6e, 0x65, 0x78, 0x74, 0x42,
	0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x48, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x18,
	0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x36, 0x0a, 0x15, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x02, 0x18, 0x01, 0x52, 0x13, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x12, 0x37, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x61,
	0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0d,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x13, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x53,
	0x61, 0x74, 0x50, 0x65, 0x72, 0x42, 0x79, 0x74, 0x65, 0x12, 0x22, 0x0a, 0x0d, 0x73, 0x61, 0x74,
	0x5f, 0x70, 0x65, 0x72, 0x5f, 0x76, 0x62, 0x79, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x0b, 0x73, 0x61, 0x74, 0x50, 0x65, 0x72, 0x56, 0x62, 0x79, 0x74, 0x65, 0x12, 0x35, 0x0a,
	0x17, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x61, 0x74, 0x5f, 0x70,
	0x65, 0x72, 0x5f, 0x76, 0x62, 0x79, 0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x04, 0x52, 0x14,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x53, 0x61, 0x74, 0x50, 0x65, 0x72, 0x56,
	0x62, 0x79, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74,
	0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61,
	0x74, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x06, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x64, 0x65,
	0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x0e, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x48, 0x65, 0x69,
	0x67, 0x68, 0x74, 0x22, 0x16, 0x0a, 0x14, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x77,
	0x65, 0x65, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x57, 0x0a, 0x15, 0x50,
	0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x77, 0x65, 0x65, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x0e, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x77, 0x65, 0x65, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x77,
	0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x53, 0x77, 0x65, 0x65, 0x70, 0x52, 0x0d, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x77,
	0x65, 0x65, 0x70, 0x73, 0x22, 0xf8, 0x01, 0x0a, 0x0e, 0x42, 0x75, 0x6d, 0x70, 0x46, 0x65, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x08, 0x6f, 0x75, 0x74, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x6c, 0x6e, 0x72, 0x70,
	0x63, 0x2e, 0x4f, 0x75, 0x74, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x6f, 0x75, 0x74, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x12, 0x24, 0x0a, 0x0c, 0x73, 0x61, 0x74, 0x5f, 0x70, 0x65, 0x72,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x0a, 0x73, 0x61, 0x74, 0x50, 0x65, 0x72, 0x42, 0x79, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x05, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x05,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x5f, 0x70, 0x65, 0x72,
	0x5f, 0x76, 0x62, 0x79, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x73, 0x61,
	0x74, 0x50, 0x65, 0x72, 0x56, 0x62, 0x79, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x69, 0x6d, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69, 0x6d,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x75, 0x64, 0x67, 0x65,
	0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x22,
	0x29, 0x0a, 0x0f, 0x42, 0x75, 0x6d, 0x70, 0x46, 0x65, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xd6, 0x01, 0x0a, 0x18, 0x42,
	0x75, 0x6d, 0x70, 0x46, 0x6f, 0x72, 0x63, 0x65, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x46, 0x65, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x5f,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x6c, 0x6e,
	0x72, 0x70, 0x63, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x6f, 0x69, 0x6e, 0x74,
	0x52, 0x09, 0x63, 0x68, 0x61, 0x6e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x64,
	0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x74, 0x61, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x0d, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x6c,
	0x74, 0x61, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x74, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x66,
	0x65, 0x65, 0x72, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x46, 0x65, 0x65, 0x72, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a,
	0x09, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x09, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x62,
	0x75, 0x64, 0x67, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x62, 0x75, 0x64,
	0x67, 0x65, 0x74, 0x22, 0x33, 0x0a, 0x19, 0x42, 0x75, 0x6d, 0x70, 0x46, 0x6f, 0x72, 0x63, 0x65,
	0x43, 0x6c, 0x6f, 0x73, 0x65, 0x46, 0x65, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x50, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x77, 0x65, 0x65, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x48, 0x65, 0x69, 0x67, 0x68, 0x74, 0x22, 0x80, 0x02, 0x0a, 0x12, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x77, 0x65, 0x65, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4c, 0x0a, 0x13, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x6c, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x12, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12,
	0x57, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65,
	0x74, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x77, 0x65, 0x65, 0x70, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x48, 0x00, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x1a, 0x39, 0x0a, 0x0e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x77, 0x65, 0x65, 0x70, 0x73, 0x22, 0x61, 0x0a,
	0x17, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x78, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x74, 0x78, 0x69, 0x64, 0x12, 0x14, 0x0a, 0x05,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x12, 0x1c, 0x0a, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65,
	0x22, 0x32, 0x0a, 0x18, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x22, 0xaa, 0x04, 0x0a, 0x0f, 0x46, 0x75, 0x6e, 0x64, 0x50, 0x73, 0x62,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x04, 0x70, 0x73, 0x62, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x04, 0x70, 0x73, 0x62, 0x74, 0x12, 0x29,
	0x0a, 0x03, 0x72, 0x61, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x77, 0x61,
	0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x54, 0x78, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x48, 0x00, 0x52, 0x03, 0x72, 0x61, 0x77, 0x12, 0x3c, 0x0a, 0x0b, 0x63, 0x6f, 0x69,
	0x6e, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x50, 0x73, 0x62, 0x74, 0x43,
	0x6f, 0x69, 0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x6f, 0x69,
	0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x12, 0x21, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x01, 0x52, 0x0a,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x12, 0x24, 0x0a, 0x0d, 0x73, 0x61,
	0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x76, 0x62, 0x79, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x04, 0x48, 0x01, 0x52, 0x0b, 0x73, 0x61, 0x74, 0x50, 0x65, 0x72, 0x56, 0x62, 0x79, 0x74, 0x65,
	0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x61, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6b, 0x77, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x04, 0x48, 0x01, 0x52, 0x08, 0x73, 0x61, 0x74, 0x50, 0x65, 0x72, 0x4b, 0x77,
	0x12, 0x18, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69,
	0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x6d,
	0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x70, 0x65, 0x6e, 0x64,
	0x5f, 0x75, 0x6e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x10, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x55, 0x6e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x72, 0x6d, 0x65, 0x64, 0x12, 0x3d, 0x0a, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x77, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x54, 0x0a, 0x17, 0x63, 0x6f, 0x69, 0x6e, 0x5f, 0x73, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x6c, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x6f, 0x69,
	0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65,
	0x67, 0x79, 0x52, 0x15, 0x63, 0x6f, 0x69, 0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x22, 0x0a, 0x0d, 0x6d, 0x61, 0x78,
	0x5f, 0x66, 0x65, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x01,
	0x52, 0x0b, 0x6d, 0x61, 0x78, 0x46, 0x65, 0x65, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x42, 0x0a, 0x0a,
	0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x66, 0x65, 0x65,
	0x73, 0x22, 0x9c, 0x01, 0x0a, 0x10, 0x46, 0x75, 0x6e, 0x64, 0x50, 0x73, 0x62, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x75, 0x6e, 0x64, 0x65, 0x64,
	0x5f, 0x70, 0x73, 0x62, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x66, 0x75, 0x6e,
	0x64, 0x65, 0x64, 0x50, 0x73, 0x62, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x37, 0x0a, 0x0c, 0x6c, 0x6f, 0x63, 0x6b, 0x65,
	0x64, 0x5f, 0x75, 0x74, 0x78, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x55, 0x74, 0x78, 0x6f, 0x4c, 0x65,
	0x61, 0x73, 0x65, 0x52, 0x0b, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x55, 0x74, 0x78, 0x6f, 0x73,
	0x22, 0xaf, 0x01, 0x0a, 0x0a, 0x54, 0x78, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12,
	0x27, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x0f, 0x2e, 0x6c, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4f, 0x75, 0x74, 0x50, 0x6f, 0x69, 0x6e, 0x74,
	0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x3c, 0x0a, 0x07, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x77, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x54, 0x78, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x1a, 0x3a, 0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x7f, 0x0a, 0x0e, 0x50, 0x73, 0x62, 0x74, 0x43, 0x6f, 0x69, 0x6e, 0x53, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x73, 0x62, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x04, 0x70, 0x73, 0x62, 0x74, 0x12, 0x34, 0x0a, 0x15, 0x65, 0x78, 0x69, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x13, 0x65, 0x78, 0x69, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x12,
	0x0a, 0x03, 0x61, 0x64, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x03, 0x61,
	0x64, 0x64, 0x42, 0x0f, 0x0a, 0x0d, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x22, 0x9b, 0x01, 0x0a, 0x09, 0x55, 0x74, 0x78, 0x6f, 0x4c, 0x65, 0x61, 0x73,
	0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x2b, 0x0a, 0x08, 0x6f, 0x75, 0x74, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x6c, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4f, 0x75, 0x74, 0x50,
	0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x6f, 0x75, 0x74, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x1e,
	0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x6b, 0x5f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x08, 0x70, 0x6b, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x22, 0x32, 0x0a, 0x0f, 0x53, 0x69, 0x67, 0x6e, 0x50, 0x73, 0x62, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x70,
	0x73, 0x62, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x66, 0x75, 0x6e, 0x64, 0x65,
	0x64, 0x50, 0x73, 0x62, 0x74, 0x22, 0x58, 0x0a, 0x10, 0x53, 0x69, 0x67, 0x6e, 0x50, 0x73, 0x62,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x69, 0x67,
	0x6e, 0x65, 0x64, 0x5f, 0x70, 0x73, 0x62, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a,
	0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x50, 0x73, 0x62, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x69,
	0x67, 0x6e, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0d, 0x52, 0x0c, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x22,
	0x50, 0x0a, 0x13, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x50, 0x73, 0x62, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x75, 0x6e, 0x64, 0x65, 0x64,
	0x5f, 0x70, 0x73, 0x62, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x66, 0x75, 0x6e,
	0x64, 0x65, 0x64, 0x50, 0x73, 0x62, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x22, 0x59, 0x0a, 0x14, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x50, 0x73, 0x62,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x69, 0x67,
	0x6e, 0x65, 0x64, 0x5f, 0x70, 0x73, 0x62, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a,
	0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x50, 0x73, 0x62, 0x74, 0x12, 0x20, 0x0a, 0x0c, 0x72, 0x61,
	0x77, 0x5f, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x74, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x0a, 0x72, 0x61, 0x77, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x54, 0x78, 0x22, 0x13, 0x0a, 0x11,
	0x4c, 0x69, 0x73, 0x74, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x22, 0x4d, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x0c, 0x6c, 0x6f, 0x63, 0x6b, 0x65,
	0x64, 0x5f, 0x75, 0x74, 0x78, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x55, 0x74, 0x78, 0x6f, 0x4c, 0x65,
	0x61, 0x73, 0x65, 0x52, 0x0b, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x55, 0x74, 0x78, 0x6f, 0x73,
	0x2a, 0x8e, 0x01, 0x0a, 0x0b, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x17, 0x0a,
	0x13, 0x57, 0x49, 0x54, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x50, 0x55, 0x42, 0x4b, 0x45, 0x59, 0x5f,
	0x48, 0x41, 0x53, 0x48, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x4e, 0x45, 0x53, 0x54, 0x45, 0x44,
	0x5f, 0x57, 0x49, 0x54, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x50, 0x55, 0x42, 0x4b, 0x45, 0x59, 0x5f,
	0x48, 0x41, 0x53, 0x48, 0x10, 0x02, 0x12, 0x25, 0x0a, 0x21, 0x48, 0x59, 0x42, 0x52, 0x49, 0x44,
	0x5f, 0x4e, 0x45, 0x53, 0x54, 0x45, 0x44, 0x5f, 0x57, 0x49, 0x54, 0x4e, 0x45, 0x53, 0x53, 0x5f,
	0x50, 0x55, 0x42, 0x4b, 0x45, 0x59, 0x5f, 0x48, 0x41, 0x53, 0x48, 0x10, 0x03, 0x12, 0x12, 0x0a,
	0x0e, 0x54, 0x41, 0x50, 0x52, 0x4f, 0x4f, 0x54, 0x5f, 0x50, 0x55, 0x42, 0x4b, 0x45, 0x59, 0x10,
	0x04, 0x2a, 0xfb, 0x09, 0x0a, 0x0b, 0x57, 0x69, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x13, 0x0a, 0x0f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x57, 0x49, 0x54,
	0x4e, 0x45, 0x53, 0x53, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54,
	0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x4c, 0x4f, 0x43, 0x4b, 0x10, 0x01,
	0x12, 0x17, 0x0a, 0x13, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x4e,
	0x4f, 0x5f, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x4f, 0x4d,
	0x4d, 0x49, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x56, 0x4f, 0x4b, 0x45, 0x10, 0x03,
	0x12, 0x17, 0x0a, 0x13, 0x48, 0x54, 0x4c, 0x43, 0x5f, 0x4f, 0x46, 0x46, 0x45, 0x52, 0x45, 0x44,
	0x5f, 0x52, 0x45, 0x56, 0x4f, 0x4b, 0x45, 0x10, 0x04, 0x12, 0x18, 0x0a, 0x14, 0x48, 0x54, 0x4c,
	0x43, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x56, 0x4f, 0x4b,
	0x45, 0x10, 0x05, 0x12, 0x25, 0x0a, 0x21, 0x48, 0x54, 0x4c, 0x43, 0x5f, 0x4f, 0x46, 0x46, 0x45,
	0x52, 0x45, 0x44, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x5f, 0x53, 0x45, 0x43, 0x4f,
	0x4e, 0x44, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x10, 0x06, 0x12, 0x26, 0x0a, 0x22, 0x48, 0x54,
	0x4c, 0x43, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x45, 0x44, 0x5f, 0x53, 0x55, 0x43, 0x43,
	0x45, 0x53, 0x53, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c,
	0x10, 0x07, 0x12, 0x1f, 0x0a, 0x1b, 0x48, 0x54, 0x4c, 0x43, 0x5f, 0x4f, 0x46, 0x46, 0x45, 0x52,
	0x45, 0x44, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x54, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55,
	0x54, 0x10, 0x08, 0x12, 0x20, 0x0a, 0x1c, 0x48, 0x54, 0x4c, 0x43, 0x5f, 0x41, 0x43, 0x43, 0x45,
	0x50, 0x54, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x54, 0x45, 0x5f, 0x53, 0x55, 0x43, 0x43,
	0x45, 0x53, 0x53, 0x10, 0x09, 0x12, 0x1c, 0x0a, 0x18, 0x48, 0x54, 0x4c, 0x43, 0x5f, 0x53, 0x45,
	0x43, 0x4f, 0x4e, 0x44, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x52, 0x45, 0x56, 0x4f, 0x4b,
	0x45, 0x10, 0x0a, 0x12, 0x14, 0x0a, 0x10, 0x57, 0x49, 0x54, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x4b,
	0x45, 0x59, 0x5f, 0x48, 0x41, 0x53, 0x48, 0x10, 0x0b, 0x12, 0x1b, 0x0a, 0x17, 0x4e, 0x45, 0x53,
	0x54, 0x45, 0x44, 0x5f, 0x57, 0x49, 0x54, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x4b, 0x45, 0x59, 0x5f,
	0x48, 0x41, 0x53, 0x48, 0x10, 0x0c, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54,
	0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x41, 0x4e, 0x43, 0x48, 0x4f, 0x52, 0x10, 0x0d, 0x12, 0x21, 0x0a,
	0x1d, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x5f, 0x44,
	0x45, 0x4c, 0x41, 0x59, 0x5f, 0x54, 0x57, 0x45, 0x41, 0x4b, 0x4c, 0x45, 0x53, 0x53, 0x10, 0x0e,
	0x12, 0x22, 0x0a, 0x1e, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x54,
	0x4f, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d,
	0x45, 0x44, 0x10, 0x0f, 0x12, 0x35, 0x0a, 0x31, 0x48, 0x54, 0x4c, 0x43, 0x5f, 0x4f, 0x46, 0x46,
	0x45, 0x52, 0x45, 0x44, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x5f, 0x53, 0x45, 0x43,
	0x4f, 0x4e, 0x44, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x5f,
	0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x45, 0x44, 0x10, 0x10, 0x12, 0x36, 0x0a, 0x32, 0x48,
	0x54, 0x4c, 0x43, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x45, 0x44, 0x5f, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x5f, 0x4c, 0x45, 0x56, 0x45,
	0x4c, 0x5f, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x45,
	0x44, 0x10, 0x11, 0x12, 0x1e, 0x0a, 0x1a, 0x4c, 0x45, 0x41, 0x53, 0x45, 0x5f, 0x43, 0x4f, 0x4d,
	0x4d, 0x49, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x4c, 0x4f, 0x43,
	0x4b, 0x10, 0x12, 0x12, 0x28, 0x0a, 0x24, 0x4c, 0x45, 0x41, 0x53, 0x45, 0x5f, 0x43, 0x4f, 0x4d,
	0x4d, 0x49, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x4f, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x54,
	0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x45, 0x44, 0x10, 0x13, 0x12, 0x2b, 0x0a,
	0x27, 0x4c, 0x45, 0x41, 0x53, 0x45, 0x5f, 0x48, 0x54, 0x4c, 0x43, 0x5f, 0x4f, 0x46, 0x46, 0x45,
	0x52, 0x45, 0x44, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x5f, 0x53, 0x45, 0x43, 0x4f,
	0x4e, 0x44, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x10, 0x14, 0x12, 0x2c, 0x0a, 0x28, 0x4c, 0x45,
	0x41, 0x53, 0x45, 0x5f, 0x48, 0x54, 0x4c, 0x43, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x45,
	0x44, 0x5f, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44,
	0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x10, 0x15, 0x12, 0x19, 0x0a, 0x15, 0x54, 0x41, 0x50, 0x52,
	0x4f, 0x4f, 0x54, 0x5f, 0x50, 0x55, 0x42, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x53, 0x50, 0x45, 0x4e,
	0x44, 0x10, 0x16, 0x12, 0x1e, 0x0a, 0x1a, 0x54, 0x41, 0x50, 0x52, 0x4f, 0x4f, 0x54, 0x5f, 0x4c,
	0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x5f, 0x53, 0x50, 0x45, 0x4e,
	0x44, 0x10, 0x17, 0x12, 0x1f, 0x0a, 0x1b, 0x54, 0x41, 0x50, 0x52, 0x4f, 0x4f, 0x54, 0x5f, 0x52,
	0x45, 0x4d, 0x4f, 0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x5f, 0x53, 0x50, 0x45,
	0x4e, 0x44, 0x10, 0x18, 0x12, 0x1e, 0x0a, 0x1a, 0x54, 0x41, 0x50, 0x52, 0x4f, 0x4f, 0x54, 0x5f,
	0x41, 0x4e, 0x43, 0x48, 0x4f, 0x52, 0x5f, 0x53, 0x57, 0x45, 0x45, 0x50, 0x5f, 0x53, 0x50, 0x45,
	0x4e, 0x44, 0x10, 0x19, 0x12, 0x2d, 0x0a, 0x29, 0x54, 0x41, 0x50, 0x52, 0x4f, 0x4f, 0x54, 0x5f,
	0x48, 0x54, 0x4c, 0x43, 0x5f, 0x4f, 0x46, 0x46, 0x45, 0x52, 0x45, 0x44, 0x5f, 0x54, 0x49, 0x4d,
	0x45, 0x4f, 0x55, 0x54, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x5f, 0x4c, 0x45, 0x56, 0x45,
	0x4c, 0x10, 0x1a, 0x12, 0x2e, 0x0a, 0x2a, 0x54, 0x41, 0x50, 0x52, 0x4f, 0x4f, 0x54, 0x5f, 0x48,
	0x54, 0x4c, 0x43, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x45, 0x44, 0x5f, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x5f, 0x4c, 0x45, 0x56, 0x45,
	0x4c, 0x10, 0x1b, 0x12, 0x24, 0x0a, 0x20, 0x54, 0x41, 0x50, 0x52, 0x4f, 0x4f, 0x54, 0x5f, 0x48,
	0x54, 0x4c, 0x43, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c,
	0x5f, 0x52, 0x45, 0x56, 0x4f, 0x4b, 0x45, 0x10, 0x1c, 0x12, 0x20, 0x0a, 0x1c, 0x54, 0x41, 0x50,
	0x52, 0x4f, 0x4f, 0x54, 0x5f, 0x48, 0x54, 0x4c, 0x43, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54,
	0x45, 0x44, 0x5f, 0x52, 0x45, 0x56, 0x4f, 0x4b, 0x45, 0x10, 0x1d, 0x12, 0x1f, 0x0a, 0x1b, 0x54,
	0x41, 0x50, 0x52, 0x4f, 0x4f, 0x54, 0x5f, 0x48, 0x54, 0x4c, 0x43, 0x5f, 0x4f, 0x46, 0x46, 0x45,
	0x52, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x56, 0x4f, 0x4b, 0x45, 0x10, 0x1e, 0x12, 0x27, 0x0a, 0x23,
	0x54, 0x41, 0x50, 0x52, 0x4f, 0x4f, 0x54, 0x5f, 0x48, 0x54, 0x4c, 0x43, 0x5f, 0x4f, 0x46, 0x46,
	0x45, 0x52, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x54, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45,
	0x4f, 0x55, 0x54, 0x10, 0x1f, 0x12, 0x26, 0x0a, 0x22, 0x54, 0x41, 0x50, 0x52, 0x4f, 0x4f, 0x54,
	0x5f, 0x48, 0x54, 0x4c, 0x43, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x4f, 0x46, 0x46, 0x45,
	0x52, 0x45, 0x44, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x20, 0x12, 0x28, 0x0a,
	0x24, 0x54, 0x41, 0x50, 0x52, 0x4f, 0x4f, 0x54, 0x5f, 0x48, 0x54, 0x4c, 0x43, 0x5f, 0x41, 0x43,
	0x43, 0x45, 0x50, 0x54, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x54, 0x45, 0x5f, 0x53, 0x55,
	0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x21, 0x12, 0x27, 0x0a, 0x23, 0x54, 0x41, 0x50, 0x52, 0x4f,
	0x4f, 0x54, 0x5f, 0x48, 0x54, 0x4c, 0x43, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x45, 0x44,
	0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x22,
	0x12, 0x1d, 0x0a, 0x19, 0x54, 0x41, 0x50, 0x52, 0x4f, 0x4f, 0x54, 0x5f, 0x43, 0x4f, 0x4d, 0x4d,
	0x49, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x56, 0x4f, 0x4b, 0x45, 0x10, 0x23, 0x2a,
	0x56, 0x0a, 0x11, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x41,
	0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x43, 0x48, 0x41,
	0x4e, 0x47, 0x45, 0x5f, 0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x50, 0x32, 0x54, 0x52, 0x10, 0x01, 0x32, 0xd6, 0x11, 0x0a, 0x09, 0x57, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x4b, 0x69, 0x74, 0x12, 0x4c, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x6e, 0x73,
	0x70, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x6e, 0x73, 0x70, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x55, 0x6e, 0x73, 0x70, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0b, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x12, 0x1d, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x4c,
	0x65, 0x61, 0x73, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1e, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x65,
	0x61, 0x73, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x52, 0x0a, 0x0d, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x12, 0x1f, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x52,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e,
	0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x65, 0x61,
	0x73, 0x65, 0x73, 0x12, 0x1c, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x3a, 0x0a, 0x0d, 0x44, 0x65, 0x72, 0x69, 0x76, 0x65, 0x4e, 0x65, 0x78, 0x74, 0x4b, 0x65,
	0x79, 0x12, 0x11, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x4b, 0x65,
	0x79, 0x52, 0x65, 0x71, 0x1a, 0x16, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4b,
	0x65, 0x79, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x38, 0x0a, 0x09,
	0x44, 0x65, 0x72, 0x69, 0x76, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x13, 0x2e, 0x73, 0x69, 0x67, 0x6e,
	0x72, 0x70, 0x63, 0x2e, 0x4b, 0x65, 0x79, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x1a, 0x16,
	0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4b, 0x65, 0x79, 0x44, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x3b, 0x0a, 0x08, 0x4e, 0x65, 0x78, 0x74, 0x41, 0x64,
	0x64, 0x72, 0x12, 0x16, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x41,
	0x64, 0x64, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x17, 0x2e, 0x77, 0x61, 0x6c,
	0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70,
	0x63, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x12, 0x2e, 0x6c, 0x6e, 0x72, 0x70, 0x63, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x0c, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x1e, 0x2e, 0x77, 0x61,
	0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x77, 0x61,
	0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58, 0x0a, 0x0f,
	0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x12,
	0x21, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x22, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x1f, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x72, 0x70, 0x63, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65,
	0x74, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x64, 0x0a, 0x13, 0x53, 0x69,
	0x67, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x57, 0x69, 0x74, 0x68, 0x41, 0x64, 0x64,
	0x72, 0x12, 0x25, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x69,
	0x67, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x57, 0x69, 0x74, 0x68, 0x41, 0x64, 0x64,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65,
	0x74, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x57, 0x69, 0x74, 0x68, 0x41, 0x64, 0x64, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x6a, 0x0a, 0x15, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x57, 0x69, 0x74, 0x68, 0x41, 0x64, 0x64, 0x72, 0x12, 0x27, 0x2e, 0x77, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x57, 0x69, 0x74, 0x68, 0x41, 0x64, 0x64, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x28, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x56,
	0x65, 0x72, 0x69, 0x66, 0x79, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x57, 0x69, 0x74, 0x68,
	0x41, 0x64, 0x64, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0d,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f, 0x2e,
	0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20,
	0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x58, 0x0a, 0x0f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x4b, 0x65, 0x79, 0x12, 0x21, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72,
	0x70, 0x63, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b,
	0x65, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58, 0x0a, 0x0f, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x70, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x21, 0x2e,
	0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x54, 0x61, 0x70, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x22, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x54, 0x61, 0x70, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x12, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x2e, 0x77, 0x61, 0x6c,
	0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x1a, 0x1a, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b,
	0x0a, 0x11, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x20, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e,
	0x47, 0x65, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70,
	0x63, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0b, 0x53,
	0x65, 0x6e, 0x64, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x1d, 0x2e, 0x77, 0x61, 0x6c,
	0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x65, 0x6e, 0x64, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x77, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x65, 0x6e, 0x64, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0b, 0x45, 0x73, 0x74,
	0x69, 0x6d, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x12, 0x1d, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65,
	0x74, 0x72, 0x70, 0x63, 0x2e, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x72, 0x70, 0x63, 0x2e, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x50, 0x65, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x53, 0x77, 0x65, 0x65, 0x70, 0x73, 0x12, 0x1f, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65,
	0x74, 0x72, 0x70, 0x63, 0x2e, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x77, 0x65, 0x65,
	0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x77, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x77, 0x65,
	0x65, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x07, 0x42,
	0x75, 0x6d, 0x70, 0x46, 0x65, 0x65, 0x12, 0x19, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72,
	0x70, 0x63, 0x2e, 0x42, 0x75, 0x6d, 0x70, 0x46, 0x65, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1a, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x42, 0x75,
	0x6d, 0x70, 0x46, 0x65, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5e, 0x0a,
	0x11, 0x42, 0x75, 0x6d, 0x70, 0x46, 0x6f, 0x72, 0x63, 0x65, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x46,
	0x65, 0x65, 0x12, 0x23, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x42,
	0x75, 0x6d, 0x70, 0x46, 0x6f, 0x72, 0x63, 0x65, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x46, 0x65, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x72, 0x70, 0x63, 0x2e, 0x42, 0x75, 0x6d, 0x70, 0x46, 0x6f, 0x72, 0x63, 0x65, 0x43, 0x6c, 0x6f,
	0x73, 0x65, 0x46, 0x65, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a,
	0x0a, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x77, 0x65, 0x65, 0x70, 0x73, 0x12, 0x1c, 0x2e, 0x77, 0x61,
	0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x77, 0x65, 0x65,
	0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x77, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x77, 0x65, 0x65, 0x70, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x10, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x2e, 0x77,
	0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x23, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x08, 0x46, 0x75, 0x6e, 0x64, 0x50, 0x73, 0x62,
	0x74, 0x12, 0x1a, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x46, 0x75,
	0x6e, 0x64, 0x50, 0x73, 0x62, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e,
	0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x46, 0x75, 0x6e, 0x64, 0x50, 0x73,
	0x62, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x08, 0x53, 0x69,
	0x67, 0x6e, 0x50, 0x73, 0x62, 0x74, 0x12, 0x1a, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x50, 0x73, 0x62, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x53,
	0x69, 0x67, 0x6e, 0x50, 0x73, 0x62, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x4f, 0x0a, 0x0c, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x50, 0x73, 0x62, 0x74, 0x12,
	0x1e, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x46, 0x69, 0x6e, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x50, 0x73, 0x62, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1f, 0x2e, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x46, 0x69, 0x6e, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x50, 0x73, 0x62, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x42, 0x31, 0x5a, 0x2f, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6c,
	0x69, 0x67, 0x68, 0x74, 0x6e, 0x69, 0x6e, 0x67, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f,
	0x6c, 0x6e, 0x64, 0x2f, 0x6c, 0x6e, 0x72, 0x70, 0x63, 0x2f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x72, 0x70, 0x63, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_walletrpc_walletkit_proto_rawDescOnce sync.Once
	file_walletrpc_walletkit_proto_rawDescData = file_walletrpc_walletkit_proto_rawDesc
)

func file_walletrpc_walletkit_proto_rawDescGZIP() []byte {
	file_walletrpc_walletkit_proto_rawDescOnce.Do(func() {
		file_walletrpc_walletkit_proto_rawDescData = protoimpl.X.CompressGZIP(file_walletrpc_walletkit_proto_rawDescData)
	})
	return file_walletrpc_walletkit_proto_rawDescData
}

var file_walletrpc_walletkit_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_walletrpc_walletkit_proto_msgTypes = make([]protoimpl.MessageInfo, 63)
var file_walletrpc_walletkit_proto_goTypes = []interface{}{
	(AddressType)(0),                          // 0: walletrpc.AddressType
	(WitnessType)(0),                          // 1: walletrpc.WitnessType
	(ChangeAddressType)(0),                    // 2: walletrpc.ChangeAddressType
	(*ListUnspentRequest)(nil),                // 3: walletrpc.ListUnspentRequest
	(*ListUnspentResponse)(nil),               // 4: walletrpc.ListUnspentResponse
	(*LeaseOutputRequest)(nil),                // 5: walletrpc.LeaseOutputRequest
	(*LeaseOutputResponse)(nil),               // 6: walletrpc.LeaseOutputResponse
	(*ReleaseOutputRequest)(nil),              // 7: walletrpc.ReleaseOutputRequest
	(*ReleaseOutputResponse)(nil),             // 8: walletrpc.ReleaseOutputResponse
	(*KeyReq)(nil),                            // 9: walletrpc.KeyReq
	(*AddrRequest)(nil),                       // 10: walletrpc.AddrRequest
	(*AddrResponse)(nil),                      // 11: walletrpc.AddrResponse
	(*Account)(nil),                           // 12: walletrpc.Account
	(*AddressProperty)(nil),                   // 13: walletrpc.AddressProperty
	(*AccountWithAddresses)(nil),              // 14: walletrpc.AccountWithAddresses
	(*ListAccountsRequest)(nil),               // 15: walletrpc.ListAccountsRequest
	(*ListAccountsResponse)(nil),              // 16: walletrpc.ListAccountsResponse
	(*RequiredReserveRequest)(nil),            // 17: walletrpc.RequiredReserveRequest
	(*RequiredReserveResponse)(nil),           // 18: walletrpc.RequiredReserveResponse
	(*ListAddressesRequest)(nil),              // 19: walletrpc.ListAddressesRequest
	(*ListAddressesResponse)(nil),             // 20: walletrpc.ListAddressesResponse
	(*GetTransactionRequest)(nil),             // 21: walletrpc.GetTransactionRequest
	(*SignMessageWithAddrRequest)(nil),        // 22: walletrpc.SignMessageWithAddrRequest
	(*SignMessageWithAddrResponse)(nil),       // 23: walletrpc.SignMessageWithAddrResponse
	(*VerifyMessageWithAddrRequest)(nil),      // 24: walletrpc.VerifyMessageWithAddrRequest
	(*VerifyMessageWithAddrResponse)(nil),     // 25: walletrpc.VerifyMessageWithAddrResponse
	(*ImportAccountRequest)(nil),              // 26: walletrpc.ImportAccountRequest
	(*ImportAccountResponse)(nil),             // 27: walletrpc.ImportAccountResponse
	(*ImportPublicKeyRequest)(nil),            // 28: walletrpc.ImportPublicKeyRequest
	(*ImportPublicKeyResponse)(nil),           // 29: walletrpc.ImportPublicKeyResponse
	(*ImportTapscriptRequest)(nil),            // 30: walletrpc.ImportTapscriptRequest
	(*TapscriptFullTree)(nil),                 // 31: walletrpc.TapscriptFullTree
	(*TapLeaf)(nil),                           // 32: walletrpc.TapLeaf
	(*TapscriptPartialReveal)(nil),            // 33: walletrpc.TapscriptPartialReveal
	(*ImportTapscriptResponse)(nil),           // 34: walletrpc.ImportTapscriptResponse
	(*Transaction)(nil),                       // 35: walletrpc.Transaction
	(*PublishResponse)(nil),                   // 36: walletrpc.PublishResponse
	(*RemoveTransactionResponse)(nil),         // 37: walletrpc.RemoveTransactionResponse
	(*SendOutputsRequest)(nil),                // 38: walletrpc.SendOutputsRequest
	(*SendOutputsResponse)(nil),               // 39: walletrpc.SendOutputsResponse
	(*EstimateFeeRequest)(nil),                // 40: walletrpc.EstimateFeeRequest
	(*EstimateFeeResponse)(nil),               // 41: walletrpc.EstimateFeeResponse
	(*PendingSweep)(nil),                      // 42: walletrpc.PendingSweep
	(*PendingSweepsRequest)(nil),              // 43: walletrpc.PendingSweepsRequest
	(*PendingSweepsResponse)(nil),             // 44: walletrpc.PendingSweepsResponse
	(*BumpFeeRequest)(nil),                    // 45: walletrpc.BumpFeeRequest
	(*BumpFeeResponse)(nil),                   // 46: walletrpc.BumpFeeResponse
	(*BumpForceCloseFeeRequest)(nil),          // 47: walletrpc.BumpForceCloseFeeRequest
	(*BumpForceCloseFeeResponse)(nil),         // 48: walletrpc.BumpForceCloseFeeResponse
	(*ListSweepsRequest)(nil),                 // 49: walletrpc.ListSweepsRequest
	(*ListSweepsResponse)(nil),                // 50: walletrpc.ListSweepsResponse
	(*LabelTransactionRequest)(nil),           // 51: walletrpc.LabelTransactionRequest
	(*LabelTransactionResponse)(nil),          // 52: walletrpc.LabelTransactionResponse
	(*FundPsbtRequest)(nil),                   // 53: walletrpc.FundPsbtRequest
	(*FundPsbtResponse)(nil),                  // 54: walletrpc.FundPsbtResponse
	(*TxTemplate)(nil),                        // 55: walletrpc.TxTemplate
	(*PsbtCoinSelect)(nil),                    // 56: walletrpc.PsbtCoinSelect
	(*UtxoLease)(nil),                         // 57: walletrpc.UtxoLease
	(*SignPsbtRequest)(nil),                   // 58: walletrpc.SignPsbtRequest
	(*SignPsbtResponse)(nil),                  // 59: walletrpc.SignPsbtResponse
	(*FinalizePsbtRequest)(nil),               // 60: walletrpc.FinalizePsbtRequest
	(*FinalizePsbtResponse)(nil),              // 61: walletrpc.FinalizePsbtResponse
	(*ListLeasesRequest)(nil),                 // 62: walletrpc.ListLeasesRequest
	(*ListLeasesResponse)(nil),                // 63: walletrpc.ListLeasesResponse
	(*ListSweepsResponse_TransactionIDs)(nil), // 64: walletrpc.ListSweepsResponse.TransactionIDs
	nil,                              // 65: walletrpc.TxTemplate.OutputsEntry
	(*lnrpc.Utxo)(nil),               // 66: lnrpc.Utxo
	(*lnrpc.OutPoint)(nil),           // 67: lnrpc.OutPoint
	(*signrpc.TxOut)(nil),            // 68: signrpc.TxOut
	(lnrpc.CoinSelectionStrategy)(0), // 69: lnrpc.CoinSelectionStrategy
	(*lnrpc.ChannelPoint)(nil),       // 70: lnrpc.ChannelPoint
	(*lnrpc.TransactionDetails)(nil), // 71: lnrpc.TransactionDetails
	(*signrpc.KeyLocator)(nil),       // 72: signrpc.KeyLocator
	(*signrpc.KeyDescriptor)(nil),    // 73: signrpc.KeyDescriptor
	(*lnrpc.Transaction)(nil),        // 74: lnrpc.Transaction
}
var file_walletrpc_walletkit_proto_depIdxs = []int32{
	66, // 0: walletrpc.ListUnspentResponse.utxos:type_name -> lnrpc.Utxo
	67, // 1: walletrpc.LeaseOutputRequest.outpoint:type_name -> lnrpc.OutPoint
	67, // 2: walletrpc.ReleaseOutputRequest.outpoint:type_name -> lnrpc.OutPoint
	0,  // 3: walletrpc.AddrRequest.type:type_name -> walletrpc.AddressType
	0,  // 4: walletrpc.Account.address_type:type_name -> walletrpc.AddressType
	0,  // 5: walletrpc.AccountWithAddresses.address_type:type_name -> walletrpc.AddressType
	13, // 6: walletrpc.AccountWithAddresses.addresses:type_name -> walletrpc.AddressProperty
	0,  // 7: walletrpc.ListAccountsRequest.address_type:type_name -> walletrpc.AddressType
	12, // 8: walletrpc.ListAccountsResponse.accounts:type_name -> walletrpc.Account
	14, // 9: walletrpc.ListAddressesResponse.account_with_addresses:type_name -> walletrpc.AccountWithAddresses
	0,  // 10: walletrpc.ImportAccountRequest.address_type:type_name -> walletrpc.AddressType
	12, // 11: walletrpc.ImportAccountResponse.account:type_name -> walletrpc.Account
	0,  // 12: walletrpc.ImportPublicKeyRequest.address_type:type_name -> walletrpc.AddressType
	31, // 13: walletrpc.ImportTapscriptRequest.full_tree:type_name -> walletrpc.TapscriptFullTree
	33, // 14: walletrpc.ImportTapscriptRequest.partial_reveal:type_name -> walletrpc.TapscriptPartialReveal
	32, // 15: walletrpc.TapscriptFullTree.all_leaves:type_name -> walletrpc.TapLeaf
	32, // 16: walletrpc.TapscriptPartialReveal.revealed_leaf:type_name -> walletrpc.TapLeaf
	68, // 17: walletrpc.SendOutputsRequest.outputs:type_name -> signrpc.TxOut
	69, // 18: walletrpc.SendOutputsRequest.coin_selection_strategy:type_name -> lnrpc.CoinSelectionStrategy
	67, // 19: walletrpc.PendingSweep.outpoint:type_name -> lnrpc.OutPoint
	1,  // 20: walletrpc.PendingSweep.witness_type:type_name -> walletrpc.WitnessType
	42, // 21: walletrpc.PendingSweepsResponse.pending_sweeps:type_name -> walletrpc.PendingSweep
	67, // 22: walletrpc.BumpFeeRequest.outpoint:type_name -> lnrpc.OutPoint
	70, // 23: walletrpc.BumpForceCloseFeeRequest.chan_point:type_name -> lnrpc.ChannelPoint
	71, // 24: walletrpc.ListSweepsResponse.transaction_details:type_name -> lnrpc.TransactionDetails
	64, // 25: walletrpc.ListSweepsResponse.transaction_ids:type_name -> walletrpc.ListSweepsResponse.TransactionIDs
	55, // 26: walletrpc.FundPsbtRequest.raw:type_name -> walletrpc.TxTemplate
	56, // 27: walletrpc.FundPsbtRequest.coin_select:type_name -> walletrpc.PsbtCoinSelect
	2,  // 28: walletrpc.FundPsbtRequest.change_type:type_name -> walletrpc.ChangeAddressType
	69, // 29: walletrpc.FundPsbtRequest.coin_selection_strategy:type_name -> lnrpc.CoinSelectionStrategy
	57, // 30: walletrpc.FundPsbtResponse.locked_utxos:type_name -> walletrpc.UtxoLease
	67, // 31: walletrpc.TxTemplate.inputs:type_name -> lnrpc.OutPoint
	65, // 32: walletrpc.TxTemplate.outputs:type_name -> walletrpc.TxTemplate.OutputsEntry
	67, // 33: walletrpc.UtxoLease.outpoint:type_name -> lnrpc.OutPoint
	57, // 34: walletrpc.ListLeasesResponse.locked_utxos:type_name -> walletrpc.UtxoLease
	3,  // 35: walletrpc.WalletKit.ListUnspent:input_type -> walletrpc.ListUnspentRequest
	5,  // 36: walletrpc.WalletKit.LeaseOutput:input_type -> walletrpc.LeaseOutputRequest
	7,  // 37: walletrpc.WalletKit.ReleaseOutput:input_type -> walletrpc.ReleaseOutputRequest
	62, // 38: walletrpc.WalletKit.ListLeases:input_type -> walletrpc.ListLeasesRequest
	9,  // 39: walletrpc.WalletKit.DeriveNextKey:input_type -> walletrpc.KeyReq
	72, // 40: walletrpc.WalletKit.DeriveKey:input_type -> signrpc.KeyLocator
	10, // 41: walletrpc.WalletKit.NextAddr:input_type -> walletrpc.AddrRequest
	21, // 42: walletrpc.WalletKit.GetTransaction:input_type -> walletrpc.GetTransactionRequest
	15, // 43: walletrpc.WalletKit.ListAccounts:input_type -> walletrpc.ListAccountsRequest
	17, // 44: walletrpc.WalletKit.RequiredReserve:input_type -> walletrpc.RequiredReserveRequest
	19, // 45: walletrpc.WalletKit.ListAddresses:input_type -> walletrpc.ListAddressesRequest
	22, // 46: walletrpc.WalletKit.SignMessageWithAddr:input_type -> walletrpc.SignMessageWithAddrRequest
	24, // 47: walletrpc.WalletKit.VerifyMessageWithAddr:input_type -> walletrpc.VerifyMessageWithAddrRequest
	26, // 48: walletrpc.WalletKit.ImportAccount:input_type -> walletrpc.ImportAccountRequest
	28, // 49: walletrpc.WalletKit.ImportPublicKey:input_type -> walletrpc.ImportPublicKeyRequest
	30, // 50: walletrpc.WalletKit.ImportTapscript:input_type -> walletrpc.ImportTapscriptRequest
	35, // 51: walletrpc.WalletKit.PublishTransaction:input_type -> walletrpc.Transaction
	21, // 52: walletrpc.WalletKit.RemoveTransaction:input_type -> walletrpc.GetTransactionRequest
	38, // 53: walletrpc.WalletKit.SendOutputs:input_type -> walletrpc.SendOutputsRequest
	40, // 54: walletrpc.WalletKit.EstimateFee:input_type -> walletrpc.EstimateFeeRequest
	43, // 55: walletrpc.WalletKit.PendingSweeps:input_type -> walletrpc.PendingSweepsRequest
	45, // 56: walletrpc.WalletKit.BumpFee:input_type -> walletrpc.BumpFeeRequest
	47, // 57: walletrpc.WalletKit.BumpForceCloseFee:input_type -> walletrpc.BumpForceCloseFeeRequest
	49, // 58: walletrpc.WalletKit.ListSweeps:input_type -> walletrpc.ListSweepsRequest
	51, // 59: walletrpc.WalletKit.LabelTransaction:input_type -> walletrpc.LabelTransactionRequest
	53, // 60: walletrpc.WalletKit.FundPsbt:input_type -> walletrpc.FundPsbtRequest
	58, // 61: walletrpc.WalletKit.SignPsbt:input_type -> walletrpc.SignPsbtRequest
	60, // 62: walletrpc.WalletKit.FinalizePsbt:input_type -> walletrpc.FinalizePsbtRequest
	4,  // 63: walletrpc.WalletKit.ListUnspent:output_type -> walletrpc.ListUnspentResponse
	6,  // 64: walletrpc.WalletKit.LeaseOutput:output_type -> walletrpc.LeaseOutputResponse
	8,  // 65: walletrpc.WalletKit.ReleaseOutput:output_type -> walletrpc.ReleaseOutputResponse
	63, // 66: walletrpc.WalletKit.ListLeases:output_type -> walletrpc.ListLeasesResponse
	73, // 67: walletrpc.WalletKit.DeriveNextKey:output_type -> signrpc.KeyDescriptor
	73, // 68: walletrpc.WalletKit.DeriveKey:output_type -> signrpc.KeyDescriptor
	11, // 69: walletrpc.WalletKit.NextAddr:output_type -> walletrpc.AddrResponse
	74, // 70: walletrpc.WalletKit.GetTransaction:output_type -> lnrpc.Transaction
	16, // 71: walletrpc.WalletKit.ListAccounts:output_type -> walletrpc.ListAccountsResponse
	18, // 72: walletrpc.WalletKit.RequiredReserve:output_type -> walletrpc.RequiredReserveResponse
	20, // 73: walletrpc.WalletKit.ListAddresses:output_type -> walletrpc.ListAddressesResponse
	23, // 74: walletrpc.WalletKit.SignMessageWithAddr:output_type -> walletrpc.SignMessageWithAddrResponse
	25, // 75: walletrpc.WalletKit.VerifyMessageWithAddr:output_type -> walletrpc.VerifyMessageWithAddrResponse
	27, // 76: walletrpc.WalletKit.ImportAccount:output_type -> walletrpc.ImportAccountResponse
	29, // 77: walletrpc.WalletKit.ImportPublicKey:output_type -> walletrpc.ImportPublicKeyResponse
	34, // 78: walletrpc.WalletKit.ImportTapscript:output_type -> walletrpc.ImportTapscriptResponse
	36, // 79: walletrpc.WalletKit.PublishTransaction:output_type -> walletrpc.PublishResponse
	37, // 80: walletrpc.WalletKit.RemoveTransaction:output_type -> walletrpc.RemoveTransactionResponse
	39, // 81: walletrpc.WalletKit.SendOutputs:output_type -> walletrpc.SendOutputsResponse
	41, // 82: walletrpc.WalletKit.EstimateFee:output_type -> walletrpc.EstimateFeeResponse
	44, // 83: walletrpc.WalletKit.PendingSweeps:output_type -> walletrpc.PendingSweepsResponse
	46, // 84: walletrpc.WalletKit.BumpFee:output_type -> walletrpc.BumpFeeResponse
	48, // 85: walletrpc.WalletKit.BumpForceCloseFee:output_type -> walletrpc.BumpForceCloseFeeResponse
	50, // 86: walletrpc.WalletKit.ListSweeps:output_type -> walletrpc.ListSweepsResponse
	52, // 87: walletrpc.WalletKit.LabelTransaction:output_type -> walletrpc.LabelTransactionResponse
	54, // 88: walletrpc.WalletKit.FundPsbt:output_type -> walletrpc.FundPsbtResponse
	59, // 89: walletrpc.WalletKit.SignPsbt:output_type -> walletrpc.SignPsbtResponse
	61, // 90: walletrpc.WalletKit.FinalizePsbt:output_type -> walletrpc.FinalizePsbtResponse
	63, // [63:91] is the sub-list for method output_type
	35, // [35:63] is the sub-list for method input_type
	35, // [35:35] is the sub-list for extension type_name
	35, // [35:35] is the sub-list for extension extendee
	0,  // [0:35] is the sub-list for field type_name
}

func init() { file_walletrpc_walletkit_proto_init() }
func file_walletrpc_walletkit_proto_init() {
	if File_walletrpc_walletkit_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_walletrpc_walletkit_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListUnspentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListUnspentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LeaseOutputRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LeaseOutputResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReleaseOutputRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReleaseOutputResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddrRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddrResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Account); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddressProperty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccountWithAddresses); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequiredReserveRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequiredReserveResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAddressesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAddressesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTransactionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignMessageWithAddrRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignMessageWithAddrResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyMessageWithAddrRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyMessageWithAddrResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportAccountResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportPublicKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportPublicKeyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportTapscriptRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TapscriptFullTree); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TapLeaf); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TapscriptPartialReveal); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportTapscriptResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Transaction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublishResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveTransactionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SendOutputsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SendOutputsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EstimateFeeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EstimateFeeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PendingSweep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PendingSweepsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PendingSweepsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BumpFeeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BumpFeeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BumpForceCloseFeeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BumpForceCloseFeeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSweepsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSweepsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LabelTransactionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LabelTransactionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FundPsbtRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FundPsbtResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TxTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PsbtCoinSelect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UtxoLease); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignPsbtRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignPsbtResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizePsbtRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizePsbtResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLeasesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLeasesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_walletrpc_walletkit_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSweepsResponse_TransactionIDs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_walletrpc_walletkit_proto_msgTypes[27].OneofWrappers = []interface{}{
		(*ImportTapscriptRequest_FullTree)(nil),
		(*ImportTapscriptRequest_PartialReveal)(nil),
		(*ImportTapscriptRequest_RootHashOnly)(nil),
		(*ImportTapscriptRequest_FullKeyOnly)(nil),
	}
	file_walletrpc_walletkit_proto_msgTypes[47].OneofWrappers = []interface{}{
		(*ListSweepsResponse_TransactionDetails)(nil),
		(*ListSweepsResponse_TransactionIds)(nil),
	}
	file_walletrpc_walletkit_proto_msgTypes[50].OneofWrappers = []interface{}{
		(*FundPsbtRequest_Psbt)(nil),
		(*FundPsbtRequest_Raw)(nil),
		(*FundPsbtRequest_CoinSelect)(nil),
		(*FundPsbtRequest_TargetConf)(nil),
		(*FundPsbtRequest_SatPerVbyte)(nil),
		(*FundPsbtRequest_SatPerKw)(nil),
	}
	file_walletrpc_walletkit_proto_msgTypes[53].OneofWrappers = []interface{}{
		(*PsbtCoinSelect_ExistingOutputIndex)(nil),
		(*PsbtCoinSelect_Add)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_walletrpc_walletkit_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   63,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_walletrpc_walletkit_proto_goTypes,
		DependencyIndexes: file_walletrpc_walletkit_proto_depIdxs,
		EnumInfos:         file_walletrpc_walletkit_proto_enumTypes,
		MessageInfos:      file_walletrpc_walletkit_proto_msgTypes,
	}.Build()
	File_walletrpc_walletkit_proto = out.File
	file_walletrpc_walletkit_proto_rawDesc = nil
	file_walletrpc_walletkit_proto_goTypes = nil
	file_walletrpc_walletkit_proto_depIdxs = nil
}
